/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.udp;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import jp.ossc.nimbus.service.publish.udp.ClientMessage;
import jp.ossc.nimbus.service.publish.udp.MessageId;
import jp.ossc.nimbus.service.publish.udp.RequestReplyMessage;
import jp.ossc.nimbus.service.publish.udp.WindowId;

public class InterpolateRequestMessage
extends ClientMessage
implements RequestReplyMessage {
    private MessageId currentFirstMessageId;
    private MessageId latestMessageId;
    private MessageId[] messageIds;
    private WindowId[] windowIds;
    private int requestId;

    public InterpolateRequestMessage() {
        super((byte)7);
    }

    @Override
    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }

    @Override
    public int compareRequestId(RequestReplyMessage msg) {
        long seq = this.getRequestId();
        long cmpSeq = msg.getRequestId();
        long middle = Integer.MAX_VALUE;
        if (seq == cmpSeq) {
            return 0;
        }
        if (seq > cmpSeq) {
            if (seq - cmpSeq > middle) {
                return (seq -= Integer.MAX_VALUE) > cmpSeq ? 1 : -1;
            }
            return 1;
        }
        if (cmpSeq - seq > middle) {
            return seq > (cmpSeq -= Integer.MAX_VALUE) ? -1 : 1;
        }
        return -1;
    }

    public MessageId getCurrentFirstMessageId() {
        return this.currentFirstMessageId;
    }

    public void setCurrentFirstMessageId(MessageId id) {
        this.currentFirstMessageId = id;
    }

    public MessageId getLatestMessageId() {
        return this.latestMessageId;
    }

    public void setLatestMessageId(MessageId id) {
        this.latestMessageId = id;
    }

    public MessageId[] getMessageIds() {
        return this.messageIds;
    }

    public void setMessageIds(MessageId[] ids) {
        this.messageIds = ids;
    }

    public WindowId[] getWindowIds() {
        return this.windowIds;
    }

    public void setWindowIds(WindowId[] ids) {
        this.windowIds = ids;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.requestId);
        out.writeObject(this.currentFirstMessageId);
        out.writeObject(this.latestMessageId);
        out.writeObject(this.messageIds);
        out.writeObject(this.windowIds);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.requestId = in.readInt();
        this.currentFirstMessageId = (MessageId)in.readObject();
        this.latestMessageId = (MessageId)in.readObject();
        this.messageIds = (MessageId[])in.readObject();
        this.windowIds = (WindowId[])in.readObject();
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append('{');
        buf.append("currentFirstMessageId=").append(this.currentFirstMessageId);
        buf.append(", latestMessageId=").append(this.latestMessageId);
        buf.append(", messageIds=");
        if (this.messageIds == null) {
            buf.append(this.messageIds);
        } else {
            buf.append('[');
            for (i = 0; i < this.messageIds.length; ++i) {
                buf.append(this.messageIds[i]);
                if (i == this.messageIds.length - 1) continue;
                buf.append(',');
            }
            buf.append(']');
        }
        buf.append(", windowIds=");
        if (this.windowIds == null) {
            buf.append(this.windowIds);
        } else {
            buf.append('[');
            for (i = 0; i < this.windowIds.length; ++i) {
                buf.append(this.windowIds[i]);
                if (i == this.windowIds.length - 1) continue;
                buf.append(',');
            }
            buf.append(']');
        }
        buf.append('}');
        return buf.toString();
    }
}

