/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import jp.ossc.nimbus.service.journal.editor.MapJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.ServletRequestMapJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class ServletRequestMapJournalEditorService
extends MapJournalEditorServiceBase
implements ServletRequestMapJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = -2626017130679402298L;
    private boolean isOutputRemoteAddress = true;
    private boolean isOutputRemotePort = true;
    private boolean isOutputRemoteHost = true;
    private boolean isOutputLocalAddress = true;
    private boolean isOutputLocalPort = true;
    private boolean isOutputLocalName = true;
    private boolean isOutputServerName = true;
    private boolean isOutputServerPort = true;
    private boolean isOutputProtocol = true;
    private boolean isOutputScheme = true;
    private boolean isOutputLocale = true;
    private boolean isOutputContentType = true;
    private boolean isOutputContentLength = true;
    private boolean isOutputCharacterEncoding = true;
    private boolean isOutputAttributes = true;
    private boolean isOutputParameters = true;
    protected String[] secretAttributes;
    private Set secretAttributeSet;
    protected String[] secretParameters;
    private Set secretParameterSet;
    protected String[] enabledAttributes;
    private Set enabledAttributeSet;
    protected String[] enabledParameters;
    private Set enabledParameterSet;

    @Override
    public void setOutputRemoteAddress(boolean isOutput) {
        this.isOutputRemoteAddress = isOutput;
    }

    @Override
    public boolean isOutputRemoteAddress() {
        return this.isOutputRemoteAddress;
    }

    @Override
    public void setOutputRemotePort(boolean isOutput) {
        this.isOutputRemotePort = isOutput;
    }

    @Override
    public boolean isOutputRemotePort() {
        return this.isOutputRemotePort;
    }

    @Override
    public void setOutputRemoteHost(boolean isOutput) {
        this.isOutputRemoteHost = isOutput;
    }

    @Override
    public boolean isOutputRemoteHost() {
        return this.isOutputRemoteHost;
    }

    @Override
    public void setOutputLocalAddress(boolean isOutput) {
        this.isOutputLocalAddress = isOutput;
    }

    @Override
    public boolean isOutputLocalAddress() {
        return this.isOutputLocalAddress;
    }

    @Override
    public void setOutputLocalPort(boolean isOutput) {
        this.isOutputLocalPort = isOutput;
    }

    @Override
    public boolean isOutputLocalPort() {
        return this.isOutputLocalPort;
    }

    @Override
    public void setOutputLocalName(boolean isOutput) {
        this.isOutputLocalName = isOutput;
    }

    @Override
    public boolean isOutputLocalName() {
        return this.isOutputLocalName;
    }

    @Override
    public void setOutputServerName(boolean isOutput) {
        this.isOutputServerName = isOutput;
    }

    @Override
    public boolean isOutputServerName() {
        return this.isOutputServerName;
    }

    @Override
    public void setOutputServerPort(boolean isOutput) {
        this.isOutputServerPort = isOutput;
    }

    @Override
    public boolean isOutputServerPort() {
        return this.isOutputServerPort;
    }

    @Override
    public void setOutputProtocol(boolean isOutput) {
        this.isOutputProtocol = isOutput;
    }

    @Override
    public boolean isOutputProtocol() {
        return this.isOutputProtocol;
    }

    @Override
    public void setOutputScheme(boolean isOutput) {
        this.isOutputScheme = isOutput;
    }

    @Override
    public boolean isOutputScheme() {
        return this.isOutputScheme;
    }

    @Override
    public void setOutputLocale(boolean isOutput) {
        this.isOutputLocale = isOutput;
    }

    @Override
    public boolean isOutputLocale() {
        return this.isOutputLocale;
    }

    @Override
    public void setOutputContentType(boolean isOutput) {
        this.isOutputContentType = isOutput;
    }

    @Override
    public boolean isOutputContentType() {
        return this.isOutputContentType;
    }

    @Override
    public void setOutputContentLength(boolean isOutput) {
        this.isOutputContentLength = isOutput;
    }

    @Override
    public boolean isOutputContentLength() {
        return this.isOutputContentLength;
    }

    @Override
    public void setOutputCharacterEncoding(boolean isOutput) {
        this.isOutputCharacterEncoding = isOutput;
    }

    @Override
    public boolean isOutputCharacterEncoding() {
        return this.isOutputCharacterEncoding;
    }

    @Override
    public void setOutputAttributes(boolean isOutput) {
        this.isOutputAttributes = isOutput;
    }

    @Override
    public boolean isOutputAttributes() {
        return this.isOutputAttributes;
    }

    @Override
    public void setOutputParameters(boolean isOutput) {
        this.isOutputParameters = isOutput;
    }

    @Override
    public boolean isOutputParameters() {
        return this.isOutputParameters;
    }

    @Override
    public void setSecretAttributes(String[] names) {
        this.secretAttributes = names;
    }

    @Override
    public String[] getSecretAttributes() {
        return this.secretAttributes;
    }

    @Override
    public void setEnabledAttributes(String[] names) {
        this.enabledAttributes = names;
    }

    @Override
    public String[] getEnabledAttributes() {
        return this.enabledAttributes;
    }

    @Override
    public void setSecretParameters(String[] names) {
        this.secretParameters = names;
    }

    @Override
    public String[] getSecretParameters() {
        return this.secretParameters;
    }

    @Override
    public void setEnabledParameters(String[] names) {
        this.enabledParameters = names;
    }

    @Override
    public String[] getEnabledParameters() {
        return this.enabledParameters;
    }

    @Override
    public void createService() {
        this.secretAttributeSet = new HashSet();
        this.secretParameterSet = new HashSet();
        this.enabledAttributeSet = new HashSet();
        this.enabledParameterSet = new HashSet();
    }

    @Override
    public void startService() {
        int i;
        if (this.secretAttributes != null) {
            for (i = 0; i < this.secretAttributes.length; ++i) {
                this.secretAttributeSet.add(this.secretAttributes[i]);
            }
        }
        if (this.enabledAttributes != null) {
            for (i = 0; i < this.enabledAttributes.length; ++i) {
                this.enabledAttributeSet.add(this.enabledAttributes[i]);
            }
        }
        if (this.secretParameters != null) {
            for (i = 0; i < this.secretParameters.length; ++i) {
                this.secretParameterSet.add(this.secretParameters[i]);
            }
        }
        if (this.enabledParameters != null) {
            for (i = 0; i < this.enabledParameters.length; ++i) {
                this.enabledParameterSet.add(this.enabledParameters[i]);
            }
        }
    }

    @Override
    public void stopService() {
        this.secretAttributeSet.clear();
        this.enabledAttributeSet.clear();
        this.secretParameterSet.clear();
        this.enabledParameterSet.clear();
    }

    @Override
    public void destroyService() {
        this.secretAttributeSet = null;
        this.enabledAttributeSet = null;
        this.secretParameterSet = null;
        this.enabledParameterSet = null;
    }

    @Override
    public Map toMap(EditorFinder finder, Object key, Object value) {
        ServletRequest request = (ServletRequest)value;
        HashMap result = new HashMap();
        if (this.isOutputRemoteAddress()) {
            this.makeRemoteAddressFormat(finder, key, request, result);
        }
        if (this.isOutputRemotePort()) {
            this.makeRemotePortFormat(finder, key, request, result);
        }
        if (this.isOutputRemoteHost()) {
            this.makeRemoteHostFormat(finder, key, request, result);
        }
        if (this.isOutputLocalAddress()) {
            this.makeLocalAddressFormat(finder, key, request, result);
        }
        if (this.isOutputLocalPort()) {
            this.makeLocalPortFormat(finder, key, request, result);
        }
        if (this.isOutputLocalName()) {
            this.makeLocalNameFormat(finder, key, request, result);
        }
        if (this.isOutputServerName()) {
            this.makeServerNameFormat(finder, key, request, result);
        }
        if (this.isOutputServerPort()) {
            this.makeServerPortFormat(finder, key, request, result);
        }
        if (this.isOutputProtocol()) {
            this.makeProtocolFormat(finder, key, request, result);
        }
        if (this.isOutputScheme()) {
            this.makeSchemeFormat(finder, key, request, result);
        }
        if (this.isOutputLocale()) {
            this.makeLocaleFormat(finder, key, request, result);
        }
        if (this.isOutputContentType()) {
            this.makeContentTypeFormat(finder, key, request, result);
        }
        if (this.isOutputContentLength()) {
            this.makeContentLengthFormat(finder, key, request, result);
        }
        if (this.isOutputCharacterEncoding()) {
            this.makeCharacterEncodingFormat(finder, key, request, result);
        }
        if (this.isOutputAttributes()) {
            this.makeAttributesFormat(finder, key, request, result);
        }
        if (this.isOutputParameters()) {
            this.makeParametersFormat(finder, key, request, result);
        }
        return result;
    }

    protected Map makeAttributesFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        Enumeration attrNames = request.getAttributeNames();
        if (!attrNames.hasMoreElements()) {
            return map;
        }
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        while (attrNames.hasMoreElements()) {
            String name = (String)attrNames.nextElement();
            if (!this.enabledAttributeSet.isEmpty() && !this.enabledAttributeSet.contains(name)) continue;
            if (this.secretAttributeSet.contains(name)) {
                subMap.put(name, null);
                continue;
            }
            subMap.put(name, this.makeObjectFormat(finder, null, request.getAttribute(name)));
        }
        map.put("Attributes", this.makeObjectFormat(finder, key, subMap));
        return map;
    }

    protected Map makeParametersFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        Enumeration paramNames = request.getParameterNames();
        if (!paramNames.hasMoreElements()) {
            return map;
        }
        HashMap<String, Object> subMap = new HashMap<String, Object>();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            if (!this.enabledParameterSet.isEmpty() && !this.enabledParameterSet.contains(name)) continue;
            if (this.secretParameterSet.contains(name)) {
                subMap.put(name, null);
                continue;
            }
            subMap.put(name, this.makeObjectFormat(finder, key, request.getParameterValues(name)));
        }
        map.put("Parameters", this.makeObjectFormat(finder, key, subMap));
        return map;
    }

    protected Map makeCharacterEncodingFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        map.put("CharacterEncoding", request.getCharacterEncoding());
        return map;
    }

    protected Map makeContentLengthFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        map.put("ContentLength", new Integer(request.getContentLength()));
        return map;
    }

    protected Map makeContentTypeFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        map.put("ContentType", request.getContentType());
        return map;
    }

    protected Map makeRemoteAddressFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        map.put("RemoteAddress", request.getRemoteAddr());
        return map;
    }

    protected Map makeRemotePortFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        try {
            int port = request.getRemotePort();
            map.put("RemotePort", new Integer(port));
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        return map;
    }

    protected Map makeRemoteHostFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        map.put("RemoteHost", request.getRemoteHost());
        return map;
    }

    protected Map makeLocalAddressFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        try {
            map.put("LocalAddress", request.getLocalAddr());
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        return map;
    }

    protected Map makeLocalPortFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        try {
            int port = request.getLocalPort();
            map.put("LocalPort", new Integer(port));
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        return map;
    }

    protected Map makeLocalNameFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        try {
            map.put("LocalName", request.getLocalName());
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        return map;
    }

    protected Map makeServerNameFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        map.put("ServerName", request.getServerName());
        return map;
    }

    protected Map makeServerPortFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        map.put("ServerPort", new Integer(request.getServerPort()));
        return map;
    }

    protected Map makeProtocolFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        map.put("Protocol", request.getProtocol());
        return map;
    }

    protected Map makeSchemeFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        map.put("Scheme", request.getScheme());
        return map;
    }

    protected Map makeLocaleFormat(EditorFinder finder, Object key, ServletRequest request, Map map) {
        map.put("Locale", request.getLocale());
        return map;
    }
}

