/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editor.ImmutableJournalEditorServiceBaseMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public abstract class ImmutableJournalEditorServiceBase
extends ServiceBase
implements ImmutableJournalEditorServiceBaseMBean,
Serializable {
    private static final long serialVersionUID = 481914013077689219L;
    protected static final String EMPTY_STRING = "";
    protected static final String NULL_STRING = "null";
    protected static final char BACK_SPACE = '\b';
    protected static final char CARRIAGE_RETURN = '\r';
    protected static final char LINE_FEED = '\n';
    protected static final char FORM_FEED = '\f';
    protected static final char HORIZONTAL_TAB = '\t';
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String INDENT_STRING = "  ";
    private String lineSeparator = LINE_SEPARATOR;
    private String indent = "  ";
    private boolean isOutputKey = false;
    private boolean isOutputIndent = true;

    @Override
    public void setOutputKey(boolean isOutput) {
        this.isOutputKey = isOutput;
    }

    @Override
    public boolean isOutputKey() {
        return this.isOutputKey;
    }

    @Override
    public void setOutputIndent(boolean isOutput) {
        this.isOutputIndent = isOutput;
    }

    @Override
    public boolean isOutputIndent() {
        return this.isOutputIndent;
    }

    @Override
    public void setLineSeparator(String separator) {
        this.lineSeparator = this.convertEscapeLiteral(separator);
    }

    @Override
    public String getLineSeparator() {
        return this.lineSeparator;
    }

    @Override
    public void setIndent(String indent) {
        this.indent = indent;
    }

    @Override
    public String getIndent() {
        return this.indent;
    }

    @Override
    public Object toObject(EditorFinder finder, Object key, Object value) {
        return this.toString(finder, key, value);
    }

    @Override
    public String toString(EditorFinder finder, Object key, Object value) {
        StringBuffer buf = new StringBuffer();
        if (this.isOutputKey()) {
            this.makeKeyFormat(finder, key, value, buf);
        }
        return this.toString(finder, key, value, buf);
    }

    protected String toString(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        return buf.toString();
    }

    protected StringBuffer makeKeyFormat(EditorFinder finder, Object key, Object obj, StringBuffer buf) {
        if (key == null) {
            return buf;
        }
        return buf.append('[').append(key).append(']');
    }

    protected StringBuffer makeObjectFormat(EditorFinder finder, Object key, Object obj, StringBuffer buf) {
        Object value = null;
        if (obj != null) {
            JournalEditor editor = finder.findEditor(key, obj.getClass());
            value = editor != null ? editor.toObject(finder, key, obj) : obj.toString();
        }
        return buf.append(value);
    }

    protected StringBuffer addIndent(StringBuffer buf) {
        if (!this.isOutputIndent) {
            return buf;
        }
        return this.setIndent(buf, 1);
    }

    protected String addIndent(String str) {
        if (!this.isOutputIndent) {
            return str;
        }
        return this.setIndent(str, 1);
    }

    protected StringBuffer setIndent(StringBuffer buf, int indent) {
        if (!this.isOutputIndent) {
            return buf;
        }
        String str = buf.toString();
        buf.setLength(0);
        return buf.append(this.setIndent(str, indent));
    }

    protected String setIndent(String str, int indent) {
        if (str == null) {
            return null;
        }
        if (!this.isOutputIndent || indent == 0 || this.getIndent() == null || this.getIndent().length() == 0) {
            return str;
        }
        int length = str.length();
        if (length == 0) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        String indentString = null;
        if (indent <= 0) {
            indentString = this.getIndent();
        } else {
            for (int i = 0; i < indent; ++i) {
                buf.append(this.getIndent());
            }
            indentString = buf.toString();
            buf.setLength(0);
        }
        int indentLength = indentString.length();
        int lsLength = this.getLineSeparator().length();
        buf.append(str);
        buf.insert(0, indentString);
        int index = 0;
        int offset = 0;
        while ((index = buf.indexOf(this.getLineSeparator(), offset)) != -1 && index + lsLength != buf.length()) {
            buf.insert(index + lsLength, indentString);
            offset = index + lsLength + indentLength;
        }
        return buf.toString();
    }

    private String convertEscapeLiteral(String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length == 0) {
            return str;
        }
        int index = str.indexOf(92);
        if (index == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.substring(index));
        boolean isInEscape = false;
        for (int i = index; i < length; ++i) {
            int c = str.charAt(i);
            if (!isInEscape && c == 92) {
                isInEscape = true;
                continue;
            }
            if (isInEscape) {
                switch (c) {
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 92: {
                        break;
                    }
                    default: {
                        buf.append('\\');
                    }
                }
            }
            buf.append((char)c);
            isInEscape = false;
        }
        return buf.toString();
    }
}

