/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import jp.ossc.nimbus.service.jms.ReconnectableConnection;
import jp.ossc.nimbus.service.jms.ReconnectableMessageConsumer;
import jp.ossc.nimbus.service.jms.ReconnectableMessageProducer;
import jp.ossc.nimbus.service.jms.ReconnectableQueueReceiver;
import jp.ossc.nimbus.service.jms.ReconnectableQueueSender;
import jp.ossc.nimbus.service.jms.ReconnectableTopicPublisher;
import jp.ossc.nimbus.service.jms.ReconnectableTopicSubscriber;

public class ReconnectableSession
implements XASession {
    protected ReconnectableConnection connection;
    protected Session session;
    protected boolean isClose;
    protected int acknowledgeMode;
    protected Set messageConsumers;
    protected Set messageProducers;
    protected boolean transacted;
    protected MessageListener messageListener;

    public ReconnectableSession(ReconnectableConnection con) throws JMSException {
        this.connection = con;
        this.session = this.createXASession();
    }

    public ReconnectableSession(ReconnectableConnection con, boolean transacted, int acknowledgeMode) throws JMSException {
        this.connection = con;
        this.acknowledgeMode = acknowledgeMode;
        this.session = this.createSession(transacted, acknowledgeMode);
    }

    protected Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.transacted = transacted;
        return this.connection.getConnection().createSession(transacted, acknowledgeMode);
    }

    protected Session createXASession() throws JMSException {
        return ((XAConnection)this.connection.getConnection()).createXASession();
    }

    public Session getRealSession() {
        return this.session;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.session.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.session.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.session.createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.session.createTextMessage(text);
    }

    public boolean getTransacted() throws JMSException {
        return this.session.getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.session.getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        this.session.commit();
    }

    public void rollback() throws JMSException {
        this.session.rollback();
    }

    public void close() throws JMSException {
        this.isClose = true;
        this.connection.removeSession(this.session);
        this.messageConsumers = null;
        this.messageProducers = null;
        this.session.close();
    }

    public void recover() throws JMSException {
        this.session.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.session.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.messageListener = listener;
        this.session.setMessageListener(listener);
    }

    public void run() {
        this.session.run();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        ReconnectableMessageProducer messageProducer = null;
        messageProducer = destination instanceof Queue ? new ReconnectableQueueSender(this, (Destination)((Queue)destination)) : new ReconnectableTopicPublisher(this, (Destination)((Topic)destination));
        this.addMessageProducer(messageProducer);
        return messageProducer;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        ReconnectableMessageConsumer messageConsumer = null;
        messageConsumer = destination instanceof Queue ? new ReconnectableQueueReceiver(this, (Queue)destination) : new ReconnectableTopicSubscriber(this, (Topic)destination);
        this.addMessageConsumer(messageConsumer);
        return messageConsumer;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        ReconnectableMessageConsumer messageConsumer = null;
        messageConsumer = destination instanceof Queue ? new ReconnectableQueueReceiver(this, (Queue)destination, messageSelector) : new ReconnectableTopicSubscriber(this, (Topic)destination, messageSelector, false);
        this.addMessageConsumer(messageConsumer);
        return messageConsumer;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        ReconnectableMessageConsumer messageConsumer = null;
        messageConsumer = destination instanceof Queue ? new ReconnectableQueueReceiver(this, (Queue)destination, messageSelector) : new ReconnectableTopicSubscriber(this, (Topic)destination, messageSelector, noLocal);
        this.addMessageConsumer(messageConsumer);
        return messageConsumer;
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.session.createQueue(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.session.createTopic(topicName);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        ReconnectableTopicSubscriber subscriber = new ReconnectableTopicSubscriber(this, topic, name);
        this.addMessageConsumer(subscriber);
        return subscriber;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        ReconnectableTopicSubscriber subscriber = new ReconnectableTopicSubscriber(this, topic, name, messageSelector, noLocal);
        this.addMessageConsumer(subscriber);
        return subscriber;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.session.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.session.createBrowser(queue, messageSelector);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.session.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.session.createTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        this.session.unsubscribe(name);
    }

    public Session getSession() throws JMSException {
        return ((XASession)this.session).getSession();
    }

    public XAResource getXAResource() {
        return ((XASession)this.session).getXAResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() throws JMSException {
        Set set;
        if (this.isClose) {
            return;
        }
        Session newSession = this.createSession(this.transacted, this.acknowledgeMode);
        if (this.messageListener != null) {
            newSession.setMessageListener(this.messageListener);
        }
        this.session = newSession;
        if (this.messageConsumers != null) {
            set = this.messageConsumers;
            synchronized (set) {
                if (this.messageConsumers != null) {
                    for (ReconnectableMessageConsumer consumer : this.messageConsumers) {
                        consumer.reconnect();
                    }
                }
            }
        }
        if (this.messageProducers != null) {
            set = this.messageProducers;
            synchronized (set) {
                if (this.messageProducers != null) {
                    for (ReconnectableMessageProducer producer : this.messageProducers) {
                        producer.reconnect();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessageConsumer(MessageConsumer messageConsumer) {
        if (this.messageConsumers == null) {
            this.messageConsumers = new HashSet();
        }
        Set set = this.messageConsumers;
        synchronized (set) {
            if (this.messageConsumers != null) {
                this.messageConsumers.add(messageConsumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageConsumer(MessageConsumer messageConsumer) {
        if (this.messageConsumers == null) {
            return;
        }
        Set set = this.messageConsumers;
        synchronized (set) {
            if (this.messageConsumers != null) {
                this.messageConsumers.remove(messageConsumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessageProducer(MessageProducer messageProducer) {
        if (this.messageProducers == null) {
            this.messageProducers = new HashSet();
        }
        Set set = this.messageProducers;
        synchronized (set) {
            if (this.messageProducers != null) {
                this.messageProducers.add(messageProducer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageProducer(MessageProducer messageProducer) {
        if (this.messageProducers == null) {
            return;
        }
        Set set = this.messageProducers;
        synchronized (set) {
            if (this.messageProducers != null) {
                this.messageProducers.remove(messageProducer);
            }
        }
    }
}

