/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import jp.ossc.nimbus.service.jms.ReconnectableMessageProducer;
import jp.ossc.nimbus.service.jms.ReconnectableSession;

public class ReconnectableQueueSender
extends ReconnectableMessageProducer
implements QueueSender {
    public ReconnectableQueueSender(ReconnectableSession session, Destination destination) throws JMSException {
        super(session, destination);
    }

    @Override
    protected MessageProducer createMessageProducer(ReconnectableSession session, Destination destination) throws JMSException {
        this.destination = destination;
        return ((QueueSession)session.getRealSession()).createSender((Queue)destination);
    }

    @Override
    public Destination getDestination() throws JMSException {
        return this.getQueue();
    }

    public Queue getQueue() throws JMSException {
        return ((QueueSender)this.messageProducer).getQueue();
    }

    @Override
    public void send(Message message) throws JMSException {
        ((QueueSender)this.messageProducer).send(message);
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        ((QueueSender)this.messageProducer).send(message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, Message message) throws JMSException {
        ((QueueSender)this.messageProducer).send(queue, message);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        ((QueueSender)this.messageProducer).send(queue, message, deliveryMode, priority, timeToLive);
    }
}

