/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import java.util.HashSet;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.jms.JMSConnectionCreateException;
import jp.ossc.nimbus.service.jms.JMSConnectionFactory;
import jp.ossc.nimbus.service.jms.JMSConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.jms.ReconnectableConnection;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.keepalive.KeepAliveChecker;

public class JMSConnectionFactoryService
extends ServiceBase
implements JMSConnectionFactory,
JMSConnectionFactoryServiceMBean,
CacheRemoveListener {
    private static final long serialVersionUID = -8996430918339950670L;
    protected ServiceName jndiFinderServiceName;
    protected JndiFinder jndiFinder;
    protected String userName;
    protected String password;
    protected String connectionFactoryName = "java:XAConnectionFactory";
    protected ConnectionFactory connectionFactory;
    protected Connection connection;
    protected Set connections;
    protected boolean isSingleConnection = true;
    protected boolean isConnectionManagement;
    protected boolean isStartConnection;
    protected String connectionKey = "JMSConnection";
    protected ServiceName connectionCacheMapServiceName;
    protected CacheMap connectionCache;
    protected int autoReconnectMode = 0;
    protected ServiceName jndiKeepAliveCheckerServiceName;
    protected KeepAliveChecker jndiKeepAliveChecker;
    protected String autoReconnectErrorLogMessageId;
    protected int autoReconnectMaxRetryCount;
    protected long autoReconnectRetryInterval = 1000L;

    @Override
    public void setConnectionManagement(boolean isManaged) {
        this.isConnectionManagement = isManaged;
    }

    @Override
    public boolean isConnectionManagement() {
        return this.isConnectionManagement;
    }

    @Override
    public void setSingleConnection(boolean isSingle) {
        this.isSingleConnection = isSingle;
    }

    @Override
    public boolean isSingleConnection() {
        return this.isSingleConnection;
    }

    @Override
    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    @Override
    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    @Override
    public void setConnectionFactoryName(String name) {
        this.connectionFactoryName = name;
    }

    @Override
    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    @Override
    public void setUserName(String name) {
        this.userName = name;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setPassword(String passwd) {
        this.password = passwd;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setConnectionKey(String key) {
        this.connectionKey = key;
    }

    @Override
    public String getConnectionKey() {
        return this.connectionKey;
    }

    @Override
    public void setConnectionCacheMapServiceName(ServiceName name) {
        this.connectionCacheMapServiceName = name;
    }

    @Override
    public ServiceName getConnectionCacheMapServiceName() {
        return this.connectionCacheMapServiceName;
    }

    @Override
    public void setAutoReconnectMode(int mode) {
        this.autoReconnectMode = mode;
    }

    @Override
    public int getAutoReconnectMode() {
        return this.autoReconnectMode;
    }

    @Override
    public void setJndiKeepAliveCheckerServiceName(ServiceName name) {
        this.jndiKeepAliveCheckerServiceName = name;
    }

    @Override
    public ServiceName getJndiKeepAliveCheckerServiceName() {
        return this.jndiKeepAliveCheckerServiceName;
    }

    @Override
    public void setAutoReconnectErrorLogMessageId(String id) {
        this.autoReconnectErrorLogMessageId = id;
    }

    @Override
    public String getAutoReconnectErrorLogMessageId() {
        return this.autoReconnectErrorLogMessageId;
    }

    @Override
    public void setStartConnection(boolean isStart) {
        this.isStartConnection = isStart;
    }

    @Override
    public boolean isStartConnection() {
        return this.isStartConnection;
    }

    @Override
    public void setAutoReconnectMaxRetryCount(int count) {
        this.autoReconnectMaxRetryCount = count;
    }

    @Override
    public int getAutoReconnectMaxRetryCount() {
        return this.autoReconnectMaxRetryCount;
    }

    @Override
    public void setAutoReconnectRetryInterval(long interval) {
        this.autoReconnectRetryInterval = interval;
    }

    @Override
    public long getAutoReconnectRetryInterval() {
        return this.autoReconnectRetryInterval;
    }

    public void setJndiKeepAliveChecker(KeepAliveChecker checker) {
        this.jndiKeepAliveChecker = checker;
    }

    public void setJndiFinder(JndiFinder jndiFinder) {
        this.jndiFinder = jndiFinder;
    }

    public void setCacheMap(CacheMap connectionCache) {
        this.connectionCache = connectionCache;
    }

    @Override
    public void createService() throws Exception {
        this.connections = new HashSet();
    }

    @Override
    public void startService() throws Exception {
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        } else if (this.jndiFinder == null) {
            throw new IllegalArgumentException("JndiFinderServiceName or JndiFinder must be specified.");
        }
        if (this.connectionCacheMapServiceName != null) {
            this.connectionCache = (CacheMap)ServiceManagerFactory.getServiceObject(this.connectionCacheMapServiceName);
        }
        this.connectionFactory = (ConnectionFactory)this.jndiFinder.lookup(this.connectionFactoryName);
        if ((this.autoReconnectMode == AUTO_RECONNECT_MODE_ON_RECOVER || this.autoReconnectMode == AUTO_RECONNECT_MODE_ON_DEAD) && this.jndiKeepAliveCheckerServiceName == null) {
            throw new IllegalArgumentException("JndiKeepAliveCheckerServiceName or JndiKeepAliveChecker must be specified.");
        }
        if (this.jndiKeepAliveCheckerServiceName != null) {
            this.jndiKeepAliveChecker = (KeepAliveChecker)ServiceManagerFactory.getServiceObject(this.jndiKeepAliveCheckerServiceName);
        }
        if (this.isSingleConnection) {
            this.getConnection();
        }
    }

    @Override
    public void stopService() throws Exception {
        this.connectionFactory = null;
        if (this.connection != null) {
            try {
                this.connection.stop();
            }
            catch (JMSException e) {
                // empty catch block
            }
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        this.connection = null;
        if (this.connections != null && this.connections.size() != 0) {
            for (Connection con : this.connections) {
                try {
                    con.stop();
                }
                catch (JMSException e) {
                    // empty catch block
                }
                try {
                    con.close();
                }
                catch (JMSException jMSException) {}
            }
            this.connections.clear();
        }
        if (this.connectionCache != null) {
            this.connectionCache.remove(this.connectionKey);
        }
    }

    @Override
    public void destroyService() throws Exception {
        this.connections = null;
    }

    @Override
    public synchronized Connection getConnection() throws JMSConnectionCreateException {
        return this.getConnection(this.userName, this.password);
    }

    @Override
    public synchronized Connection getConnection(String user, String pwd) throws JMSConnectionCreateException {
        if (this.connectionFactory == null) {
            throw new JMSConnectionCreateException("ConnectionFactory is null.");
        }
        Connection con = null;
        if (this.isSingleConnection) {
            if (this.connectionCache != null) {
                con = (Connection)this.connectionCache.get(this.connectionKey);
                if (con != null) {
                    return con;
                }
            } else if (this.connection != null) {
                return this.connection;
            }
        }
        try {
            if (this.isSingleConnection) {
                if (this.connectionCache != null) {
                    con = (Connection)this.connectionCache.get(this.connectionKey);
                    if (con != null) {
                        return con;
                    }
                } else if (this.connection != null) {
                    return this.connection;
                }
            }
            con = this.createConnection(user, pwd);
            if (this.isSingleConnection && con != null) {
                if (this.connectionCache != null) {
                    this.connectionCache.put(this.connectionKey, con);
                    this.connectionCache.getCachedReference(this.connectionKey).addCacheRemoveListener(this);
                } else {
                    this.connection = con;
                }
            }
            if (this.isConnectionManagement) {
                this.connections.add(con);
            }
            if (this.isStartConnection) {
                con.start();
            }
        }
        catch (JMSException e) {
            throw new JMSConnectionCreateException(e);
        }
        return con;
    }

    protected Connection createConnection(String user, String pwd) throws JMSException, JMSConnectionCreateException {
        if (this.autoReconnectMode == AUTO_RECONNECT_MODE_ON_RECOVER || this.autoReconnectMode == AUTO_RECONNECT_MODE_ON_DEAD) {
            ReconnectableConnection con = null;
            con = user == null ? new ReconnectableConnection(this.connectionFactory) : new ReconnectableConnection(this.connectionFactory, user, pwd);
            con.setKeepAliveChecker(this.jndiKeepAliveChecker);
            con.setReconnectMode(this.autoReconnectMode);
            if (this.autoReconnectErrorLogMessageId != null) {
                con.setReconnectErrorLogMessageId(this.autoReconnectErrorLogMessageId);
                con.setLogger(this.getLogger());
            }
            con.setReconnectMaxRetryCount(this.autoReconnectMaxRetryCount);
            con.setReconnectRetryInterval(this.autoReconnectRetryInterval);
            return con;
        }
        if (user != null) {
            return this.connectionFactory.createConnection(user, pwd);
        }
        return this.connectionFactory.createConnection();
    }

    @Override
    public void removed(CachedReference ref) {
        Connection con = (Connection)ref.get();
        if (con != null) {
            try {
                con.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

