/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.converter;

import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.converter.CodeMasterConverter;
import jp.ossc.nimbus.service.converter.CodeMasterConverterServiceMBean;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.Converter;

public class CodeMasterConverterService
extends ServiceBase
implements Converter,
CodeMasterConverterServiceMBean {
    private static final long serialVersionUID = -1293434754491458419L;
    protected ServiceName threadContextServiceName;
    protected String threadContextKey = "CODE_MASTER";
    protected Context threadContext;
    protected ServiceName codeMasterFinderServiceName;
    protected CodeMasterFinder codeMasterFinder;
    protected String masterName;
    protected ServiceName codeMasterConverterServiceName;
    protected CodeMasterConverter codeMasterConverter;

    @Override
    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    @Override
    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    @Override
    public void setThreadContextKey(String key) {
        this.threadContextKey = key;
    }

    @Override
    public String getThreadContextKey() {
        return this.threadContextKey;
    }

    @Override
    public void setCodeMasterFinderServiceName(ServiceName name) {
        this.codeMasterFinderServiceName = name;
    }

    @Override
    public ServiceName getCodeMasterFinderServiceName() {
        return this.codeMasterFinderServiceName;
    }

    @Override
    public void setMasterName(String name) {
        this.masterName = name;
    }

    @Override
    public String getMasterName() {
        return this.masterName;
    }

    @Override
    public void setCodeMasterConverterServiceName(ServiceName name) {
        this.codeMasterConverterServiceName = name;
    }

    @Override
    public ServiceName getCodeMasterConverterServiceName() {
        return this.codeMasterConverterServiceName;
    }

    public void setThreadContext(Context context) {
        this.threadContext = context;
    }

    public Context getThreadContext() {
        return this.threadContext;
    }

    public void setCodeMasterFinder(CodeMasterFinder finder) {
        this.codeMasterFinder = finder;
    }

    public CodeMasterFinder getCodeMasterFinder() {
        return this.codeMasterFinder;
    }

    public void setCodeMasterConverter(CodeMasterConverter converter) {
        this.codeMasterConverter = converter;
    }

    public CodeMasterConverter getCodeMasterConverter() {
        return this.codeMasterConverter;
    }

    @Override
    public void startService() throws Exception {
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
        if (this.codeMasterFinderServiceName != null) {
            this.codeMasterFinder = (CodeMasterFinder)ServiceManagerFactory.getServiceObject(this.codeMasterFinderServiceName);
        }
        if (this.threadContext == null && this.codeMasterFinder == null) {
            throw new IllegalArgumentException("It is necessary to set either of ThreadContext or CodeMasterFinder.");
        }
        if (this.masterName == null) {
            throw new IllegalArgumentException("MasterName must be specified.");
        }
        if (this.codeMasterConverterServiceName != null) {
            this.codeMasterConverter = (CodeMasterConverter)ServiceManagerFactory.getServiceObject(this.codeMasterConverterServiceName);
        }
        if (this.codeMasterConverter == null) {
            throw new IllegalArgumentException("CodeMasterConverter must be specified.");
        }
    }

    @Override
    public Object convert(Object obj) throws ConvertException {
        return this.codeMasterConverter.convert(this.getCodeMaster(), obj);
    }

    protected Object getCodeMaster() throws ConvertException {
        Object master = this.getCodeMasters().get(this.masterName);
        if (master == null) {
            throw new ConvertException("CodeMaster not found.");
        }
        return master;
    }

    protected Map getCodeMasters() throws ConvertException {
        Map masters = null;
        masters = this.threadContext != null ? (Map)this.threadContext.get(this.threadContextKey) : this.codeMasterFinder.getCodeMasters();
        if (masters == null) {
            throw new ConvertException("CodeMasters not found.");
        }
        return masters;
    }
}

