/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertySetException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.service.context.SharedContextRecordList;
import jp.ossc.nimbus.service.context.SharedContextUpdateException;
import jp.ossc.nimbus.service.context.SharedContextValueDifference;
import jp.ossc.nimbus.service.context.SharedContextValueDifferenceSupport;

public class SharedContextRecord
extends Record
implements SharedContextValueDifferenceSupport {
    protected SharedContextRecordList recordList;
    protected int index = -1;
    protected int updateVersion;

    public SharedContextRecord() {
    }

    public SharedContextRecord(String schema) throws PropertySchemaDefineException {
        super(schema);
    }

    public SharedContextRecord(RecordSchema recordSchema) {
        super(recordSchema);
    }

    protected void setRecordList(SharedContextRecordList list) {
        this.recordList = list;
    }

    protected SharedContextRecordList getRecordList() {
        return this.recordList;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void setUpdateVersion(int version) {
        this.updateVersion = version;
    }

    @Override
    public int getUpdateVersion() {
        return this.updateVersion;
    }

    protected static int compareToUpdateVersion(int ver1, int ver2) {
        long version1 = ver1;
        long version2 = ver2;
        long middle = Integer.MAX_VALUE;
        if (version1 == version2) {
            return 0;
        }
        if (version1 > version2) {
            if (version1 - version2 > Integer.MAX_VALUE) {
                return (version1 -= Integer.MAX_VALUE) > version2 ? 1 : -1;
            }
            return 1;
        }
        if (version2 - version1 > Integer.MAX_VALUE) {
            return version1 > (version2 -= Integer.MAX_VALUE) ? -1 : 1;
        }
        return -1;
    }

    public SharedContextValueDifference updateProperty(String name, Object val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        RecordSchema recordSchema = this.getRecordSchema();
        if (recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        PropertySchema propertySchema = recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertySetException(null, "No such property : " + name);
        }
        return this.updateProperty(recordSchema.getPropertyIndex(name), val, diff);
    }

    public SharedContextValueDifference updateProperty(int index, Object val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        if (this.getRecordList() == null) {
            if (diff == null) {
                diff = new Difference();
            } else if (!(diff instanceof Difference)) {
                throw new SharedContextUpdateException("Unsupported type. class=" + diff.getClass().getName());
            }
            ((Difference)diff).updateProperty(this, index, val);
        } else {
            if (diff == null) {
                diff = new SharedContextRecordList.Difference();
            } else if (!(diff instanceof SharedContextRecordList.Difference)) {
                throw new SharedContextUpdateException("Unsupported type. class=" + diff.getClass().getName());
            }
            Difference recordDiff = ((SharedContextRecordList.Difference)diff).getRecordDifference(this.index);
            if (recordDiff == null) {
                recordDiff = new Difference();
            }
            recordDiff.updateProperty(this, index, val);
            ((SharedContextRecordList.Difference)diff).updateRecord(this.getRecordList(), this.index, recordDiff);
        }
        return diff;
    }

    public SharedContextValueDifference updateProperty(String name, boolean val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(name, (Object)(val ? Boolean.TRUE : Boolean.FALSE), diff);
    }

    public SharedContextValueDifference updateProperty(int index, boolean val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(index, (Object)(val ? Boolean.TRUE : Boolean.FALSE), diff);
    }

    public SharedContextValueDifference updateProperty(String name, byte val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(name, (Object)new Byte(val), diff);
    }

    public SharedContextValueDifference updateProperty(int index, byte val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(index, (Object)new Byte(val), diff);
    }

    public SharedContextValueDifference updateProperty(String name, char val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(name, (Object)new Character(val), diff);
    }

    public SharedContextValueDifference updateProperty(int index, char val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(index, (Object)new Character(val), diff);
    }

    public SharedContextValueDifference updateProperty(String name, short val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(name, (Object)new Short(val), diff);
    }

    public SharedContextValueDifference updateProperty(int index, short val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(index, (Object)new Short(val), diff);
    }

    public SharedContextValueDifference updateProperty(String name, int val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(name, (Object)new Integer(val), diff);
    }

    public SharedContextValueDifference updateProperty(int index, int val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(index, (Object)new Integer(val), diff);
    }

    public SharedContextValueDifference updateProperty(String name, long val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(name, (Object)new Long(val), diff);
    }

    public SharedContextValueDifference updateProperty(int index, long val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(index, (Object)new Long(val), diff);
    }

    public SharedContextValueDifference updateProperty(String name, float val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(name, (Object)new Float(val), diff);
    }

    public SharedContextValueDifference updateProperty(int index, float val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(index, (Object)new Float(val), diff);
    }

    public SharedContextValueDifference updateProperty(String name, double val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(name, (Object)new Double(val), diff);
    }

    public SharedContextValueDifference updateProperty(int index, double val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        return this.updateProperty(index, (Object)new Double(val), diff);
    }

    public SharedContextValueDifference updateParseProperty(String name, Object val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        RecordSchema recordSchema = this.getRecordSchema();
        if (recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        PropertySchema propertySchema = recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertySetException(null, "No such property : " + name);
        }
        return this.updateProperty(recordSchema.getPropertyIndex(name), propertySchema.parse(val), diff);
    }

    public SharedContextValueDifference updateParseProperty(int index, Object val, SharedContextValueDifference diff) throws PropertySetException, SharedContextUpdateException {
        RecordSchema recordSchema = this.getRecordSchema();
        if (recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        PropertySchema propertySchema = recordSchema.getPropertySchema(index);
        if (propertySchema == null) {
            throw new PropertySetException(null, "No such property : " + index);
        }
        return this.updateProperty(index, propertySchema.parse(val), diff);
    }

    @Override
    public boolean update(SharedContextValueDifference diff) throws SharedContextUpdateException {
        if (!(diff instanceof Difference)) {
            throw new SharedContextUpdateException("Unsupported type. class=" + diff.getClass().getName());
        }
        return ((Difference)diff).updateRecord(this);
    }

    protected static void writeInt(ObjectOutput out, int val) throws IOException {
        if (val >= -128 && val <= 127) {
            out.writeByte(1);
            out.writeByte((byte)val);
        } else if (val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) {
            out.writeByte(2);
            out.writeShort((short)val);
        } else {
            out.writeByte(3);
            out.writeInt(val);
        }
    }

    protected static int readInt(ObjectInput in) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 1: {
                return in.readByte();
            }
            case 2: {
                return in.readShort();
            }
        }
        return in.readInt();
    }

    @Override
    protected void writeExternalValues(ObjectOutput out) throws IOException {
        super.writeExternalValues(out);
        SharedContextRecord.writeInt(out, this.updateVersion);
    }

    @Override
    protected void readExternalValues(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalValues(in);
        this.updateVersion = SharedContextRecord.readInt(in);
    }

    public static class Difference
    implements SharedContextValueDifference,
    Externalizable {
        private int updateVersion;
        private Map updateValueMap;

        @Override
        public int getUpdateVersion() {
            return this.updateVersion;
        }

        public void updateProperty(SharedContextRecord record, int index, Object value) throws SharedContextUpdateException {
            Integer key = new Integer(index);
            try {
                Object old = record.getProperty(index);
                if (old == null && value != null || old != null && value == null || old != null && !old.equals(value)) {
                    if (this.updateValueMap == null) {
                        this.updateValueMap = new HashMap();
                    }
                    this.updateValueMap.put(key, value);
                } else if (this.updateValueMap != null && this.updateValueMap.containsKey(key)) {
                    this.updateValueMap.remove(key);
                }
            }
            catch (PropertyGetException e) {
                throw new SharedContextUpdateException(e);
            }
            this.updateVersion = record.getUpdateVersion() + 1;
        }

        public boolean updateRecord(SharedContextRecord record) throws SharedContextUpdateException {
            if (this.updateValueMap != null && this.updateValueMap.size() != 0) {
                if (SharedContextRecord.compareToUpdateVersion(record.getUpdateVersion(), this.updateVersion) >= 0) {
                    return true;
                }
                if (record.getUpdateVersion() + 1 != this.updateVersion) {
                    return false;
                }
                try {
                    for (Map.Entry entry : this.updateValueMap.entrySet()) {
                        record.setProperty((int)((Integer)entry.getKey()), entry.getValue());
                    }
                }
                catch (PropertySetException e) {
                    throw new SharedContextUpdateException(e);
                }
            }
            record.setUpdateVersion(this.updateVersion);
            return true;
        }

        public int[] getUpdatePropertyIndexs() {
            if (this.updateValueMap == null || this.updateValueMap.size() == 0) {
                return null;
            }
            int[] result = new int[this.updateValueMap.size()];
            int index = 0;
            Iterator itr = this.updateValueMap.keySet().iterator();
            while (itr.hasNext()) {
                result[index++] = (Integer)itr.next();
            }
            return result;
        }

        public Object getUpdateProperty(int index) {
            return this.updateValueMap == null ? null : this.updateValueMap.get(new Integer(index));
        }

        public void removeUpdateProperty(int index) {
            if (this.updateValueMap != null) {
                this.updateValueMap.remove(new Integer(index));
            }
        }

        public boolean isUpdate(int index) {
            return this.updateValueMap == null ? false : this.updateValueMap.containsKey(new Integer(index));
        }

        @Override
        public boolean isUpdate() {
            return this.updateValueMap != null && this.updateValueMap.size() != 0;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.updateValueMap);
            SharedContextRecord.writeInt(out, this.updateVersion);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.updateValueMap = (Map)in.readObject();
            this.updateVersion = SharedContextRecord.readInt(in);
        }
    }
}

