/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.context.ContextStore;
import jp.ossc.nimbus.service.context.DefaultContextServiceMBean;

public class DefaultContextService
extends ServiceBase
implements Context,
DefaultContextServiceMBean,
Serializable {
    private static final long serialVersionUID = 920050666611019516L;
    protected Map context;
    protected ServiceName contextStoreServiceName;
    protected ContextStore contextStore;
    protected boolean isLoadOnStart;
    protected boolean isLoadKeyOnStart;
    protected boolean isSaveOnStop;
    protected boolean isClearBeforeSave = true;

    @Override
    public void setContextStoreServiceName(ServiceName name) {
        this.contextStoreServiceName = name;
    }

    @Override
    public ServiceName getContextStoreServiceName() {
        return this.contextStoreServiceName;
    }

    @Override
    public void setLoadOnStart(boolean isLoad) {
        this.isLoadOnStart = isLoad;
    }

    @Override
    public boolean isLoadOnStart() {
        return this.isLoadOnStart;
    }

    @Override
    public void setLoadKeyOnStart(boolean isLoad) {
        this.isLoadKeyOnStart = isLoad;
    }

    @Override
    public boolean isLoadKeyOnStart() {
        return this.isLoadKeyOnStart;
    }

    @Override
    public void setSaveOnStop(boolean isSave) {
        this.isSaveOnStop = isSave;
    }

    @Override
    public boolean isSaveOnStop() {
        return this.isSaveOnStop;
    }

    @Override
    public void setClearBeforeSave(boolean isClear) {
        this.isClearBeforeSave = isClear;
    }

    @Override
    public boolean isClearBeforeSave() {
        return this.isClearBeforeSave;
    }

    public void setContextStore(ContextStore store) {
        this.contextStore = store;
    }

    @Override
    public void createService() throws Exception {
        this.context = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void startService() throws Exception {
        if (this.contextStoreServiceName != null) {
            this.contextStore = (ContextStore)ServiceManagerFactory.getServiceObject(this.contextStoreServiceName);
        }
        if (this.contextStore == null && (this.isLoadOnStart || this.isLoadKeyOnStart || this.isSaveOnStop)) {
            throw new IllegalArgumentException("ContextStore is null.");
        }
        if (this.isLoadOnStart) {
            this.load();
        } else if (this.isLoadKeyOnStart) {
            this.loadKey();
        }
    }

    @Override
    public void stopService() throws Exception {
        if (this.isSaveOnStop) {
            this.save();
        }
        this.context.clear();
    }

    @Override
    public void destroyService() throws Exception {
        this.context = null;
    }

    @Override
    public synchronized void load() throws Exception {
        if (this.contextStore != null) {
            this.contextStore.load(this);
        }
    }

    @Override
    public synchronized void loadKey() throws Exception {
        if (this.contextStore != null) {
            this.contextStore.loadKey(this);
        }
    }

    @Override
    public void load(Object key) throws Exception {
        if (this.contextStore != null) {
            this.contextStore.load(this, key);
        }
    }

    @Override
    public synchronized void save() throws Exception {
        if (this.contextStore != null) {
            if (this.isClearBeforeSave) {
                this.contextStore.clear();
            }
            this.contextStore.save(this);
        }
    }

    @Override
    public void save(Object key) throws Exception {
        if (this.contextStore != null) {
            this.contextStore.save(this, key);
        }
    }

    @Override
    public Object get(Object key) {
        Object val = this.context.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof ServiceName) {
            ServiceName name = (ServiceName)val;
            try {
                val = ServiceManagerFactory.getServiceObject(name);
            }
            catch (ServiceNotFoundException e) {
                val = null;
            }
        }
        return val;
    }

    @Override
    public Object put(Object key, Object value) {
        return this.context.put(key, value);
    }

    @Override
    public Set keySet() {
        return this.context.keySet();
    }

    @Override
    public Collection values() {
        return this.context.values();
    }

    @Override
    public Object remove(Object key) {
        return this.context.remove(key);
    }

    @Override
    public void clear() {
        this.context.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.context.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.context.containsValue(value);
    }

    @Override
    public Set entrySet() {
        return this.context.entrySet();
    }

    @Override
    public int size() {
        return this.context.size();
    }

    @Override
    public void putAll(Map t) {
        this.context.putAll(t);
    }

    public Hashtable cloneHash() {
        return new Hashtable(this.context);
    }

    @Override
    public Object get(String key) {
        return this.get((Object)key);
    }

    @Override
    public Object remove(String key) {
        return this.remove((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String list() {
        StringBuffer buf = new StringBuffer();
        Map map = this.context;
        synchronized (map) {
            for (Object key : this.context.keySet()) {
                buf.append(key);
                buf.append(" : ");
                buf.append(this.context.get(key));
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    @Override
    public Map all() {
        return new HashMap(this.context);
    }
}

