/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.connection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.beans.BooleanEditor;
import jp.ossc.nimbus.beans.NestedProperty;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.connection.DefaultPersistentManagerServiceMBean;
import jp.ossc.nimbus.service.connection.PersistentException;
import jp.ossc.nimbus.service.connection.PersistentManager;

public class DefaultPersistentManagerService
extends ServiceBase
implements PersistentManager,
DefaultPersistentManagerServiceMBean {
    private static final long serialVersionUID = 301756347991573032L;
    private PropertyAccess propertyAccess;
    private boolean isIgnoreNullProperty;
    private Map resultSetJDBCTypeMap;

    @Override
    public void setIgnoreNullProperty(boolean isIgnore) {
        this.isIgnoreNullProperty = isIgnore;
    }

    @Override
    public boolean isIgnoreNullProperty() {
        return this.isIgnoreNullProperty;
    }

    @Override
    public void setResultSetJDBCTypeMap(Map mapping) {
        this.resultSetJDBCTypeMap = mapping;
    }

    @Override
    public Map getResultSetJDBCTypeMap() {
        return this.resultSetJDBCTypeMap;
    }

    @Override
    public void setResultSetJDBCType(String jdbcType, Class javaType) throws IllegalArgumentException {
        Integer type = null;
        try {
            Field field = Types.class.getField(jdbcType);
            type = (Integer)field.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.toString());
        }
        this.resultSetJDBCTypeMap.put(type, javaType);
    }

    @Override
    public void createService() throws Exception {
        this.resultSetJDBCTypeMap = new HashMap();
        this.resultSetJDBCTypeMap.put(new Integer(1), String.class);
        this.resultSetJDBCTypeMap.put(new Integer(12), String.class);
        this.resultSetJDBCTypeMap.put(new Integer(-1), String.class);
        this.resultSetJDBCTypeMap.put(new Integer(2), BigDecimal.class);
        this.resultSetJDBCTypeMap.put(new Integer(3), BigDecimal.class);
        this.resultSetJDBCTypeMap.put(new Integer(-7), Boolean.TYPE);
        this.resultSetJDBCTypeMap.put(new Integer(-6), Byte.TYPE);
        this.resultSetJDBCTypeMap.put(new Integer(5), Short.TYPE);
        this.resultSetJDBCTypeMap.put(new Integer(4), Integer.TYPE);
        this.resultSetJDBCTypeMap.put(new Integer(-5), Long.TYPE);
        this.resultSetJDBCTypeMap.put(new Integer(7), Float.TYPE);
        this.resultSetJDBCTypeMap.put(new Integer(8), Double.TYPE);
        this.resultSetJDBCTypeMap.put(new Integer(-2), byte[].class);
        this.resultSetJDBCTypeMap.put(new Integer(-3), byte[].class);
        this.resultSetJDBCTypeMap.put(new Integer(-4), byte[].class);
        this.resultSetJDBCTypeMap.put(new Integer(91), Date.class);
        this.resultSetJDBCTypeMap.put(new Integer(92), Time.class);
        this.resultSetJDBCTypeMap.put(new Integer(93), Timestamp.class);
        this.resultSetJDBCTypeMap.put(new Integer(2005), Clob.class);
        this.resultSetJDBCTypeMap.put(new Integer(2004), Blob.class);
        this.resultSetJDBCTypeMap.put(new Integer(2003), java.sql.Array.class);
        this.resultSetJDBCTypeMap.put(new Integer(2002), Struct.class);
        this.resultSetJDBCTypeMap.put(new Integer(2006), Ref.class);
    }

    @Override
    public void startService() throws Exception {
        this.propertyAccess = new PropertyAccess();
        this.propertyAccess.setIgnoreNullProperty(this.isIgnoreNullProperty);
    }

    @Override
    public Object loadQuery(Connection con, String query, Object input, Object output) throws PersistentException {
        return this.loadQuery(con, query, input, output, null, null);
    }

    @Override
    public Object loadQuery(Connection con, String query, Object input, Object output, Map statementProps, Map resultSetProps) throws PersistentException {
        StringBuffer buf = new StringBuffer(query);
        List inputProps = this.parseInput(buf);
        List outputProps = this.parseOutput(buf);
        String sql = buf.toString();
        return this.load(con, sql, input, inputProps, output, outputProps, statementProps, resultSetProps);
    }

    private List parseInput(StringBuffer query) throws PersistentException {
        return this.parseQuery(query, "<-{", false);
    }

    private List parseOutput(StringBuffer query) throws PersistentException {
        return this.parseQuery(query, "->{", true);
    }

    private List parseQuery(StringBuffer query, String prefix, boolean isSet) throws PersistentException {
        int startIndex;
        LinkedHashSet<String> result = null;
        while ((startIndex = query.indexOf(prefix)) != -1) {
            int endIndex = query.indexOf("}", startIndex + 3);
            if (endIndex == -1) {
                throw new PersistentException("Illegal query : " + query);
            }
            String propStr = query.substring(startIndex + 3, endIndex).trim();
            if (propStr.length() == 0) {
                throw new PersistentException("Illegal query : " + query);
            }
            if (result == null) {
                result = isSet ? new LinkedHashSet() : new ArrayList();
            }
            result.add(propStr);
            query.delete(startIndex, endIndex + 1);
        }
        return result == null ? null : (isSet ? new ArrayList(result) : (List)((Object)result));
    }

    @Override
    public Object load(Connection con, String sql, Object input, Object inputProps, Object output, Object outputProps) throws PersistentException {
        return this.load(con, sql, input, inputProps, output, outputProps, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object load(Connection con, String sql, Object input, Object inputProps, Object output, Object outputProps, Map statementProps, Map resultSetProps) throws PersistentException {
        ArrayList<Object> inputPropList = null;
        if (inputProps != null) {
            if (inputProps.getClass().isArray()) {
                inputPropList = Arrays.asList((Object[])inputProps);
            } else if (inputProps instanceof List) {
                inputPropList = (ArrayList)inputProps;
            } else {
                if (!(inputProps instanceof String)) throw new PersistentException("No supported inputProps type." + inputProps);
                inputPropList = new ArrayList();
                inputPropList.add(inputProps);
            }
        } else if (input != null && input instanceof Map) {
            inputPropList = new ArrayList(((Map)input).keySet());
        }
        ArrayList<Object> outputPropList = null;
        LinkedHashMap<String, String> outputPropMap = null;
        if (outputProps != null) {
            if (outputProps.getClass().isArray()) {
                outputPropList = Arrays.asList((Object[])outputProps);
            } else if (outputProps instanceof List) {
                outputPropList = (ArrayList<Object>)outputProps;
            } else if (outputProps instanceof Map) {
                outputPropMap = (LinkedHashMap<String, String>)outputProps;
            } else {
                if (!(outputProps instanceof String)) throw new PersistentException("No supported outputProps type." + outputProps);
                outputPropList = new ArrayList<Object>();
                outputPropList.add(outputProps);
            }
        }
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            int i;
            try {
                statement = con.prepareStatement(sql);
            }
            catch (SQLException e) {
                throw new PersistentException("Illegal sql : " + sql, e);
            }
            this.setStatementProperties(statement, statementProps);
            try {
                try {
                    ParameterMetaData metadata = statement.getParameterMetaData();
                    if (inputPropList != null && inputPropList.size() != metadata.getParameterCount()) {
                        throw new PersistentException("Illegal sql : " + sql);
                    }
                }
                catch (IncompatibleClassChangeError e) {
                    // empty catch block
                }
                if (input != null) {
                    int imax;
                    if (inputPropList != null) {
                        imax = inputPropList.size();
                        for (int i2 = 0; i2 < imax; ++i2) {
                            Object param = this.propertyAccess.get(input, inputPropList.get(i2).toString());
                            this.setObject(statement, i2 + 1, param);
                        }
                    } else if (input.getClass().isArray()) {
                        imax = Array.getLength(input);
                        for (int i3 = 0; i3 < imax; ++i3) {
                            Object param = Array.get(input, i3);
                            this.setObject(statement, i3 + 1, param);
                        }
                    } else if (input instanceof List) {
                        List list = (List)input;
                        int imax2 = list.size();
                        for (i = 0; i < imax2; ++i) {
                            Object param = list.get(i);
                            this.setObject(statement, i + 1, param);
                        }
                    } else {
                        this.setObject(statement, 1, input);
                    }
                }
            }
            catch (NoSuchPropertyException e) {
                throw new PersistentException("Input bean get error.", e);
            }
            catch (InvocationTargetException e) {
                throw new PersistentException("Input bean get error.", e.getTargetException());
            }
            catch (SQLException e) {
                throw new PersistentException("The parameter is not suitable for SQL.", e);
            }
            try {
                resultSet = statement.executeQuery();
            }
            catch (SQLException e) {
                throw new PersistentException("SQL execute error : " + sql, e);
            }
            this.setResultSetProperties(resultSet, resultSetProps);
            if (outputPropList != null) {
                try {
                    ResultSetMetaData metadata = resultSet.getMetaData();
                    if (outputPropList.size() != metadata.getColumnCount()) {
                        throw new PersistentException("Illegal sql : " + sql);
                    }
                    outputPropMap = new LinkedHashMap<String, String>();
                    int imax = outputPropList.size();
                    for (i = 0; i < imax; ++i) {
                        outputPropMap.put(metadata.getColumnName(i + 1), outputPropList.get(i).toString());
                    }
                }
                catch (SQLException e) {
                    throw new PersistentException("The parameter is not suitable for SQL.", e);
                }
            }
            Object object = this.fillOutput(resultSet, output, outputPropMap, false);
            return object;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
                statement = null;
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
                resultSet = null;
            }
        }
    }

    private Object fillOutput(ResultSet resultSet, Object output, Map outputMapping, boolean isCursor) throws PersistentException {
        if (output == null) {
            output = isCursor ? new LinkedHashMap() : new ArrayList();
        }
        try {
            Record record;
            ResultSetMetaData metadata = resultSet.getMetaData();
            int colCount = metadata.getColumnCount();
            boolean isOutputMappingFromMetaData = false;
            if (outputMapping == null && (output instanceof RecordList || output instanceof Record || !(output instanceof List))) {
                outputMapping = new LinkedHashMap<String, String>();
                for (int i = 1; i <= colCount; ++i) {
                    outputMapping.put(metadata.getColumnName(i), metadata.getColumnName(i).toUpperCase());
                }
                isOutputMappingFromMetaData = true;
            }
            if (output instanceof DataSet) {
                LinkedHashSet headerSet = new LinkedHashSet();
                LinkedHashMap recordListMap = new LinkedHashMap();
                LinkedHashMap recordListPropMap = new LinkedHashMap();
                for (Map.Entry entry : outputMapping.entrySet()) {
                    Property prop = this.propertyAccess.getProperty((String)entry.getValue());
                    if (prop instanceof NestedProperty) {
                        Object obj = ((NestedProperty)prop).getThisProperty().getProperty(output);
                        if (obj instanceof RecordList) {
                            recordListMap.put(entry.getKey(), (RecordList)obj);
                            recordListPropMap.put(entry.getKey(), ((NestedProperty)prop).getNestedProperty());
                            continue;
                        }
                        headerSet.add(entry.getKey());
                        continue;
                    }
                    throw new PersistentException("Output bean fill error.");
                }
                HashMap<RecordList, Record> recordMap = new HashMap<RecordList, Record>();
                while (isCursor || resultSet.next()) {
                    if (headerSet.size() != 0) {
                        for (String columnName : headerSet) {
                            this.setValue(output, (String)outputMapping.get(columnName), resultSet, columnName, isOutputMappingFromMetaData);
                        }
                        headerSet.clear();
                    }
                    recordMap.clear();
                    for (Map.Entry entry : recordListMap.entrySet()) {
                        RecordList list = (RecordList)entry.getValue();
                        Record record2 = (Record)recordMap.get(list);
                        if (record2 == null) {
                            record2 = list.createRecord();
                            recordMap.put(list, record2);
                            list.addRecord(record2);
                        }
                        Property prop = (Property)recordListPropMap.get(entry.getKey());
                        prop.setProperty(record2, this.getValue((Object)record2, prop, resultSet, (String)entry.getKey()));
                    }
                    if (!isCursor) continue;
                }
                return output;
            }
            if (output instanceof RecordList) {
                RecordList list = (RecordList)output;
                if (list.getSchema() == null) {
                    list.setSchema(this.createSchema(metadata));
                }
                while (isCursor || resultSet.next()) {
                    Record record3 = list.createRecord();
                    for (Map.Entry entry : outputMapping.entrySet()) {
                        this.setValue((Object)record3, (String)entry.getValue(), resultSet, (String)entry.getKey(), isOutputMappingFromMetaData);
                    }
                    list.addRecord(record3);
                    if (!isCursor) continue;
                    break;
                }
                return list;
            }
            if (output instanceof List) {
                List list = (List)((Object)output);
                while (isCursor || resultSet.next()) {
                    LinkedHashMap<String, Object> record4 = new LinkedHashMap<String, Object>();
                    for (int i = 1; i <= colCount; ++i) {
                        record4.put(metadata.getColumnName(i), resultSet.getObject(i));
                    }
                    list.add(record4);
                    if (!isCursor) continue;
                    break;
                }
                return list;
            }
            if (output instanceof Class) {
                Class outputClass = (Class)((Object)output);
                if (Record.class.isAssignableFrom(outputClass)) {
                    if (!isCursor && !resultSet.next()) {
                        return null;
                    }
                    Record record5 = null;
                    try {
                        record5 = (Record)outputClass.newInstance();
                        if (record5.getSchema() == null) {
                            record5.setSchema(this.createSchema(metadata));
                        }
                    }
                    catch (InstantiationException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    for (Map.Entry entry : outputMapping.entrySet()) {
                        this.setValue((Object)record5, (String)entry.getValue(), resultSet, (String)entry.getKey(), isOutputMappingFromMetaData);
                    }
                    return record5;
                }
                if (RecordList.class.isAssignableFrom(outputClass)) {
                    RecordList list = null;
                    try {
                        list = (RecordList)outputClass.newInstance();
                        if (list.getSchema() == null) {
                            list.setSchema(this.createSchema(metadata));
                        }
                    }
                    catch (InstantiationException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    while (isCursor || resultSet.next()) {
                        Record record6 = list.createRecord();
                        for (Map.Entry entry : outputMapping.entrySet()) {
                            this.setValue((Object)record6, (String)entry.getValue(), resultSet, (String)entry.getKey(), isOutputMappingFromMetaData);
                        }
                        list.addRecord(record6);
                        if (!isCursor) continue;
                        break;
                    }
                    return list;
                }
                if (outputClass.isArray()) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    while (isCursor || resultSet.next()) {
                        Object bean = this.fillOutput(resultSet, outputClass.getComponentType(), outputMapping, isCursor);
                        list.add(bean);
                        if (!isCursor) continue;
                        break;
                    }
                    return this.listToArray(list, outputClass.getComponentType());
                }
                if (String.class.equals((Object)outputClass) || outputClass.isPrimitive() || Number.class.isAssignableFrom(outputClass)) {
                    return this.getValue(outputClass, resultSet, 1);
                }
                if (isCursor) {
                    Object bean = null;
                    try {
                        bean = outputClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    for (Map.Entry entry : outputMapping.entrySet()) {
                        this.setValue(bean, (String)entry.getValue(), resultSet, (String)entry.getKey(), isOutputMappingFromMetaData);
                    }
                    return bean;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                while (resultSet.next()) {
                    Object bean = null;
                    try {
                        bean = outputClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    for (Map.Entry entry : outputMapping.entrySet()) {
                        this.setValue(bean, (String)entry.getValue(), resultSet, (String)entry.getKey(), isOutputMappingFromMetaData);
                    }
                    list.add(bean);
                }
                return list;
            }
            if (!isCursor && !resultSet.next()) {
                return output;
            }
            if (output instanceof Record && (record = (Record)output).getSchema() == null) {
                record.setSchema(this.createSchema(metadata));
            }
            for (Map.Entry entry : outputMapping.entrySet()) {
                this.setValue(output, (String)entry.getValue(), resultSet, (String)entry.getKey(), isOutputMappingFromMetaData);
            }
            return output;
        }
        catch (IllegalArgumentException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        catch (NoSuchPropertyException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        catch (InvocationTargetException e) {
            throw new PersistentException("Output bean fill error.", e.getTargetException());
        }
        catch (SQLException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
    }

    private Object listToArray(List list, Class componentType) {
        if (componentType.isPrimitive()) {
            Object array = Array.newInstance(componentType, list.size());
            if (Byte.TYPE.equals(componentType)) {
                int imax = list.size();
                for (int i = 0; i < imax; ++i) {
                    Array.setByte(array, i, ((Number)list.get(i)).byteValue());
                }
            } else if (Short.TYPE.equals(componentType)) {
                int imax = list.size();
                for (int i = 0; i < imax; ++i) {
                    Array.setShort(array, i, ((Number)list.get(i)).shortValue());
                }
            } else if (Integer.TYPE.equals(componentType)) {
                int imax = list.size();
                for (int i = 0; i < imax; ++i) {
                    Array.setInt(array, i, ((Number)list.get(i)).intValue());
                }
            } else if (Long.TYPE.equals(componentType)) {
                int imax = list.size();
                for (int i = 0; i < imax; ++i) {
                    Array.setLong(array, i, ((Number)list.get(i)).longValue());
                }
            } else if (Float.TYPE.equals(componentType)) {
                int imax = list.size();
                for (int i = 0; i < imax; ++i) {
                    Array.setFloat(array, i, ((Number)list.get(i)).floatValue());
                }
            } else if (Double.TYPE.equals(componentType)) {
                int imax = list.size();
                for (int i = 0; i < imax; ++i) {
                    Array.setDouble(array, i, ((Number)list.get(i)).doubleValue());
                }
            } else if (Boolean.TYPE.equals(componentType)) {
                int imax = list.size();
                for (int i = 0; i < imax; ++i) {
                    Array.setBoolean(array, i, (Boolean)list.get(i));
                }
            }
            return array;
        }
        return list.toArray((Object[])Array.newInstance(componentType, list.size()));
    }

    private void setValue(Object target, String propName, ResultSet rs, String cloumnName, boolean isIgnoreCase) throws PersistentException {
        int index = 0;
        try {
            index = rs.findColumn(cloumnName);
        }
        catch (SQLException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        this.setValue(target, propName, rs, index, isIgnoreCase);
    }

    private void setValue(Object target, String propName, ResultSet rs, int index, boolean isIgnoreCase) throws PersistentException {
        try {
            this.propertyAccess.set(target, propName, this.getValue(target, propName, rs, index));
        }
        catch (IllegalArgumentException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        catch (NoSuchPropertyException e) {
            if (isIgnoreCase) {
                try {
                    this.propertyAccess.set(target, propName.toLowerCase(), this.getValue(target, propName, rs, index));
                }
                catch (IllegalArgumentException e2) {
                    throw new PersistentException("Output bean fill error.", e2);
                }
                catch (NoSuchPropertyException e2) {
                    throw new PersistentException("Output bean fill error.", e2);
                }
                catch (InvocationTargetException e2) {
                    throw new PersistentException("Output bean fill error.", e2.getTargetException());
                }
            }
            throw new PersistentException("Output bean fill error.", e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (isIgnoreCase && targetException instanceof PropertyGetException) {
                try {
                    this.propertyAccess.set(target, propName.toLowerCase(), this.getValue(target, propName, rs, index));
                }
                catch (IllegalArgumentException e2) {
                    throw new PersistentException("Output bean fill error.", e2);
                }
                catch (NoSuchPropertyException e2) {
                    throw new PersistentException("Output bean fill error.", e2);
                }
                catch (InvocationTargetException e2) {
                    throw new PersistentException("Output bean fill error.", e2.getTargetException());
                }
            }
            throw new PersistentException("Output bean fill error.", e.getTargetException());
        }
    }

    private Object getValue(Object target, String propName, ResultSet rs, int index) throws PersistentException {
        try {
            return this.getValue(target, this.propertyAccess.getProperty(propName), rs, index);
        }
        catch (IllegalArgumentException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
    }

    private Object getValue(Object target, Property prop, ResultSet rs, String cloumnName) throws PersistentException {
        int index = 0;
        try {
            index = rs.findColumn(cloumnName);
        }
        catch (SQLException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        return this.getValue(target, prop, rs, index);
    }

    private Object getValue(Object target, Property prop, ResultSet rs, int index) throws PersistentException {
        try {
            return this.getValue(prop.getPropertyType(target), rs, index);
        }
        catch (NoSuchPropertyException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        catch (InvocationTargetException e) {
            throw new PersistentException("Output bean fill error.", e.getTargetException());
        }
    }

    private Object getValue(Class type, ResultSet rs, int index) throws PersistentException {
        try {
            ResultSetMetaData metadata = rs.getMetaData();
            int jdbcType = metadata.getColumnType(index);
            Object value = null;
            switch (jdbcType) {
                case 2004: 
                case 2005: {
                    switch (jdbcType) {
                        case 2004: {
                            Blob blob = null;
                            if (byte[].class.equals((Object)type)) {
                                blob = rs.getBlob(index);
                                if (blob == null) break;
                                value = blob.getBytes(1L, (int)blob.length());
                                break;
                            }
                            if (InputStream.class.equals((Object)type)) {
                                value = rs.getBinaryStream(index);
                                break;
                            }
                            if (String.class.equals((Object)type)) {
                                blob = rs.getBlob(index);
                                if (blob == null) break;
                                value = new String(blob.getBytes(1L, (int)blob.length()));
                                break;
                            }
                            value = rs.getBlob(index);
                            break;
                        }
                        case 2005: {
                            Clob clob = null;
                            if (char[].class.equals((Object)type)) {
                                clob = rs.getClob(index);
                                if (clob == null) break;
                                Reader r = clob.getCharacterStream();
                                value = new char[(int)clob.length()];
                                r.read((char[])value);
                                r.close();
                                break;
                            }
                            if (InputStream.class.equals((Object)type)) {
                                value = rs.getAsciiStream(index);
                                break;
                            }
                            if (Reader.class.equals((Object)type)) {
                                clob = rs.getClob(index);
                                if (clob == null) break;
                                value = clob.getCharacterStream();
                                break;
                            }
                            if (String.class.equals((Object)type)) {
                                clob = rs.getClob(index);
                                if (clob == null) break;
                                value = clob.getSubString(1L, (int)clob.length());
                                break;
                            }
                            value = rs.getClob(index);
                        }
                    }
                    break;
                }
                case 2: 
                case 3: {
                    if (Byte.TYPE.equals(type) || Byte.class.equals((Object)type)) {
                        value = new Byte(rs.getByte(index));
                        break;
                    }
                    if (Short.TYPE.equals(type) || Short.class.equals((Object)type)) {
                        value = new Short(rs.getShort(index));
                        break;
                    }
                    if (Integer.TYPE.equals(type) || Integer.class.equals((Object)type)) {
                        value = new Integer(rs.getInt(index));
                        break;
                    }
                    if (Long.TYPE.equals(type) || Long.class.equals((Object)type)) {
                        value = new Long(rs.getLong(index));
                        break;
                    }
                    if (Float.TYPE.equals(type) || Float.class.equals((Object)type)) {
                        value = new Float(rs.getFloat(index));
                        break;
                    }
                    if (Double.TYPE.equals(type) || Double.class.equals((Object)type)) {
                        value = new Double(rs.getDouble(index));
                        break;
                    }
                    if (BigInteger.class.equals((Object)type)) {
                        value = new BigInteger(rs.getString(index));
                        break;
                    }
                    if (BigDecimal.class.equals((Object)type)) {
                        value = rs.getBigDecimal(index);
                        break;
                    }
                    value = rs.getObject(index);
                    break;
                }
                case 1: 
                case 12: {
                    if (Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type)) {
                        BooleanEditor editor = new BooleanEditor();
                        editor.setAsText(rs.getString(index));
                        value = editor.getValue();
                        break;
                    }
                    value = rs.getString(index);
                    break;
                }
                default: {
                    value = rs.getObject(index);
                }
            }
            return value;
        }
        catch (IOException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        catch (SQLException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
    }

    private void setObject(PreparedStatement statement, int index, Object value) throws PersistentException {
        try {
            if (value != null) {
                if (value instanceof byte[]) {
                    statement.setBinaryStream(index, (InputStream)new ByteArrayInputStream((byte[])value), ((byte[])value).length);
                    return;
                }
                if (value instanceof InputStream) {
                    InputStream is = (InputStream)value;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] bytes = new byte[1024];
                    int length = 0;
                    try {
                        while ((length = is.read(bytes)) != -1) {
                            baos.write(bytes, 0, length);
                        }
                    }
                    catch (IOException e) {
                        throw new PersistentException(e);
                    }
                    bytes = baos.toByteArray();
                    statement.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                    return;
                }
                if (value instanceof char[]) {
                    statement.setCharacterStream(index, (Reader)new CharArrayReader((char[])value), ((char[])value).length);
                    return;
                }
                if (value instanceof Reader) {
                    Reader reader = (Reader)value;
                    CharArrayWriter caw = new CharArrayWriter();
                    char[] chars = new char[1024];
                    int length = 0;
                    try {
                        while ((length = reader.read(chars)) != -1) {
                            caw.write(chars, 0, length);
                        }
                    }
                    catch (IOException e) {
                        throw new PersistentException(e);
                    }
                    chars = caw.toCharArray();
                    statement.setCharacterStream(index, (Reader)new CharArrayReader(chars), chars.length);
                    return;
                }
            }
            statement.setObject(index, value);
        }
        catch (SQLException e) {
            throw new PersistentException("The parameter is not suitable for SQL.", e);
        }
    }

    private String createSchema(ResultSetMetaData metadata) throws SQLException {
        int colCount = metadata.getColumnCount();
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i <= colCount; ++i) {
            Class type = (Class)this.resultSetJDBCTypeMap.get(new Integer(metadata.getColumnType(i)));
            buf.append(':').append(metadata.getColumnName(i));
            if (type != null) {
                buf.append(',').append(type.getName());
            }
            if (i == colCount) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public PersistentManager.Cursor createQueryCursor(Connection con, String query, Object input) throws PersistentException {
        return this.createQueryCursor(con, query, input, null, null);
    }

    @Override
    public PersistentManager.Cursor createQueryCursor(Connection con, String query, Object input, Map statementProps, Map resultSetProps) throws PersistentException {
        StringBuffer buf = new StringBuffer(query);
        List inputProps = this.parseInput(buf);
        List outputProps = this.parseOutput(buf);
        String sql = buf.toString();
        return this.createCursor(con, sql, input, inputProps, outputProps, statementProps, resultSetProps);
    }

    @Override
    public PersistentManager.Cursor createCursor(Connection con, String sql, Object input, Object inputProps, Object outputProps) throws PersistentException {
        return this.createCursor(con, sql, input, inputProps, outputProps, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PersistentManager.Cursor createCursor(Connection con, String sql, Object input, Object inputProps, Object outputProps, Map statementProps, Map resultSetProps) throws PersistentException {
        int i;
        ArrayList<Object> inputPropList = null;
        if (inputProps != null) {
            if (inputProps.getClass().isArray()) {
                inputPropList = Arrays.asList((Object[])inputProps);
            } else if (inputProps instanceof List) {
                inputPropList = (ArrayList)inputProps;
            } else {
                if (!(inputProps instanceof String)) throw new PersistentException("No supported inputProps type." + inputProps);
                inputPropList = new ArrayList();
                inputPropList.add(inputProps);
            }
        } else if (input != null && input instanceof Map) {
            inputPropList = new ArrayList(((Map)input).keySet());
        }
        ArrayList<Object> outputPropList = null;
        LinkedHashMap<String, String> outputPropMap = null;
        if (outputProps != null) {
            if (outputProps.getClass().isArray()) {
                outputPropList = Arrays.asList((Object[])outputProps);
            } else if (outputProps instanceof List) {
                outputPropList = (ArrayList<Object>)outputProps;
            } else if (outputProps instanceof Map) {
                outputPropMap = (LinkedHashMap<String, String>)outputProps;
            } else {
                if (!(outputProps instanceof String)) throw new PersistentException("No supported outputProps type." + outputProps);
                outputPropList = new ArrayList<Object>();
                outputPropList.add(outputProps);
            }
        }
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = con.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new PersistentException("Illegal sql : " + sql, e);
        }
        this.setStatementProperties(statement, statementProps);
        try {
            try {
                ParameterMetaData metadata = statement.getParameterMetaData();
                if (inputPropList != null && inputPropList.size() != metadata.getParameterCount()) {
                    throw new PersistentException("Illegal sql : " + sql);
                }
            }
            catch (IncompatibleClassChangeError e) {
                // empty catch block
            }
            if (input != null) {
                int imax;
                if (inputPropList != null) {
                    imax = inputPropList.size();
                    for (int i2 = 0; i2 < imax; ++i2) {
                        Object param = this.propertyAccess.get(input, inputPropList.get(i2).toString());
                        this.setObject(statement, i2 + 1, param);
                    }
                } else if (input.getClass().isArray()) {
                    imax = Array.getLength(input);
                    for (int i3 = 0; i3 < imax; ++i3) {
                        Object param = Array.get(input, i3);
                        this.setObject(statement, i3 + 1, param);
                    }
                } else if (input instanceof List) {
                    List list = (List)input;
                    int imax2 = list.size();
                    for (i = 0; i < imax2; ++i) {
                        Object param = list.get(i);
                        this.setObject(statement, i + 1, param);
                    }
                } else {
                    this.setObject(statement, 1, input);
                }
            }
        }
        catch (NoSuchPropertyException e) {
            throw new PersistentException("Input bean get error.", e);
        }
        catch (InvocationTargetException e) {
            throw new PersistentException("Input bean get error.", e.getTargetException());
        }
        catch (SQLException e) {
            throw new PersistentException("The parameter is not suitable for SQL.", e);
        }
        try {
            resultSet = statement.executeQuery();
        }
        catch (SQLException e) {
            throw new PersistentException("SQL execute error : " + sql, e);
        }
        this.setResultSetProperties(resultSet, resultSetProps);
        if (outputPropList == null) return new CursorImpl(statement, resultSet, outputPropMap);
        try {
            ResultSetMetaData metadata = resultSet.getMetaData();
            if (outputPropList.size() != metadata.getColumnCount()) {
                throw new PersistentException("Illegal sql : " + sql);
            }
            outputPropMap = new LinkedHashMap<String, String>();
            int imax = outputPropList.size();
            for (i = 0; i < imax; ++i) {
                outputPropMap.put(metadata.getColumnName(i + 1), outputPropList.get(i).toString());
            }
            return new CursorImpl(statement, resultSet, outputPropMap);
        }
        catch (SQLException e) {
            throw new PersistentException("The parameter is not suitable for SQL.", e);
        }
    }

    @Override
    public int persistQuery(Connection con, String query, Object input) throws PersistentException {
        return this.persistQuery(con, query, input, null);
    }

    @Override
    public int persistQuery(Connection con, String query, Object input, Map statementProps) throws PersistentException {
        StringBuffer buf = new StringBuffer(query);
        List inputProps = this.parseInput(buf);
        String sql = buf.toString();
        return this.persist(con, sql, input, inputProps, statementProps);
    }

    @Override
    public int persist(Connection con, String sql, Object input, Object inputProps) throws PersistentException {
        return this.persist(con, sql, input, inputProps, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int persist(Connection con, String sql, Object input, Object inputProps, Map statementProps) throws PersistentException {
        ArrayList<Object> inputPropList = null;
        if (inputProps != null) {
            if (inputProps.getClass().isArray()) {
                inputPropList = Arrays.asList((Object[])inputProps);
            } else if (inputProps instanceof List) {
                inputPropList = (ArrayList<Object>)inputProps;
            } else if (inputProps instanceof String) {
                inputPropList = new ArrayList<Object>();
                inputPropList.add(inputProps);
            } else {
                throw new PersistentException("No supported inputProps type." + inputProps);
            }
        }
        PreparedStatement statement = null;
        try {
            try {
                statement = con.prepareStatement(sql);
                ParameterMetaData metadata = statement.getParameterMetaData();
                if (inputPropList != null && inputPropList.size() != metadata.getParameterCount()) {
                    throw new PersistentException("Illegal sql : " + sql);
                }
            }
            catch (SQLException e) {
                throw new PersistentException("Illegal sql : " + sql, e);
            }
            catch (IncompatibleClassChangeError e) {
                // empty catch block
            }
            this.setStatementProperties(statement, statementProps);
            int n = this.persistQueryInternal(sql, statement, input, inputPropList, false);
            return n;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
                statement = null;
            }
        }
    }

    private int persistQueryInternal(String sql, PreparedStatement statement, Object input, List inputProps, boolean isBatch) throws PersistentException {
        block94: {
            if (input instanceof DataSet) {
                if (inputProps == null) {
                    throw new PersistentException("Input bean get error.");
                }
                ArrayList<Object> beans = new ArrayList<Object>();
                ArrayList<Property> properties = new ArrayList<Property>();
                int count = -1;
                try {
                    for (Object propStr : inputProps) {
                        Property prop = this.propertyAccess.getProperty(propStr.toString());
                        if (prop instanceof NestedProperty) {
                            Object obj = ((NestedProperty)prop).getThisProperty().getProperty(input);
                            if (obj instanceof RecordList) {
                                int size = ((RecordList)obj).size();
                                if (count == -1) {
                                    count = size;
                                } else if (count != size) {
                                    throw new PersistentException("Input bean get error.");
                                }
                            }
                            beans.add(obj);
                            properties.add(((NestedProperty)prop).getNestedProperty());
                            continue;
                        }
                        throw new PersistentException("Input bean get error.");
                    }
                }
                catch (NoSuchPropertyException e) {
                    throw new PersistentException("Input bean get error.", e);
                }
                catch (InvocationTargetException e) {
                    throw new PersistentException("Input bean get error.", e.getTargetException());
                }
                if (count == 0) {
                    return 0;
                }
                if (count == -1) {
                    try {
                        int imax = beans.size();
                        for (int i = 0; i < imax; ++i) {
                            Object param = ((Property)properties.get(i)).getProperty(beans.get(i));
                            this.setObject(statement, i + 1, param);
                        }
                    }
                    catch (NoSuchPropertyException e) {
                        throw new PersistentException("Input bean get error.", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new PersistentException("Input bean get error.", e.getTargetException());
                    }
                    try {
                        if (isBatch) {
                            statement.addBatch();
                            return -1;
                        }
                        return statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        throw new PersistentException("SQL execute error : " + sql, e);
                    }
                }
                for (int i = 0; i < count; ++i) {
                    try {
                        int jmax = beans.size();
                        for (int j = 0; j < jmax; ++j) {
                            Object bean = beans.get(j);
                            if (bean instanceof RecordList) {
                                bean = ((RecordList)bean).get(i);
                            }
                            Object param = ((Property)properties.get(j)).getProperty(bean);
                            this.setObject(statement, j + 1, param);
                        }
                    }
                    catch (NoSuchPropertyException e) {
                        throw new PersistentException("Input bean get error.", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new PersistentException("Input bean get error.", e.getTargetException());
                    }
                    try {
                        statement.addBatch();
                        continue;
                    }
                    catch (SQLException e) {
                        throw new PersistentException("SQL add batch error : " + sql, e);
                    }
                }
                if (isBatch) {
                    return -1;
                }
                int[] updateCounts = null;
                try {
                    updateCounts = statement.executeBatch();
                }
                catch (SQLException e) {
                    throw new PersistentException("SQL execute error : " + sql, e);
                }
                int result = 0;
                for (int i = 0; i < updateCounts.length; ++i) {
                    if (updateCounts[i] <= 0) continue;
                    result += updateCounts[i];
                }
                if (result == 0) {
                    try {
                        result = statement.getUpdateCount();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                return result;
            }
            if (input instanceof List || input != null && input.getClass().isArray()) {
                List<Object> list = null;
                list = input instanceof List ? (List<Object>)input : Arrays.asList((Object[])input);
                if (inputProps != null) {
                    if (list.size() == 0) {
                        return 0;
                    }
                    int jmax = list.size();
                    for (int j = 0; j < jmax; ++j) {
                        Object bean = list.get(j);
                        try {
                            int imax = inputProps.size();
                            for (int i = 0; i < imax; ++i) {
                                Object param = this.propertyAccess.get(bean, inputProps.get(i).toString());
                                this.setObject(statement, i + 1, param);
                            }
                        }
                        catch (NoSuchPropertyException e) {
                            throw new PersistentException("Input bean get error.", e);
                        }
                        catch (InvocationTargetException e) {
                            throw new PersistentException("Input bean get error.", e.getTargetException());
                        }
                        try {
                            statement.addBatch();
                            continue;
                        }
                        catch (SQLException e) {
                            throw new PersistentException("SQL add batch error : " + sql, e);
                        }
                    }
                    if (isBatch) {
                        return -1;
                    }
                    int[] updateCounts = null;
                    try {
                        updateCounts = statement.executeBatch();
                    }
                    catch (SQLException e) {
                        throw new PersistentException("SQL execute error : " + sql, e);
                    }
                    int result = 0;
                    for (int i = 0; i < updateCounts.length; ++i) {
                        if (updateCounts[i] <= 0) continue;
                        result += updateCounts[i];
                    }
                    if (result == 0) {
                        try {
                            result = statement.getUpdateCount();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    return result;
                }
                if (list.size() == 0) {
                    return 0;
                }
                int result = 0;
                int imax = list.size();
                for (int i = 0; i < imax; ++i) {
                    Object bean = list.get(i);
                    if (bean instanceof Map) {
                        try {
                            Iterator propItr = ((Map)bean).keySet().iterator();
                            int j = 0;
                            while (propItr.hasNext()) {
                                Object param = this.propertyAccess.get(bean, propItr.next().toString());
                                this.setObject(statement, ++j, param);
                            }
                        }
                        catch (NoSuchPropertyException e) {
                            throw new PersistentException("Input bean get error.", e);
                        }
                        catch (InvocationTargetException e) {
                            throw new PersistentException("Input bean get error.", e.getTargetException());
                        }
                        try {
                            statement.addBatch();
                        }
                        catch (SQLException e) {
                            throw new PersistentException("SQL add batch error : " + sql, e);
                        }
                        if (i != imax - 1) continue;
                        if (isBatch) {
                            result = -1;
                            continue;
                        }
                        int updateCount = 0;
                        int[] updateCounts = null;
                        try {
                            updateCounts = statement.executeBatch();
                        }
                        catch (SQLException e) {
                            throw new PersistentException("SQL execute error : " + sql, e);
                        }
                        for (int j = 0; j < updateCounts.length; ++j) {
                            if (updateCounts[j] <= 0) continue;
                            updateCount += updateCounts[j];
                        }
                        if (updateCount == 0) {
                            try {
                                updateCount = statement.getUpdateCount();
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        result = updateCount;
                        continue;
                    }
                    this.setObject(statement, i + 1, bean);
                    if (i != imax - 1) continue;
                    if (isBatch) {
                        try {
                            statement.addBatch();
                        }
                        catch (SQLException e) {
                            throw new PersistentException("SQL add batch error : " + sql, e);
                        }
                        result = -1;
                        continue;
                    }
                    try {
                        result = statement.executeUpdate();
                        continue;
                    }
                    catch (SQLException e) {
                        throw new PersistentException("SQL execute error : " + sql, e);
                    }
                }
                return result;
            }
            try {
                if (input != null) {
                    if (inputProps != null) {
                        int imax = inputProps.size();
                        for (int i = 0; i < imax; ++i) {
                            Object param = this.propertyAccess.get(input, inputProps.get(i).toString());
                            this.setObject(statement, i + 1, param);
                        }
                    } else if (input instanceof Map) {
                        Iterator propItr = ((Map)input).keySet().iterator();
                        int i = 0;
                        while (propItr.hasNext()) {
                            Object param = this.propertyAccess.get(input, propItr.next().toString());
                            this.setObject(statement, ++i, param);
                        }
                    } else {
                        this.setObject(statement, 1, input);
                    }
                    break block94;
                }
                if (inputProps != null) {
                    int imax = inputProps.size();
                    for (int i = 0; i < imax; ++i) {
                        this.setObject(statement, i + 1, null);
                    }
                    break block94;
                }
                int parameterCount = 0;
                try {
                    ParameterMetaData paramMetaData = statement.getParameterMetaData();
                    parameterCount = paramMetaData.getParameterCount();
                }
                catch (SQLException e) {
                    throw new PersistentException("Illegal sql : " + sql, e);
                }
                catch (IncompatibleClassChangeError e) {
                    // empty catch block
                }
                if (parameterCount != 0) {
                    this.setObject(statement, 1, input);
                }
            }
            catch (NoSuchPropertyException e) {
                throw new PersistentException("Input bean get error.", e);
            }
            catch (InvocationTargetException e) {
                throw new PersistentException("Input bean get error.", e.getTargetException());
            }
        }
        if (isBatch) {
            try {
                statement.addBatch();
            }
            catch (SQLException e) {
                throw new PersistentException("SQL add batch error : " + sql, e);
            }
            return -1;
        }
        try {
            return statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistentException("SQL execute error : " + sql, e);
        }
    }

    @Override
    public PersistentManager.BatchExecutor createQueryBatchExecutor(Connection con, String query) throws PersistentException {
        return this.createQueryBatchExecutor(con, query, null);
    }

    @Override
    public PersistentManager.BatchExecutor createQueryBatchExecutor(Connection con, String query, Map statementProps) throws PersistentException {
        StringBuffer buf = new StringBuffer(query);
        List inputProps = this.parseInput(buf);
        String sql = buf.toString();
        return new BatchExecutorImpl(con, sql, inputProps, statementProps);
    }

    @Override
    public PersistentManager.BatchExecutor createBatchExecutor(Connection con, String sql, Object inputProps) throws PersistentException {
        return this.createBatchExecutor(con, sql, inputProps, null);
    }

    @Override
    public PersistentManager.BatchExecutor createBatchExecutor(Connection con, String sql, Object inputProps, Map statementProps) throws PersistentException {
        ArrayList<Object> inputPropList = null;
        if (inputProps != null) {
            if (inputProps.getClass().isArray()) {
                inputPropList = Arrays.asList((Object[])inputProps);
            } else if (inputProps instanceof List) {
                inputPropList = (ArrayList<Object>)inputProps;
            } else if (inputProps instanceof String) {
                inputPropList = new ArrayList<Object>();
                inputPropList.add(inputProps);
            } else {
                throw new PersistentException("No supported inputProps type." + inputProps);
            }
        }
        return new BatchExecutorImpl(con, sql, inputPropList, statementProps);
    }

    private void setStatementProperties(PreparedStatement st, Map statementProps) throws PersistentException {
        if (statementProps == null || statementProps.size() == 0) {
            return;
        }
        try {
            for (Map.Entry entry : statementProps.entrySet()) {
                this.propertyAccess.set(st, (String)entry.getKey(), entry.getValue());
            }
        }
        catch (NoSuchPropertyException e) {
            throw new PersistentException("Statement property set error.", e);
        }
        catch (InvocationTargetException e) {
            throw new PersistentException("Statement property set error.", e.getTargetException());
        }
    }

    private void setResultSetProperties(ResultSet rs, Map resultSetProps) throws PersistentException {
        if (resultSetProps == null || resultSetProps.size() == 0) {
            return;
        }
        try {
            for (Map.Entry entry : resultSetProps.entrySet()) {
                this.propertyAccess.set(rs, (String)entry.getKey(), entry.getValue());
            }
        }
        catch (NoSuchPropertyException e) {
            throw new PersistentException("ResultSet property set error.", e);
        }
        catch (InvocationTargetException e) {
            throw new PersistentException("ResultSet property set error.", e.getTargetException());
        }
    }

    private class BatchExecutorImpl
    implements PersistentManager.BatchExecutor {
        private Connection connection;
        private String sql;
        private PreparedStatement statement;
        private List inputProps;
        private int currentBatchCount;
        private int autoBatchPersistCount;
        private boolean isAutoCommitOnPersist;

        BatchExecutorImpl(Connection con, String sql, List inputProps, Map statementProps) throws PersistentException {
            this.connection = con;
            this.sql = sql;
            this.inputProps = inputProps;
            try {
                this.statement = con.prepareStatement(sql);
                if (inputProps != null) {
                    ParameterMetaData metadata = this.statement.getParameterMetaData();
                    if (inputProps.size() != metadata.getParameterCount()) {
                        throw new PersistentException("Illegal sql : " + sql);
                    }
                }
            }
            catch (SQLException e) {
                throw new PersistentException("Illegal sql : " + sql, e);
            }
            catch (IncompatibleClassChangeError e) {
                // empty catch block
            }
            DefaultPersistentManagerService.this.setStatementProperties(this.statement, statementProps);
        }

        @Override
        public void setAutoBatchPersistCount(int count) {
            this.autoBatchPersistCount = count;
        }

        @Override
        public int getAutoBatchPersistCount() {
            return this.autoBatchPersistCount;
        }

        @Override
        public void setAutoCommitOnPersist(boolean isCommit) {
            this.isAutoCommitOnPersist = isCommit;
        }

        @Override
        public boolean isAutoCommitOnPersist() {
            return this.isAutoCommitOnPersist;
        }

        @Override
        public int addBatch(Object input) throws PersistentException {
            if (this.statement == null) {
                throw new PersistentException("Closed");
            }
            DefaultPersistentManagerService.this.persistQueryInternal(this.sql, this.statement, input, this.inputProps, true);
            ++this.currentBatchCount;
            if (this.autoBatchPersistCount > 0 && this.currentBatchCount >= this.autoBatchPersistCount) {
                return this.persist();
            }
            return 0;
        }

        @Override
        public int persist() throws PersistentException {
            if (this.statement == null) {
                throw new PersistentException("Closed");
            }
            int[] updateCounts = null;
            try {
                updateCounts = this.statement.executeBatch();
            }
            catch (SQLException e) {
                throw new PersistentException("Batch execute error.", e);
            }
            int result = 0;
            for (int i = 0; i < updateCounts.length; ++i) {
                if (updateCounts[i] <= 0) continue;
                result += updateCounts[i];
            }
            if (result == 0) {
                try {
                    result = this.statement.getUpdateCount();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            this.currentBatchCount = 0;
            try {
                if (this.isAutoCommitOnPersist && !this.connection.getAutoCommit()) {
                    this.connection.commit();
                }
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
            return result;
        }

        @Override
        public void clearBatch() throws PersistentException {
            if (this.statement != null) {
                try {
                    this.statement.clearBatch();
                }
                catch (SQLException e) {
                    throw new PersistentException("Batch clear error.", e);
                }
            }
            this.currentBatchCount = 0;
        }

        @Override
        public void close() {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.statement = null;
            }
            if (this.inputProps != null) {
                this.inputProps = null;
            }
            this.connection = null;
            this.currentBatchCount = 0;
        }
    }

    private class CursorImpl
    implements PersistentManager.Cursor {
        private PreparedStatement statement;
        private ResultSet resultSet;
        private Map outputMapping;

        public CursorImpl(PreparedStatement statement, ResultSet resultSet, Map outputMapping) {
            this.statement = statement;
            this.resultSet = resultSet;
            this.outputMapping = outputMapping;
        }

        @Override
        public boolean next() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.next();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public boolean previous() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.previous();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public boolean first() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.first();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public boolean last() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.last();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public void beforeFirst() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                this.resultSet.beforeFirst();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public void afterLast() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                this.resultSet.afterLast();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public boolean absolute(int row) throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.absolute(row);
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public boolean relative(int rows) throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.relative(rows);
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public boolean isFirst() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.isFirst();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public boolean isLast() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.isLast();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public boolean isBeforeFirst() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.isBeforeFirst();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public boolean isAfterLast() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.isAfterLast();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public void setFetchDirection(int direction) throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                this.resultSet.setFetchDirection(direction);
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public int getFetchDirection() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.getFetchDirection();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public void setFetchSize(int rows) throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                this.resultSet.setFetchSize(rows);
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public int getFetchSize() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.getFetchSize();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public int getRow() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.getRow();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        @Override
        public Object load(Object output) throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            return DefaultPersistentManagerService.this.fillOutput(this.resultSet, output, this.outputMapping, true);
        }

        @Override
        public boolean isClosed() {
            return this.statement == null;
        }

        @Override
        public void close() {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                this.statement = null;
            }
            if (this.resultSet != null) {
                try {
                    this.resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.resultSet = null;
            }
            this.outputMapping = null;
        }
    }
}

