/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNameRef;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ThreadContextInitializeInterceptorServiceMBean;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.sequence.Sequence;

public class ThreadContextInitializeInterceptorService
extends ServletFilterInterceptorService
implements ThreadContextInitializeInterceptorServiceMBean {
    private static final long serialVersionUID = -3154621046378825548L;
    protected ServiceName threadContextServiceName;
    protected Context threadContext;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected ServiceName codeMasterFinderServiceName;
    protected CodeMasterFinder codeMasterFinder;
    protected ServiceNameRef[] contextValueServiceNames;
    protected Properties contextValueRequestParameter;
    protected Map contextValueMapping;
    protected boolean isOutputContextPath = true;
    protected boolean isOutputServletPath = true;
    protected boolean isOutputSessionID = true;
    protected boolean isNewSession = false;
    protected boolean isOutputThreadName = true;
    protected boolean isOutputThreadGroupName = true;
    protected boolean isInitializeRecursiveCall = true;
    protected boolean isClear = true;
    protected ThreadLocal callStack;

    @Override
    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    @Override
    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    @Override
    public void setCodeMasterFinderServiceName(ServiceName name) {
        this.codeMasterFinderServiceName = name;
    }

    @Override
    public ServiceName getCodeMasterFinderServiceName() {
        return this.codeMasterFinderServiceName;
    }

    @Override
    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    @Override
    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    @Override
    public void setContextValueServiceNames(ServiceNameRef[] names) {
        this.contextValueServiceNames = names;
    }

    @Override
    public ServiceNameRef[] getContextValueServiceNames() {
        return this.contextValueServiceNames;
    }

    @Override
    public void setContextValueRequestParameter(Properties map) {
        this.contextValueRequestParameter = map;
    }

    @Override
    public Properties getContextValueRequestParameter() {
        return this.contextValueRequestParameter;
    }

    @Override
    public void setContextValueMapping(Map mapping) {
        this.contextValueMapping = mapping;
    }

    @Override
    public Map getContextValueMapping() {
        return this.contextValueMapping;
    }

    @Override
    public void setContextValue(String key, Object value) {
        if (this.contextValueMapping == null) {
            this.contextValueMapping = new HashMap();
        }
        this.contextValueMapping.put(key, value);
    }

    @Override
    public Object getContextValue(String key) {
        if (this.contextValueMapping == null) {
            return null;
        }
        return this.contextValueMapping.get(key);
    }

    @Override
    public void setOutputContextPath(boolean isOutput) {
        this.isOutputContextPath = isOutput;
    }

    @Override
    public boolean isOutputContextPath() {
        return this.isOutputContextPath;
    }

    @Override
    public void setOutputServletPath(boolean isOutput) {
        this.isOutputServletPath = isOutput;
    }

    @Override
    public boolean isOutputServletPath() {
        return this.isOutputServletPath;
    }

    @Override
    public void setOutputSessionID(boolean isOutput) {
        this.isOutputSessionID = isOutput;
    }

    @Override
    public boolean isOutputSessionID() {
        return this.isOutputSessionID;
    }

    @Override
    public void setOutputThreadName(boolean isOutput) {
        this.isOutputThreadName = isOutput;
    }

    @Override
    public boolean isOutputThreadName() {
        return this.isOutputThreadName;
    }

    @Override
    public void setOutputThreadGroupName(boolean isOutput) {
        this.isOutputThreadGroupName = isOutput;
    }

    @Override
    public boolean isOutputThreadGroupName() {
        return this.isOutputThreadGroupName;
    }

    @Override
    public void setNewSession(boolean isNew) {
        this.isNewSession = isNew;
    }

    @Override
    public boolean isNewSession() {
        return this.isNewSession;
    }

    @Override
    public boolean isInitializeRecursiveCall() {
        return this.isInitializeRecursiveCall;
    }

    @Override
    public void setInitializeRecursiveCall(boolean isInitialize) {
        this.isInitializeRecursiveCall = isInitialize;
    }

    @Override
    public boolean isClear() {
        return this.isClear;
    }

    @Override
    public void setClear(boolean isClear) {
        this.isClear = isClear;
    }

    @Override
    public void startService() throws Exception {
        if (this.threadContextServiceName == null) {
            throw new IllegalArgumentException("threadContextServiceName must be specified.");
        }
        this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        if (this.codeMasterFinderServiceName != null) {
            this.codeMasterFinder = (CodeMasterFinder)ServiceManagerFactory.getServiceObject(this.codeMasterFinderServiceName);
        }
        if (!this.isInitializeRecursiveCall) {
            this.callStack = new ThreadLocal(){

                protected Object initialValue() {
                    return new CallStack();
                }
            };
        }
    }

    @Override
    public void stopService() throws Exception {
        this.callStack = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3 && (this.callStack == null || ((CallStack)this.callStack.get()).stackIndex == 0)) {
            ServletRequest request = context.getServletRequest();
            if (this.isClear) {
                this.threadContext.clear();
            }
            if (this.sequence != null) {
                String requestId = this.sequence.increment();
                this.threadContext.put("REQUEST_ID", requestId);
            }
            if (this.contextValueServiceNames != null) {
                for (int i = 0; i < this.contextValueServiceNames.length; ++i) {
                    this.threadContext.put(this.contextValueServiceNames[i].getReferenceServiceName(), ServiceManagerFactory.getServiceObject(this.contextValueServiceNames[i].getServiceName()));
                }
            }
            if (this.contextValueRequestParameter != null && this.contextValueRequestParameter.size() != 0) {
                for (String string : this.contextValueRequestParameter.keySet()) {
                    String parameterName = this.contextValueRequestParameter.getProperty(string);
                    String[] params = request.getParameterValues(parameterName);
                    if (params == null) continue;
                    if (params.length == 1) {
                        this.threadContext.put(string, params[0]);
                        continue;
                    }
                    this.threadContext.put(string, params);
                }
            }
            if (this.contextValueMapping != null && this.contextValueMapping.size() != 0) {
                for (String string : this.contextValueMapping.keySet()) {
                    this.threadContext.put(string, this.contextValueMapping.get(string));
                }
            }
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpReq = (HttpServletRequest)request;
                if (this.isOutputContextPath) {
                    this.threadContext.put("CONTEXT_PATH", httpReq.getContextPath());
                }
                if (this.isOutputServletPath) {
                    this.threadContext.put("SERVLET_PATH", httpReq.getServletPath());
                }
                HttpSession httpSession = httpReq.getSession(this.isNewSession);
                if (this.isOutputSessionID && httpSession != null) {
                    this.threadContext.put("SESSION_ID", httpSession.getId());
                }
            }
            Thread thread = Thread.currentThread();
            if (this.isOutputThreadName) {
                this.threadContext.put("THREAD_NAME", thread.getName());
            }
            if (this.isOutputThreadGroupName) {
                ThreadGroup threadGroup = thread.getThreadGroup();
                this.threadContext.put("THREAD_GROUP_NAME", threadGroup.getName());
            }
            if (this.codeMasterFinder != null) {
                Map map = this.codeMasterFinder.getCodeMasters();
                this.threadContext.put("CODE_MASTER", map);
            }
        }
        try {
            if (this.callStack != null) {
                ++((CallStack)this.callStack.get()).stackIndex;
            }
            Object object = chain.invokeNext(context);
            return object;
        }
        finally {
            if (this.callStack != null) {
                --((CallStack)this.callStack.get()).stackIndex;
                if (this.isClear && ((CallStack)this.callStack.get()).stackIndex == 0) {
                    this.threadContext.clear();
                }
            } else if (this.isClear) {
                this.threadContext.clear();
            }
        }
    }

    protected static class CallStack {
        public int stackIndex;

        protected CallStack() {
        }
    }
}

