/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.BreakPointInterceptorServiceMBean;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class BreakPointInterceptorService
extends ServiceBase
implements Interceptor,
BreakPointInterceptorServiceMBean {
    private static final long serialVersionUID = -2667830848395155759L;
    private SynchronizeMonitor monitor = new WaitSynchronizeMonitor();
    private SynchronizeMonitor listenerMonitor = new WaitSynchronizeMonitor();
    private boolean enabled = true;
    private int breakPoint = 1;
    private long timeout;
    private List threads = new ArrayList();

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setMonitor(SynchronizeMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public SynchronizeMonitor getMonitor() {
        return this.monitor;
    }

    @Override
    public void setBreakPoint(int breakPoint) {
        this.breakPoint = breakPoint;
    }

    @Override
    public int getBreakPoint() {
        return this.breakPoint;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        SynchronizeMonitor synchronizeMonitor = this.monitor;
        synchronized (synchronizeMonitor) {
            this.monitor.notifyMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeAll() {
        SynchronizeMonitor synchronizeMonitor = this.monitor;
        synchronized (synchronizeMonitor) {
            this.monitor.notifyAllMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List suspendThreads() {
        List list = this.threads;
        synchronized (list) {
            return new ArrayList(this.threads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitSuspend() throws InterruptedException {
        if (this.getState() != 3) {
            return;
        }
        SynchronizeMonitor synchronizeMonitor = this.listenerMonitor;
        synchronized (synchronizeMonitor) {
            List list = this.threads;
            synchronized (list) {
                if (this.threads.size() != 0) {
                    return;
                }
            }
            this.listenerMonitor.initMonitor();
            this.listenerMonitor.waitMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitSuspend(long timeout) throws InterruptedException {
        if (this.getState() != 3) {
            return false;
        }
        SynchronizeMonitor synchronizeMonitor = this.listenerMonitor;
        synchronized (synchronizeMonitor) {
            List list = this.threads;
            synchronized (list) {
                if (this.threads.size() != 0) {
                    return true;
                }
            }
            this.listenerMonitor.initMonitor();
            this.listenerMonitor.waitMonitor(timeout);
            list = this.threads;
            synchronized (list) {
                return this.threads.size() != 0;
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitSuspend(String threadName) throws InterruptedException {
        if (this.getState() != 3) {
            return;
        }
        SynchronizeMonitor synchronizeMonitor = this.listenerMonitor;
        synchronized (synchronizeMonitor) {
            List list = this.threads;
            synchronized (list) {
                if (this.threads.contains(threadName)) {
                    return;
                }
            }
            this.listenerMonitor.initMonitor();
            this.listenerMonitor.waitMonitor();
            list = this.threads;
            synchronized (list) {
                if (this.threads.contains(threadName)) {
                    return;
                }
            }
            this.waitSuspend(threadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitSuspend(String threadName, long timeout) throws InterruptedException {
        if (this.getState() != 3) {
            return false;
        }
        SynchronizeMonitor synchronizeMonitor = this.listenerMonitor;
        synchronized (synchronizeMonitor) {
            List list = this.threads;
            synchronized (list) {
                if (this.threads.contains(threadName)) {
                    return true;
                }
            }
            long startTime = System.currentTimeMillis();
            this.listenerMonitor.initMonitor();
            this.listenerMonitor.waitMonitor(timeout);
            long waitTime = System.currentTimeMillis() - startTime;
            List list2 = this.threads;
            synchronized (list2) {
                if (this.threads.contains(threadName)) {
                    return true;
                }
                if (waitTime >= timeout) {
                    return false;
                }
            }
            return this.waitSuspend(threadName, timeout - waitTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService() throws Exception {
        SynchronizeMonitor synchronizeMonitor = this.listenerMonitor;
        synchronized (synchronizeMonitor) {
            this.listenerMonitor.notifyAllMonitor();
        }
        synchronizeMonitor = this.monitor;
        synchronized (synchronizeMonitor) {
            this.monitor.notifyAllMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3 && this.enabled && this.breakPoint == 1) {
            this.breakpoint();
        }
        try {
            Object object = chain.invokeNext(context);
            return object;
        }
        finally {
            if (this.getState() == 3 && this.enabled && this.breakPoint == 2) {
                this.breakpoint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void breakpoint() {
        List list;
        SynchronizeMonitor synchronizeMonitor;
        Thread thread = Thread.currentThread();
        try {
            synchronizeMonitor = this.listenerMonitor;
            synchronized (synchronizeMonitor) {
                list = this.threads;
                synchronized (list) {
                    this.threads.add(thread.getName());
                }
                this.listenerMonitor.notifyAllMonitor();
            }
            synchronizeMonitor = this.monitor;
            synchronized (synchronizeMonitor) {
                try {
                    this.monitor.initMonitor();
                    if (this.timeout > 0L) {
                        this.monitor.waitMonitor(this.timeout);
                    } else {
                        this.monitor.waitMonitor();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        finally {
            synchronizeMonitor = this.listenerMonitor;
            synchronized (synchronizeMonitor) {
                list = this.threads;
                synchronized (list) {
                    this.threads.remove(thread.getName());
                }
            }
        }
    }
}

