/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.Iterator;
import jp.ossc.nimbus.core.ArgumentMetaData;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.InvokeMetaData;
import jp.ossc.nimbus.core.MetaData;
import org.w3c.dom.Element;

public class StaticInvokeMetaData
extends InvokeMetaData
implements Serializable {
    private static final long serialVersionUID = 1485995391022397775L;
    public static final String STATIC_INVOKE_TAG_NAME = "static-invoke";
    protected static final String CODE_ATTRIBUTE_NAME = "code";
    protected String code;

    public StaticInvokeMetaData(MetaData parent) {
        super(parent);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public void importXML(Element element) throws DeploymentException {
        if (!element.getTagName().equals(STATIC_INVOKE_TAG_NAME)) {
            throw new DeploymentException("Tag must be static-invoke : " + element.getTagName());
        }
        this.code = StaticInvokeMetaData.getUniqueAttribute(element, CODE_ATTRIBUTE_NAME);
        this.name = StaticInvokeMetaData.getUniqueAttribute(element, "name");
        Iterator argElements = StaticInvokeMetaData.getChildrenByTagName(element, "argument");
        while (argElements.hasNext()) {
            ArgumentMetaData argData = new ArgumentMetaData(this, this.getParentObjectMetaData());
            argData.importXML((Element)argElements.next());
            this.addArgument(argData);
        }
    }

    @Override
    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append('<').append(STATIC_INVOKE_TAG_NAME);
        if (this.code != null) {
            buf.append(' ').append(CODE_ATTRIBUTE_NAME).append("=\"").append(this.code).append("\"");
        }
        if (this.name != null) {
            buf.append(' ').append("name").append("=\"").append(this.name).append("\"");
        }
        if (this.arguments.size() == 0) {
            buf.append("/>");
        } else {
            buf.append('>');
            if (this.arguments.size() != 0) {
                buf.append(LINE_SEPARATOR);
                int imax = this.arguments.size();
                for (int i = 0; i < imax; ++i) {
                    buf.append(this.addIndent(((MetaData)this.arguments.get(i)).toXML(new StringBuffer())));
                    if (i == imax - 1) continue;
                    buf.append(LINE_SEPARATOR);
                }
            }
            buf.append(LINE_SEPARATOR);
            buf.append("</").append(STATIC_INVOKE_TAG_NAME).append('>');
        }
        return buf;
    }
}

