/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.Locale;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.core.ServiceStateBroadcaster;
import jp.ossc.nimbus.core.ServiceStateChangeEvent;
import jp.ossc.nimbus.core.ServiceStateListener;
import jp.ossc.nimbus.lang.AppException;
import jp.ossc.nimbus.service.log.Logger;

class LoggerWrapper
implements Logger,
ServiceStateListener,
Serializable {
    private static final long serialVersionUID = 6446367171255245828L;
    private Logger defaultLog;
    private Logger currentLog;

    public LoggerWrapper(Logger defaultLog) {
        this(null, null, defaultLog);
    }

    public LoggerWrapper(Logger log, Service logService, Logger defaultLog) {
        this.setDefaultLogger(defaultLog);
        this.setLogger(log, logService);
    }

    public void setDefaultLogger(Logger log) {
        if (log == this) {
            return;
        }
        this.defaultLog = log;
    }

    public Logger getDefaultLogger() {
        return this.defaultLog;
    }

    public void setLogger(Logger log) {
        this.setLogger(log, null);
    }

    public void setLogger(Logger log, Service logService) {
        if (log == this) {
            return;
        }
        if (logService != null) {
            this.currentLog = logService.getState() == 3 ? log : this.defaultLog;
            try {
                ServiceStateBroadcaster broadcaster = ServiceManagerFactory.getServiceStateBroadcaster(logService.getServiceManagerName(), logService.getServiceName());
                if (broadcaster != null) {
                    broadcaster.addServiceStateListener(this);
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {}
        } else {
            this.currentLog = log != null ? log : this.defaultLog;
        }
    }

    public Logger getLogger() {
        return this.currentLog;
    }

    @Override
    public void write(String logCode, Object[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds);
        }
    }

    @Override
    public void write(String logCode, byte[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds);
        }
    }

    @Override
    public void write(String logCode, short[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds);
        }
    }

    @Override
    public void write(String logCode, char[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds);
        }
    }

    @Override
    public void write(String logCode, int[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds);
        }
    }

    @Override
    public void write(String logCode, long[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds);
        }
    }

    @Override
    public void write(String logCode, float[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds);
        }
    }

    @Override
    public void write(String logCode, double[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds);
        }
    }

    @Override
    public void write(String logCode, boolean[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds);
        }
    }

    @Override
    public void write(String logCode, Object embed) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed);
        }
    }

    @Override
    public void write(String logCode, byte embed) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed);
        }
    }

    @Override
    public void write(String logCode, short embed) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed);
        }
    }

    @Override
    public void write(String logCode, char embed) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed);
        }
    }

    @Override
    public void write(String logCode, int embed) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed);
        }
    }

    @Override
    public void write(String logCode, long embed) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed);
        }
    }

    @Override
    public void write(String logCode, float embed) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed);
        }
    }

    @Override
    public void write(String logCode, double embed) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed);
        }
    }

    @Override
    public void write(String logCode, boolean embed) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed);
        }
    }

    @Override
    public void write(String logCode) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode);
        }
    }

    @Override
    public void write(String logCode, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, oException);
        }
    }

    @Override
    public void write(String logCode, Object embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed, oException);
        }
    }

    @Override
    public void write(String logCode, byte embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed, oException);
        }
    }

    @Override
    public void write(String logCode, short embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed, oException);
        }
    }

    @Override
    public void write(String logCode, char embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed, oException);
        }
    }

    @Override
    public void write(String logCode, int embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed, oException);
        }
    }

    @Override
    public void write(String logCode, long embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed, oException);
        }
    }

    @Override
    public void write(String logCode, float embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed, oException);
        }
    }

    @Override
    public void write(String logCode, double embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed, oException);
        }
    }

    @Override
    public void write(String logCode, boolean embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embed, oException);
        }
    }

    @Override
    public void write(String logCode, Object[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds, oException);
        }
    }

    @Override
    public void write(String logCode, byte[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds, oException);
        }
    }

    @Override
    public void write(String logCode, short[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds, oException);
        }
    }

    @Override
    public void write(String logCode, char[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds, oException);
        }
    }

    @Override
    public void write(String logCode, int[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds, oException);
        }
    }

    @Override
    public void write(String logCode, long[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds, oException);
        }
    }

    @Override
    public void write(String logCode, float[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds, oException);
        }
    }

    @Override
    public void write(String logCode, double[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds, oException);
        }
    }

    @Override
    public void write(String logCode, boolean[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(logCode, embeds, oException);
        }
    }

    @Override
    public void write(AppException e) {
        if (this.currentLog != null) {
            this.currentLog.write(e);
        }
    }

    @Override
    public void write(Locale lo, String logCode, Object[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds);
        }
    }

    @Override
    public void write(Locale lo, String logCode, byte[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds);
        }
    }

    @Override
    public void write(Locale lo, String logCode, short[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds);
        }
    }

    @Override
    public void write(Locale lo, String logCode, char[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds);
        }
    }

    @Override
    public void write(Locale lo, String logCode, int[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds);
        }
    }

    @Override
    public void write(Locale lo, String logCode, long[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds);
        }
    }

    @Override
    public void write(Locale lo, String logCode, float[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds);
        }
    }

    @Override
    public void write(Locale lo, String logCode, double[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds);
        }
    }

    @Override
    public void write(Locale lo, String logCode, boolean[] embeds) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds);
        }
    }

    @Override
    public void write(Locale lo, String logCode, Object embed) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed);
        }
    }

    @Override
    public void write(Locale lo, String logCode, byte embed) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed);
        }
    }

    @Override
    public void write(Locale lo, String logCode, short embed) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed);
        }
    }

    @Override
    public void write(Locale lo, String logCode, char embed) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed);
        }
    }

    @Override
    public void write(Locale lo, String logCode, int embed) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed);
        }
    }

    @Override
    public void write(Locale lo, String logCode, long embed) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed);
        }
    }

    @Override
    public void write(Locale lo, String logCode, float embed) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed);
        }
    }

    @Override
    public void write(Locale lo, String logCode, double embed) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed);
        }
    }

    @Override
    public void write(Locale lo, String logCode, boolean embed) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed);
        }
    }

    @Override
    public void write(Locale lo, String logCode) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode);
        }
    }

    @Override
    public void write(Locale lo, String logCode, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, Object embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, byte embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, short embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, char embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, int embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, long embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, float embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, double embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, boolean embed, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embed, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, Object[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, byte[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, short[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, char[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, int[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, long[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, float[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, double[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds, oException);
        }
    }

    @Override
    public void write(Locale lo, String logCode, boolean[] embeds, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, logCode, embeds, oException);
        }
    }

    @Override
    public void write(Locale lo, AppException e) {
        if (this.currentLog != null) {
            this.currentLog.write(lo, e);
        }
    }

    @Override
    public boolean isWrite(String logCode) {
        if (this.currentLog != null) {
            return this.currentLog.isWrite(logCode);
        }
        return false;
    }

    @Override
    public boolean isDebugWrite() {
        if (this.currentLog != null) {
            return this.currentLog.isDebugWrite();
        }
        return false;
    }

    @Override
    public void debug(Object msg) {
        if (this.currentLog != null) {
            this.currentLog.debug(msg);
        }
    }

    @Override
    public void debug(Object msg, Throwable oException) {
        if (this.currentLog != null) {
            this.currentLog.debug(msg, oException);
        }
    }

    @Override
    public void stateChanged(ServiceStateChangeEvent e) throws Exception {
        Service service = e.getService();
        int state = service.getState();
        String managerName = service.getServiceManagerName();
        String serviceName = service.getServiceName();
        switch (state) {
            case 3: {
                this.currentLog = (Logger)ServiceManagerFactory.getServiceObject(managerName, serviceName);
                break;
            }
            case 4: {
                this.currentLog = this.defaultLog;
                break;
            }
        }
    }

    @Override
    public boolean isEnabledState(int state) {
        switch (state) {
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return super.toString() + '{' + "currentLog=" + this.currentLog + "defaultLog=" + this.defaultLog + '}';
    }
}

