/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.NullKeyPropertyException;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;

public class MappedProperty
extends SimpleProperty
implements Serializable {
    private static final long serialVersionUID = 8407662267357861189L;
    private static final String MSG_00001 = "Illegal MappedProperty : ";
    private static final String MSG_00002 = "Length of property literal must be not null.";
    private static final String RECORD_PROP_NAME = "Property";
    protected static final String GET_METHOD_NAME = "get";
    protected static final String IS_METHOD_NAME = "is";
    protected static final Class[] GET_METHOD_ARGS = new Class[]{String.class};
    protected static final String SET_METHOD_NAME = "set";
    protected String key;
    protected transient Map mappedReadMethodCache = new HashMap();
    protected transient Map mappedWriteMethodCache = new HashMap();

    public MappedProperty() {
    }

    public MappedProperty(String name) throws IllegalArgumentException {
        super(name);
    }

    public MappedProperty(String name, String key) throws IllegalArgumentException {
        super(name);
        this.key = key;
    }

    @Override
    public String getPropertyName() {
        return super.getPropertyName() + '(' + this.key + ')';
    }

    @Override
    protected void setPropertyName(String prop) throws IllegalArgumentException {
        if (prop == null) {
            throw new IllegalArgumentException(MSG_00002);
        }
        this.property = prop;
    }

    @Override
    public void parse(String prop) throws IllegalArgumentException {
        int startMappedDelim = prop.indexOf(40);
        int endMappedDelim = prop.indexOf(41);
        if (startMappedDelim == -1 || endMappedDelim == -1 || endMappedDelim - startMappedDelim < 1 || endMappedDelim != prop.length() - 1) {
            throw new IllegalArgumentException(MSG_00001 + prop);
        }
        this.key = prop.substring(startMappedDelim + 1, endMappedDelim);
        this.setPropertyName(prop.substring(0, startMappedDelim));
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public Class getPropertyType(Object obj) throws NoSuchPropertyException {
        Class type;
        PropertySchema propSchema;
        Record record;
        RecordSchema recSchema;
        if (obj == null) {
            return Object.class;
        }
        if (obj instanceof Record && RECORD_PROP_NAME.equalsIgnoreCase(super.getPropertyName()) && (recSchema = (record = (Record)obj).getRecordSchema()) != null && (propSchema = recSchema.getPropertySchema(this.getKey())) != null && (type = propSchema.getType()) != null) {
            return type;
        }
        Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if (this.property.length() == 0) {
            return this.getMappedObjectPropertyType(clazz);
        }
        if (this.mappedReadMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.mappedReadMethodCache.get(clazz);
        } else {
            readMethod = this.getReadMappedMethod(clazz);
            this.mappedReadMethodCache.put(clazz, readMethod);
        }
        if (readMethod == null) {
            Method setMethod = this.getWriteMappedMethod(clazz, null);
            if (setMethod != null) {
                Map overloadMap;
                Object methodObj;
                if (this.mappedWriteMethodCache.containsKey(clazz) && !((methodObj = this.mappedWriteMethodCache.get(clazz)) instanceof Method) && ((overloadMap = (Map)methodObj).size() > 2 || overloadMap.size() == 2 && !overloadMap.containsKey(null))) {
                    return null;
                }
                return setMethod.getParameterTypes()[1];
            }
            Class retClass = null;
            try {
                retClass = super.getPropertyType(obj);
            }
            catch (NoSuchPropertyException e) {
                throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')');
            }
            return this.getMappedObjectPropertyType(retClass);
        }
        return readMethod.getReturnType();
    }

    @Override
    public boolean isReadable(Object obj) {
        try {
            this.getProperty(obj);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isWritable(Object obj, Class clazz) {
        Class<?> objClazz = obj.getClass();
        Method readMethod = null;
        Method writeMethod = null;
        if (this.getMethodCache.containsKey(objClazz) && this.getMethodCache.get(objClazz) != null) {
            readMethod = (Method)this.getMethodCache.get(objClazz);
            return this.isWritableNoMappedProperty(obj, readMethod, clazz);
        }
        if (this.property.length() == 0) {
            return this.isWritableMappedObjectProperty(obj, clazz);
        }
        writeMethod = this.getWriteMappedMethod(objClazz, clazz);
        if (writeMethod == null) {
            Object prop = null;
            try {
                prop = super.getProperty(obj);
            }
            catch (NoSuchPropertyException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            if (prop == null) {
                return false;
            }
            return this.isWritableMappedObjectProperty(obj, clazz);
        }
        return true;
    }

    @Override
    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz) && this.getMethodCache.get(clazz) != null) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            if (readMethod.getParameterTypes().length == 0) {
                return this.getNoMappedProperty(obj, readMethod);
            }
            Object prop = super.getProperty(obj);
            if (prop == null) {
                throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')');
            }
            return this.getMappedObjectProperty(prop.getClass(), prop);
        }
        if (this.mappedReadMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.mappedReadMethodCache.get(clazz);
            return this.getMappedProperty(obj, readMethod);
        }
        if (this.property.length() == 0) {
            return this.getMappedObjectProperty(clazz, obj);
        }
        readMethod = this.getReadMappedMethod(clazz);
        if (readMethod == null) {
            Object prop = super.getProperty(obj);
            if (prop == null) {
                throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')');
            }
            return this.getMappedObjectProperty(prop.getClass(), prop);
        }
        this.mappedReadMethodCache.put(clazz, readMethod);
        return this.getMappedProperty(obj, readMethod);
    }

    protected Object getMappedProperty(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            return readMethod.invoke(obj, this.key);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')', e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')', e);
        }
    }

    protected Object getNoMappedProperty(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Object mappedObj = this.getMappedObject(obj, readMethod);
        if (mappedObj == null) {
            if (this.isIgnoreNullProperty) {
                return null;
            }
            throw new NullKeyPropertyException(clazz, this.property + '(' + this.key + ')');
        }
        return this.getMappedObjectProperty(mappedObj.getClass(), mappedObj);
    }

    protected Class getMappedObjectPropertyType(Class mappedClazz) throws NoSuchPropertyException {
        if (Map.class.isAssignableFrom(mappedClazz)) {
            return Object.class;
        }
        Method getMethod = null;
        try {
            getMethod = mappedClazz.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
        }
        catch (NoSuchMethodException e) {
            Method setMethod = null;
            Method[] methods = mappedClazz.getMethods();
            if (methods == null || methods.length == 0) {
                throw new NoSuchPropertyException(mappedClazz, this.property + '(' + this.key + ')');
            }
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] params;
                Method method = methods[i];
                if (!SET_METHOD_NAME.equals(method.getName()) || !Modifier.isPublic(method.getModifiers()) || Modifier.isNative(method.getModifiers()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(String.class)) continue;
                if (setMethod == null) {
                    setMethod = method;
                    continue;
                }
                throw new NoSuchPropertyException(mappedClazz, this.property + '(' + this.key + ')');
            }
            if (setMethod == null) {
                throw new NoSuchPropertyException(mappedClazz, this.property + '(' + this.key + ')');
            }
            return setMethod.getParameterTypes()[1];
        }
        if (!Modifier.isPublic(getMethod.getModifiers()) || Modifier.isNative(getMethod.getModifiers())) {
            throw new NoSuchPropertyException(mappedClazz, this.property + '(' + this.key + ')');
        }
        return getMethod.getReturnType();
    }

    protected Object getMappedObjectProperty(Class clazz, Object obj) throws NoSuchPropertyException, InvocationTargetException {
        if (Map.class.isAssignableFrom(clazz)) {
            Map map = (Map)obj;
            return map.get(this.key);
        }
        Class mappedClazz = clazz;
        if (!MappedProperty.isAccessableClass(mappedClazz)) {
            Class<?>[] interfaces = mappedClazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!MappedProperty.isAccessableClass(interfaces[i])) continue;
                try {
                    return this.getMappedObjectProperty(interfaces[i], obj);
                }
                catch (NoSuchPropertyException e) {
                    // empty catch block
                }
            }
            Class superClass = mappedClazz.getSuperclass();
            if (superClass != null) {
                return this.getMappedObjectProperty(superClass, obj);
            }
            throw new NoSuchPropertyException(mappedClazz, this.property + '(' + this.key + ')');
        }
        Method getMethod = null;
        try {
            getMethod = mappedClazz.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchPropertyException(mappedClazz, this.property + '(' + this.key + ')');
        }
        if (Modifier.isPublic(getMethod.getModifiers()) && !Modifier.isNative(getMethod.getModifiers())) {
            try {
                return getMethod.invoke(obj, this.key);
            }
            catch (IllegalAccessException e) {
                throw new NoSuchPropertyException(mappedClazz, this.property + '(' + this.key + ')', e);
            }
            catch (IllegalArgumentException e) {
                throw new NoSuchPropertyException(mappedClazz, this.property + '(' + this.key + ')', e);
            }
        }
        throw new NoSuchPropertyException(mappedClazz, this.property + '(' + this.key + ')');
    }

    @Override
    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        this.setProperty(obj, value == null ? null : value.getClass(), value);
    }

    @Override
    public void setProperty(Object obj, Class type, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Method readMethod = null;
        Method writeMethod = null;
        if (this.getMethodCache.containsKey(clazz) && this.getMethodCache.get(clazz) != null) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            this.setNoMappedProperty(obj, readMethod, value);
        } else if (this.property.length() == 0) {
            this.setMappedObjectProperty(clazz, obj, value);
        } else {
            if (type == null && value != null) {
                type = value.getClass();
            }
            if ((writeMethod = this.getWriteMappedMethod(clazz, type)) == null) {
                Object prop = super.getProperty(obj);
                if (prop == null) {
                    throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')');
                }
                this.setMappedObjectProperty(prop.getClass(), prop, value);
            } else {
                this.setMappedProperty(obj, writeMethod, value);
            }
        }
    }

    protected void setMappedProperty(Object obj, Method writeMethod, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            Class<?> paramType = writeMethod.getParameterTypes()[1];
            if (value instanceof Number && !paramType.isPrimitive() && !paramType.equals(value.getClass())) {
                value = this.castPrimitiveWrapper(paramType, (Number)value);
            }
            writeMethod.invoke(obj, this.key, value);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')', e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')', e);
        }
    }

    protected Object getMappedObject(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Object mappedObj = null;
        try {
            mappedObj = readMethod.invoke(obj, NULL_ARGS);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')', e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')', e);
        }
        return mappedObj;
    }

    protected void setNoMappedProperty(Object obj, Method readMethod, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Object mappedObj = this.getMappedObject(obj, readMethod);
        if (mappedObj == null) {
            throw new NullKeyPropertyException(clazz, this.property + '(' + this.key + ')');
        }
        this.setMappedObjectProperty(mappedObj.getClass(), mappedObj, value);
    }

    protected boolean isWritableNoMappedProperty(Object obj, Method readMethod, Class clazz) {
        Object mappedObj = null;
        try {
            mappedObj = this.getMappedObject(obj, readMethod);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        if (mappedObj == null) {
            return false;
        }
        return this.isWritableMappedObjectProperty(mappedObj, clazz);
    }

    protected boolean isWritableMappedObjectProperty(Object obj, Class clazz) {
        Class<?> mappedClazz = obj.getClass();
        if (obj instanceof Map) {
            return true;
        }
        Method setMethod = null;
        Class valueClass = clazz == null ? null : clazz;
        Method[] methods = mappedClazz.getMethods();
        if (methods == null || methods.length == 0) {
            return false;
        }
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params;
            Method method = methods[i];
            if (!SET_METHOD_NAME.equals(method.getName()) || !Modifier.isPublic(method.getModifiers()) || Modifier.isNative(method.getModifiers()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(String.class) || valueClass != null && !this.isAssignableFrom(params[1], valueClass) || setMethod != null && !this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
            setMethod = method;
        }
        return setMethod != null;
    }

    protected void setMappedObjectProperty(Class clazz, Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        if (obj instanceof Map) {
            Map map = (Map)obj;
            map.put(this.key, value);
        } else {
            if (!MappedProperty.isAccessableClass(clazz)) {
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!MappedProperty.isAccessableClass(interfaces[i])) continue;
                    try {
                        this.setMappedObjectProperty(interfaces[i], obj, value);
                        return;
                    }
                    catch (NoSuchPropertyException e) {
                        // empty catch block
                    }
                }
                Class superClass = clazz.getSuperclass();
                if (superClass != null) {
                    this.setMappedObjectProperty(superClass, obj, value);
                    return;
                }
                throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')');
            }
            Method setMethod = null;
            Class<?> valueClass = value == null ? null : value.getClass();
            Method[] methods = clazz.getMethods();
            if (methods == null || methods.length == 0) {
                throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')');
            }
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] params;
                Method method = methods[i];
                if (!SET_METHOD_NAME.equals(method.getName()) || !Modifier.isPublic(method.getModifiers()) || Modifier.isNative(method.getModifiers()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(String.class) || valueClass != null && !this.isAssignableFrom(params[1], valueClass) || setMethod != null && !this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
            }
            if (setMethod == null) {
                throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')');
            }
            try {
                setMethod.invoke(obj, this.key, value);
            }
            catch (IllegalAccessException e) {
                throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')', e);
            }
            catch (IllegalArgumentException e) {
                throw new NoSuchPropertyException(clazz, this.property + '(' + this.key + ')', e);
            }
        }
    }

    protected Method getReadMappedMethod(Class clazz) {
        if (!MappedProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method method = this.getReadMappedMethod(interfaces[i]);
                if (method == null) continue;
                return method;
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getReadMappedMethod(superClass);
            }
            return null;
        }
        StringBuffer methodName = new StringBuffer(GET_METHOD_NAME);
        if (this.property.length() != 0) {
            char capital = this.property.charAt(0);
            if (Character.isUpperCase(capital)) {
                methodName.append(this.property);
            } else {
                capital = Character.toUpperCase(capital);
                methodName.append(capital);
                if (this.property.length() > 1) {
                    methodName.append(this.property.substring(1));
                }
            }
        }
        try {
            return clazz.getMethod(methodName.toString(), GET_METHOD_ARGS);
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getMethod(this.property, GET_METHOD_ARGS);
            }
            catch (NoSuchMethodException e2) {
                methodName.delete(0, 3);
                methodName.insert(0, IS_METHOD_NAME);
                try {
                    return clazz.getMethod(methodName.toString(), GET_METHOD_ARGS);
                }
                catch (NoSuchMethodException e3) {
                    return null;
                }
            }
        }
    }

    protected Method getWriteMappedMethod(Class clazz, Class param) {
        if (this.mappedWriteMethodCache.containsKey(clazz)) {
            Object methodObj = this.mappedWriteMethodCache.get(clazz);
            if (methodObj instanceof Method) {
                return (Method)methodObj;
            }
            Map overloadMap = (Map)methodObj;
            if (param == null) {
                if (overloadMap.size() == 1) {
                    return (Method)overloadMap.values().iterator().next();
                }
                Method setMethod = (Method)overloadMap.get(null);
                if (setMethod != null) {
                    return setMethod;
                }
                Object[] classes = overloadMap.keySet().toArray();
                for (int i = 0; i < classes.length; ++i) {
                    Method method = (Method)overloadMap.get(classes[i]);
                    Class<?>[] params = method.getParameterTypes();
                    if (setMethod == null) {
                        if (params[1].isPrimitive()) continue;
                        setMethod = method;
                        continue;
                    }
                    if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                    setMethod = method;
                }
                HashMap<Object, Method> tmpOverloadMap = new HashMap<Object, Method>(overloadMap);
                tmpOverloadMap.put(null, setMethod);
                this.mappedWriteMethodCache.put(clazz, tmpOverloadMap);
                return setMethod;
            }
            if (overloadMap.containsKey(param)) {
                return (Method)overloadMap.get(param);
            }
            Method setMethod = (Method)overloadMap.get(null);
            if (setMethod != null) {
                return setMethod;
            }
            Object[] classes = overloadMap.keySet().toArray();
            Class primitiveClazz = this.toPrimitive(param);
            for (int i = 0; i < classes.length; ++i) {
                Method method = (Method)overloadMap.get(classes[i]);
                Class<?>[] params = method.getParameterTypes();
                if (setMethod == null) {
                    if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
                    setMethod = method;
                    if (!param.equals(params[0]) && !params[0].equals(primitiveClazz)) continue;
                    break;
                }
                if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
                if (params[1].equals(param) || params[1].equals(primitiveClazz)) {
                    setMethod = method;
                    break;
                }
                if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
            }
            HashMap<Class, Method> tmpOverloadMap = new HashMap<Class, Method>(overloadMap);
            tmpOverloadMap.put(param, setMethod);
            this.mappedWriteMethodCache.put(clazz, tmpOverloadMap);
            return setMethod;
        }
        if (!MappedProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method method = this.getWriteMappedMethod(interfaces[i], param);
                if (method == null) continue;
                return method;
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getWriteMappedMethod(superClass, param);
            }
            return null;
        }
        StringBuffer methodName = new StringBuffer(SET_METHOD_NAME);
        if (this.property.length() != 0) {
            char capital = this.property.charAt(0);
            if (Character.isUpperCase(capital)) {
                methodName.append(this.property);
            } else {
                capital = Character.toUpperCase(capital);
                methodName.append(capital);
                if (this.property.length() > 1) {
                    methodName.append(this.property.substring(1));
                }
            }
        }
        Method setMethod = null;
        Method[] methods = clazz.getMethods();
        if (methods == null || methods.length == 0) {
            return null;
        }
        Class primitiveClazz = this.toPrimitive(param);
        HashMap overloadMap = new HashMap();
        boolean isMatch = false;
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params;
            Method method = methods[i];
            if (!methodName.toString().equals(method.getName()) || Modifier.isNative(method.getModifiers()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(String.class)) continue;
            overloadMap.put(params[1], method);
            if (isMatch) continue;
            if (setMethod == null) {
                if (param == null) {
                    setMethod = method;
                    continue;
                }
                if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
                setMethod = method;
                if (!param.equals(params[0]) && !params[0].equals(primitiveClazz)) continue;
                isMatch = true;
                continue;
            }
            if (param == null) {
                if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
                continue;
            }
            if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
            if (params[1].equals(param) || params[1].equals(primitiveClazz)) {
                isMatch = true;
                setMethod = method;
                continue;
            }
            if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
            setMethod = method;
        }
        if (param == null) {
            overloadMap.put(null, setMethod);
        }
        if (setMethod != null) {
            if (overloadMap.size() > 1) {
                this.mappedWriteMethodCache.put(clazz, overloadMap);
            } else {
                this.mappedWriteMethodCache.put(clazz, setMethod);
            }
        }
        return setMethod;
    }

    public static MappedProperty[] getMappedProperties(Object bean) {
        return MappedProperty.getMappedProperties(bean.getClass());
    }

    public static MappedProperty[] getMappedProperties(Class clazz) {
        Set props = new HashSet();
        if (MappedProperty.isAccessableClass(clazz)) {
            props = MappedProperty.getMappedProperties(clazz, null, props);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!MappedProperty.isAccessableClass(interfaces[i])) continue;
                props = MappedProperty.getMappedProperties(interfaces[i], null, props);
                break;
            }
        }
        return props.toArray(new MappedProperty[props.size()]);
    }

    private static Set getMappedProperties(Class clazz, String prop, Set props) {
        Method[] methods = clazz.getMethods();
        if (methods == null || methods.length == 0) {
            return props;
        }
        String getMethodName = null;
        String setMethodName = null;
        String isMethodName = null;
        if (prop != null) {
            StringBuffer methodName = new StringBuffer();
            if (prop.length() != 0) {
                char capital = prop.charAt(0);
                if (Character.isUpperCase(capital)) {
                    methodName.append(prop);
                } else {
                    capital = Character.toUpperCase(capital);
                    methodName.append(capital);
                    if (prop.length() > 1) {
                        methodName.append(prop.substring(1));
                    }
                }
            }
            getMethodName = methodName.insert(0, GET_METHOD_NAME).toString();
            methodName.delete(0, GET_METHOD_NAME.length());
            setMethodName = methodName.insert(0, SET_METHOD_NAME).toString();
            methodName.delete(0, SET_METHOD_NAME.length());
            isMethodName = methodName.insert(0, IS_METHOD_NAME).toString();
        }
        for (int i = 0; i < methods.length; ++i) {
            Class<?> retType;
            Method method = methods[i];
            if (Modifier.isNative(method.getModifiers())) continue;
            Class<?>[] params = method.getParameterTypes();
            if (getMethodName != null && getMethodName.equals(method.getName()) || getMethodName == null && method.getName().startsWith(GET_METHOD_NAME)) {
                retType = method.getReturnType();
                if (Void.TYPE.equals(retType)) continue;
                if (params == null) {
                    if (Map.class.isAssignableFrom(retType)) {
                        props.add(new MappedProperty(method.getName().substring(3)));
                        continue;
                    }
                    try {
                        retType.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
                        props.add(new MappedProperty(method.getName().substring(3)));
                    }
                    catch (NoSuchMethodException e) {
                        Method[] nestedMethods = retType.getMethods();
                        boolean isFound = false;
                        for (int j = 0; j < nestedMethods.length; ++j) {
                            Class<?>[] nestedParams = nestedMethods[j].getParameterTypes();
                            if (!SET_METHOD_NAME.equals(nestedMethods[j].getName()) || Modifier.isNative(nestedMethods[j].getModifiers()) || nestedParams.length != 2 || !String.class.equals(nestedParams[0])) continue;
                            isFound = true;
                            break;
                        }
                        if (!isFound) continue;
                        props.add(new MappedProperty(method.getName().substring(3)));
                    }
                    continue;
                }
                if (params.length != 1 || !String.class.equals(params[0])) continue;
                props.add(new MappedProperty(method.getName().substring(3)));
                continue;
            }
            if (isMethodName != null && isMethodName.equals(method.getName()) || isMethodName == null && method.getName().startsWith(IS_METHOD_NAME)) {
                retType = method.getReturnType();
                if (!Boolean.TYPE.equals(retType) || params == null || params.length != 1 || !String.class.equals(params[0])) continue;
                props.add(new MappedProperty(method.getName().substring(2)));
                continue;
            }
            if ((setMethodName == null || !setMethodName.equals(method.getName())) && (setMethodName != null || !method.getName().startsWith(SET_METHOD_NAME)) || params == null || params.length != 2 || !String.class.equals(params[0])) continue;
            props.add(new MappedProperty(method.getName().substring(3)));
        }
        return props;
    }

    public static MappedProperty[] getMappedProperties(Class clazz, String prop) {
        Set props = new HashSet();
        if (MappedProperty.isAccessableClass(clazz)) {
            props = MappedProperty.getMappedProperties(clazz, prop, props);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!MappedProperty.isAccessableClass(interfaces[i])) continue;
                props = MappedProperty.getMappedProperties(interfaces[i], prop, props);
                break;
            }
        }
        return props.toArray(new MappedProperty[props.size()]);
    }

    @Override
    public String toString() {
        return "MappedProperty{" + this.property + '(' + this.key + ")}";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappedProperty)) {
            return false;
        }
        MappedProperty comp = (MappedProperty)obj;
        if (this.property == null && comp.property != null || this.property != null && comp.property == null) {
            return false;
        }
        if (this.property != null && comp.property != null && !this.property.equals(comp.property)) {
            return false;
        }
        if (this.key == null && comp.key == null) {
            return true;
        }
        if (this.key == null) {
            return false;
        }
        return this.key.equals(comp.key);
    }

    @Override
    public int hashCode() {
        return (this.property == null ? 0 : this.property.hashCode()) + (this.key == null ? 0 : this.key.hashCode()) + 1;
    }

    @Override
    public int compareTo(Object obj) {
        int val;
        if (obj == null) {
            return 1;
        }
        if (!(obj instanceof MappedProperty)) {
            return 1;
        }
        MappedProperty comp = (MappedProperty)obj;
        if (this.property == null && comp.property != null) {
            return -1;
        }
        if (this.property != null && comp.property == null) {
            return 1;
        }
        if (this.property != null && comp.property != null && (val = this.property.compareTo(comp.property)) != 0) {
            return val;
        }
        if (this.key == null && comp.key == null) {
            return 0;
        }
        if (this.key == null) {
            return -1;
        }
        return this.key.compareTo(comp.key);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getMethodCache = new HashMap();
        this.setMethodCache = new HashMap();
        this.mappedReadMethodCache = new HashMap();
        this.mappedWriteMethodCache = new HashMap();
    }
}

