/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.Serializable;
import java.util.List;
import jp.ossc.nimbus.beans.ArrayEditor;
import jp.ossc.nimbus.beans.Utility;

public class CharacterArrayEditor
extends ArrayEditor
implements Serializable {
    private static final long serialVersionUID = -6605836013809384384L;
    private static final String HEX_PREFIX = "0x";
    private static final String UNICODE_PREFIX = "\\u";

    @Override
    protected Object createArray(List strList) {
        char[] charArray = new char[strList.size()];
        for (int i = 0; i < charArray.length; ++i) {
            String charStr = (String)strList.get(i);
            if (charStr.length() == 1) {
                charArray[i] = charStr.charAt(0);
                continue;
            }
            if (charStr.startsWith(HEX_PREFIX) && charStr.length() > 2) {
                charArray[i] = (char)Integer.parseInt(charStr.substring(2), 16);
                continue;
            }
            if (charStr.startsWith(UNICODE_PREFIX) && charStr.length() > 2) {
                if ((charStr = Utility.unicodeConvert(charStr)).length() != 1) {
                    throw new IllegalArgumentException("Not a character. : " + charStr);
                }
                charArray[i] = charStr.charAt(0);
                continue;
            }
            throw new IllegalArgumentException("Not a character. : " + charStr);
        }
        return charArray;
    }
}

