/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import jp.ossc.nimbus.service.connection.SQLMetricsCollector;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.util.sql.StatementWrapper;

public class WrappedStatement
extends StatementWrapper {
    private static final long serialVersionUID = -9161665514224368780L;
    protected static final String DEFAULT_REQUEST_ID_KEY = "REQUEST_ID";
    protected static final String DEFAULT_JOURNAL_EXECUTE = "Execute";
    protected static final String DEFAULT_JOURNAL_SQL = "SQL";
    protected static final String SQL_SEPARATOR = ";";
    protected Journal journal;
    protected SQLMetricsCollector collector;
    protected Context threadContext;
    protected String requestIDKey = "REQUEST_ID";
    protected Sequence sequence;
    protected String journalKeyExecute = "Execute";
    protected String journalKeySQL = "SQL";
    protected EditorFinder editorFinderForExecute;
    protected String requestId;
    protected StringBuffer batchSQL;
    protected int batchSQLSize;
    protected int maxJournalBatchSize = -1;

    public WrappedStatement(Statement st) {
        super(st);
    }

    public WrappedStatement(Connection con, Statement st) {
        super(con, st);
    }

    public void setJournal(Journal jnl) {
        this.journal = jnl;
    }

    public void setMaxJournalBatchSize(int max) {
        this.maxJournalBatchSize = max;
    }

    public void setSQLMetricsCollector(SQLMetricsCollector collector) {
        this.collector = collector;
    }

    public void setThreadContext(Context ctx) {
        this.threadContext = ctx;
    }

    public void setRequestIDKey(String key) {
        this.requestIDKey = key;
    }

    public void setSequence(Sequence seq) {
        this.sequence = seq;
    }

    public void setJournalKeyExecute(String key) {
        this.journalKeyExecute = key;
    }

    public void setEditorFinderForExecute(EditorFinder finder) {
        this.editorFinderForExecute = finder;
    }

    public void setJournalKeySQL(String key) {
        this.journalKeySQL = key;
    }

    protected void setRequestID() {
        if (this.journal == null) {
            return;
        }
        if (this.requestId == null) {
            if (this.threadContext != null && this.requestIDKey != null) {
                this.requestId = (String)this.threadContext.get(this.requestIDKey);
            }
            if (this.requestId == null && this.sequence != null) {
                this.requestId = this.sequence.increment();
                if (this.threadContext != null && this.requestIDKey != null) {
                    this.threadContext.put(this.requestIDKey, this.requestId);
                }
            }
        }
        if (this.requestId != null) {
            this.journal.setRequestId(this.requestId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String arg0) throws SQLException {
        long start = 0L;
        boolean isException = false;
        boolean isError = false;
        try {
            boolean bl;
            block15: {
                block16: {
                    try {
                        if (this.journal != null) {
                            this.setRequestID();
                            this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                            this.journal.addInfo(this.journalKeySQL, arg0);
                        }
                        if (this.collector != null) {
                            start = System.currentTimeMillis();
                        }
                        bl = super.execute(arg0);
                        Object var8_9 = null;
                        if (this.collector == null) break block15;
                        if (!isException) break block16;
                    }
                    catch (SQLException e) {
                        isException = true;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        isException = true;
                        throw e;
                    }
                    catch (Error err) {
                        isError = true;
                        throw err;
                    }
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                    break block15;
                }
                if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) return bl;
            this.journal.endJournal();
            return bl;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (this.collector != null) {
                if (isException) {
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                } else if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) throw throwable;
            this.journal.endJournal();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String arg0, int arg1) throws SQLException {
        long start = 0L;
        boolean isException = false;
        boolean isError = false;
        try {
            boolean bl;
            block15: {
                block16: {
                    try {
                        if (this.journal != null) {
                            this.setRequestID();
                            this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                            this.journal.addInfo(this.journalKeySQL, arg0);
                        }
                        if (this.collector != null) {
                            start = System.currentTimeMillis();
                        }
                        bl = super.execute(arg0, arg1);
                        Object var9_10 = null;
                        if (this.collector == null) break block15;
                        if (!isException) break block16;
                    }
                    catch (SQLException e) {
                        isException = true;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        isException = true;
                        throw e;
                    }
                    catch (Error err) {
                        isError = true;
                        throw err;
                    }
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                    break block15;
                }
                if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) return bl;
            this.journal.endJournal();
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (this.collector != null) {
                if (isException) {
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                } else if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) throw throwable;
            this.journal.endJournal();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        long start = 0L;
        boolean isException = false;
        boolean isError = false;
        try {
            boolean bl;
            block15: {
                block16: {
                    try {
                        if (this.journal != null) {
                            this.setRequestID();
                            this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                            this.journal.addInfo(this.journalKeySQL, arg0);
                        }
                        if (this.collector != null) {
                            start = System.currentTimeMillis();
                        }
                        bl = super.execute(arg0, arg1);
                        Object var9_10 = null;
                        if (this.collector == null) break block15;
                        if (!isException) break block16;
                    }
                    catch (SQLException e) {
                        isException = true;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        isException = true;
                        throw e;
                    }
                    catch (Error err) {
                        isError = true;
                        throw err;
                    }
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                    break block15;
                }
                if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) return bl;
            this.journal.endJournal();
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (this.collector != null) {
                if (isException) {
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                } else if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) throw throwable;
            this.journal.endJournal();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        long start = 0L;
        boolean isException = false;
        boolean isError = false;
        try {
            boolean bl;
            block15: {
                block16: {
                    try {
                        if (this.journal != null) {
                            this.setRequestID();
                            this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                            this.journal.addInfo(this.journalKeySQL, arg0);
                        }
                        if (this.collector != null) {
                            start = System.currentTimeMillis();
                        }
                        bl = super.execute(arg0, arg1);
                        Object var9_10 = null;
                        if (this.collector == null) break block15;
                        if (!isException) break block16;
                    }
                    catch (SQLException e) {
                        isException = true;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        isException = true;
                        throw e;
                    }
                    catch (Error err) {
                        isError = true;
                        throw err;
                    }
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                    break block15;
                }
                if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) return bl;
            this.journal.endJournal();
            return bl;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (this.collector != null) {
                if (isException) {
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                } else if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) throw throwable;
            this.journal.endJournal();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String arg0) throws SQLException {
        long start = 0L;
        boolean isException = false;
        boolean isError = false;
        try {
            int n;
            block15: {
                block16: {
                    try {
                        if (this.journal != null) {
                            this.setRequestID();
                            this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                            this.journal.addInfo(this.journalKeySQL, arg0);
                        }
                        if (this.collector != null) {
                            start = System.currentTimeMillis();
                        }
                        n = super.executeUpdate(arg0);
                        Object var8_9 = null;
                        if (this.collector == null) break block15;
                        if (!isException) break block16;
                    }
                    catch (SQLException e) {
                        isException = true;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        isException = true;
                        throw e;
                    }
                    catch (Error err) {
                        isError = true;
                        throw err;
                    }
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                    break block15;
                }
                if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) return n;
            this.journal.endJournal();
            return n;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (this.collector != null) {
                if (isException) {
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                } else if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) throw throwable;
            this.journal.endJournal();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        long start = 0L;
        boolean isException = false;
        boolean isError = false;
        try {
            int n;
            block15: {
                block16: {
                    try {
                        if (this.journal != null) {
                            this.setRequestID();
                            this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                            this.journal.addInfo(this.journalKeySQL, arg0);
                        }
                        if (this.collector != null) {
                            start = System.currentTimeMillis();
                        }
                        n = super.executeUpdate(arg0, arg1);
                        Object var9_10 = null;
                        if (this.collector == null) break block15;
                        if (!isException) break block16;
                    }
                    catch (SQLException e) {
                        isException = true;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        isException = true;
                        throw e;
                    }
                    catch (Error err) {
                        isError = true;
                        throw err;
                    }
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                    break block15;
                }
                if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) return n;
            this.journal.endJournal();
            return n;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (this.collector != null) {
                if (isException) {
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                } else if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) throw throwable;
            this.journal.endJournal();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        long start = 0L;
        boolean isException = false;
        boolean isError = false;
        try {
            int n;
            block15: {
                block16: {
                    try {
                        if (this.journal != null) {
                            this.setRequestID();
                            this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                            this.journal.addInfo(this.journalKeySQL, arg0);
                        }
                        if (this.collector != null) {
                            start = System.currentTimeMillis();
                        }
                        n = super.executeUpdate(arg0, arg1);
                        Object var9_10 = null;
                        if (this.collector == null) break block15;
                        if (!isException) break block16;
                    }
                    catch (SQLException e) {
                        isException = true;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        isException = true;
                        throw e;
                    }
                    catch (Error err) {
                        isError = true;
                        throw err;
                    }
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                    break block15;
                }
                if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) return n;
            this.journal.endJournal();
            return n;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (this.collector != null) {
                if (isException) {
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                } else if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) throw throwable;
            this.journal.endJournal();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        long start = 0L;
        boolean isException = false;
        boolean isError = false;
        try {
            int n;
            block15: {
                block16: {
                    try {
                        if (this.journal != null) {
                            this.setRequestID();
                            this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                            this.journal.addInfo(this.journalKeySQL, arg0);
                        }
                        if (this.collector != null) {
                            start = System.currentTimeMillis();
                        }
                        n = super.executeUpdate(arg0, arg1);
                        Object var9_10 = null;
                        if (this.collector == null) break block15;
                        if (!isException) break block16;
                    }
                    catch (SQLException e) {
                        isException = true;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        isException = true;
                        throw e;
                    }
                    catch (Error err) {
                        isError = true;
                        throw err;
                    }
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                    break block15;
                }
                if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) return n;
            this.journal.endJournal();
            return n;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (this.collector != null) {
                if (isException) {
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                } else if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) throw throwable;
            this.journal.endJournal();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeQuery(String arg0) throws SQLException {
        long start = 0L;
        boolean isException = false;
        boolean isError = false;
        try {
            ResultSet resultSet;
            block15: {
                block16: {
                    try {
                        if (this.journal != null) {
                            this.setRequestID();
                            this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                            this.journal.addInfo(this.journalKeySQL, arg0);
                        }
                        if (this.collector != null) {
                            start = System.currentTimeMillis();
                        }
                        resultSet = super.executeQuery(arg0);
                        Object var8_9 = null;
                        if (this.collector == null) break block15;
                        if (!isException) break block16;
                    }
                    catch (SQLException e) {
                        isException = true;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        isException = true;
                        throw e;
                    }
                    catch (Error err) {
                        isError = true;
                        throw err;
                    }
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                    break block15;
                }
                if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) return resultSet;
            this.journal.endJournal();
            return resultSet;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (this.collector != null) {
                if (isException) {
                    this.collector.registerException(arg0, System.currentTimeMillis() - start);
                } else if (isError) {
                    this.collector.registerError(arg0, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(arg0, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) throw throwable;
            this.journal.endJournal();
            throw throwable;
        }
    }

    public void addBatch(String arg0) throws SQLException {
        super.addBatch(arg0);
        if (this.journal != null && this.batchSQL == null) {
            this.batchSQL = new StringBuffer();
            this.batchSQLSize = 0;
        }
        if (this.batchSQL != null && (this.maxJournalBatchSize < 0 || this.batchSQLSize < this.maxJournalBatchSize)) {
            this.batchSQL.append(arg0).append(SQL_SEPARATOR);
            ++this.batchSQLSize;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        long start = 0L;
        boolean isException = false;
        boolean isError = false;
        String sql = null;
        String collectorKey = this.getBatchQueryForCollectorKey();
        if (this.batchSQL != null) {
            sql = this.batchSQL.toString();
            this.batchSQL.setLength(0);
            this.batchSQLSize = 0;
        }
        try {
            int[] nArray;
            block17: {
                block18: {
                    try {
                        if (this.journal != null) {
                            this.setRequestID();
                            this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                            if (sql != null) {
                                this.journal.addInfo(this.journalKeySQL, sql);
                            }
                        }
                        if (this.collector != null) {
                            start = System.currentTimeMillis();
                        }
                        nArray = super.executeBatch();
                        Object var9_10 = null;
                        if (this.collector == null) break block17;
                        if (!isException) break block18;
                    }
                    catch (SQLException e) {
                        isException = true;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        isException = true;
                        throw e;
                    }
                    catch (Error err) {
                        isError = true;
                        throw err;
                    }
                    this.collector.registerException(collectorKey, System.currentTimeMillis() - start);
                    break block17;
                }
                if (isError) {
                    this.collector.registerError(collectorKey, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(collectorKey, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) return nArray;
            this.journal.endJournal();
            return nArray;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (this.collector != null) {
                if (isException) {
                    this.collector.registerException(collectorKey, System.currentTimeMillis() - start);
                } else if (isError) {
                    this.collector.registerError(collectorKey, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(collectorKey, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) throw throwable;
            this.journal.endJournal();
            throw throwable;
        }
    }

    protected String getBatchQueryForCollectorKey() {
        return this.batchSQL == null ? "" : this.batchSQL.toString();
    }

    public void clearBatch() throws SQLException {
        super.clearBatch();
        if (this.batchSQL != null) {
            this.batchSQL.setLength(0);
            this.batchSQLSize = 0;
        }
    }
}

