/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jp.ossc.nimbus.util.sql.WrappedStatement;

public class WrappedPreparedStatement
extends WrappedStatement
implements PreparedStatement {
    private static final long serialVersionUID = 7786335878798298219L;
    protected static final String PREPARED_KEY = "?";
    protected static final String ESCAPE1 = "'";
    protected static final int ESCAPE1_LENGTH = "'".length();
    protected static final String ESCAPE1_ESCAPE = "''";
    protected static final String ESCAPE2 = "\\";
    protected static final int ESCAPE2_LENGTH = "\\".length();
    protected static final String ESCAPE2_ESCAPE = "\\\\";
    protected final String preparedSql;
    protected List argList;

    public WrappedPreparedStatement(PreparedStatement st, String sql) {
        super(st);
        this.preparedSql = sql;
    }

    public WrappedPreparedStatement(Connection con, PreparedStatement st, String sql) {
        super(con, st);
        this.preparedSql = sql;
    }

    protected void addArg(int index, Object arg) {
        if (this.argList == null) {
            this.argList = new ArrayList();
        }
        int tmpIndex = index - 1;
        if (this.argList.size() > tmpIndex) {
            this.argList.set(tmpIndex, arg);
        } else {
            for (int i = this.argList.size(); i <= tmpIndex; ++i) {
                if (i == tmpIndex) {
                    this.argList.add(arg);
                    continue;
                }
                this.argList.add(null);
            }
        }
    }

    protected void addSQL() {
        if (this.journal != null && this.batchSQL == null) {
            this.batchSQL = new StringBuffer();
        }
        if (this.batchSQL == null || this.maxJournalBatchSize >= 0 && this.batchSQLSize >= this.maxJournalBatchSize) {
            return;
        }
        if (this.batchSQL.length() != 0) {
            this.batchSQL.append(';');
        }
        this.batchSQL.append(this.createSQL());
        ++this.batchSQLSize;
    }

    protected String createSQL() {
        if (this.preparedSql == null) {
            return null;
        }
        if (this.preparedSql.indexOf(63) == -1) {
            return this.preparedSql;
        }
        StringBuffer tmpSql = new StringBuffer(this.preparedSql);
        StringBuffer tmpVal = new StringBuffer();
        int indexWk = 0;
        if (this.argList != null) {
            int max = this.argList.size();
            for (int i = 0; i < max; ++i) {
                int index = 0;
                while (index != -1 && (index = tmpSql.indexOf(PREPARED_KEY, indexWk)) != -1 && !this.checkPreparedKey(tmpSql.substring(0, index))) {
                    indexWk = index + 1;
                }
                if (index == -1) break;
                Object val = this.argList.get(i);
                tmpVal.setLength(0);
                tmpSql.replace(index, index + 1, this.escapeSQLValue(val, tmpVal));
            }
        }
        return tmpSql.toString();
    }

    protected boolean checkPreparedKey(String sql) {
        int count = 0;
        int max = sql.length();
        for (int i = 0; i < max; ++i) {
            if (sql.charAt(i) != '\'') continue;
            ++count;
        }
        return count % 2 == 0;
    }

    protected String toHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        int max = bytes.length;
        for (int i = 0; i < max; ++i) {
            int intValue = bytes[i];
            String str = Integer.toHexString(intValue &= 0xFF).toUpperCase();
            if (str.length() == 1) {
                buf.append('0');
            }
            buf.append(str);
        }
        return buf.toString();
    }

    protected String escapeSQLValue(Object obj, StringBuffer buf) {
        int index;
        String val;
        String string = val = obj == null ? null : obj.toString();
        if (val == null || val.indexOf(ESCAPE1) == -1 && val.indexOf(ESCAPE2) == -1) {
            buf.append('\'');
            buf.append(val);
            buf.append('\'');
            return buf.toString();
        }
        buf.append(val);
        if (buf.indexOf(ESCAPE1) != -1) {
            index = buf.length();
            while ((index = buf.lastIndexOf(ESCAPE1, index - 1)) != -1) {
                buf.replace(index, index + ESCAPE1_LENGTH, ESCAPE1_ESCAPE);
            }
        }
        if (buf.indexOf(ESCAPE2) != -1) {
            index = buf.length();
            while ((index = buf.lastIndexOf(ESCAPE2, index - 1)) != -1) {
                buf.replace(index, index + ESCAPE2_LENGTH, ESCAPE2_ESCAPE);
            }
        }
        buf.insert(0, '\'');
        buf.append('\'');
        return buf.toString();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ((PreparedStatement)this.statement).getParameterMetaData();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return ((PreparedStatement)this.statement).getMetaData();
    }

    public void setByte(int arg0, byte arg1) throws SQLException {
        ((PreparedStatement)this.statement).setByte(arg0, arg1);
        this.addArg(arg0, new Byte(arg1));
    }

    public void setDouble(int arg0, double arg1) throws SQLException {
        ((PreparedStatement)this.statement).setDouble(arg0, arg1);
        this.addArg(arg0, new Double(arg1));
    }

    public void setFloat(int arg0, float arg1) throws SQLException {
        ((PreparedStatement)this.statement).setFloat(arg0, arg1);
        this.addArg(arg0, new Float(arg1));
    }

    public void setInt(int arg0, int arg1) throws SQLException {
        ((PreparedStatement)this.statement).setInt(arg0, arg1);
        this.addArg(arg0, new Integer(arg1));
    }

    public void setNull(int arg0, int arg1) throws SQLException {
        ((PreparedStatement)this.statement).setNull(arg0, arg1);
        this.addArg(arg0, null);
    }

    public void setLong(int arg0, long arg1) throws SQLException {
        ((PreparedStatement)this.statement).setLong(arg0, arg1);
        this.addArg(arg0, new Long(arg1));
    }

    public void setShort(int arg0, short arg1) throws SQLException {
        ((PreparedStatement)this.statement).setShort(arg0, arg1);
        this.addArg(arg0, new Short(arg1));
    }

    public void setBoolean(int arg0, boolean arg1) throws SQLException {
        ((PreparedStatement)this.statement).setBoolean(arg0, arg1);
        this.addArg(arg0, new Boolean(arg1));
    }

    public void setBytes(int arg0, byte[] arg1) throws SQLException {
        ((PreparedStatement)this.statement).setBytes(arg0, arg1);
        this.addArg(arg0, this.toHexString(arg1));
    }

    public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        ((PreparedStatement)this.statement).setAsciiStream(arg0, arg1, arg2);
        this.addArg(arg0, arg1);
    }

    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        ((PreparedStatement)this.statement).setBinaryStream(arg0, arg1, arg2);
        this.addArg(arg0, arg1);
    }

    public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        ((PreparedStatement)this.statement).setUnicodeStream(arg0, arg1, arg2);
        this.addArg(arg0, arg1);
    }

    public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        ((PreparedStatement)this.statement).setCharacterStream(arg0, arg1, arg2);
        this.addArg(arg0, arg1);
    }

    public void setObject(int arg0, Object arg1) throws SQLException {
        ((PreparedStatement)this.statement).setObject(arg0, arg1);
        this.addArg(arg0, arg1);
    }

    public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
        ((PreparedStatement)this.statement).setObject(arg0, arg1, arg2);
        this.addArg(arg0, arg1);
    }

    public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
        ((PreparedStatement)this.statement).setObject(arg0, arg1, arg2, arg3);
        this.addArg(arg0, arg1);
    }

    public void setNull(int arg0, int arg1, String arg2) throws SQLException {
        ((PreparedStatement)this.statement).setNull(arg0, arg1, arg2);
        this.addArg(arg0, null);
    }

    public void setString(int arg0, String arg1) throws SQLException {
        ((PreparedStatement)this.statement).setString(arg0, arg1);
        this.addArg(arg0, arg1);
    }

    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        ((PreparedStatement)this.statement).setBigDecimal(arg0, arg1);
        this.addArg(arg0, arg1);
    }

    public void setURL(int arg0, URL arg1) throws SQLException {
        ((PreparedStatement)this.statement).setURL(arg0, arg1);
        this.addArg(arg0, arg1);
    }

    public void setArray(int arg0, Array arg1) throws SQLException {
        ((PreparedStatement)this.statement).setArray(arg0, arg1);
        this.addArg(arg0, arg1);
    }

    public void setBlob(int arg0, Blob arg1) throws SQLException {
        ((PreparedStatement)this.statement).setBlob(arg0, arg1);
        this.addArg(arg0, arg1);
    }

    public void setClob(int arg0, Clob arg1) throws SQLException {
        ((PreparedStatement)this.statement).setClob(arg0, arg1);
        this.addArg(arg0, arg1);
    }

    public void setDate(int arg0, Date arg1) throws SQLException {
        ((PreparedStatement)this.statement).setDate(arg0, arg1);
        this.addArg(arg0, arg1);
    }

    public void setRef(int arg0, Ref arg1) throws SQLException {
        ((PreparedStatement)this.statement).setRef(arg0, arg1);
        this.addArg(arg0, arg1);
    }

    public void setTime(int arg0, Time arg1) throws SQLException {
        ((PreparedStatement)this.statement).setTime(arg0, arg1);
        this.addArg(arg0, arg1);
    }

    public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
        ((PreparedStatement)this.statement).setTimestamp(arg0, arg1);
        this.addArg(arg0, arg1);
    }

    public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
        ((PreparedStatement)this.statement).setDate(arg0, arg1, arg2);
        this.addArg(arg0, arg1);
    }

    public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
        ((PreparedStatement)this.statement).setTime(arg0, arg1, arg2);
        this.addArg(arg0, arg1);
    }

    public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
        ((PreparedStatement)this.statement).setTimestamp(arg0, arg1, arg2);
        this.addArg(arg0, arg1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() throws SQLException {
        long start = 0L;
        boolean isException = false;
        boolean isError = false;
        try {
            boolean bl;
            block15: {
                block16: {
                    try {
                        if (this.journal != null) {
                            this.setRequestID();
                            this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                            this.journal.addInfo(this.journalKeySQL, this.createSQL());
                        }
                        if (this.collector != null) {
                            start = System.currentTimeMillis();
                        }
                        bl = ((PreparedStatement)this.statement).execute();
                        Object var7_8 = null;
                        if (this.collector == null) break block15;
                        if (!isException) break block16;
                    }
                    catch (SQLException e) {
                        isException = true;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        isException = true;
                        throw e;
                    }
                    catch (Error err) {
                        isError = true;
                        throw err;
                    }
                    this.collector.registerException(this.preparedSql, System.currentTimeMillis() - start);
                    break block15;
                }
                if (isError) {
                    this.collector.registerError(this.preparedSql, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(this.preparedSql, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) return bl;
            this.journal.endJournal();
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (this.collector != null) {
                if (isException) {
                    this.collector.registerException(this.preparedSql, System.currentTimeMillis() - start);
                } else if (isError) {
                    this.collector.registerError(this.preparedSql, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(this.preparedSql, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) throw throwable;
            this.journal.endJournal();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate() throws SQLException {
        long start = 0L;
        boolean isException = false;
        boolean isError = false;
        try {
            int n;
            block15: {
                block16: {
                    try {
                        if (this.journal != null) {
                            this.setRequestID();
                            this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                            this.journal.addInfo(this.journalKeySQL, this.createSQL());
                        }
                        if (this.collector != null) {
                            start = System.currentTimeMillis();
                        }
                        n = ((PreparedStatement)this.statement).executeUpdate();
                        Object var7_8 = null;
                        if (this.collector == null) break block15;
                        if (!isException) break block16;
                    }
                    catch (SQLException e) {
                        isException = true;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        isException = true;
                        throw e;
                    }
                    catch (Error err) {
                        isError = true;
                        throw err;
                    }
                    this.collector.registerException(this.preparedSql, System.currentTimeMillis() - start);
                    break block15;
                }
                if (isError) {
                    this.collector.registerError(this.preparedSql, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(this.preparedSql, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) return n;
            this.journal.endJournal();
            return n;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (this.collector != null) {
                if (isException) {
                    this.collector.registerException(this.preparedSql, System.currentTimeMillis() - start);
                } else if (isError) {
                    this.collector.registerError(this.preparedSql, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(this.preparedSql, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) throw throwable;
            this.journal.endJournal();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeQuery() throws SQLException {
        long start = 0L;
        boolean isException = false;
        boolean isError = false;
        try {
            ResultSet resultSet;
            block15: {
                block16: {
                    try {
                        if (this.journal != null) {
                            this.setRequestID();
                            this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                            this.journal.addInfo(this.journalKeySQL, this.createSQL());
                        }
                        if (this.collector != null) {
                            start = System.currentTimeMillis();
                        }
                        resultSet = ((PreparedStatement)this.statement).executeQuery();
                        Object var7_8 = null;
                        if (this.collector == null) break block15;
                        if (!isException) break block16;
                    }
                    catch (SQLException e) {
                        isException = true;
                        throw e;
                    }
                    catch (RuntimeException e) {
                        isException = true;
                        throw e;
                    }
                    catch (Error err) {
                        isError = true;
                        throw err;
                    }
                    this.collector.registerException(this.preparedSql, System.currentTimeMillis() - start);
                    break block15;
                }
                if (isError) {
                    this.collector.registerError(this.preparedSql, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(this.preparedSql, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) return resultSet;
            this.journal.endJournal();
            return resultSet;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (this.collector != null) {
                if (isException) {
                    this.collector.registerException(this.preparedSql, System.currentTimeMillis() - start);
                } else if (isError) {
                    this.collector.registerError(this.preparedSql, System.currentTimeMillis() - start);
                } else {
                    this.collector.register(this.preparedSql, System.currentTimeMillis() - start);
                }
            }
            if (this.journal == null) throw throwable;
            this.journal.endJournal();
            throw throwable;
        }
    }

    protected String getBatchQueryForCollectorKey() {
        return this.preparedSql == null ? "" : this.preparedSql;
    }

    public void addBatch() throws SQLException {
        this.addSQL();
        ((PreparedStatement)this.statement).addBatch();
    }

    public void clearParameters() throws SQLException {
        ((PreparedStatement)this.statement).clearParameters();
        if (this.argList != null) {
            this.argList.clear();
        }
    }
}

