/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import jp.ossc.nimbus.util.converter.BufferedStreamConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StreamStringConverter;

public class StringStreamConverter
extends BufferedStreamConverter
implements StreamStringConverter,
Serializable {
    private static final long serialVersionUID = -4431451590828201935L;
    public static final int STRING_FROM_STREAM = 1;
    public static final int STREAM_FROM_STRING = 2;
    protected int convertType;
    protected String characterEncodingToStream;
    protected String characterEncodingToObject;

    public StringStreamConverter() {
        this(1);
    }

    public StringStreamConverter(int type) {
        this.convertType = type;
    }

    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setCharacterEncodingToStream(String encoding) {
        this.characterEncodingToStream = encoding;
    }

    public String getCharacterEncodingToStream() {
        return this.characterEncodingToStream;
    }

    public void setCharacterEncodingToObject(String encoding) {
        this.characterEncodingToObject = encoding;
    }

    public String getCharacterEncodingToObject() {
        return this.characterEncodingToObject;
    }

    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        switch (this.convertType) {
            case 1: {
                return this.convertToStream(obj);
            }
            case 2: {
                if (!(obj instanceof InputStream)) {
                    throw new ConvertException("Invalid input type : " + obj.getClass());
                }
                return this.convertToObject((InputStream)obj);
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }

    protected byte[] convertToByteArray(Object obj) throws ConvertException {
        byte[] bytes = null;
        if (this.characterEncodingToStream == null) {
            bytes = ((String)obj).getBytes();
        } else {
            try {
                bytes = ((String)obj).getBytes(this.characterEncodingToStream);
            }
            catch (UnsupportedEncodingException e) {
                throw new ConvertException(e);
            }
        }
        return bytes;
    }

    public Object convertToObject(InputStream is) throws ConvertException {
        return this.toString(this.toBytes(is));
    }

    protected byte[] toBytes(InputStream is) throws ConvertException {
        byte[] bytes = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int length = 0;
        try {
            while ((length = is.read(bytes)) != -1) {
                baos.write(bytes, 0, length);
            }
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        return baos.toByteArray();
    }

    protected String toString(byte[] bytes) throws ConvertException {
        if (this.characterEncodingToObject == null) {
            return new String(bytes);
        }
        try {
            return new String(bytes, this.characterEncodingToObject);
        }
        catch (UnsupportedEncodingException e) {
            throw new ConvertException(e);
        }
    }
}

