/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.File;
import java.util.ArrayList;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.scheduler2.BeanFlowScheduleExecutorService;
import jp.ossc.nimbus.service.scheduler2.ConcentrateBackupManager;
import jp.ossc.nimbus.service.scheduler2.ConcentrateRequest;
import jp.ossc.nimbus.service.scheduler2.ConcentrateResponse;
import jp.ossc.nimbus.service.scheduler2.ConcentrateScheduleExecutorServiceMBean;
import jp.ossc.nimbus.service.scheduler2.Schedule;

public class ConcentrateScheduleExecutorService
extends BeanFlowScheduleExecutorService
implements ConcentrateScheduleExecutorServiceMBean {
    private static final long serialVersionUID = -2690240488435859910L;
    protected ServiceName concentrateBackupManagerServiceName;
    protected ConcentrateBackupManager concentrateBackupManager;

    public ConcentrateScheduleExecutorService() {
        this.type = "CONCENTRATE";
    }

    public void setConcentrateBackupManagerServiceName(ServiceName name) {
        this.concentrateBackupManagerServiceName = name;
    }

    public ServiceName getConcentrateBackupManagerServiceName() {
        return this.concentrateBackupManagerServiceName;
    }

    public void setConcentrateBackupManager(ConcentrateBackupManager manager) {
        this.concentrateBackupManager = manager;
    }

    public ConcentrateBackupManager getConcentrateBackupManager() {
        return this.concentrateBackupManager;
    }

    public void startService() throws Exception {
        if (this.concentrateBackupManagerServiceName != null) {
            this.concentrateBackupManager = (ConcentrateBackupManager)ServiceManagerFactory.getServiceObject(this.concentrateBackupManagerServiceName);
        }
        super.startService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Schedule executeInternal(Schedule schedule) throws Throwable {
        block20: {
            Object rawInput = schedule.getInput();
            try {
                ConcentrateRequest request = null;
                ConcentrateResponse response = null;
                if (rawInput instanceof String) {
                    String inputStr = (String)rawInput;
                    String[] params = CSVReader.toArray(inputStr, ',', '\\', '\"', "", null, true, false, true, false);
                    if (params.length != 3) {
                        throw new IllegalArgumentException("Input is illegal : " + rawInput);
                    }
                    String key = this.toKey(schedule);
                    int processType = ConcentrateRequest.toProcessType(params[0]);
                    if (processType == 0) {
                        throw new IllegalArgumentException("ProcessType is illegal : " + rawInput);
                    }
                    String source = params[1];
                    if (source == null || source.length() == 0) {
                        throw new IllegalArgumentException("Source is null : " + rawInput);
                    }
                    String dest = params[2];
                    if (dest == null || dest.length() == 0) {
                        throw new IllegalArgumentException("Destination is null : " + rawInput);
                    }
                    request = new ConcentrateRequest(key, processType, source, dest);
                    schedule.setInput(request);
                    response = new ConcentrateResponse();
                    schedule.setOutput(response);
                }
                schedule = super.executeInternal(schedule);
                Object output = schedule.getOutput();
                if (request == null || output == null || !(output instanceof ConcentrateResponse)) break block20;
                response = (ConcentrateResponse)output;
                File[] files = response.getFiles();
                if (files != null && files.length != 0) {
                    if (this.concentrateBackupManager != null) {
                        Object result = null;
                        result = response.getGroup() == null && response.getDate() == null && response.getKey() == null ? this.concentrateBackupManager.backup(this.toFlowName(schedule), null, ConcentrateRequest.toProcessTypeString(request.getProcessType()), files, response.getFileCompressed()) : this.concentrateBackupManager.backup(response.getGroup(), response.getDate(), response.getKey(), files, response.getFileCompressed());
                        schedule.setOutput(result);
                    } else {
                        ArrayList<File> list = new ArrayList<File>();
                        for (int i = 0; i < files.length; ++i) {
                            list.add(files[i]);
                        }
                        schedule.setOutput(list);
                    }
                    switch (request.getProcessType()) {
                        case 1: {
                            File destFile = new File(request.getDestination());
                            String fileName = null;
                            if (!destFile.isDirectory()) {
                                fileName = destFile.getName();
                                destFile = destFile.getParentFile();
                            }
                            if (destFile != null && !destFile.exists()) {
                                destFile.mkdirs();
                            }
                            for (int i = 0; i < files.length; ++i) {
                                if (!files[i].exists()) continue;
                                File tmp = new File(destFile, fileName == null ? files[i].getName() : fileName);
                                if (tmp.getParentFile() != null && !tmp.getParentFile().exists()) {
                                    tmp.getParentFile().mkdirs();
                                }
                                files[i].renameTo(tmp);
                            }
                            break block20;
                        }
                        default: {
                            for (int i = 0; i < files.length; ++i) {
                                if (!files[i].exists()) continue;
                                files[i].delete();
                            }
                            break block20;
                        }
                    }
                }
                schedule.setOutput(null);
            }
            finally {
                schedule.setInput(rawInput);
            }
        }
        return schedule;
    }

    protected void checkPreExecute(Schedule schedule) throws Exception {
        BeanFlowInvoker invoker = this.beanFlowInvokerFactory.createFlow(this.toFlowName(schedule));
        if (invoker == null) {
            throw new IllegalArgumentException("BeanFlow is not found : " + this.toFlowName(schedule));
        }
    }

    protected BeanFlowInvoker getBeanFlowInvoker(Schedule schedule) throws Throwable {
        return this.beanFlowInvokerFactory.createFlow(this.toFlowName(schedule));
    }

    protected String toFlowName(Schedule schedule) {
        String flowName = schedule.getTaskName();
        int index = flowName.indexOf(58);
        if (index != -1) {
            flowName = flowName.substring(0, index);
        }
        return flowName;
    }

    protected String toKey(Schedule schedule) {
        String key = schedule.getTaskName();
        int index = key.indexOf(58);
        if (index != -1) {
            key = key.substring(index + 1);
        }
        return key;
    }
}

