/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.udp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.publish.udp.MessageImpl;
import jp.ossc.nimbus.service.publish.udp.WindowId;

public class Window
extends WindowId {
    private static final int HEADER_LENGTH = 12;
    private short windowCount;
    private byte[] data;
    private List windows;
    private Set windowSet;
    private MessageImpl message;
    private long receiveTime;
    private boolean isLost;

    public int getSequence() {
        return this.sequence;
    }

    public short getWindowCount() {
        return this.windowCount;
    }

    public void setWindowCount(short count) {
        this.windowCount = count;
    }

    public short getWindowNo() {
        return this.windowNo;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getReceiveTime() {
        return this.receiveTime;
    }

    public void setLost(boolean isLost) {
        this.isLost = isLost;
    }

    public boolean isLost() {
        return this.isLost;
    }

    public static List toWindows(MessageImpl message, int windowSize, Externalizer ext) throws IOException {
        int dataLength;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (ext == null) {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(message);
            oos.flush();
        } else {
            ext.writeExternal((Object)message, baos);
        }
        ArrayList<Window> result = new ArrayList<Window>();
        byte[] tmp = baos.toByteArray();
        int offset = 0;
        short no = 0;
        do {
            Window window = new Window();
            window.sequence = message.getSequence();
            window.windowNo = no;
            dataLength = Math.min(windowSize - 12, tmp.length - offset);
            window.data = new byte[dataLength];
            System.arraycopy(tmp, offset, window.data, 0, dataLength);
            result.add(window);
            no = (short)(no + 1);
        } while (tmp.length > (offset += dataLength));
        int imax = result.size();
        for (int i = 0; i < imax; ++i) {
            ((Window)result.get((int)i)).windowCount = (short)imax;
        }
        return result;
    }

    public synchronized boolean addWindow(Window window) {
        if (this.isComplete()) {
            return true;
        }
        if (this.windows == null) {
            this.windows = new ArrayList(this.windowCount);
            this.windowSet = Collections.synchronizedSet(new HashSet(this.windowCount));
        }
        if (this.windows.size() == 0) {
            this.windowSet.add(this);
            this.windows.add(this);
        }
        if (this.windowSet != null && this.windowSet.contains(window)) {
            return false;
        }
        if (window.isLost()) {
            this.isLost = true;
            return true;
        }
        this.windows.add(window);
        this.windowSet.add(window);
        if (this.windowCount <= this.windows.size()) {
            Collections.sort(this.windows);
            return true;
        }
        return false;
    }

    public boolean isComplete() {
        return this.windowCount == 1 || this.windows != null && this.windowCount <= this.windows.size();
    }

    public synchronized List getMissingWindowIds(List result) {
        block8: {
            int i;
            block7: {
                if (this.isComplete() || this.isLost()) {
                    return result;
                }
                if (result == null) {
                    result = new ArrayList<WindowId>();
                }
                if (this.windows != null) break block7;
                for (int i2 = 0; i2 < this.windowCount; ++i2) {
                    if (i2 == this.windowNo) continue;
                    result.add(new WindowId(this.sequence, (short)i2));
                }
                break block8;
            }
            Collections.sort(this.windows);
            int currentNo = -1;
            int imax = this.windows.size();
            for (i = 0; i < imax; ++i) {
                Window window = (Window)this.windows.get(i);
                if (window.windowNo - currentNo != 1) {
                    for (int j = currentNo + 1; j < window.windowNo; ++j) {
                        result.add(new WindowId(this.sequence, (short)j));
                    }
                }
                currentNo = window.windowNo;
            }
            if (currentNo >= this.windowCount - 1) break block8;
            for (i = currentNo + 1; i < this.windowCount; ++i) {
                result.add(new WindowId(this.sequence, (short)i));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageImpl getMessage(Externalizer ext) throws IOException, ClassNotFoundException {
        if (this.message != null) {
            return this.message;
        }
        if (this.isLost()) {
            this.message = new MessageImpl();
            this.message.setSequence(this.sequence);
            this.message.setLost(true);
            this.message.setReceiveTime(System.currentTimeMillis());
            return this.message;
        }
        if (!this.isComplete()) {
            return null;
        }
        Window window = this;
        synchronized (window) {
            if (this.message != null) {
                return this.message;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            long recTime = -1L;
            if (this.windows == null || this.windows.size() == 0) {
                baos.write(this.data);
                recTime = this.receiveTime;
            } else {
                int imax = this.windows.size();
                for (int i = 0; i < imax; ++i) {
                    Window w = (Window)this.windows.get(i);
                    if (recTime < w.getReceiveTime()) {
                        recTime = w.getReceiveTime();
                    }
                    baos.write(w.data);
                }
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            if (ext == null) {
                ObjectInputStream ois = new ObjectInputStream(bais);
                this.message = (MessageImpl)ois.readObject();
            } else {
                this.message = (MessageImpl)ext.readExternal(bais);
            }
            this.message.setReceiveTime(recTime);
        }
        return this.message;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.sequence);
        out.writeShort(this.windowCount);
        out.writeShort(this.windowNo);
        out.writeInt(this.data == null ? 0 : this.data.length);
        if (this.data != null && this.data.length != 0) {
            out.write(this.data);
        }
    }

    public void read(DataInput in) throws IOException {
        this.sequence = in.readInt();
        this.windowCount = in.readShort();
        this.windowNo = in.readShort();
        int length = in.readInt();
        if (length != 0) {
            this.data = new byte[length];
            in.readFully(this.data, 0, length);
        }
        this.receiveTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.deleteCharAt(buf.length() - 1);
        buf.append(", windowCount=").append(this.windowCount);
        buf.append(", data=").append(this.data == null ? null : String.valueOf(this.data.length));
        buf.append('}');
        return buf.toString();
    }
}

