/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish.udp;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.service.publish.udp.MessageId;
import jp.ossc.nimbus.service.publish.udp.RequestReplyMessage;
import jp.ossc.nimbus.service.publish.udp.ServerMessage;
import jp.ossc.nimbus.service.publish.udp.Window;
import jp.ossc.nimbus.service.publish.udp.WindowId;

public class InterpolateResponseMessage
extends ServerMessage
implements RequestReplyMessage {
    private Map windowsByMessageId;
    private Map windowByWindowId;
    private List windows;
    private int requestId;

    public InterpolateResponseMessage() {
        super((byte)1);
    }

    public int getRequestId() {
        return this.requestId;
    }

    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }

    public int compareRequestId(RequestReplyMessage msg) {
        long seq = this.getRequestId();
        long cmpSeq = msg.getRequestId();
        long middle = Integer.MAX_VALUE;
        if (seq == cmpSeq) {
            return 0;
        }
        if (seq > cmpSeq) {
            if (seq - cmpSeq > middle) {
                return (seq -= Integer.MAX_VALUE) > cmpSeq ? 1 : -1;
            }
            return 1;
        }
        if (cmpSeq - seq > middle) {
            return seq > (cmpSeq -= Integer.MAX_VALUE) ? -1 : 1;
        }
        return -1;
    }

    public List getWindows() {
        return this.windows;
    }

    public void addWindow(Window window) {
        if (this.windows == null) {
            this.windows = new ArrayList();
        }
        this.windows.add(window);
    }

    public void addWindows(List windows) {
        if (windows == null) {
            return;
        }
        for (int i = 0; i < windows.size(); ++i) {
            this.addWindow((Window)windows.get(i));
        }
    }

    public List getWindows(MessageId id) {
        return this.windowsByMessageId == null ? null : (List)this.windowsByMessageId.get(id);
    }

    public void addWindows(MessageId id, List windows) {
        if (this.windowsByMessageId == null) {
            this.windowsByMessageId = new HashMap();
        }
        this.windowsByMessageId.put(id, windows);
    }

    public Window getWindow(WindowId id) {
        return this.windowByWindowId == null ? null : (Window)this.windowByWindowId.get(id);
    }

    public void addWindow(WindowId id, Window window) {
        if (this.windowByWindowId == null) {
            this.windowByWindowId = new HashMap();
        }
        this.windowByWindowId.put(id, window);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.requestId);
        if (this.windows == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.windows.size());
            int imax = this.windows.size();
            for (int i = 0; i < imax; ++i) {
                ((Window)this.windows.get(i)).write(out);
            }
        }
        if (this.windowsByMessageId == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.windowsByMessageId.size());
            Iterator entries = this.windowsByMessageId.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                MessageId id = (MessageId)entry.getKey();
                out.writeInt(id.sequence);
                List windows = (List)entry.getValue();
                out.writeInt(windows.size());
                int imax = windows.size();
                for (int i = 0; i < imax; ++i) {
                    ((Window)windows.get(i)).write(out);
                }
            }
        }
        if (this.windowByWindowId == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.windowByWindowId.size());
            Iterator windows = this.windowByWindowId.values().iterator();
            while (windows.hasNext()) {
                Window window = (Window)windows.next();
                window.write(out);
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Window window;
        int i;
        super.readExternal(in);
        this.requestId = in.readInt();
        int size = in.readInt();
        if (size != 0) {
            for (i = 0; i < size; ++i) {
                window = new Window();
                window.read(in);
                this.addWindow(window);
            }
        }
        if ((size = in.readInt()) != 0) {
            for (i = 0; i < size; ++i) {
                MessageId id = new MessageId(in.readInt());
                int size2 = in.readInt();
                ArrayList<Window> windows = new ArrayList<Window>(size2);
                for (int j = 0; j < size2; ++j) {
                    Window window2 = new Window();
                    window2.read(in);
                    windows.add(window2);
                }
                this.addWindows(id, windows);
            }
        }
        if ((size = in.readInt()) != 0) {
            for (i = 0; i < size; ++i) {
                window = new Window();
                window.read(in);
                this.addWindow(window, window);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append('{');
        buf.append("windows=").append(this.windows);
        buf.append(", windowsByMessageId=").append(this.windowsByMessageId);
        buf.append(", windowByWindowId=").append(this.windowByWindowId);
        buf.append('}');
        return buf.toString();
    }
}

