/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.graph.DatasetCondition;
import jp.ossc.nimbus.service.graph.DatasetConnection;
import jp.ossc.nimbus.service.graph.DatasetCreateException;
import jp.ossc.nimbus.service.graph.DatasetFactory;
import jp.ossc.nimbus.service.graph.OHLCDatasetFactoryServiceMBean;
import jp.ossc.nimbus.service.graph.SeriesCursor;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultOHLCDataset;
import org.jfree.data.xy.OHLCDataItem;

public abstract class OHLCDatasetFactoryService
extends ServiceBase
implements DatasetFactory,
OHLCDatasetFactoryServiceMBean {
    private static final long serialVersionUID = -5683807188095075424L;
    protected String dataSetName;
    protected int collateDataField = 14;
    protected int collateDataPeriod = 1;
    protected int collateDataDateType = 1;

    public void setName(String name) {
        this.dataSetName = name;
    }

    public String getName() {
        return this.dataSetName;
    }

    public void setCollateDataPeriod(int field, int period) {
        this.collateDataField = field;
        this.collateDataPeriod = period;
    }

    public void setCollateDataDateType(int type) {
        this.collateDataDateType = type;
    }

    public int getCollateDataDateType() {
        return this.collateDataDateType;
    }

    public void preStartService() throws Exception {
        super.preStartService();
        if (this.dataSetName == null || this.dataSetName.length() == 0) {
            this.dataSetName = this.getServiceName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset createDataset(DatasetCondition[] dsConditions) throws DatasetCreateException {
        DatasetConnection connection = this.createConnection(dsConditions);
        String series = null;
        OHLCDataItem[] items = null;
        try {
            List cursors = connection.getSeriesCursorList();
            if (cursors == null || cursors.size() == 0) {
                Dataset dataset = null;
                return dataset;
            }
            OHLCDatasetSeriesCursor cursor = (OHLCDatasetSeriesCursor)cursors.get(0);
            series = cursor.getSeriesName();
            items = this.createOHLCDataItems(dsConditions, cursor);
        }
        finally {
            connection.close();
        }
        return new DefaultOHLCDataset((Comparable)((Object)series), items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OHLCDataItem[] createOHLCDataItems(DatasetCondition[] dsConditions, OHLCDatasetSeriesCursor cursor) throws DatasetCreateException {
        ArrayList<OHLCDataItem> list = new ArrayList<OHLCDataItem>();
        try {
            Calendar cal = Calendar.getInstance();
            long periodStartMillis = -1L;
            long prePeriodStartMillis = -1L;
            double openPrice = Double.NaN;
            double highPrice = Double.NaN;
            double lowPrice = Double.NaN;
            double closePrice = Double.NaN;
            double volume = 0.0;
            long period = 0L;
            block1 : switch (this.collateDataDateType) {
                case 2: {
                    switch (this.collateDataField) {
                        case 13: {
                            period = 1000L;
                            break block1;
                        }
                        case 12: {
                            period = 60000L;
                            break block1;
                        }
                        case 10: {
                            period = 3600000L;
                            break block1;
                        }
                        case 5: {
                            period = 86400000L;
                            break block1;
                        }
                        case 2: {
                            cal.setTimeInMillis(periodStartMillis);
                            long dayOfMonth = cal.getActualMaximum(5);
                            period = dayOfMonth * 24L * 60L * 60L * 1000L;
                            break block1;
                        }
                        case 1: {
                            cal.setTimeInMillis(periodStartMillis);
                            long dayOfYear = cal.getActualMaximum(6);
                            period = dayOfYear * 24L * 60L * 60L * 1000L;
                            break block1;
                        }
                    }
                    period = 1L;
                    break;
                }
            }
            while (cursor.next()) {
                double val;
                Date date = cursor.getDate();
                if (date == null) {
                    throw new DatasetCreateException("date is null.");
                }
                periodStartMillis = this.getStartMillis(cal, date);
                if (prePeriodStartMillis != -1L && prePeriodStartMillis != periodStartMillis) {
                    Date itemDate = null;
                    switch (this.collateDataDateType) {
                        case 2: {
                            itemDate = new Date(prePeriodStartMillis + period * (long)(this.collateDataPeriod - 1));
                            break;
                        }
                        default: {
                            itemDate = new Date(prePeriodStartMillis);
                        }
                    }
                    OHLCDataItem item = new OHLCDataItem(itemDate, openPrice, highPrice, lowPrice, closePrice, volume);
                    list.add(item);
                    openPrice = Double.NaN;
                    highPrice = Double.NaN;
                    lowPrice = Double.NaN;
                    closePrice = Double.NaN;
                    volume = Double.NaN;
                    prePeriodStartMillis = periodStartMillis;
                }
                if (!Double.isNaN(val = cursor.getOpenPrice()) && cursor.wasNull()) continue;
                if (!Double.isNaN(val) && Double.isNaN(openPrice)) {
                    openPrice = val;
                }
                if (!Double.isNaN(val = cursor.getHighPrice()) && cursor.wasNull()) continue;
                if (!Double.isNaN(val) && (Double.isNaN(highPrice) || highPrice < val)) {
                    highPrice = val;
                }
                if (!Double.isNaN(val = cursor.getLowPrice()) && cursor.wasNull()) continue;
                if (!Double.isNaN(val) && (Double.isNaN(lowPrice) || lowPrice > val)) {
                    lowPrice = val;
                }
                if (!Double.isNaN(val = cursor.getClosePrice()) && cursor.wasNull()) continue;
                if (!Double.isNaN(val)) {
                    closePrice = val;
                }
                if (!Double.isNaN(val = cursor.getVolume()) && cursor.wasNull()) continue;
                if (!Double.isNaN(val)) {
                    volume = Double.isNaN(volume) ? val : (volume += val);
                }
                if (prePeriodStartMillis != -1L) continue;
                prePeriodStartMillis = periodStartMillis;
            }
            if (periodStartMillis != -1L && prePeriodStartMillis == periodStartMillis) {
                Date itemDate = null;
                switch (this.collateDataDateType) {
                    case 2: {
                        itemDate = new Date(periodStartMillis + period * (long)(this.collateDataPeriod - 1));
                        break;
                    }
                    default: {
                        itemDate = new Date(prePeriodStartMillis);
                    }
                }
                OHLCDataItem item = new OHLCDataItem(itemDate, openPrice, highPrice, lowPrice, closePrice, volume);
                list.add(item);
            }
        }
        finally {
            cursor.close();
        }
        return list.toArray(new OHLCDataItem[list.size()]);
    }

    protected abstract DatasetConnection createConnection(DatasetCondition[] var1) throws DatasetCreateException;

    protected long getStartMillis(Calendar cal, Date date) {
        cal.setTime(date);
        int currVal = cal.get(this.collateDataField);
        switch (this.collateDataField) {
            case 13: {
                cal.set(14, 0);
                break;
            }
            case 12: {
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 10: 
            case 11: {
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 2: 
            case 5: {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 1: {
                cal.set(2, 0);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
        }
        cal.set(this.collateDataField, currVal - currVal % this.collateDataPeriod);
        return cal.getTimeInMillis();
    }

    protected abstract class OHLCDatasetSeriesCursor
    extends SeriesCursor {
        public OHLCDatasetSeriesCursor(String seriesName) {
            super(seriesName);
        }

        public abstract Date getDate() throws DatasetCreateException;

        public abstract double getOpenPrice() throws DatasetCreateException;

        public abstract double getHighPrice() throws DatasetCreateException;

        public abstract double getLowPrice() throws DatasetCreateException;

        public abstract double getClosePrice() throws DatasetCreateException;

        public abstract double getVolume() throws DatasetCreateException;

        public abstract boolean wasNull() throws DatasetCreateException;
    }
}

