/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ga;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import jp.ossc.nimbus.service.ga.AbstractGene;
import jp.ossc.nimbus.service.ga.Gene;
import jp.ossc.nimbus.service.ga.Genom;

public class DefaultGenom
implements Genom,
Cloneable,
Externalizable {
    public static final int CROSSOVER_SINGLE_POINT = 1;
    public static final int CROSSOVER_TWO_POINT = 2;
    public static final int CROSSOVER_UNIFORM_POINT = 3;
    public static final int CROSSOVER_ALL_POINT = 4;
    protected int crossoverType = 3;
    protected Map geneMap;

    public void setCrossoverType(int type) {
        this.crossoverType = type;
    }

    public int getCrossoverType() {
        return this.crossoverType;
    }

    public Gene getGene(String name) {
        return this.geneMap == null ? null : (Gene)this.geneMap.get(name);
    }

    public void setGene(String name, Gene gene) {
        if (this.geneMap == null) {
            this.geneMap = new LinkedHashMap();
        }
        if (gene instanceof AbstractGene) {
            ((AbstractGene)gene).setName(name);
        }
        this.geneMap.put(name, gene);
    }

    public void addGene(Gene gene) {
        if (this.geneMap == null) {
            this.geneMap = new LinkedHashMap();
        }
        this.geneMap.put(gene.getName(), gene);
    }

    public Map getGeneMap() {
        return this.geneMap;
    }

    public void random(Random random) {
        if (this.geneMap != null) {
            Iterator itr = this.geneMap.values().iterator();
            while (itr.hasNext()) {
                Gene gene = (Gene)itr.next();
                gene.random(random);
            }
        }
    }

    public void crossover(Random random, Genom genom) {
        switch (this.crossoverType) {
            case 1: {
                this.crossoverBySinglePoint(random, genom);
                break;
            }
            case 2: {
                this.crossoverByTwoPoint(random, genom);
                break;
            }
            case 4: {
                this.crossoverByAllPoint(random, genom);
                break;
            }
            default: {
                this.crossoverByUniformPoint(random, genom);
            }
        }
    }

    protected void crossoverBySinglePoint(Random random, Genom genom) {
        if (this.geneMap != null) {
            int crossoverPoint = 0;
            if (this.geneMap.size() < 2) {
                this.crossoverByAllPoint(random, genom);
                return;
            }
            crossoverPoint = this.geneMap.size() == 2 ? 1 : random.nextInt(this.geneMap.size() - 1) + 1;
            Object[] paramArray = this.geneMap.values().toArray();
            int start = 0;
            int end = 0;
            if (random.nextBoolean()) {
                start = 0;
                end = crossoverPoint;
            } else {
                start = crossoverPoint;
                end = paramArray.length;
            }
            for (int i = start; i < end; ++i) {
                Gene param = (Gene)paramArray[i];
                param.crossover(random, genom.getGene(param.getName()));
            }
        }
    }

    protected void crossoverByTwoPoint(Random random, Genom genom) {
        if (this.geneMap != null) {
            int crossoverPoint1 = 0;
            int crossoverPoint2 = 0;
            if (this.geneMap.size() < 3) {
                this.crossoverBySinglePoint(random, genom);
                return;
            }
            if (this.geneMap.size() == 3) {
                crossoverPoint1 = 1;
                crossoverPoint2 = 2;
            } else {
                crossoverPoint1 = random.nextInt(this.geneMap.size() - 2) + 1;
                crossoverPoint2 = random.nextInt(this.geneMap.size() - 1 - crossoverPoint1) + crossoverPoint1 + 1;
            }
            int section = random.nextInt(3);
            int start = 0;
            int end = 0;
            Object[] paramArray = this.geneMap.values().toArray();
            switch (section) {
                case 0: {
                    start = 0;
                    end = crossoverPoint1;
                }
                case 1: {
                    start = crossoverPoint1;
                    end = crossoverPoint2;
                }
                case 2: {
                    start = crossoverPoint2;
                    end = paramArray.length;
                }
            }
            for (int i = start; i < end; ++i) {
                Gene param = (Gene)paramArray[i];
                param.crossover(random, genom.getGene(param.getName()));
            }
        }
    }

    protected void crossoverByUniformPoint(Random random, Genom genom) {
        if (this.geneMap != null) {
            Iterator itr = this.geneMap.values().iterator();
            while (itr.hasNext()) {
                Gene param = (Gene)itr.next();
                if (!random.nextBoolean()) continue;
                param.crossover(random, genom.getGene(param.getName()));
            }
        }
    }

    protected void crossoverByAllPoint(Random random, Genom genom) {
        if (this.geneMap != null) {
            Iterator itr = this.geneMap.values().iterator();
            while (itr.hasNext()) {
                Gene param = (Gene)itr.next();
                param.crossover(random, genom.getGene(param.getName()));
            }
        }
    }

    public Genom cloneGenom() {
        DefaultGenom clone = null;
        try {
            clone = (DefaultGenom)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        if (this.geneMap != null) {
            LinkedHashMap<String, Gene> cloneGeneMap = new LinkedHashMap<String, Gene>();
            Iterator itr = this.geneMap.values().iterator();
            while (itr.hasNext()) {
                Gene gene = ((Gene)itr.next()).cloneGene();
                cloneGeneMap.put(gene.getName(), gene);
            }
            clone.geneMap = cloneGeneMap;
        }
        return clone;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.crossoverType);
        out.writeObject(this.geneMap);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.crossoverType = in.readInt();
        this.geneMap = (Map)in.readObject();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        if (this.geneMap != null) {
            Iterator itr = this.geneMap.values().iterator();
            while (itr.hasNext()) {
                buf.append(itr.next());
                if (!itr.hasNext()) continue;
                buf.append(',');
            }
            buf.append(']');
        }
        buf.append('}');
        return buf.toString();
    }
}

