/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.IllegalCachedReferenceException;
import jp.ossc.nimbus.service.cache.KeyCachedReference;
import jp.ossc.nimbus.service.context.DefaultContextService;
import jp.ossc.nimbus.service.context.NoConnectServerException;
import jp.ossc.nimbus.service.context.SharedContext;
import jp.ossc.nimbus.service.context.SharedContextIllegalIndexException;
import jp.ossc.nimbus.service.context.SharedContextSendException;
import jp.ossc.nimbus.service.context.SharedContextServiceMBean;
import jp.ossc.nimbus.service.context.SharedContextTimeoutException;
import jp.ossc.nimbus.service.context.SharedContextUpdateException;
import jp.ossc.nimbus.service.context.SharedContextUpdateListener;
import jp.ossc.nimbus.service.context.SharedContextValueDifference;
import jp.ossc.nimbus.service.context.SharedContextValueDifferenceSupport;
import jp.ossc.nimbus.service.interpreter.EvaluateException;
import jp.ossc.nimbus.service.interpreter.Interpreter;
import jp.ossc.nimbus.service.keepalive.ClusterListener;
import jp.ossc.nimbus.service.keepalive.ClusterService;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageReceiver;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.RequestMessageListener;
import jp.ossc.nimbus.service.publish.RequestServerConnection;
import jp.ossc.nimbus.service.publish.ServerConnectionFactory;
import jp.ossc.nimbus.service.queue.AsynchContext;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerService;
import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

public class SharedContextService
extends DefaultContextService
implements SharedContext,
RequestMessageListener,
CacheRemoveListener,
ClusterListener,
SharedContextServiceMBean,
Serializable {
    private static final long serialVersionUID = -7616415086512838961L;
    private ServiceName requestConnectionFactoryServiceName;
    private RequestServerConnection serverConnection;
    private MessageReceiver messageReceiver;
    private ServiceName clusterServiceName;
    private ClusterService cluster;
    private ServiceName clientCacheMapServiceName;
    private ServiceName serverCacheMapServiceName;
    private CacheMap clientCacheMap;
    private CacheMap serverCacheMap;
    private CacheMap cacheMap;
    private boolean isClient;
    private ServiceName[] sharedContextUpdateListenerServiceNames;
    private ServiceName interpreterServiceName;
    private Interpreter interpreter;
    private int executeThreadSize;
    private QueueHandlerContainerService executeQueueHandlerContainer;
    private ServiceName executeQueueServiceName;
    private long synchronizeTimeout = 5000L;
    private long defaultTimeout = 1000L;
    private String subject = "SharedContext";
    private String clientSubject;
    private boolean isSynchronizeOnStart = true;
    private boolean isSaveOnlyMain;
    private Map keyLockMap;
    private Map idLocksMap;
    private Map clientCacheLockMap;
    private Message targetMessage;
    private List updateListeners;
    private Map keyIndexMap;
    private Map keyIndexResultMap;
    private Timer lockTimeoutTimer;

    public void setRequestConnectionFactoryServiceName(ServiceName name) {
        this.requestConnectionFactoryServiceName = name;
    }

    public ServiceName getRequestConnectionFactoryServiceName() {
        return this.requestConnectionFactoryServiceName;
    }

    public void setClusterServiceName(ServiceName name) {
        this.clusterServiceName = name;
    }

    public ServiceName getClusterServiceName() {
        return this.clusterServiceName;
    }

    public void setClientCacheMapServiceName(ServiceName name) {
        this.clientCacheMapServiceName = name;
    }

    public ServiceName getClientCacheMapServiceName() {
        return this.clientCacheMapServiceName;
    }

    public void setServerCacheMapServiceName(ServiceName name) {
        this.serverCacheMapServiceName = name;
    }

    public ServiceName getServerCacheMapServiceName() {
        return this.serverCacheMapServiceName;
    }

    public void setInterpreterServiceName(ServiceName name) {
        this.interpreterServiceName = name;
    }

    public ServiceName getInterpreterServiceName() {
        return this.interpreterServiceName;
    }

    public void setExecuteThreadSize(int size) {
        this.executeThreadSize = size;
    }

    public int getExecuteThreadSize() {
        return this.executeThreadSize;
    }

    public void setExecuteQueueServiceName(ServiceName name) {
        this.executeQueueServiceName = name;
    }

    public ServiceName getExecuteQueueServiceName() {
        return this.executeQueueServiceName;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setClient(boolean isClient) throws SharedContextSendException, SharedContextTimeoutException {
        if (this.isClient == isClient) {
            return;
        }
        if (this.getState() == 3) {
            if (isClient) {
                if (this.clientCacheMapServiceName != null) {
                    this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.clientCacheMapServiceName);
                } else if (this.clientCacheMap != null) {
                    this.cacheMap = this.clientCacheMap;
                }
            } else if (this.serverCacheMapServiceName != null) {
                this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.serverCacheMapServiceName);
            } else if (this.serverCacheMap != null) {
                this.cacheMap = this.serverCacheMap;
            }
            if (this.keyIndexResultMap != null) {
                this.keyIndexResultMap.clear();
            }
            try {
                if (isClient) {
                    this.synchronizeForClient(this.synchronizeTimeout);
                } else {
                    this.synchronizeWithMain(this.synchronizeTimeout);
                }
            }
            catch (NoConnectServerException e) {
                // empty catch block
            }
            try {
                this.messageReceiver.removeMessageListener(this);
                this.messageReceiver.addSubject(this, isClient ? this.clientSubject : this.subject);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            if (this.cacheMap != null) {
                Object[] keys = null;
                Map map = this.context;
                synchronized (map) {
                    keys = super.keySet().toArray();
                }
                for (int i = 0; i < keys.length; ++i) {
                    this.cacheMap.remove(keys[i]);
                }
            }
        }
        this.isClient = isClient;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public void setSynchronizeOnStart(boolean isSynch) {
        this.isSynchronizeOnStart = isSynch;
    }

    public boolean isSynchronizeOnStart() {
        return this.isSynchronizeOnStart;
    }

    public void setSaveOnlyMain(boolean isSave) {
        this.isSaveOnlyMain = isSave;
    }

    public boolean isSaveOnlyMain() {
        return this.isSaveOnlyMain;
    }

    public void setSynchronizeTimeout(long timeout) {
        this.synchronizeTimeout = timeout;
    }

    public long getSynchronizeTimeout() {
        return this.synchronizeTimeout;
    }

    public void setDefaultTimeout(long timeout) {
        this.defaultTimeout = timeout;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setClientCacheMap(CacheMap map) {
        this.clientCacheMap = map;
    }

    public void setServerCacheMap(CacheMap map) {
        this.serverCacheMap = map;
    }

    public void setSharedContextUpdateListenerServiceNames(ServiceName[] names) {
        this.sharedContextUpdateListenerServiceNames = names;
    }

    public ServiceName[] getSharedContextUpdateListenerServiceNames() {
        return this.sharedContextUpdateListenerServiceNames;
    }

    public void setKeyIndex(String name, String[] keyProps) throws SharedContextIllegalIndexException {
        Property[] props = new Property[keyProps.length];
        for (int i = 0; i < keyProps.length; ++i) {
            try {
                props[i] = PropertyFactory.createProperty(keyProps[i]);
            }
            catch (IllegalArgumentException e) {
                throw new SharedContextIllegalIndexException(e);
            }
            props[i].setIgnoreNullProperty(true);
        }
        if (this.keyIndexMap == null) {
            this.keyIndexMap = Collections.synchronizedMap(new HashMap());
            this.keyIndexResultMap = Collections.synchronizedMap(new HashMap());
        }
        this.keyIndexMap.put(name, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeKeyIndex(String name) throws SharedContextIllegalIndexException, SharedContextSendException, SharedContextTimeoutException {
        block18: {
            if (!this.isClient) {
                if (this.keyIndexMap == null || !this.keyIndexMap.containsKey(name)) {
                    return;
                }
                Property[] keyProps = (Property[])this.keyIndexMap.get(name);
                Map indexMap = Collections.synchronizedMap(new HashMap());
                Map map = this.context;
                synchronized (map) {
                    Iterator entries = this.context.entrySet().iterator();
                    while (entries.hasNext()) {
                        Map.Entry entry = entries.next();
                        Object[] keys = new Object[keyProps.length];
                        for (int i = 0; i < keyProps.length; ++i) {
                            try {
                                keys[i] = keyProps[i].getProperty(entry.getValue());
                                continue;
                            }
                            catch (NoSuchPropertyException e) {
                                throw new SharedContextIllegalIndexException(e);
                            }
                            catch (InvocationTargetException e) {
                                throw new SharedContextIllegalIndexException(e);
                            }
                        }
                        IndexKey key = new IndexKey(keys);
                        Set keySet = (Set)indexMap.get(key);
                        if (keySet == null) {
                            keySet = Collections.synchronizedSet(new HashSet());
                            indexMap.put(key, keySet);
                        }
                        keySet.add(entry.getKey());
                    }
                }
                this.keyIndexResultMap.put(name, indexMap);
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                message.setObject(new SharedContextEvent(21, name));
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() == 0) {
                    if (this.isClient) {
                        throw new NoConnectServerException();
                    }
                    break block18;
                }
                Message[] responses = this.serverConnection.request(message, this.clientSubject, null, 0, this.defaultTimeout);
                if (responses != null && responses.length > 0) {
                    for (int i = 0; i < responses.length; ++i) {
                        Object ret = responses[i].getObject();
                        if (!(ret instanceof Throwable)) continue;
                        throw new SharedContextSendException((Throwable)ret);
                    }
                    break block18;
                }
                throw new SharedContextTimeoutException();
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
        }
    }

    protected void addAllKeyIndex(Object key, Object value) {
        if (this.isClient || this.keyIndexMap == null || this.keyIndexMap.size() == 0) {
            return;
        }
        Object[] names = this.keyIndexMap.keySet().toArray();
        for (int i = 0; i < names.length; ++i) {
            this.addKeyIndex((String)names[i], key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addKeyIndex(String name, Object key, Object value) {
        if (this.isClient || this.keyIndexMap == null || !this.keyIndexMap.containsKey(name)) {
            return;
        }
        Map indexMap = (Map)this.keyIndexResultMap.get(name);
        if (indexMap == null) {
            Map map = this.keyIndexResultMap;
            synchronized (map) {
                indexMap = (Map)this.keyIndexResultMap.get(name);
                if (indexMap == null) {
                    indexMap = Collections.synchronizedMap(new HashMap());
                    this.keyIndexResultMap.put(name, indexMap);
                }
            }
        }
        Property[] keyProps = (Property[])this.keyIndexMap.get(name);
        Object[] keys = new Object[keyProps.length];
        for (int i = 0; i < keyProps.length; ++i) {
            try {
                keys[i] = keyProps[i].getProperty(value);
                continue;
            }
            catch (NoSuchPropertyException e) {
                throw new SharedContextIllegalIndexException(e);
            }
            catch (InvocationTargetException e) {
                throw new SharedContextIllegalIndexException(e);
            }
        }
        IndexKey indexKey = new IndexKey(keys);
        Set<Object> keySet = (Set<Object>)indexMap.get(indexKey);
        if (keySet == null) {
            Map map = indexMap;
            synchronized (map) {
                keySet = (Set)indexMap.get(indexKey);
                if (keySet == null) {
                    keySet = Collections.synchronizedSet(new HashSet());
                    indexMap.put(indexKey, keySet);
                }
            }
        }
        keySet.add(key);
    }

    protected void removeAllKeyIndex(Object key, Object value) {
        if (this.isClient || this.keyIndexMap == null || this.keyIndexMap.size() == 0) {
            return;
        }
        Object[] names = this.keyIndexMap.keySet().toArray();
        for (int i = 0; i < names.length; ++i) {
            this.removeKeyIndex((String)names[i], key, value);
        }
    }

    protected void removeKeyIndex(String name, Object key, Object value) {
        if (this.isClient || this.keyIndexMap == null || !this.keyIndexMap.containsKey(name)) {
            return;
        }
        Map indexMap = (Map)this.keyIndexResultMap.get(name);
        if (indexMap == null) {
            return;
        }
        Property[] keyProps = (Property[])this.keyIndexMap.get(name);
        Object[] keys = new Object[keyProps.length];
        for (int i = 0; i < keyProps.length; ++i) {
            try {
                keys[i] = keyProps[i].getProperty(value);
                continue;
            }
            catch (NoSuchPropertyException e) {
                throw new SharedContextIllegalIndexException(e);
            }
            catch (InvocationTargetException e) {
                throw new SharedContextIllegalIndexException(e);
            }
        }
        IndexKey indexKey = new IndexKey(keys);
        Set keySet = (Set)indexMap.get(indexKey);
        if (keySet == null) {
            return;
        }
        keySet.remove(key);
        if (keySet.size() == 0) {
            indexMap.remove(indexKey);
        }
    }

    public void createService() throws Exception {
        super.createService();
        this.keyLockMap = Collections.synchronizedMap(new HashMap());
        this.idLocksMap = Collections.synchronizedMap(new HashMap());
        this.clientCacheLockMap = Collections.synchronizedMap(new HashMap());
    }

    public void startService() throws Exception {
        block16: {
            if (this.requestConnectionFactoryServiceName == null) {
                throw new IllegalArgumentException("RequestConnectionFactoryServiceName must be specified.");
            }
            if (this.isClient) {
                if (this.clientCacheMapServiceName != null) {
                    this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.clientCacheMapServiceName);
                } else if (this.clientCacheMap != null) {
                    this.cacheMap = this.clientCacheMap;
                }
            } else if (this.serverCacheMapServiceName != null) {
                this.cacheMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.serverCacheMapServiceName);
            } else if (this.serverCacheMap != null) {
                this.cacheMap = this.serverCacheMap;
            }
            if (this.interpreterServiceName != null) {
                this.interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(this.interpreterServiceName);
            }
            this.executeQueueHandlerContainer = new QueueHandlerContainerService();
            this.executeQueueHandlerContainer.create();
            this.executeQueueHandlerContainer.setQueueHandlerSize(this.executeThreadSize);
            this.executeQueueHandlerContainer.setQueueServiceName(this.executeQueueServiceName);
            this.executeQueueHandlerContainer.setQueueHandler(new ExecuteQueueHandler());
            this.executeQueueHandlerContainer.start();
            if (this.sharedContextUpdateListenerServiceNames != null) {
                for (int i = 0; i < this.sharedContextUpdateListenerServiceNames.length; ++i) {
                    this.addSharedContextUpdateListener((SharedContextUpdateListener)ServiceManagerFactory.getServiceObject(this.sharedContextUpdateListenerServiceNames[i]));
                }
            }
            ServerConnectionFactory factory = (ServerConnectionFactory)ServiceManagerFactory.getServiceObject(this.requestConnectionFactoryServiceName);
            this.serverConnection = (RequestServerConnection)factory.getServerConnection();
            this.targetMessage = this.serverConnection.createMessage(this.subject, null);
            this.messageReceiver = (MessageReceiver)ServiceManagerFactory.getServiceObject(this.requestConnectionFactoryServiceName);
            this.clientSubject = this.subject + ".Client";
            this.messageReceiver.addSubject(this, this.isClient ? this.clientSubject : this.subject);
            if (this.clusterServiceName == null) {
                throw new IllegalArgumentException("ClusterServiceName must be specified.");
            }
            this.cluster = (ClusterService)ServiceManagerFactory.getServiceObject(this.clusterServiceName);
            this.cluster.addClusterListener(this);
            this.lockTimeoutTimer = new Timer(true);
            super.startService();
            if (this.isSynchronizeOnStart && !this.isMain()) {
                try {
                    this.synchronize();
                }
                catch (NoConnectServerException e) {
                    if (this.isClient) break block16;
                    throw e;
                }
            }
        }
    }

    public void stopService() throws Exception {
        this.unlockAll();
        if (this.messageReceiver != null) {
            this.messageReceiver.removeMessageListener(this);
        }
        if (this.cluster != null) {
            this.cluster.removeClusterListener(this);
        }
        super.stopService();
    }

    public void destroyService() throws Exception {
        this.keyLockMap = null;
        this.idLocksMap = null;
        this.clientCacheLockMap = null;
        super.destroyService();
    }

    public synchronized void load() throws Exception {
        this.load(-1L);
    }

    public synchronized void load(long timeout) throws Exception {
        block8: {
            if (this.isMain()) {
                super.load();
            } else {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(16));
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                        if (responses != null && responses.length > 0) {
                            Object ret = responses[0].getObject();
                            if (ret instanceof Throwable) {
                                throw new SharedContextSendException((Throwable)ret);
                            }
                            break block8;
                        }
                        throw new SharedContextTimeoutException();
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
            }
        }
    }

    public synchronized void loadKey() throws Exception {
        this.loadKey(-1L);
    }

    public synchronized void loadKey(long timeout) throws Exception {
        block8: {
            if (this.isMain()) {
                super.loadKey();
            } else {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(17));
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                        if (responses != null && responses.length > 0) {
                            Object ret = responses[0].getObject();
                            if (ret instanceof Throwable) {
                                throw new SharedContextSendException((Throwable)ret);
                            }
                            break block8;
                        }
                        throw new SharedContextTimeoutException();
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
            }
        }
    }

    public void load(Object key) throws Exception {
        this.load(key, -1L);
    }

    public void load(Object key, long timeout) throws Exception {
        block8: {
            if (this.isMain()) {
                super.load(key);
            } else {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(16, key));
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                        if (responses != null && responses.length > 0) {
                            Object ret = responses[0].getObject();
                            if (ret instanceof Throwable) {
                                throw new SharedContextSendException((Throwable)ret);
                            }
                            break block8;
                        }
                        throw new SharedContextTimeoutException();
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
            }
        }
    }

    public synchronized void save() throws Exception {
        this.save(-1L);
    }

    public synchronized void save(long timeout) throws Exception {
        block8: {
            if (!this.isMain()) {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(15));
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, this.isSaveOnlyMain ? 1 : 0, timeout);
                        if (responses != null && (this.isSaveOnlyMain ? responses.length > 0 : responses.length >= receiveClients.size())) {
                            for (int i = 0; i < responses.length; ++i) {
                                Object ret = responses[i].getObject();
                                if (!(ret instanceof Throwable)) continue;
                                throw new SharedContextSendException((Throwable)ret);
                            }
                            break block8;
                        }
                        throw new SharedContextTimeoutException();
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
            }
        }
        if (!(this.isClient || !this.isMain() && this.isSaveOnlyMain)) {
            super.save();
        }
    }

    public void save(Object key) throws Exception {
        this.save(key, -1L);
    }

    public void save(Object key, long timeout) throws Exception {
        block8: {
            if (!this.isMain()) {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(15, key));
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, this.isSaveOnlyMain ? 1 : 0, timeout);
                        if (responses != null && (this.isSaveOnlyMain ? responses.length > 0 : responses.length >= receiveClients.size())) {
                            for (int i = 0; i < responses.length; ++i) {
                                Object ret = responses[i].getObject();
                                if (!(ret instanceof Throwable)) continue;
                                throw new SharedContextSendException((Throwable)ret);
                            }
                            break block8;
                        }
                        throw new SharedContextTimeoutException();
                    }
                    throw new NoConnectServerException("Main server is not found.");
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
            }
        }
        if (!(this.isClient || !this.isMain() && this.isSaveOnlyMain)) {
            super.save(key);
        }
    }

    public void synchronize() throws SharedContextSendException, SharedContextTimeoutException {
        this.synchronize(this.synchronizeTimeout);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void synchronize(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (this.isClient) {
            this.synchronizeForClient(timeout);
            return;
        } else if (this.isMain()) {
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                message.setSubject(this.clientSubject, null);
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() == 0) return;
                message.setObject(new SharedContextEvent(11, null, new Long(timeout)));
                Message[] responses = this.serverConnection.request(message, 0, timeout);
                if (responses == null || responses.length < receiveClients.size()) throw new SharedContextTimeoutException();
                for (int i = 0; i < responses.length; ++i) {
                    if (responses[i].getObject() != null && ((Boolean)responses[i].getObject()).booleanValue()) continue;
                    throw new SharedContextSendException("It faild to synchronize.");
                }
                return;
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
        } else {
            this.synchronizeWithMain(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void synchronizeForClient(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        block16: {
            if (this.cacheMap != null) {
                Object[] keys = null;
                Map map = this.context;
                synchronized (map) {
                    keys = super.keySet().toArray();
                }
                for (int i = 0; i < keys.length; ++i) {
                    this.cacheMap.remove(keys[i]);
                }
            }
            if (this.updateListeners != null) {
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onClearSynchronize(this);
                }
            }
            super.clear();
            if (this.updateListeners != null) {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(4));
                        Message[] responses = this.serverConnection.request(message, 1, timeout);
                        if (responses != null && responses.length > 0) {
                            Map result = (Map)responses[0].getObject();
                            if (result != null) {
                                Iterator entries = result.entrySet().iterator();
                                while (entries.hasNext()) {
                                    Map.Entry entry = entries.next();
                                    if (this.updateListeners == null) continue;
                                    for (int i = 0; i < this.updateListeners.size() && ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutSynchronize(this, entry.getKey(), entry.getValue()); ++i) {
                                    }
                                }
                            }
                            break block16;
                        }
                        throw new SharedContextTimeoutException();
                    }
                    throw new NoConnectServerException();
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
            }
        }
    }

    private synchronized void synchronizeWithMain(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        block11: {
            try {
                Message message = this.serverConnection.createMessage(this.subject, null);
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(4));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                    if (responses != null && responses.length > 0) {
                        Map result = (Map)responses[0].getObject();
                        if (this.updateListeners != null) {
                            for (int i = 0; i < this.updateListeners.size(); ++i) {
                                ((SharedContextUpdateListener)this.updateListeners.get(i)).onClearSynchronize(this);
                            }
                        }
                        super.clear();
                        if (result != null) {
                            Iterator entries = result.entrySet().iterator();
                            while (entries.hasNext()) {
                                Map.Entry entry = entries.next();
                                boolean isPut = true;
                                if (this.updateListeners != null) {
                                    for (int i = 0; i < this.updateListeners.size(); ++i) {
                                        if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutSynchronize(this, entry.getKey(), entry.getValue())) continue;
                                        isPut = false;
                                        break;
                                    }
                                }
                                if (!isPut) continue;
                                super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                                this.addAllKeyIndex(entry.getKey(), entry.getValue());
                            }
                        }
                        break block11;
                    }
                    throw new SharedContextTimeoutException();
                }
                throw new NoConnectServerException("Main server is not found.");
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
        }
    }

    protected Object wrapCachedReference(Object key, Object value) {
        if (value == null || this.cacheMap == null) {
            return value;
        }
        this.cacheMap.put(key, value);
        KeyCachedReference ref = this.cacheMap.getCachedReference(key);
        if (ref != null) {
            ref.addCacheRemoveListener(this);
        }
        return ref;
    }

    protected Object unwrapCachedReference(Object value, boolean notify, boolean remove) {
        if (value == null) {
            return null;
        }
        if (this.cacheMap == null) {
            return value;
        }
        CachedReference ref = (CachedReference)value;
        if (remove) {
            ref.remove(this);
        }
        return ref.get(this, notify);
    }

    public void lock(Object key) throws SharedContextSendException, SharedContextTimeoutException {
        this.lock(key, this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void lock(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        Lock lock;
        Object id;
        block22: {
            id = this.cluster.getUID();
            lock = null;
            Map map = this.keyLockMap;
            synchronized (map) {
                lock = (Lock)this.keyLockMap.get(key);
                if (lock == null) {
                    lock = new Lock(key);
                    this.keyLockMap.put(key, lock);
                }
            }
            Object lockedOwner = lock.getOwner();
            if (id.equals(lockedOwner)) {
                return;
            }
            if (this.isMain()) {
                long start = System.currentTimeMillis();
                if (!lock.acquire(id, timeout)) throw new SharedContextTimeoutException();
                boolean isNoTimeout = timeout <= 0L;
                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                if (!isNoTimeout && timeout <= 0L) {
                    lock.release(id, false);
                    throw new SharedContextTimeoutException();
                }
                try {
                    Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                    message.setSubject(this.clientSubject, key == null ? null : key.toString());
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() == 0) return;
                    message.setObject(new SharedContextEvent(13, key, new Object[]{id, new Long(timeout)}));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                    if (responses != null && responses.length >= receiveClients.size()) {
                        for (int i = 0; i < responses.length; ++i) {
                            Object ret = responses[i].getObject();
                            if (ret instanceof Throwable) {
                                this.unlock(key);
                                throw new SharedContextSendException((Throwable)ret);
                            }
                            if (ret != null && ((Boolean)ret).booleanValue()) continue;
                            this.unlock(key);
                            throw new SharedContextTimeoutException();
                        }
                        return;
                    }
                    this.unlock(key);
                    throw new SharedContextTimeoutException();
                }
                catch (MessageException e) {
                    this.unlock(key);
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    this.unlock(key);
                    throw new SharedContextSendException(e);
                }
                catch (RuntimeException e) {
                    this.unlock(key);
                    throw e;
                }
                catch (Error e) {
                    this.unlock(key);
                    throw e;
                }
                catch (Throwable th) {
                    this.unlock(key);
                    throw new SharedContextSendException(th);
                }
            }
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() == 0) throw new NoConnectServerException("Main server is not found.");
                message.setObject(new SharedContextEvent(12, key, new Long(timeout)));
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 1, timeout);
                if (responses != null && responses.length > 0) {
                    Object ret = responses[0].getObject();
                    if (ret instanceof Throwable) {
                        this.unlock(key);
                        throw new SharedContextSendException((Throwable)ret);
                    }
                    if (ret == null || !((Boolean)ret).booleanValue()) {
                        this.unlock(key);
                        throw new SharedContextTimeoutException();
                    }
                    break block22;
                }
                this.unlock(key);
                throw new SharedContextTimeoutException();
            }
            catch (MessageException e) {
                this.unlock(key);
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                this.unlock(key);
                throw new SharedContextSendException(e);
            }
        }
        if (lock.acquire(id, timeout)) return;
        this.unlock(key);
        throw new SharedContextTimeoutException();
    }

    public boolean unlock(Object key) throws SharedContextSendException {
        return this.unlock(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(Object key, boolean force) throws SharedContextSendException {
        boolean result;
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(key);
        }
        Object id = this.cluster.getUID();
        if (force && lock != null && lock.getOwner() != null) {
            id = lock.getOwner();
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            message.setSubject(this.clientSubject, key == null ? null : key.toString());
            message.setObject(new SharedContextEvent(14, key, id));
            this.serverConnection.sendAsynch(message);
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        boolean bl = result = lock == null;
        if (lock != null) {
            result = lock.release(id, force);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAll() {
        Map map = this.keyLockMap;
        synchronized (map) {
            Object myId = this.cluster.getUID();
            Iterator entries = this.keyLockMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object key = entry.getKey();
                Lock lock = (Lock)entry.getValue();
                Object owner = lock.getOwner();
                if (owner == null || !owner.equals(myId)) continue;
                try {
                    this.unlock(key, true);
                }
                catch (SharedContextSendException e) {
                    lock.release(myId, true);
                }
            }
        }
        map = this.clientCacheLockMap;
        synchronized (map) {
            Iterator locks = this.clientCacheLockMap.values().iterator();
            while (locks.hasNext()) {
                ClientCacheLock lock = (ClientCacheLock)locks.next();
                lock.notifyAllLock();
            }
        }
        this.lockTimeoutTimer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLockOwner(Object key) {
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(key);
        }
        return lock == null ? null : lock.getOwner();
    }

    public Object put(Object key, Object value) throws SharedContextSendException {
        return this.put(key, value, this.defaultTimeout);
    }

    public Object put(Object key, Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        Object result;
        block15: {
            if (this.updateListeners != null) {
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, key, value)) continue;
                    return null;
                }
            }
            result = null;
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                message.setSubject(this.clientSubject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(1, key, value));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                    if (responses != null && responses.length >= receiveClients.size()) {
                        for (int i = 0; i < responses.length; ++i) {
                            if (responses[i].getObject() == null) continue;
                            result = responses[i].getObject();
                            break block15;
                        }
                        break block15;
                    }
                    throw new SharedContextTimeoutException();
                }
                if (this.isClient) {
                    throw new NoConnectServerException();
                }
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
        }
        if (this.isClient) {
            if (super.containsKey(key)) {
                result = super.put(key, this.wrapCachedReference(key, value));
                result = this.unwrapCachedReference(result, false, true);
            }
        } else {
            boolean isContainsKey = super.containsKey(key);
            result = super.put(key, this.wrapCachedReference(key, value));
            result = this.unwrapCachedReference(result, false, true);
            if (isContainsKey) {
                this.removeAllKeyIndex(key, result);
            }
            this.addAllKeyIndex(key, value);
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, key, value, result);
            }
        }
        return result;
    }

    public Object putLocal(Object key, Object value) {
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, key, value)) continue;
                return null;
            }
        }
        Object result = null;
        if (this.isClient) {
            if (super.containsKey(key)) {
                result = super.put(key, this.wrapCachedReference(key, value));
                result = this.unwrapCachedReference(result, false, true);
            }
        } else {
            boolean isContainsKey = super.containsKey(key);
            result = super.put(key, this.wrapCachedReference(key, value));
            result = this.unwrapCachedReference(result, false, true);
            if (isContainsKey) {
                this.removeAllKeyIndex(key, result);
            }
            this.addAllKeyIndex(key, value);
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, key, value, result);
            }
        }
        return result;
    }

    public void putAsynch(Object key, Object value) throws SharedContextSendException {
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, key, value)) continue;
                return;
            }
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            message.setSubject(this.clientSubject, key == null ? null : key.toString());
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(1, key, value));
                this.serverConnection.sendAsynch(message);
            } else if (this.isClient) {
                throw new NoConnectServerException();
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        Object removed = null;
        if (this.isClient) {
            if (super.containsKey(key)) {
                removed = super.put(key, this.wrapCachedReference(key, value));
                removed = this.unwrapCachedReference(removed, false, true);
            }
        } else {
            boolean isContainsKey = super.containsKey(key);
            removed = super.put(key, this.wrapCachedReference(key, value));
            removed = this.unwrapCachedReference(removed, false, true);
            if (isContainsKey) {
                this.removeAllKeyIndex(key, removed);
            }
            this.addAllKeyIndex(key, value);
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, key, value, removed);
            }
        }
    }

    public void update(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        this.update(key, diff, this.defaultTimeout);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        Set receiveClients;
        Message message;
        if (diff == null) {
            return;
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateBefore(this, true, key, diff)) continue;
                return;
            }
        }
        long start = System.currentTimeMillis();
        try {
            message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(18, key, diff));
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                if (responses == null || responses.length < receiveClients.size()) throw new SharedContextTimeoutException();
                for (int i = 0; i < responses.length; ++i) {
                    Object ret = responses[i].getObject();
                    if (ret == null || !(ret instanceof Throwable)) continue;
                    throw new SharedContextSendException((Throwable)ret);
                }
            } else if (this.isClient) {
                throw new NoConnectServerException();
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        if (!this.isClient || super.containsKey(key)) {
            Object current = this.getRawLocal(key);
            Object currentValue = this.unwrapCachedReference(current, false, false);
            if (currentValue == null) {
                throw new SharedContextUpdateException("Current value is null. key=" + key);
            }
            if (!(currentValue instanceof SharedContextValueDifferenceSupport)) throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + key + ", value=" + currentValue);
            if (!((SharedContextValueDifferenceSupport)currentValue).update(diff)) {
                throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)currentValue).getUpdateVersion() + ", updateVersion=" + diff.getUpdateVersion());
            }
            if (current instanceof CachedReference) {
                try {
                    ((CachedReference)current).set(this, currentValue);
                }
                catch (IllegalCachedReferenceException e) {
                    throw new SharedContextUpdateException(e);
                }
            }
        }
        try {
            message = this.serverConnection.createMessage(this.clientSubject, key == null ? null : key.toString());
            receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(18, key, diff));
                boolean isNoTimeout = timeout <= 0L;
                long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                if (!isNoTimeout && timeout <= 0L) {
                    throw new SharedContextTimeoutException();
                }
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                if (responses == null || responses.length < receiveClients.size()) throw new SharedContextTimeoutException();
                for (int i = 0; i < responses.length; ++i) {
                    Object ret = responses[i].getObject();
                    if (ret == null || !(ret instanceof Throwable)) continue;
                    throw new SharedContextSendException((Throwable)ret);
                }
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        if (this.updateListeners == null) return;
        for (int i = 0; i < this.updateListeners.size(); ++i) {
            ((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateAfter(this, true, key, diff);
        }
    }

    public void updateLocal(Object key, SharedContextValueDifference diff) {
        int i;
        if (diff == null) {
            return;
        }
        if (this.updateListeners != null) {
            for (i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateBefore(this, true, key, diff)) continue;
                return;
            }
        }
        if (!this.isClient || super.containsKey(key)) {
            Object current = this.getRawLocal(key);
            Object currentValue = this.unwrapCachedReference(current, false, false);
            if (currentValue == null) {
                throw new SharedContextUpdateException("Current value is null. key=" + key);
            }
            if (currentValue instanceof SharedContextValueDifferenceSupport) {
                if (!((SharedContextValueDifferenceSupport)currentValue).update(diff)) {
                    throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)currentValue).getUpdateVersion() + ", updateVersion=" + diff.getUpdateVersion());
                }
            } else {
                throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + key + ", value=" + currentValue);
            }
            if (current instanceof CachedReference) {
                try {
                    ((CachedReference)current).set(this, currentValue);
                }
                catch (IllegalCachedReferenceException e) {
                    throw new SharedContextUpdateException(e);
                }
            }
        }
        if (this.updateListeners != null) {
            for (i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateAfter(this, true, key, diff);
            }
        }
    }

    public void updateAsynch(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
        if (diff == null) {
            return;
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateBefore(this, true, key, diff)) continue;
                return;
            }
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            message.setSubject(this.clientSubject, key == null ? null : key.toString());
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(18, key, diff));
                this.serverConnection.sendAsynch(message);
            } else if (this.isClient) {
                throw new NoConnectServerException();
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        if (!this.isClient || super.containsKey(key)) {
            Object current = this.getRawLocal(key);
            Object currentValue = this.unwrapCachedReference(current, false, false);
            if (currentValue == null) {
                throw new SharedContextUpdateException("Current value is null. key=" + key);
            }
            if (currentValue instanceof SharedContextValueDifferenceSupport) {
                if (!((SharedContextValueDifferenceSupport)currentValue).update(diff)) {
                    throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)currentValue).getUpdateVersion() + ", updateVersion=" + diff.getUpdateVersion());
                }
            } else {
                throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + key + ", value=" + currentValue);
            }
            if (current instanceof CachedReference) {
                try {
                    ((CachedReference)current).set(this, currentValue);
                }
                catch (IllegalCachedReferenceException e) {
                    throw new SharedContextUpdateException(e);
                }
            }
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateAfter(this, true, key, diff);
            }
        }
    }

    public Object remove(Object key) throws SharedContextSendException {
        return this.remove(key, this.defaultTimeout);
    }

    public Object remove(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        Object result;
        block14: {
            if (this.isMain() && !super.containsKey(key)) {
                return null;
            }
            if (this.updateListeners != null) {
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    if (((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveBefore(this, true, key)) continue;
                    return null;
                }
            }
            result = null;
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                message.setSubject(this.clientSubject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(2, key));
                    Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, key == null ? null : key.toString(), 0, timeout);
                    if (responses != null && responses.length >= receiveClients.size()) {
                        if (this.isMain()) {
                            result = super.remove(key);
                            result = this.unwrapCachedReference(result, false, true);
                            break block14;
                        }
                        Object removed = super.remove(key);
                        this.unwrapCachedReference(removed, false, true);
                        for (int i = 0; i < responses.length; ++i) {
                            if (responses[i].getObject() == null) continue;
                            result = responses[i].getObject();
                            break block14;
                        }
                        break block14;
                    }
                    throw new SharedContextTimeoutException();
                }
                if (this.isClient) {
                    throw new NoConnectServerException();
                }
                result = super.remove(key);
                result = this.unwrapCachedReference(result, false, true);
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
        }
        if (!this.isClient) {
            this.removeAllKeyIndex(key, result);
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveAfter(this, true, key, result);
            }
        }
        return result;
    }

    public Object removeLocal(Object key) {
        if (this.isMain() && !super.containsKey(key)) {
            return null;
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveBefore(this, true, key)) continue;
                return null;
            }
        }
        Object result = super.remove(key);
        result = this.unwrapCachedReference(result, false, true);
        if (!this.isClient) {
            this.removeAllKeyIndex(key, result);
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveAfter(this, true, key, result);
            }
        }
        return result;
    }

    public void removeAsynch(Object key) throws SharedContextSendException {
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveBefore(this, true, key)) continue;
                return;
            }
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            message.setSubject(this.clientSubject, key == null ? null : key.toString());
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(2, key));
                this.serverConnection.sendAsynch(message);
            } else if (this.isClient) {
                throw new NoConnectServerException();
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        Object removed = super.remove(key);
        removed = this.unwrapCachedReference(removed, false, true);
        if (!this.isClient) {
            this.removeAllKeyIndex(key, removed);
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveAfter(this, true, key, removed);
            }
        }
    }

    public void putAll(Map t) {
        this.putAll(t, this.defaultTimeout);
    }

    public synchronized void putAll(Map t, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (t.size() == 0) {
            return;
        }
        if (this.updateListeners != null) {
            LinkedHashMap tmpMap = new LinkedHashMap();
            Iterator entries = t.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    if (this.isClient && !super.containsKey(entry.getKey()) || !((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, entry.getKey(), entry.getValue())) continue;
                    tmpMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (tmpMap.size() == 0) {
                return;
            }
            t = tmpMap;
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            message.setSubject(this.clientSubject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(6, null, t));
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 0, timeout);
                if (responses == null || responses.length < receiveClients.size()) {
                    throw new SharedContextTimeoutException();
                }
            } else if (this.isClient) {
                throw new NoConnectServerException();
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        Iterator entries = t.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (this.isClient) {
                if (!super.containsKey(entry.getKey())) continue;
                Object old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                old = this.unwrapCachedReference(old, false, true);
                if (this.updateListeners == null) continue;
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, entry.getKey(), entry.getValue(), old);
                }
                continue;
            }
            boolean isContainsKey = super.containsKey(entry.getKey());
            Object old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
            old = this.unwrapCachedReference(old, false, true);
            if (isContainsKey) {
                this.removeAllKeyIndex(entry.getKey(), old);
            }
            this.addAllKeyIndex(entry.getKey(), entry.getValue());
            if (this.updateListeners == null) continue;
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, entry.getKey(), entry.getValue(), old);
            }
        }
    }

    public synchronized void putAllLocal(Map t) {
        if (t.size() == 0) {
            return;
        }
        if (this.updateListeners != null) {
            LinkedHashMap tmpMap = new LinkedHashMap();
            Iterator entries = t.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    if (this.isClient && !super.containsKey(entry.getKey()) || !((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, entry.getKey(), entry.getValue())) continue;
                    tmpMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (tmpMap.size() == 0) {
                return;
            }
            t = tmpMap;
        }
        Iterator entries = t.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (this.isClient) {
                if (!super.containsKey(entry.getKey())) continue;
                Object old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                old = this.unwrapCachedReference(old, false, true);
                if (this.updateListeners == null) continue;
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, entry.getKey(), entry.getValue(), old);
                }
                continue;
            }
            boolean isContainsKey = super.containsKey(entry.getKey());
            Object old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
            old = this.unwrapCachedReference(old, false, true);
            if (isContainsKey) {
                this.removeAllKeyIndex(entry.getKey(), old);
            }
            this.addAllKeyIndex(entry.getKey(), entry.getValue());
            if (this.updateListeners == null) continue;
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, entry.getKey(), entry.getValue(), old);
            }
        }
    }

    public synchronized void putAllAsynch(Map t) throws SharedContextSendException {
        if (t.size() == 0) {
            return;
        }
        if (this.updateListeners != null) {
            LinkedHashMap tmpMap = new LinkedHashMap();
            Iterator entries = t.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    if (this.isClient && !super.containsKey(entry.getKey()) || !((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, true, entry.getKey(), entry.getValue())) continue;
                    tmpMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (tmpMap.size() == 0) {
                return;
            }
            t = tmpMap;
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            message.setSubject(this.clientSubject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(6, null, t));
                this.serverConnection.sendAsynch(message);
            } else if (this.isClient) {
                throw new NoConnectServerException();
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        Iterator entries = t.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (this.isClient) {
                if (!super.containsKey(entry.getKey())) continue;
                Object old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                old = this.unwrapCachedReference(old, false, true);
                if (this.updateListeners == null) continue;
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, entry.getKey(), entry.getValue(), old);
                }
                continue;
            }
            boolean isContainsKey = super.containsKey(entry.getKey());
            Object old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
            old = this.unwrapCachedReference(old, false, true);
            if (isContainsKey) {
                this.removeAllKeyIndex(entry.getKey(), old);
            }
            this.addAllKeyIndex(entry.getKey(), entry.getValue());
            if (this.updateListeners == null) continue;
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, true, entry.getKey(), entry.getValue(), old);
            }
        }
    }

    public void clear() throws SharedContextSendException {
        this.clear(this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        Object receiveClients;
        if (this.isMain() && this.size() == 0) {
            return;
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            message.setSubject(this.clientSubject, null);
            receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(3));
                Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 0, timeout);
                if (responses == null || responses.length < receiveClients.size()) {
                    throw new SharedContextTimeoutException();
                }
            } else if (this.isClient) {
                throw new NoConnectServerException();
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        Object[] keys = null;
        receiveClients = this.context;
        synchronized (receiveClients) {
            keys = super.keySet().toArray();
        }
        for (int i = 0; i < keys.length; ++i) {
            int j;
            if (this.updateListeners != null) {
                boolean isRemove = true;
                for (j = 0; j < this.updateListeners.size(); ++j) {
                    if (((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveBefore(this, true, keys[i])) continue;
                    isRemove = false;
                    break;
                }
                if (!isRemove) continue;
            }
            Object removed = super.remove(keys[i]);
            removed = this.unwrapCachedReference(removed, false, true);
            if (!this.isClient) {
                this.removeAllKeyIndex(keys[i], removed);
            }
            if (this.updateListeners == null) continue;
            for (j = 0; j < this.updateListeners.size(); ++j) {
                ((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveAfter(this, true, keys[i], removed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearLocal() {
        if (this.size() == 0) {
            return;
        }
        Object[] keys = null;
        Map map = this.context;
        synchronized (map) {
            keys = super.keySet().toArray();
        }
        for (int i = 0; i < keys.length; ++i) {
            int j;
            if (this.updateListeners != null) {
                boolean isRemove = true;
                for (j = 0; j < this.updateListeners.size(); ++j) {
                    if (((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveBefore(this, true, keys[i])) continue;
                    isRemove = false;
                    break;
                }
                if (!isRemove) continue;
            }
            Object removed = super.remove(keys[i]);
            removed = this.unwrapCachedReference(removed, false, true);
            if (!this.isClient) {
                this.removeAllKeyIndex(keys[i], removed);
            }
            if (this.updateListeners == null) continue;
            for (j = 0; j < this.updateListeners.size(); ++j) {
                ((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveAfter(this, true, keys[i], removed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearAsynch() throws SharedContextSendException {
        Object receiveClients;
        if (this.isMain() && this.size() == 0) {
            return;
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            message.setSubject(this.clientSubject, null);
            receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(3));
                this.serverConnection.sendAsynch(message);
            } else if (this.isClient) {
                throw new NoConnectServerException();
            }
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
        Object[] keys = null;
        receiveClients = this.context;
        synchronized (receiveClients) {
            keys = super.keySet().toArray();
        }
        for (int i = 0; i < keys.length; ++i) {
            int j;
            if (this.updateListeners != null) {
                boolean isRemove = true;
                for (j = 0; j < this.updateListeners.size(); ++j) {
                    if (((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveBefore(this, true, keys[i])) continue;
                    isRemove = false;
                    break;
                }
                if (!isRemove) continue;
            }
            Object removed = super.remove(keys[i]);
            removed = this.unwrapCachedReference(removed, false, true);
            if (!this.isClient) {
                this.removeAllKeyIndex(keys[i], removed);
            }
            if (this.updateListeners == null) continue;
            for (j = 0; j < this.updateListeners.size(); ++j) {
                ((SharedContextUpdateListener)this.updateListeners.get(j)).onRemoveAfter(this, true, keys[i], removed);
            }
        }
    }

    public Object get(Object key) throws SharedContextSendException {
        return this.get(key, this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object get(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        Object result = null;
        if (!this.isClient) {
            return this.getLocal(key);
        }
        if (super.containsKey(key)) {
            result = this.getLocal(key);
            if (result != null) return result;
            if (super.containsKey(key)) return result;
            return this.get(key, timeout);
        }
        ClientCacheLock lock = null;
        ClientCacheLock newLock = null;
        Map map2 = this.clientCacheLockMap;
        // MONITORENTER : map2
        lock = (ClientCacheLock)this.clientCacheLockMap.get(key);
        if (lock == null) {
            newLock = new ClientCacheLock(key);
            this.clientCacheLockMap.put(key, newLock);
        } else {
            lock.init();
        }
        // MONITOREXIT : map2
        if (lock != null) {
            long start = System.currentTimeMillis();
            if (!lock.waitLock(timeout)) {
                throw new SharedContextTimeoutException();
            }
            boolean isNoTimeout = timeout <= 0L;
            timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
            if (isNoTimeout) return this.get(key, timeout);
            if (timeout > 0L) return this.get(key, timeout);
            throw new SharedContextTimeoutException();
        }
        try {
            try {
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() == 0) throw new NoConnectServerException();
                message.setObject(new SharedContextEvent(5, key));
                Message[] responses = this.serverConnection.request(message, this.clientSubject, key == null ? null : key.toString(), 1, timeout);
                if (responses == null) throw new SharedContextTimeoutException();
                if (responses.length <= 0) throw new SharedContextTimeoutException();
                result = responses[0].getObject();
                ClientCacheLock clientCacheLock = newLock;
                // MONITORENTER : clientCacheLock
                if (!newLock.isRemove()) {
                    result = newLock.updateValue(result);
                    super.put(key, this.wrapCachedReference(key, result));
                }
                // MONITOREXIT : clientCacheLock
                Object var13_14 = null;
                Map map = this.clientCacheLockMap;
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
            // MONITORENTER : map
            this.clientCacheLockMap.remove(key);
            newLock.notifyAllLock();
            // MONITOREXIT : map
            return result;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            Map map = this.clientCacheLockMap;
            // MONITORENTER : map
            this.clientCacheLockMap.remove(key);
            newLock.notifyAllLock();
            // MONITOREXIT : map
            throw throwable;
        }
    }

    public Object getLocal(Object key) {
        Object result = this.getRawLocal(key);
        result = this.unwrapCachedReference(result, true, false);
        return result;
    }

    private Object getRawLocal(Object key) {
        Object result = super.get(key);
        if (result == null && !this.isClient && this.contextStore != null && super.containsKey(key)) {
            try {
                this.contextStore.load(this, key);
            }
            catch (Exception e) {
                this.getLogger().write("SCS__00001", new Object[]{key, this.subject}, (Throwable)e);
            }
            result = super.get(key);
        }
        return result;
    }

    public Set searchByKeyIndex(String name, Object key) throws SharedContextIllegalIndexException, SharedContextSendException, SharedContextTimeoutException {
        return this.searchByKeyIndex(name, key, this.defaultTimeout);
    }

    public Set searchByKeyIndex(String name, Object key, long timeout) throws SharedContextIllegalIndexException, SharedContextSendException, SharedContextTimeoutException {
        Set result = null;
        if (this.isClient) {
            try {
                Message[] responses;
                Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
                Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                if (receiveClients.size() != 0) {
                    message.setObject(new SharedContextEvent(22, name, key));
                    responses = this.serverConnection.request(message, this.clientSubject, name, 1, timeout);
                    if (responses == null || responses.length <= 0) {
                        throw new SharedContextTimeoutException();
                    }
                } else {
                    throw new NoConnectServerException();
                }
                result = (Set)responses[0].getObject();
            }
            catch (MessageException e) {
                throw new SharedContextSendException(e);
            }
            catch (MessageSendException e) {
                throw new SharedContextSendException(e);
            }
        } else {
            if (this.keyIndexMap == null || !this.keyIndexMap.containsKey(name)) {
                throw new SharedContextIllegalIndexException("No such keyIndex." + name);
            }
            result = new HashSet();
            Map indexMap = (Map)this.keyIndexResultMap.get(name);
            if (indexMap == null) {
                return result;
            }
            Property[] keyProps = (Property[])this.keyIndexMap.get(name);
            Object[] keys = new Object[keyProps.length];
            for (int i = 0; i < keyProps.length; ++i) {
                try {
                    keys[i] = keyProps[i].getProperty(key);
                    continue;
                }
                catch (NoSuchPropertyException e) {
                    throw new SharedContextIllegalIndexException(e);
                }
                catch (InvocationTargetException e) {
                    throw new SharedContextIllegalIndexException(e);
                }
            }
            IndexKey indexKey = new IndexKey(keys);
            Set keySet = (Set)indexMap.get(indexKey);
            if (keySet == null) {
                return result;
            }
            result.addAll(keySet);
        }
        return result;
    }

    public Set searchByKeyIndexLocal(String name, Object key) throws SharedContextIllegalIndexException {
        if (this.keyIndexMap == null || !this.keyIndexMap.containsKey(name)) {
            throw new SharedContextIllegalIndexException("No such keyIndex." + name);
        }
        HashSet result = new HashSet();
        Map indexMap = (Map)this.keyIndexResultMap.get(name);
        if (indexMap == null) {
            return result;
        }
        Property[] keyProps = (Property[])this.keyIndexMap.get(name);
        Object[] keys = new Object[keyProps.length];
        for (int i = 0; i < keyProps.length; ++i) {
            try {
                keys[i] = keyProps[i].getProperty(key);
                continue;
            }
            catch (NoSuchPropertyException e) {
                throw new SharedContextIllegalIndexException(e);
            }
            catch (InvocationTargetException e) {
                throw new SharedContextIllegalIndexException(e);
            }
        }
        IndexKey indexKey = new IndexKey(keys);
        Set keySet = (Set)indexMap.get(indexKey);
        if (keySet == null) {
            return result;
        }
        result.addAll(keySet);
        result.retainAll(super.keySet());
        return result;
    }

    public Set keySet() throws SharedContextSendException {
        return this.keySet(this.defaultTimeout);
    }

    public synchronized Set keySet(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (!this.isClient) {
            return this.keySetLocal();
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(7));
                Message[] responses = this.serverConnection.request(message, this.clientSubject, null, 1, timeout);
                if (responses != null && responses.length > 0) {
                    return (Set)responses[0].getObject();
                }
                throw new SharedContextTimeoutException();
            }
            throw new NoConnectServerException();
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    public synchronized Set keySetLocal() {
        return super.keySet();
    }

    public int size() throws SharedContextSendException {
        return this.size(this.defaultTimeout);
    }

    public synchronized int size(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (!this.isClient) {
            return this.sizeLocal();
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(8));
                Message[] responses = this.serverConnection.request(message, this.clientSubject, null, 1, timeout);
                if (responses != null && responses.length > 0) {
                    return (Integer)responses[0].getObject();
                }
                throw new SharedContextTimeoutException();
            }
            return this.sizeLocal();
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    public synchronized int sizeLocal() {
        return super.size();
    }

    public boolean isEmpty() throws SharedContextSendException {
        return this.size() == 0;
    }

    public boolean isEmptyLocal() {
        return super.isEmpty();
    }

    public boolean containsKey(Object key) throws SharedContextSendException {
        return this.containsKey(key, this.defaultTimeout);
    }

    public boolean containsKey(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (!this.isClient) {
            return this.containsKeyLocal(key);
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, key == null ? null : key.toString());
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(9, key));
                Message[] responses = this.serverConnection.request(message, this.clientSubject, key == null ? null : key.toString(), 1, timeout);
                if (responses != null && responses.length > 0) {
                    return (Boolean)responses[0].getObject();
                }
                throw new SharedContextTimeoutException();
            }
            throw new NoConnectServerException();
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    public boolean containsKeyLocal(Object key) {
        return super.containsKey(key);
    }

    public boolean containsValue(Object value) throws SharedContextSendException {
        return this.containsValue(value, this.defaultTimeout);
    }

    public boolean containsValue(Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
        if (!this.isClient) {
            return this.containsValueLocal(value);
        }
        try {
            Message message = this.serverConnection.createMessage(this.subject, null);
            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
            if (receiveClients.size() != 0) {
                message.setObject(new SharedContextEvent(10, null, value));
                Message[] responses = this.serverConnection.request(message, this.clientSubject, null, 1, timeout);
                if (responses != null && responses.length > 0) {
                    return (Boolean)responses[0].getObject();
                }
                throw new SharedContextTimeoutException();
            }
            throw new NoConnectServerException();
        }
        catch (MessageException e) {
            throw new SharedContextSendException(e);
        }
        catch (MessageSendException e) {
            throw new SharedContextSendException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValueLocal(Object value) {
        if (this.cacheMap == null) {
            return super.containsValue(value);
        }
        Object[] keys = null;
        Map map = this.context;
        synchronized (map) {
            keys = super.keySet().toArray();
        }
        for (int i = 0; i < keys.length; ++i) {
            Object val = this.cacheMap.get(keys[i]);
            if (!(val == null ? value == null : val.equals(value))) continue;
            return true;
        }
        return false;
    }

    public Collection values() {
        if (!this.isClient) {
            return this.valuesLocal();
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection valuesLocal() {
        if (this.cacheMap == null) {
            return super.values();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] keys = null;
        Map map = this.context;
        synchronized (map) {
            keys = super.keySet().toArray();
        }
        for (int i = 0; i < keys.length; ++i) {
            result.add(this.cacheMap.get(keys[i]));
        }
        return result;
    }

    public Map all() {
        if (!this.isClient) {
            return this.allLocal();
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map allLocal() {
        if (this.cacheMap == null) {
            return super.all();
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Object[] keys = null;
        Map map = this.context;
        synchronized (map) {
            keys = super.keySet().toArray();
        }
        for (int i = 0; i < keys.length; ++i) {
            result.put(keys[i], this.cacheMap.get(keys[i]));
        }
        return result;
    }

    public Set entrySet() {
        if (!this.isClient) {
            return this.entrySetLocal();
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySetLocal() {
        if (this.cacheMap == null) {
            return super.entrySet();
        }
        HashSet<Map.Entry> reuslt = new HashSet<Map.Entry>();
        Map.Entry[] entries = null;
        Map map = this.context;
        synchronized (map) {
            entries = this.cacheMap.entrySet().toArray(new Map.Entry[this.cacheMap.size()]);
        }
        for (int i = 0; i < entries.length; ++i) {
            if (!super.containsKey(entries[i].getKey())) continue;
            reuslt.add(entries[i]);
        }
        return reuslt;
    }

    public boolean isMain() {
        return this.isMain(this.cluster.getMembers());
    }

    protected boolean isMain(List members) {
        if (this.isClient) {
            return false;
        }
        Set targetMembers = this.serverConnection.getReceiveClientIds(this.targetMessage);
        Object myId = this.cluster.getUID();
        int imax = members.size();
        for (int i = 0; i < imax; ++i) {
            Object id = members.get(i);
            if (id.equals(myId)) {
                return true;
            }
            if (!targetMembers.contains(id)) continue;
            return false;
        }
        return true;
    }

    public Object getId() {
        return this.cluster == null ? null : this.cluster.getUID();
    }

    public Object getMainId() {
        if (this.cluster == null) {
            return null;
        }
        Object myId = this.cluster.getUID();
        List members = this.cluster.getMembers();
        Set targetMembers = this.serverConnection.getReceiveClientIds(this.targetMessage);
        int imax = members.size();
        for (int i = 0; i < imax; ++i) {
            Object id = members.get(i);
            if (id.equals(myId)) {
                return myId;
            }
            if (!targetMembers.contains(id)) continue;
            return id;
        }
        return myId;
    }

    public Object executeInterpretQuery(String query, Map variables) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
        return this.executeInterpretQuery(query, variables, this.defaultTimeout);
    }

    public Object executeInterpretQuery(String query, Map variables, long timeout) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
        Object result;
        block8: {
            result = null;
            if (!this.isClient && this.isMain()) {
                result = this.executeInterpretQueryLocal(query, variables);
            } else {
                try {
                    Message message = this.serverConnection.createMessage(this.subject, null);
                    Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                    if (receiveClients.size() != 0) {
                        message.setObject(new SharedContextEvent(23, query, variables));
                        Message[] responses = this.serverConnection.request(message, this.isClient ? this.clientSubject : this.subject, null, 1, timeout);
                        if (responses != null && responses.length != 0) {
                            result = responses[0].getObject();
                            if (result != null && result instanceof Throwable) {
                                throw new SharedContextSendException((Throwable)result);
                            }
                            break block8;
                        }
                        throw new SharedContextTimeoutException();
                    }
                    throw new NoConnectServerException();
                }
                catch (MessageException e) {
                    throw new SharedContextSendException(e);
                }
                catch (MessageSendException e) {
                    throw new SharedContextSendException(e);
                }
            }
        }
        return result;
    }

    protected Object executeInterpretQueryLocal(String evaluate, Map variables) throws EvaluateException {
        if (this.interpreter == null) {
            throw new EvaluateException("Interpreter is null.");
        }
        if (variables == null) {
            variables = new HashMap<String, LocalSharedContext>();
        }
        variables.put("context", new LocalSharedContext());
        return this.interpreter.evaluate(evaluate, variables);
    }

    public void addSharedContextUpdateListener(SharedContextUpdateListener listener) {
        if (this.updateListeners == null) {
            this.updateListeners = Collections.synchronizedList(new ArrayList());
        }
        if (!this.updateListeners.contains(listener)) {
            this.updateListeners.add(listener);
        }
    }

    public void removeSharedContextUpdateListener(SharedContextUpdateListener listener) {
        if (this.updateListeners == null) {
            return;
        }
        this.updateListeners.remove(listener);
    }

    public void memberInit(Object myId, List members) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberChange(List oldMembers, List newMembers) {
        if (this.isClient) {
            Set targetMembers;
            if (this.sizeLocal() != 0 && (targetMembers = this.serverConnection.getReceiveClientIds(this.targetMessage)).size() == 0) {
                this.clearLocal();
            }
        } else if (this.isMain(newMembers)) {
            HashSet deadMembers = new HashSet(oldMembers);
            deadMembers.removeAll(newMembers);
            if (deadMembers.size() != 0) {
                Iterator ids = deadMembers.iterator();
                while (ids.hasNext()) {
                    Object id = ids.next();
                    Set keySet = (Set)this.idLocksMap.remove(id);
                    if (keySet == null || keySet.size() == 0) continue;
                    Set set = keySet;
                    synchronized (set) {
                        Iterator keys = keySet.iterator();
                        while (keys.hasNext()) {
                            try {
                                this.unlock(keys.next(), true);
                            }
                            catch (SharedContextSendException e) {}
                        }
                    }
                }
            }
        }
    }

    public void changeMain() throws Exception {
    }

    public void changeSub() {
    }

    public void removed(CachedReference ref) {
        if (ref == null) {
            return;
        }
        KeyCachedReference kcr = (KeyCachedReference)ref;
        Object removed = this.isClient ? super.remove(kcr.getKey()) : super.put(kcr.getKey(), (Object)null);
        removed = this.unwrapCachedReference(removed, false, true);
        if (this.isClient) {
            this.removeAllKeyIndex(kcr.getKey(), removed);
        }
    }

    public void onMessage(Message message) {
        SharedContextEvent event = null;
        try {
            event = (SharedContextEvent)message.getObject();
        }
        catch (MessageException e) {
            e.printStackTrace();
            return;
        }
        switch (event.type) {
            case 1: {
                this.onPut(event, null, null);
                break;
            }
            case 6: {
                this.onPutAll(event, null, null);
                break;
            }
            case 2: {
                this.onRemove(event, null, null);
                break;
            }
            case 3: {
                this.onClear(event, null, null);
                break;
            }
            case 14: {
                this.onReleaseLock(event, null, null);
                break;
            }
            case 18: {
                this.onUpdate(event, null, null);
                break;
            }
            case 20: {
                this.onPutInner(event);
                break;
            }
        }
    }

    public Message onRequestMessage(Object sourceId, int sequence, Message message, String responseSubject, String responseKey) {
        SharedContextEvent event = null;
        try {
            event = (SharedContextEvent)message.getObject();
        }
        catch (MessageException e) {
            e.printStackTrace();
            return null;
        }
        Message result = null;
        switch (event.type) {
            case 1: {
                result = this.onPut(event, responseSubject, responseKey);
                break;
            }
            case 6: {
                result = this.onPutAll(event, responseSubject, responseKey);
                break;
            }
            case 2: {
                result = this.onRemove(event, responseSubject, responseKey);
                break;
            }
            case 3: {
                result = this.onClear(event, responseSubject, responseKey);
                break;
            }
            case 5: {
                result = this.onGet(event, responseSubject, responseKey);
                break;
            }
            case 4: {
                result = this.onGetAll(event, responseSubject, responseKey);
                break;
            }
            case 7: {
                result = this.onKeySet(event, responseSubject, responseKey);
                break;
            }
            case 8: {
                result = this.onSize(event, responseSubject, responseKey);
                break;
            }
            case 9: {
                result = this.onContainsKey(event, responseSubject, responseKey);
                break;
            }
            case 10: {
                result = this.onContainsValue(event, responseSubject, responseKey);
                break;
            }
            case 11: {
                result = this.onSynchronizeAll(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 19: {
                result = this.onSynchronize(event, responseSubject, responseKey);
                break;
            }
            case 12: {
                result = this.onGetLock(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 13: {
                result = this.onGotLock(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 15: {
                result = this.onSave(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 16: {
                result = this.onLoad(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 17: {
                result = this.onLoadKey(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
            case 18: {
                result = this.onUpdate(event, responseSubject, responseKey);
                break;
            }
            case 21: {
                result = this.onAnalyzeKeyIndex(event, responseSubject, responseKey);
                break;
            }
            case 22: {
                result = this.onSearchKeyIndex(event, responseSubject, responseKey);
                break;
            }
            case 23: {
                this.onExecuteInterpret(event, sourceId, sequence, responseSubject, responseKey);
                break;
            }
        }
        return result;
    }

    protected Message createResponseMessage(String responseSubject, String responseKey, Object response) {
        Message result = null;
        try {
            result = this.serverConnection.createMessage(responseSubject, responseKey);
            result.setObject(response);
        }
        catch (MessageException e) {
            this.getLogger().write("SCS__00002", new Object[]{this.isClient ? this.clientSubject : this.subject, responseSubject, responseKey, response}, (Throwable)e);
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onPut(SharedContextEvent event, String responseSubject, String responseKey) {
        Object result = null;
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, false, event.key, event.value)) continue;
                return this.createResponseMessage(responseSubject, responseKey, null);
            }
        }
        Object old = null;
        if (this.isClient) {
            if (super.containsKey(event.key)) {
                old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
                old = this.unwrapCachedReference(old, false, true);
            } else if (this.clientCacheLockMap.containsKey(event.key)) {
                ClientCacheLock lock = null;
                Object object = this.clientCacheLockMap;
                synchronized (object) {
                    lock = (ClientCacheLock)this.clientCacheLockMap.get(event.key);
                }
                if (lock != null) {
                    object = lock;
                    synchronized (object) {
                        if (super.containsKey(event.key)) {
                            old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
                            old = this.unwrapCachedReference(old, false, true);
                        } else {
                            lock.put(event.value);
                        }
                    }
                }
            }
        } else {
            boolean isContainsKey = super.containsKey(event.key);
            old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
            old = this.unwrapCachedReference(old, false, true);
            if (isContainsKey) {
                this.removeAllKeyIndex(event.key, old);
            }
            this.addAllKeyIndex(event.key, event.value);
            if (this.isMain()) {
                result = old;
            }
        }
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, false, event.key, event.value, old);
            }
        }
        return this.createResponseMessage(responseSubject, responseKey, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onPutAll(SharedContextEvent event, String responseSubject, String responseKey) {
        Map map = (Map)event.key;
        if (map != null) {
            Iterator entries = map.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                boolean isPut = true;
                if (this.updateListeners != null) {
                    for (int i = 0; i < this.updateListeners.size(); ++i) {
                        if (((SharedContextUpdateListener)this.updateListeners.get(i)).onPutBefore(this, false, entry.getKey(), entry.getValue())) continue;
                        isPut = false;
                        break;
                    }
                }
                if (!isPut) continue;
                Object old = null;
                if (this.isClient) {
                    if (super.containsKey(entry.getKey())) {
                        old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                        old = this.unwrapCachedReference(old, false, true);
                    } else if (this.clientCacheLockMap.containsKey(entry.getKey())) {
                        ClientCacheLock lock = null;
                        Object object = this.clientCacheLockMap;
                        synchronized (object) {
                            lock = (ClientCacheLock)this.clientCacheLockMap.get(entry.getKey());
                        }
                        if (lock != null) {
                            object = lock;
                            synchronized (object) {
                                if (super.containsKey(entry.getKey())) {
                                    old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                                    old = this.unwrapCachedReference(old, false, true);
                                } else {
                                    lock.put(entry.getValue());
                                }
                            }
                        }
                    }
                } else {
                    boolean isContainsKey = super.containsKey(entry.getKey());
                    old = super.put(entry.getKey(), this.wrapCachedReference(entry.getKey(), entry.getValue()));
                    old = this.unwrapCachedReference(old, false, true);
                    if (isContainsKey) {
                        this.removeAllKeyIndex(entry.getKey(), old);
                    }
                    this.addAllKeyIndex(entry.getKey(), entry.getValue());
                }
                if (this.updateListeners == null) continue;
                for (int i = 0; i < this.updateListeners.size(); ++i) {
                    ((SharedContextUpdateListener)this.updateListeners.get(i)).onPutAfter(this, false, entry.getKey(), entry.getValue(), old);
                }
            }
        }
        return this.createResponseMessage(responseSubject, responseKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPutInner(SharedContextEvent event) {
        Object old = null;
        if (this.isClient) {
            if (super.containsKey(event.key)) {
                old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
                old = this.unwrapCachedReference(old, false, true);
            } else if (this.clientCacheLockMap.containsKey(event.key)) {
                ClientCacheLock lock = null;
                Object object = this.clientCacheLockMap;
                synchronized (object) {
                    lock = (ClientCacheLock)this.clientCacheLockMap.get(event.key);
                }
                if (lock != null) {
                    object = lock;
                    synchronized (object) {
                        if (super.containsKey(event.key)) {
                            old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
                            old = this.unwrapCachedReference(old, false, true);
                        } else {
                            lock.put(event.value);
                        }
                    }
                }
            }
        } else {
            boolean isContainsKey = super.containsKey(event.key);
            old = super.put(event.key, this.wrapCachedReference(event.key, event.value));
            old = this.unwrapCachedReference(old, false, true);
            if (isContainsKey) {
                this.removeAllKeyIndex(event.key, old);
            }
            this.addAllKeyIndex(event.key, event.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Message onUpdate(final SharedContextEvent event, String responseSubject, String responseKey) {
        block41: {
            block38: {
                block42: {
                    block39: {
                        block40: {
                            if (this.updateListeners != null) {
                                for (i = 0; i < this.updateListeners.size(); ++i) {
                                    if (((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateBefore(this, false, event.key, (SharedContextValueDifference)event.value)) continue;
                                    return this.createResponseMessage(responseSubject, responseKey, null);
                                }
                            }
                            if (this.isClient && !super.containsKey(event.key)) break block38;
                            current = this.getRawLocal(event.key);
                            currentValue = this.unwrapCachedReference(current, false, false);
                            if (currentValue != null) break block39;
                            if (!this.isClient) break block40;
                            removed = super.remove(event.key);
                            removed = this.unwrapCachedReference(removed, false, true);
                            break block41;
                        }
                        return this.createResponseMessage(responseSubject, responseKey, new SharedContextUpdateException("Current value is null. key=" + event.key));
                    }
                    if (!(currentValue instanceof SharedContextValueDifferenceSupport)) break block42;
                    try {
                        isSuccess = false;
                        try {
                            isSuccess = ((SharedContextValueDifferenceSupport)currentValue).update((SharedContextValueDifference)event.value);
                            if (!isSuccess) {
                                if (this.isClient) {
                                    this.getLogger().write("SCS__00003", new Object[]{this.clientSubject, event.key});
                                } else if (!this.isMain()) {
                                    this.getLogger().write("SCS__00004", new Object[]{this.subject, event.key});
                                } else {
                                    this.getLogger().write("SCS__00005", new Object[]{this.subject, event.key});
                                }
                            }
                        }
                        catch (SharedContextUpdateException e) {
                            if (this.isClient) {
                                this.getLogger().write("SCS__00003", new Object[]{this.clientSubject, event.key}, (Throwable)e);
                            }
                            if (!this.isMain()) {
                                this.getLogger().write("SCS__00004", new Object[]{this.subject, event.key}, (Throwable)e);
                            }
                            this.getLogger().write("SCS__00005", new Object[]{this.subject, event.key}, (Throwable)e);
                        }
                        if (isSuccess) {
                            if (!(current instanceof CachedReference)) ** GOTO lbl113
                            try {
                                ((CachedReference)current).set(this, currentValue);
                            }
                            catch (IllegalCachedReferenceException e) {
                                throw new SharedContextUpdateException(e);
                            }
                        }
                        if (this.isClient) {
                            removed = super.remove(event.key);
                            removed = this.unwrapCachedReference(removed, false, true);
                        }
                        if (!this.isMain()) {
                            message = this.serverConnection.createMessage(this.subject, event.key == null ? null : event.key.toString());
                            message.setObject(new SharedContextEvent(19, event.key));
                            this.serverConnection.request(message, this.isClient != false ? this.clientSubject : this.subject, event.key == null ? null : event.key.toString(), 1, 0L, new RequestServerConnection.ResponseCallBack(){

                                public void onResponse(Message message, boolean isLast) {
                                    SharedContextService.this.onMessage(message);
                                    if (SharedContextService.this.updateListeners != null) {
                                        for (int i = 0; i < SharedContextService.this.updateListeners.size(); ++i) {
                                            ((SharedContextUpdateListener)SharedContextService.this.updateListeners.get(i)).onUpdateAfter(SharedContextService.this, false, event.key, (SharedContextValueDifference)event.value);
                                        }
                                    }
                                }
                            });
                            return this.createResponseMessage(responseSubject, responseKey, null);
                        }
                        throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)currentValue).getUpdateVersion() + ", updateVersion=" + ((SharedContextValueDifference)event.value).getUpdateVersion());
                    }
                    catch (Throwable th) {
                        this.getLogger().write("SCS__00005", new Object[]{this.isClient != false ? this.clientSubject : this.subject, event.key}, th);
                        return this.createResponseMessage(responseSubject, responseKey, th);
                    }
                }
                e = new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + event.key + ", value=" + currentValue);
                this.getLogger().write("SCS__00005", new Object[]{this.isClient != false ? this.clientSubject : this.subject, event.key}, (Throwable)e);
                return this.createResponseMessage(responseSubject, responseKey, e);
            }
            if (!this.isClient || !this.clientCacheLockMap.containsKey(event.key)) break block41;
            lock = null;
            var5_8 = this.clientCacheLockMap;
            synchronized (var5_8) {
                lock = (ClientCacheLock)this.clientCacheLockMap.get(event.key);
            }
            if (lock == null) break block41;
            var5_8 = lock;
            synchronized (var5_8) {
                if (!super.containsKey(event.key)) ** GOTO lbl109
                current = this.getRawLocal(event.key);
                currentValue = this.unwrapCachedReference(current, false, false);
                if (currentValue == null) {
                    removed = super.remove(event.key);
                    removed = this.unwrapCachedReference(removed, false, true);
                } else if (currentValue instanceof SharedContextValueDifferenceSupport) {
                    try {
                        isSuccess = false;
                        try {
                            isSuccess = ((SharedContextValueDifferenceSupport)currentValue).update((SharedContextValueDifference)event.value);
                            if (!isSuccess) {
                                this.getLogger().write("SCS__00003", new Object[]{this.clientSubject, event.key});
                            }
                        }
                        catch (SharedContextUpdateException e) {
                            this.getLogger().write("SCS__00003", new Object[]{this.clientSubject, event.key}, (Throwable)e);
                        }
                        if (isSuccess) {
                            if (!(current instanceof CachedReference)) ** GOTO lbl113
                            try {
                                ((CachedReference)current).set(this, currentValue);
                            }
                            catch (IllegalCachedReferenceException e) {
                                throw new SharedContextUpdateException(e);
                            }
                        }
                        removed = super.remove(event.key);
                        removed = this.unwrapCachedReference(removed, false, true);
                    }
                    catch (Throwable th) {
                        this.getLogger().write("SCS__00005", new Object[]{this.isClient != false ? this.clientSubject : this.subject, event.key}, th);
                        return this.createResponseMessage(responseSubject, responseKey, th);
                    }
                } else {
                    e = new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + event.key + ", value=" + currentValue);
                    this.getLogger().write("SCS__00005", new Object[]{this.isClient != false ? this.clientSubject : this.subject, event.key}, (Throwable)e);
                    return this.createResponseMessage(responseSubject, responseKey, e);
lbl109:
                    // 1 sources

                    lock.update((SharedContextValueDifference)event.value);
                }
            }
        }
        if (this.updateListeners != null) {
            for (i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onUpdateAfter(this, false, event.key, (SharedContextValueDifference)event.value);
            }
        }
        return this.createResponseMessage(responseSubject, responseKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onRemove(SharedContextEvent event, String responseSubject, String responseKey) {
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                if (((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveBefore(this, false, event.key)) continue;
                return this.createResponseMessage(responseSubject, responseKey, null);
            }
        }
        if (this.isClient && this.clientCacheLockMap.containsKey(event.key)) {
            ClientCacheLock lock = null;
            Object object = this.clientCacheLockMap;
            synchronized (object) {
                lock = (ClientCacheLock)this.clientCacheLockMap.get(event.key);
            }
            if (lock != null) {
                object = lock;
                synchronized (object) {
                    lock.remove();
                }
            }
        }
        Object removed = super.remove(event.key);
        removed = this.unwrapCachedReference(removed, false, true);
        this.removeAllKeyIndex(event.key, removed);
        if (this.updateListeners != null) {
            for (int i = 0; i < this.updateListeners.size(); ++i) {
                ((SharedContextUpdateListener)this.updateListeners.get(i)).onRemoveAfter(this, false, event.key, removed);
            }
        }
        return this.createResponseMessage(responseSubject, responseKey, this.isMain() ? removed : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onClear(SharedContextEvent event, String responseSubject, String responseKey) {
        Object[] keys = null;
        Map map = this.context;
        synchronized (map) {
            keys = super.keySet().toArray();
        }
        for (int i = 0; i < keys.length; ++i) {
            int j2;
            if (this.updateListeners != null) {
                boolean isRemove = true;
                for (j2 = 0; j2 < this.updateListeners.size(); ++j2) {
                    if (((SharedContextUpdateListener)this.updateListeners.get(j2)).onRemoveBefore(this, false, keys[i])) continue;
                    isRemove = false;
                    break;
                }
                if (!isRemove) continue;
            }
            if (this.isClient && this.clientCacheLockMap.containsKey(keys[i])) {
                ClientCacheLock lock = null;
                Object j2 = this.clientCacheLockMap;
                synchronized (j2) {
                    lock = (ClientCacheLock)this.clientCacheLockMap.get(keys[i]);
                }
                if (lock != null) {
                    j2 = lock;
                    synchronized (j2) {
                        lock.remove();
                    }
                }
            }
            Object removed = super.remove(keys[i]);
            removed = this.unwrapCachedReference(removed, false, true);
            this.removeAllKeyIndex(keys[i], removed);
            if (this.updateListeners == null) continue;
            for (j2 = 0; j2 < this.updateListeners.size(); ++j2) {
                ((SharedContextUpdateListener)this.updateListeners.get(j2)).onRemoveAfter(this, false, event.key, removed);
            }
        }
        return this.createResponseMessage(responseSubject, responseKey, null);
    }

    protected Message onGet(SharedContextEvent event, String responseSubject, String responseKey) {
        if (this.isMain()) {
            return this.createResponseMessage(responseSubject, responseKey, this.getLocal(event.key));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onGetAll(SharedContextEvent event, String responseSubject, String responseKey) {
        if (this.isMain()) {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            Map map = this.context;
            synchronized (map) {
                if (this.cacheMap == null) {
                    result.putAll(this.context);
                } else {
                    Object[] keys = null;
                    Map map2 = this.context;
                    synchronized (map2) {
                        keys = super.keySet().toArray();
                    }
                    for (int i = 0; i < keys.length; ++i) {
                        if (!this.cacheMap.containsKey(keys[i])) continue;
                        result.put(keys[i], this.cacheMap.get(keys[i]));
                    }
                }
            }
            return this.createResponseMessage(responseSubject, responseKey, result);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onKeySet(SharedContextEvent event, String responseSubject, String responseKey) {
        if (this.isMain()) {
            HashSet result = new HashSet();
            Map map = this.context;
            synchronized (map) {
                result.addAll(this.context.keySet());
            }
            return this.createResponseMessage(responseSubject, responseKey, result);
        }
        return null;
    }

    protected Message onSize(SharedContextEvent event, String responseSubject, String responseKey) {
        if (this.isMain()) {
            return this.createResponseMessage(responseSubject, responseKey, new Integer(this.size()));
        }
        return null;
    }

    protected Message onContainsKey(SharedContextEvent event, String responseSubject, String responseKey) {
        if (this.isMain()) {
            return this.createResponseMessage(responseSubject, responseKey, this.containsKey(event.key) ? Boolean.TRUE : Boolean.FALSE);
        }
        return null;
    }

    protected Message onContainsValue(SharedContextEvent event, String responseSubject, String responseKey) {
        if (this.isMain()) {
            return this.createResponseMessage(responseSubject, responseKey, this.containsValue(event.value) ? Boolean.TRUE : Boolean.FALSE);
        }
        return null;
    }

    protected Message onSynchronizeAll(final SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        Thread synchronizeThread = new Thread(){

            public void run() {
                Message response = null;
                try {
                    SharedContextService.this.synchronize((Long)event.value);
                    response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, Boolean.TRUE);
                }
                catch (SharedContextSendException e) {
                    response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, Boolean.FALSE);
                }
                catch (SharedContextTimeoutException e) {
                    response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, Boolean.FALSE);
                }
                try {
                    SharedContextService.this.serverConnection.response(sourceId, sequence, response);
                }
                catch (MessageSendException e) {
                    SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                }
            }
        };
        synchronizeThread.start();
        return null;
    }

    protected Message onSynchronize(SharedContextEvent event, String responseSubject, String responseKey) {
        if (this.isClient || !this.isMain()) {
            return null;
        }
        if (this.containsKeyLocal(event.key)) {
            return this.createResponseMessage(responseSubject, responseKey, new SharedContextEvent(20, event.key, this.getLocal(event.key)));
        }
        return this.createResponseMessage(responseSubject, responseKey, new SharedContextEvent(2, event.key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onGetLock(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain()) {
            Object result;
            block15: {
                result = null;
                Lock lock = null;
                Map map = this.keyLockMap;
                synchronized (map) {
                    lock = (Lock)this.keyLockMap.get(event.key);
                    if (lock == null) {
                        lock = new Lock(event.key);
                        this.keyLockMap.put(event.key, lock);
                    }
                }
                long timeout = (Long)event.value;
                long start = System.currentTimeMillis();
                if (lock.acquireForReply(sourceId, timeout, sourceId, sequence, responseSubject, responseKey)) {
                    boolean isNoTimeout = timeout <= 0L;
                    long l = timeout = isNoTimeout ? timeout : timeout - (System.currentTimeMillis() - start);
                    if (!isNoTimeout && timeout <= 0L) {
                        lock.release(sourceId, false);
                        result = Boolean.FALSE;
                    } else {
                        try {
                            Message message = this.serverConnection.createMessage(this.subject, event.key == null ? null : event.key.toString());
                            message.setSubject(this.clientSubject, event.key == null ? null : event.key.toString());
                            Set receiveClients = this.serverConnection.getReceiveClientIds(message);
                            receiveClients.remove(sourceId);
                            result = Boolean.TRUE;
                            if (receiveClients.size() == 0) break block15;
                            message.setDestinationIds(receiveClients);
                            message.setObject(new SharedContextEvent(13, event.key, new Object[]{sourceId, new Long(timeout)}));
                            Message[] responses = this.serverConnection.request(message, 0, timeout);
                            if (responses != null && responses.length >= receiveClients.size()) {
                                for (int i = 0; i < responses.length; ++i) {
                                    Object ret = responses[i].getObject();
                                    if (ret != null && !(ret instanceof Throwable) && ((Boolean)ret).booleanValue()) continue;
                                    this.unlock(event.key);
                                    result = ret;
                                    break block15;
                                }
                                break block15;
                            }
                            this.unlock(event.key);
                            result = Boolean.FALSE;
                        }
                        catch (Throwable th) {
                            try {
                                this.unlock(event.key);
                            }
                            catch (SharedContextSendException e) {
                                this.getLogger().write("SCS__00007", new Object[]{this.isClient ? this.clientSubject : this.subject, event.key}, (Throwable)e);
                            }
                            result = th;
                        }
                    }
                } else {
                    return null;
                }
            }
            return this.createResponseMessage(responseSubject, responseKey, result);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onGotLock(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(event.key);
            if (lock == null) {
                lock = new Lock(event.key);
                this.keyLockMap.put(event.key, lock);
            }
        }
        Object[] params = (Object[])event.value;
        Object id = params[0];
        long timeout = (Long)params[1];
        try {
            if (lock.acquireForReply(id, timeout, sourceId, sequence, responseSubject, responseKey)) {
                return this.createResponseMessage(responseSubject, responseKey, Boolean.TRUE);
            }
            return null;
        }
        catch (Throwable th) {
            lock.release(id, false);
            return this.createResponseMessage(responseSubject, responseKey, th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message onReleaseLock(SharedContextEvent event, String responseSubject, String responseKey) {
        Lock lock = null;
        Map map = this.keyLockMap;
        synchronized (map) {
            lock = (Lock)this.keyLockMap.get(event.key);
        }
        if (lock != null) {
            lock.release(event.value, true);
        }
        return this.createResponseMessage(responseSubject, responseKey, null);
    }

    protected Message onSave(final SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (!(this.isClient || !this.isMain() && this.isSaveOnlyMain)) {
            Thread saveThread = new Thread(){

                public void run() {
                    Message response = null;
                    try {
                        if (event.key == null) {
                            SharedContextService.super.save();
                        } else {
                            SharedContextService.super.save(event.key);
                        }
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        SharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            saveThread.start();
        }
        return null;
    }

    protected Message onLoad(final SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain()) {
            Thread loadThread = new Thread(){

                public void run() {
                    Message response = null;
                    try {
                        if (event.key == null) {
                            SharedContextService.super.load();
                        } else {
                            SharedContextService.super.load(event.key);
                        }
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        SharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            loadThread.start();
        }
        return null;
    }

    protected Message onLoadKey(SharedContextEvent event, final Object sourceId, final int sequence, final String responseSubject, final String responseKey) {
        if (this.isMain()) {
            Thread loadThread = new Thread(){

                public void run() {
                    Message response = null;
                    try {
                        SharedContextService.super.loadKey();
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, null);
                    }
                    catch (Throwable th) {
                        response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                    }
                    try {
                        SharedContextService.this.serverConnection.response(sourceId, sequence, response);
                    }
                    catch (MessageSendException e) {
                        SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                    }
                }
            };
            loadThread.start();
        }
        return null;
    }

    protected Message onAnalyzeKeyIndex(SharedContextEvent event, String responseSubject, String responseKey) {
        if (this.isClient) {
            return null;
        }
        try {
            this.analyzeKeyIndex((String)event.key);
            return this.createResponseMessage(responseSubject, responseKey, null);
        }
        catch (Throwable th) {
            this.getLogger().write("SCS__00008", new Object[]{this.isClient ? this.clientSubject : this.subject, event.key}, th);
            return this.createResponseMessage(responseSubject, responseKey, th);
        }
    }

    protected Message onSearchKeyIndex(SharedContextEvent event, String responseSubject, String responseKey) {
        if (this.isMain()) {
            return this.createResponseMessage(responseSubject, responseKey, this.searchByKeyIndex((String)event.key, event.value));
        }
        return null;
    }

    protected void onExecuteInterpret(SharedContextEvent event, Object sourceId, int sequence, String responseSubject, String responseKey) {
        if (this.isMain()) {
            this.executeQueueHandlerContainer.push(new AsynchContext(new Object[]{event.key, event.value, responseSubject, responseKey, sourceId, new Integer(sequence)}));
        }
    }

    protected class LocalSharedContext
    implements SharedContext {
        protected LocalSharedContext() {
        }

        public void lock(Object key) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public void lock(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public boolean unlock(Object key) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        public boolean unlock(Object key, boolean force) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        public Object getLockOwner(Object key) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public Object putLocal(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void putAsynch(Object key, Object value) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        public void update(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        public void update(Object key, SharedContextValueDifference diff, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public void updateLocal(Object key, SharedContextValueDifference diff) {
            throw new UnsupportedOperationException();
        }

        public void updateAsynch(Object key, SharedContextValueDifference diff) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public void putAllLocal(Map t) {
            throw new UnsupportedOperationException();
        }

        public void putAllAsynch(Map t) throws SharedContextSendException {
            throw new UnsupportedOperationException();
        }

        public Object get(Object key) {
            return SharedContextService.this.getLocal(key);
        }

        public Object get(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.getLocal(key);
        }

        public Object getLocal(Object key) {
            return SharedContextService.this.getLocal(key);
        }

        public Object remove(Object key) {
            return SharedContextService.this.removeLocal(key);
        }

        public Object remove(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.removeLocal(key);
        }

        public Object removeLocal(Object key) {
            return SharedContextService.this.removeLocal(key);
        }

        public void removeAsynch(Object key) throws SharedContextSendException {
            SharedContextService.this.removeLocal(key);
        }

        public void clear() {
            SharedContextService.this.clearLocal();
        }

        public void clear(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            SharedContextService.this.clearLocal();
        }

        public void clearLocal() {
            SharedContextService.this.clearLocal();
        }

        public void clearAsynch() throws SharedContextSendException {
            SharedContextService.this.clearLocal();
        }

        public Set keySet() {
            return SharedContextService.this.keySetLocal();
        }

        public Set keySet(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.keySetLocal();
        }

        public Set keySetLocal() {
            return SharedContextService.this.keySetLocal();
        }

        public int size() {
            return SharedContextService.this.sizeLocal();
        }

        public int size(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.sizeLocal();
        }

        public int sizeLocal() {
            return SharedContextService.this.sizeLocal();
        }

        public boolean isEmpty() throws SharedContextSendException {
            return SharedContextService.this.isEmptyLocal();
        }

        public boolean isEmptyLocal() {
            return SharedContextService.this.isEmptyLocal();
        }

        public boolean containsKey(Object key) {
            return SharedContextService.this.containsKeyLocal(key);
        }

        public boolean containsKey(Object key, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.containsKeyLocal(key);
        }

        public boolean containsKeyLocal(Object key) {
            return SharedContextService.this.containsKeyLocal(key);
        }

        public boolean containsValue(Object value) {
            return SharedContextService.this.containsValueLocal(value);
        }

        public boolean containsValue(Object value, long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.containsValueLocal(value);
        }

        public boolean containsValueLocal(Object value) {
            return SharedContextService.this.containsValueLocal(value);
        }

        public Map all() {
            return SharedContextService.this.allLocal();
        }

        public Map allLocal() {
            return SharedContextService.this.allLocal();
        }

        public Set entrySet() {
            return SharedContextService.this.entrySetLocal();
        }

        public Set entrySetLocal() {
            return SharedContextService.this.entrySetLocal();
        }

        public Collection values() {
            return SharedContextService.this.valuesLocal();
        }

        public Collection valuesLocal() {
            return SharedContextService.this.valuesLocal();
        }

        public void synchronize() throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public void synchronize(long timeout) throws SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public boolean isClient() {
            return SharedContextService.this.isClient();
        }

        public boolean isMain() {
            return SharedContextService.this.isMain();
        }

        public Object getId() {
            return SharedContextService.this.getId();
        }

        public Object getMainId() {
            return SharedContextService.this.getMainId();
        }

        public void addSharedContextUpdateListener(SharedContextUpdateListener listener) {
            SharedContextService.this.addSharedContextUpdateListener(listener);
        }

        public void removeSharedContextUpdateListener(SharedContextUpdateListener listener) {
            SharedContextService.this.removeSharedContextUpdateListener(listener);
        }

        public void setKeyIndex(String name, String[] keyProps) throws SharedContextIllegalIndexException {
            throw new UnsupportedOperationException();
        }

        public void analyzeKeyIndex(String name) throws SharedContextIllegalIndexException, SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public Set searchByKeyIndex(String name, Object key) throws SharedContextIllegalIndexException, SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.searchByKeyIndexLocal(name, key);
        }

        public Set searchByKeyIndex(String name, Object key, long timeout) throws SharedContextIllegalIndexException, SharedContextSendException, SharedContextTimeoutException {
            return SharedContextService.this.searchByKeyIndexLocal(name, key);
        }

        public Set searchByKeyIndexLocal(String name, Object key) throws SharedContextIllegalIndexException {
            return SharedContextService.this.searchByKeyIndexLocal(name, key);
        }

        public Object executeInterpretQuery(String query, Map variables) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public Object executeInterpretQuery(String query, Map variables, long timeout) throws EvaluateException, SharedContextSendException, SharedContextTimeoutException {
            throw new UnsupportedOperationException();
        }

        public void load() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void loadKey() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void load(Object key) throws Exception {
            throw new UnsupportedOperationException();
        }

        public void save() throws Exception {
            throw new UnsupportedOperationException();
        }

        public void save(Object key) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExecuteQueueHandler
    implements QueueHandler {
        protected ExecuteQueueHandler() {
        }

        public void handleDequeuedObject(Object obj) throws Throwable {
            AsynchContext ac = (AsynchContext)obj;
            if (ac == null) {
                return;
            }
            Object[] params = (Object[])ac.getInput();
            String query = (String)params[0];
            Map variables = (Map)params[1];
            String responseSubject = (String)params[2];
            String responseKey = (String)params[3];
            Object sourceId = params[4];
            int sequence = (Integer)params[5];
            Object ret = SharedContextService.this.executeInterpretQueryLocal(query, variables);
            Message response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, ret);
            try {
                SharedContextService.this.serverConnection.response(sourceId, sequence, response);
            }
            catch (MessageSendException e) {
                SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
            }
        }

        public boolean handleError(Object obj, Throwable th) throws Throwable {
            return false;
        }

        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            AsynchContext ac = (AsynchContext)obj;
            Object[] params = (Object[])ac.getInput();
            String responseSubject = (String)params[2];
            String responseKey = (String)params[3];
            Object sourceId = params[4];
            int sequence = (Integer)params[5];
            Message response = null;
            try {
                response = SharedContextService.this.createResponseMessage(responseSubject, responseKey, th);
                SharedContextService.this.serverConnection.response(sourceId, sequence, response);
            }
            catch (MessageSendException e) {
                SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
            }
        }
    }

    protected static class IndexKey
    implements Serializable {
        private static final long serialVersionUID = -6040174467896232277L;
        private Object[] keys;

        public IndexKey(Object[] keys) {
            this.keys = keys;
        }

        public int hashCode() {
            int hashCode = 0;
            for (int i = 0; i < this.keys.length; ++i) {
                hashCode += this.keys[i] == null ? 0 : this.keys[i].hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object target) {
            if (target == null) {
                return false;
            }
            IndexKey targetKey = (IndexKey)target;
            if (targetKey == this) {
                return true;
            }
            if (this.keys.length != targetKey.keys.length) {
                return false;
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == null && targetKey.keys[i] != null) {
                    return false;
                }
                if (this.keys[i] == null || this.keys[i].equals(targetKey.keys[i])) continue;
                return false;
            }
            return true;
        }
    }

    protected class ClientCacheLock {
        private final SynchronizeMonitor monitor = new WaitSynchronizeMonitor();
        private Object key;
        private Object putVlaue;
        private List updateDiffList;
        private boolean isRemove;
        private boolean isNotify;

        public ClientCacheLock(Object key) {
            this.key = key;
        }

        public void init() {
            this.monitor.initMonitor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitLock(long timeout) {
            if (this.isNotify) {
                return true;
            }
            try {
                if (this.monitor.waitMonitor(timeout)) {
                    if (SharedContextService.this.getState() != 3) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.monitor.releaseMonitor();
            }
        }

        public void update(SharedContextValueDifference diff) {
            if (this.updateDiffList == null) {
                this.updateDiffList = new ArrayList();
            }
            this.updateDiffList.add(diff);
        }

        public void remove() {
            this.isRemove = true;
            this.updateDiffList = null;
            this.putVlaue = null;
        }

        public void put(Object value) {
            this.isRemove = false;
            this.updateDiffList = null;
            this.putVlaue = value;
        }

        private boolean isRemove() {
            return this.isRemove;
        }

        public Object updateValue(Object value) throws SharedContextUpdateException {
            if (this.putVlaue != null) {
                return this.putVlaue;
            }
            if (this.updateDiffList != null) {
                if (value instanceof SharedContextValueDifferenceSupport) {
                    for (int i = 0; i < this.updateDiffList.size(); ++i) {
                        SharedContextValueDifference diff = (SharedContextValueDifference)this.updateDiffList.get(i);
                        if (((SharedContextValueDifferenceSupport)value).update(diff)) continue;
                        throw new SharedContextUpdateException("An update version is mismatching. currentVersion=" + ((SharedContextValueDifferenceSupport)value).getUpdateVersion() + ", updateVersion=" + diff.getUpdateVersion());
                    }
                } else {
                    throw new SharedContextUpdateException("Not support SharedContextValueDifference. key=" + this.key + ", value=" + value);
                }
            }
            return value;
        }

        public void notifyAllLock() {
            this.isNotify = true;
            this.monitor.notifyAllMonitor();
        }
    }

    protected class Lock {
        private Object key;
        private Object owner;
        private Thread ownerThread;
        private final SynchronizeMonitor monitor = new WaitSynchronizeMonitor();
        private Set callbacks = new LinkedHashSet();

        public Lock(Object key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acquire(Object id, long timeout) {
            boolean isLocal = id.equals(SharedContextService.this.getId());
            Lock lock = this;
            synchronized (lock) {
                if (this.owner == null) {
                    if (SharedContextService.this.getState() != 3) {
                        return false;
                    }
                    this.owner = id;
                    if (isLocal) {
                        this.ownerThread = Thread.currentThread();
                    }
                    Map map = SharedContextService.this.idLocksMap;
                    synchronized (map) {
                        HashSet<Object> keySet = (HashSet<Object>)SharedContextService.this.idLocksMap.get(id);
                        if (keySet == null) {
                            keySet = new HashSet<Object>();
                            SharedContextService.this.idLocksMap.put(id, keySet);
                        }
                        HashSet<Object> hashSet = keySet;
                        synchronized (hashSet) {
                            keySet.add(this.key);
                        }
                    }
                    return true;
                }
                if (id.equals(this.owner)) {
                    return isLocal ? Thread.currentThread().equals(this.ownerThread) : true;
                }
            }
            try {
                long start = System.currentTimeMillis();
                if (this.monitor.initAndWaitMonitor(timeout)) {
                    if ((timeout -= System.currentTimeMillis() - start) <= 0L) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = this.acquire(id, timeout);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.monitor.releaseMonitor();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acquireForReply(Object id, long timeout, Object sourceId, int sequence, String responseSubject, String responseKey) {
            boolean isLocal = id.equals(SharedContextService.this.getId());
            Lock lock = this;
            synchronized (lock) {
                if (this.owner == null) {
                    if (SharedContextService.this.getState() != 3) {
                        return false;
                    }
                    this.owner = id;
                    if (isLocal) {
                        this.ownerThread = Thread.currentThread();
                    }
                    Map map = SharedContextService.this.idLocksMap;
                    synchronized (map) {
                        HashSet<Object> keySet = (HashSet<Object>)SharedContextService.this.idLocksMap.get(id);
                        if (keySet == null) {
                            keySet = new HashSet<Object>();
                            SharedContextService.this.idLocksMap.put(id, keySet);
                        }
                        HashSet<Object> hashSet = keySet;
                        synchronized (hashSet) {
                            keySet.add(this.key);
                        }
                    }
                    return true;
                }
                if (id.equals(this.owner)) {
                    return isLocal ? Thread.currentThread().equals(this.ownerThread) : true;
                }
                NotifyCallback callback = new NotifyCallback(id, timeout, sourceId, sequence, responseSubject, responseKey);
                this.callbacks.add(callback);
                if (timeout > 0L) {
                    SharedContextService.this.lockTimeoutTimer.schedule((TimerTask)callback, timeout);
                }
            }
            return false;
        }

        public Object getOwner() {
            return this.owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean release(Object id, boolean force) {
            boolean isLocal = id.equals(SharedContextService.this.getId());
            boolean result = false;
            TimerTask callback = null;
            Lock lock = this;
            synchronized (lock) {
                if (this.owner == null || id.equals(this.owner) && (force || !isLocal || Thread.currentThread().equals(this.ownerThread))) {
                    this.owner = null;
                    this.ownerThread = null;
                    result = true;
                }
                Map map = SharedContextService.this.idLocksMap;
                synchronized (map) {
                    Set keySet = (Set)SharedContextService.this.idLocksMap.get(id);
                    if (keySet != null) {
                        Set set = keySet;
                        synchronized (set) {
                            keySet.remove(this.key);
                        }
                    }
                }
                if (this.monitor.isWait()) {
                    this.monitor.notifyMonitor();
                } else if (this.callbacks.size() != 0) {
                    Iterator itr = this.callbacks.iterator();
                    callback = (NotifyCallback)itr.next();
                    itr.remove();
                }
            }
            if (callback != null) {
                callback.cancel();
                ((NotifyCallback)callback).notify(true);
            }
            return result;
        }

        private class NotifyCallback
        extends TimerTask {
            private Object id;
            private long startTime;
            private long timeout;
            private Object sourceId;
            private int sequence;
            private String responseSubject;
            private String responseKey;

            public NotifyCallback(Object id, long timeout, Object sourceId, int sequence, String responseSubject, String responseKey) {
                this.id = id;
                this.sourceId = sourceId;
                this.sequence = sequence;
                this.responseSubject = responseSubject;
                this.responseKey = responseKey;
                this.timeout = timeout;
                this.startTime = System.currentTimeMillis();
            }

            public void notify(boolean notify) {
                if (notify) {
                    if (this.timeout <= 0L) {
                        if (!Lock.this.acquireForReply(this.id, this.timeout, this.sourceId, this.sequence, this.responseSubject, this.responseKey)) {
                            return;
                        }
                    } else {
                        long currentTimeout = this.startTime + this.timeout - System.currentTimeMillis();
                        if (currentTimeout > 0L) {
                            if (!Lock.this.acquireForReply(this.id, currentTimeout, this.sourceId, this.sequence, this.responseSubject, this.responseKey)) {
                                return;
                            }
                        } else {
                            notify = false;
                        }
                    }
                }
                Message response = null;
                try {
                    response = SharedContextService.this.createResponseMessage(this.responseSubject, this.responseKey, notify ? Boolean.TRUE : Boolean.FALSE);
                }
                catch (Throwable th) {
                    response = SharedContextService.this.createResponseMessage(this.responseSubject, this.responseKey, th);
                }
                try {
                    SharedContextService.this.serverConnection.response(this.sourceId, this.sequence, response);
                }
                catch (MessageSendException e) {
                    SharedContextService.this.getLogger().write("SCS__00006", new Object[]{SharedContextService.this.isClient ? SharedContextService.this.clientSubject : SharedContextService.this.subject, response}, (Throwable)e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean isRemoved = false;
                Lock lock = Lock.this;
                synchronized (lock) {
                    isRemoved = Lock.this.callbacks.remove(this);
                }
                if (isRemoved) {
                    this.notify(false);
                }
            }
        }
    }

    protected static class SharedContextEvent
    implements Externalizable {
        public static final byte EVENT_PUT = 1;
        public static final byte EVENT_REMOVE = 2;
        public static final byte EVENT_CLEAR = 3;
        public static final byte EVENT_GET_ALL = 4;
        public static final byte EVENT_GET = 5;
        public static final byte EVENT_PUT_ALL = 6;
        public static final byte EVENT_KEY_SET = 7;
        public static final byte EVENT_SIZE = 8;
        public static final byte EVENT_CONTAINS_KEY = 9;
        public static final byte EVENT_CONTAINS_VALUE = 10;
        public static final byte EVENT_SYNCH_ALL = 11;
        public static final byte EVENT_GET_LOCK = 12;
        public static final byte EVENT_GOT_LOCK = 13;
        public static final byte EVENT_RELEASE_LOCK = 14;
        public static final byte EVENT_SAVE = 15;
        public static final byte EVENT_LOAD = 16;
        public static final byte EVENT_LOAD_KEY = 17;
        public static final byte EVENT_UPDATE = 18;
        public static final byte EVENT_SYNCH = 19;
        public static final byte EVENT_PUT_INNER = 20;
        public static final byte EVENT_ANALYZE_KEY_INDEX = 21;
        public static final byte EVENT_SEARCH_KEY_INDEX = 22;
        public static final byte EVENT_EXECUTE_INTERPRET = 23;
        public byte type;
        public Object key;
        public Object value;

        public SharedContextEvent() {
        }

        public SharedContextEvent(byte type) {
            this(type, null, null);
        }

        public SharedContextEvent(byte type, Object key) {
            this(type, key, null);
        }

        public SharedContextEvent(byte type, Object key, Object value) {
            this.type = type;
            this.key = key;
            this.value = value;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.write(this.type);
            out.writeObject(this.key);
            out.writeObject(this.value);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = (byte)in.read();
            this.key = in.readObject();
            this.value = in.readObject();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append('{');
            buf.append("type=").append(this.type);
            buf.append(", key=").append(this.key);
            buf.append(", value=").append(this.value);
            buf.append('}');
            return buf.toString();
        }
    }
}

