/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.context.ContextStore;
import jp.ossc.nimbus.service.context.DefaultContextServiceMBean;

public class DefaultContextService
extends ServiceBase
implements Context,
DefaultContextServiceMBean,
Serializable {
    private static final long serialVersionUID = 920050666611019516L;
    protected Map context;
    protected ServiceName contextStoreServiceName;
    protected ContextStore contextStore;
    protected boolean isLoadOnStart;
    protected boolean isLoadKeyOnStart;
    protected boolean isSaveOnStop;
    protected boolean isClearBeforeSave = true;

    public void setContextStoreServiceName(ServiceName name) {
        this.contextStoreServiceName = name;
    }

    public ServiceName getContextStoreServiceName() {
        return this.contextStoreServiceName;
    }

    public void setLoadOnStart(boolean isLoad) {
        this.isLoadOnStart = isLoad;
    }

    public boolean isLoadOnStart() {
        return this.isLoadOnStart;
    }

    public void setLoadKeyOnStart(boolean isLoad) {
        this.isLoadKeyOnStart = isLoad;
    }

    public boolean isLoadKeyOnStart() {
        return this.isLoadKeyOnStart;
    }

    public void setSaveOnStop(boolean isSave) {
        this.isSaveOnStop = isSave;
    }

    public boolean isSaveOnStop() {
        return this.isSaveOnStop;
    }

    public void setClearBeforeSave(boolean isClear) {
        this.isClearBeforeSave = isClear;
    }

    public boolean isClearBeforeSave() {
        return this.isClearBeforeSave;
    }

    public void setContextStore(ContextStore store) {
        this.contextStore = store;
    }

    public void createService() throws Exception {
        this.context = Collections.synchronizedMap(new HashMap());
    }

    public void startService() throws Exception {
        if (this.contextStoreServiceName != null) {
            this.contextStore = (ContextStore)ServiceManagerFactory.getServiceObject(this.contextStoreServiceName);
        }
        if (this.contextStore == null && (this.isLoadOnStart || this.isLoadKeyOnStart || this.isSaveOnStop)) {
            throw new IllegalArgumentException("ContextStore is null.");
        }
        if (this.isLoadOnStart) {
            this.load();
        } else if (this.isLoadKeyOnStart) {
            this.loadKey();
        }
    }

    public void stopService() throws Exception {
        if (this.isSaveOnStop) {
            this.save();
        }
        this.context.clear();
    }

    public void destroyService() throws Exception {
        this.context = null;
    }

    public synchronized void load() throws Exception {
        if (this.contextStore != null) {
            this.contextStore.load(this);
        }
    }

    public synchronized void loadKey() throws Exception {
        if (this.contextStore != null) {
            this.contextStore.loadKey(this);
        }
    }

    public void load(Object key) throws Exception {
        if (this.contextStore != null) {
            this.contextStore.load(this, key);
        }
    }

    public synchronized void save() throws Exception {
        if (this.contextStore != null) {
            if (this.isClearBeforeSave) {
                this.contextStore.clear();
            }
            this.contextStore.save(this);
        }
    }

    public void save(Object key) throws Exception {
        if (this.contextStore != null) {
            this.contextStore.save(this, key);
        }
    }

    public Object get(Object key) {
        Object val = this.context.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof ServiceName) {
            ServiceName name = (ServiceName)val;
            try {
                val = ServiceManagerFactory.getServiceObject(name);
            }
            catch (ServiceNotFoundException e) {
                val = null;
            }
        }
        return val;
    }

    public Object put(Object key, Object value) {
        return this.context.put(key, value);
    }

    public Set keySet() {
        return this.context.keySet();
    }

    public Collection values() {
        return this.context.values();
    }

    public Object remove(Object key) {
        return this.context.remove(key);
    }

    public void clear() {
        this.context.clear();
    }

    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.context.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.context.containsValue(value);
    }

    public Set entrySet() {
        return this.context.entrySet();
    }

    public int size() {
        return this.context.size();
    }

    public void putAll(Map t) {
        this.context.putAll(t);
    }

    public Hashtable cloneHash() {
        return new Hashtable(this.context);
    }

    public Object get(String key) {
        return this.get((Object)key);
    }

    public Object remove(String key) {
        return this.remove((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String list() {
        StringBuffer buf = new StringBuffer();
        Map map = this.context;
        synchronized (map) {
            Iterator ite = this.context.keySet().iterator();
            while (ite.hasNext()) {
                Object key = ite.next();
                buf.append(key);
                buf.append(" : ");
                buf.append(this.context.get(key));
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    public Map all() {
        return new HashMap(this.context);
    }
}

