/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.codemaster;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.publish.Message;
import jp.ossc.nimbus.service.publish.MessageCreateException;
import jp.ossc.nimbus.service.publish.MessageException;
import jp.ossc.nimbus.service.publish.MessageSendException;
import jp.ossc.nimbus.service.publish.ServerConnection;

public class CodeMasterNotifyBean
extends HashMap {
    private static final long serialVersionUID = 3508475057737920813L;
    private JndiFinder mTopicFinder;
    private TopicSession mRes;
    private String mFlowKey;
    private Date mDate;
    private Object mData;
    private String mTopicName;
    private String subject;
    private ServerConnection connection;
    private Set flowNameSet = new LinkedHashSet();

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setServerConnection(ServerConnection connection) {
        this.connection = connection;
    }

    public void setTopicName(String name) {
        this.mTopicName = name;
    }

    public void setResource(TopicSession rc) {
        this.mRes = rc;
    }

    public void setMasterFlowKey(String masterKey) {
        this.mFlowKey = masterKey;
    }

    public void setDate(Date effectiveDate) {
        this.mDate = effectiveDate;
    }

    public void setData(Object data) {
        this.mData = data;
    }

    public void setJndiFinder(JndiFinder finder) {
        this.mTopicFinder = finder;
    }

    public void addMessage() {
        if (this.mFlowKey == null) {
            return;
        }
        this.flowNameSet.add(this.mFlowKey);
        this.put(this.mFlowKey, this.mData);
        this.put(this.mFlowKey + "$updateTime", this.mDate == null ? new Date() : this.mDate);
        this.mDate = null;
        this.mFlowKey = null;
    }

    public void send() throws JMSException, NamingException, MessageCreateException, MessageSendException, MessageException {
        if (this.size() == 0) {
            return;
        }
        if (this.connection == null) {
            TopicSession session = this.mRes;
            MapMessage msg = session.createMapMessage();
            Iterator flowNames = this.flowNameSet.iterator();
            while (flowNames.hasNext()) {
                String flowName = (String)flowNames.next();
                String dateKey = flowName + "$updateTime";
                this.setObject(msg, dateKey, this.get(dateKey));
                this.setObject(msg, flowName, this.get(flowName));
            }
            Topic tp = null;
            tp = this.mTopicName == null ? (Topic)this.mTopicFinder.lookup() : (Topic)this.mTopicFinder.lookup(this.mTopicName);
            TopicPublisher tpub = session.createPublisher(tp);
            msg.setJMSDeliveryMode(2);
            tpub.publish((javax.jms.Message)msg);
        } else {
            Iterator flowNames = this.flowNameSet.iterator();
            while (flowNames.hasNext()) {
                String flowName = (String)flowNames.next();
                Message msg = this.connection.createMessage(this.subject, flowName);
                HashMap map = new HashMap();
                map.put(flowName, this.get(flowName));
                String dateKey = flowName + "$updateTime";
                map.put(dateKey, this.get(dateKey));
                msg.setObject(map);
                this.connection.send(msg);
            }
        }
        this.flowNameSet.clear();
        this.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setObject(MapMessage msg, String key, Object obj) throws JMSException {
        ByteArrayOutputStream baos;
        block10: {
            if (obj == null) {
                msg.setString(key, null);
                return;
            }
            if (obj instanceof Date) {
                Date dt = (Date)obj;
                msg.setLong(key, dt.getTime());
                return;
            }
            if (obj instanceof Boolean || obj instanceof Byte || obj instanceof byte[] || obj instanceof Character || obj instanceof Double || obj instanceof Float || obj instanceof Integer || obj instanceof Long || obj instanceof Short || obj instanceof String) {
                msg.setObject(key, obj);
                return;
            }
            baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                try {
                    oos = new ObjectOutputStream(baos);
                    oos.writeObject(obj);
                    oos.flush();
                }
                catch (IOException e) {
                    JMSException ex = new JMSException("Not serializable : " + obj);
                    ex.setLinkedException((Exception)e);
                    throw ex;
                }
                Object var9_7 = null;
                if (oos == null) break block10;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (oos == null) throw throwable;
                try {
                    oos.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            oos.close();
        }
        msg.setBytes(key, baos.toByteArray());
    }

    public void addMessageAndSend() throws JMSException, NamingException, MessageCreateException, MessageSendException, MessageException {
        this.addMessage();
        this.send();
    }
}

