/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.AbstractCacheFactoryService;
import jp.ossc.nimbus.service.cache.AbstractCacheService;
import jp.ossc.nimbus.service.cache.FileCacheFactoryServiceMBean;
import jp.ossc.nimbus.service.cache.FileCacheService;

public class FileCacheFactoryService
extends AbstractCacheFactoryService
implements FileCacheFactoryServiceMBean,
Serializable {
    private static final long serialVersionUID = -4354172514890478044L;

    protected AbstractCacheService createAbstractCacheService() throws Exception {
        return new FileCacheService();
    }

    protected Service createServiceInstance() throws Exception {
        FileCacheService cache = (FileCacheService)super.createServiceInstance();
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        cache.setOutputDirectory(templateCache.getOutputDirectory());
        cache.setOutputPrefix(templateCache.getOutputPrefix());
        cache.setOutputSuffix(templateCache.getOutputSuffix());
        cache.setLoadOnStart(templateCache.isLoadOnStart());
        cache.setDeleteOnExitWithJVM(templateCache.isDeleteOnExitWithJVM());
        cache.setExternalizerServiceName(templateCache.getExternalizerServiceName());
        return cache;
    }

    public void setOutputDirectory(String path) throws IllegalArgumentException {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setOutputDirectory(path);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            FileCacheService cache = (FileCacheService)instances.next();
            cache.setOutputDirectory(path);
        }
    }

    public String getOutputDirectory() {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return null;
        }
        return templateCache.getOutputDirectory();
    }

    public void setOutputPrefix(String prefix) {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setOutputPrefix(prefix);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            FileCacheService cache = (FileCacheService)instances.next();
            cache.setOutputPrefix(prefix);
        }
    }

    public String getOutputPrefix() {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return null;
        }
        return templateCache.getOutputPrefix();
    }

    public void setOutputSuffix(String suffix) {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setOutputSuffix(suffix);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            FileCacheService cache = (FileCacheService)instances.next();
            cache.setOutputSuffix(suffix);
        }
    }

    public String getOutputSuffix() {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return null;
        }
        return templateCache.getOutputSuffix();
    }

    public void setLoadOnStart(boolean isLoad) {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setLoadOnStart(isLoad);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            FileCacheService cache = (FileCacheService)instances.next();
            cache.setLoadOnStart(isLoad);
        }
    }

    public boolean isLoadOnStart() {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return false;
        }
        return templateCache.isLoadOnStart();
    }

    public void setDeleteOnExitWithJVM(boolean isDeleteOnExit) {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setDeleteOnExitWithJVM(isDeleteOnExit);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            FileCacheService cache = (FileCacheService)instances.next();
            cache.setDeleteOnExitWithJVM(isDeleteOnExit);
        }
    }

    public boolean isDeleteOnExitWithJVM() {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return false;
        }
        return templateCache.isDeleteOnExitWithJVM();
    }

    public void setExternalizerServiceName(ServiceName name) {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return;
        }
        templateCache.setExternalizerServiceName(name);
        Set instanceSet = this.getManagedInstanceSet();
        Iterator instances = instanceSet.iterator();
        while (instances.hasNext()) {
            FileCacheService cache = (FileCacheService)instances.next();
            cache.setExternalizerServiceName(name);
        }
    }

    public ServiceName getExternalizerServiceName() {
        FileCacheService templateCache = (FileCacheService)this.getTemplate();
        if (templateCache == null) {
            return null;
        }
        return templateCache.getExternalizerServiceName();
    }
}

