/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.dataset.DataSetException;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertySetException;
import jp.ossc.nimbus.beans.dataset.PropertyValidateException;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.service.codemaster.CodeMasterUpdateKey;

public class Record
implements Externalizable,
Cloneable,
Map {
    private static final long serialVersionUID = -6640296864936227160L;
    protected String schema;
    protected RecordSchema recordSchema;
    protected Object[] values;

    public Record() {
    }

    public Record(String schema) throws PropertySchemaDefineException {
        this(RecordSchema.getInstance(schema));
    }

    public Record(RecordSchema recordSchema) {
        if (recordSchema != null) {
            this.schema = recordSchema.getSchema();
            this.recordSchema = recordSchema;
        }
    }

    public void setSchema(String schema) throws PropertySchemaDefineException {
        this.setRecordSchema(RecordSchema.getInstance(schema));
    }

    public String getSchema() {
        return this.schema;
    }

    public void setRecordSchema(RecordSchema schema) throws PropertySchemaDefineException {
        if (this.values != null) {
            throw new PropertySchemaDefineException("Data already exists.");
        }
        this.recordSchema = schema;
        this.schema = schema == null ? null : schema.getSchema();
    }

    public RecordSchema getRecordSchema() {
        return this.recordSchema;
    }

    public void replaceSchema(String schema) throws PropertySchemaDefineException {
        this.replaceRecordSchema(RecordSchema.getInstance(schema));
    }

    public void replaceRecordSchema(RecordSchema schema) throws PropertySchemaDefineException {
        if (this.recordSchema != null && schema != null && this.values != null) {
            PropertySchema[] props = schema.getPropertySchemata();
            Object[] newValues = new Object[props.length];
            for (int i = 0; i < props.length; ++i) {
                PropertySchema oldProp = this.recordSchema.getPropertySchema(props[i].getName());
                if (oldProp != null) {
                    Class type = props[i].getType();
                    Class oldType = oldProp.getType();
                    if (!(type == null || oldType != null && type.isAssignableFrom(oldType))) {
                        throw new PropertySchemaDefineException("It is not compatible. old=" + oldProp + ", new=" + props[i]);
                    }
                }
                newValues[i] = this.getProperty(oldProp.getName());
            }
            this.values = newValues;
        }
        this.recordSchema = schema;
        this.schema = schema == null ? null : schema.getSchema();
    }

    public void appendSchema(String schema) throws PropertySchemaDefineException {
        if (this.recordSchema == null) {
            this.setSchema(schema);
        } else {
            this.replaceRecordSchema(this.recordSchema.appendSchema(schema));
        }
    }

    public void setProperty(String name, Object val) throws PropertySetException {
        if (this.recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertySetException(null, "No such property : " + name);
        }
        this.setProperty(this.recordSchema.getPropertyIndex(name), val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(int index, Object val) throws PropertySetException {
        if (this.recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(index);
        if (propertySchema == null) {
            throw new PropertySetException(null, "No such property : " + index);
        }
        if (this.values == null) {
            Record record = this;
            synchronized (record) {
                if (this.values == null) {
                    this.values = new Object[this.recordSchema.getPropertySize()];
                }
            }
        }
        this.values[index] = propertySchema.set(val);
    }

    public void setProperty(String name, boolean val) throws PropertySetException {
        if (this.recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        this.setProperty(this.recordSchema.getPropertyIndex(name), val);
    }

    public void setProperty(int index, boolean val) throws PropertySetException {
        this.setProperty(index, (Object)(val ? Boolean.TRUE : Boolean.FALSE));
    }

    public void setProperty(String name, byte val) throws PropertySetException {
        if (this.recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        this.setProperty(this.recordSchema.getPropertyIndex(name), val);
    }

    public void setProperty(int index, byte val) throws PropertySetException {
        this.setProperty(index, (Object)new Byte(val));
    }

    public void setProperty(String name, char val) throws PropertySetException {
        if (this.recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        this.setProperty(this.recordSchema.getPropertyIndex(name), val);
    }

    public void setProperty(int index, char val) throws PropertySetException {
        this.setProperty(index, (Object)new Character(val));
    }

    public void setProperty(String name, short val) throws PropertySetException {
        if (this.recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        this.setProperty(this.recordSchema.getPropertyIndex(name), val);
    }

    public void setProperty(int index, short val) throws PropertySetException {
        this.setProperty(index, (Object)new Short(val));
    }

    public void setProperty(String name, int val) throws PropertySetException {
        if (this.recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        this.setProperty(this.recordSchema.getPropertyIndex(name), val);
    }

    public void setProperty(int index, int val) throws PropertySetException {
        this.setProperty(index, (Object)new Integer(val));
    }

    public void setProperty(String name, long val) throws PropertySetException {
        if (this.recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        this.setProperty(this.recordSchema.getPropertyIndex(name), val);
    }

    public void setProperty(int index, long val) throws PropertySetException {
        this.setProperty(index, (Object)new Long(val));
    }

    public void setProperty(String name, float val) throws PropertySetException {
        if (this.recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        this.setProperty(this.recordSchema.getPropertyIndex(name), val);
    }

    public void setProperty(int index, float val) throws PropertySetException {
        this.setProperty(index, (Object)new Float(val));
    }

    public void setProperty(String name, double val) throws PropertySetException {
        if (this.recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        this.setProperty(this.recordSchema.getPropertyIndex(name), val);
    }

    public void setProperty(int index, double val) throws PropertySetException {
        this.setProperty(index, (Object)new Double(val));
    }

    public Object getProperty(String name) throws PropertyGetException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertyGetException(null, "No such property : " + name);
        }
        return this.getProperty(this.recordSchema.getPropertyIndex(name));
    }

    public Object getProperty(int index) throws PropertyGetException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(index);
        if (propertySchema == null) {
            throw new PropertyGetException(null, "No such property : " + index);
        }
        return propertySchema.get(this.values == null ? null : this.values[index]);
    }

    public boolean getBooleanProperty(String name) throws PropertyGetException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        return this.getBooleanProperty(this.recordSchema.getPropertyIndex(name));
    }

    public boolean getBooleanProperty(int index) throws PropertyGetException {
        Object ret = this.getProperty(index);
        if (ret == null) {
            return false;
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        if (ret instanceof String) {
            try {
                return Integer.parseInt((String)ret) != 0;
            }
            catch (NumberFormatException e) {
                return Boolean.valueOf((String)ret);
            }
        }
        if (ret instanceof Number) {
            return ((Number)ret).intValue() != 0;
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(index), "The type is unmatch. value=" + ret);
    }

    public byte getByteProperty(String name) throws PropertyGetException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        return this.getByteProperty(this.recordSchema.getPropertyIndex(name));
    }

    public byte getByteProperty(int index) throws PropertyGetException {
        Object ret = this.getProperty(index);
        if (ret == null) {
            return 0;
        }
        if (ret instanceof Number) {
            return ((Number)ret).byteValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? (byte)1 : 0;
        }
        if (ret instanceof String) {
            try {
                return Byte.parseByte((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(index), "The type is unmatch. value=" + ret);
    }

    public short getShortProperty(String name) throws PropertyGetException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        return this.getShortProperty(this.recordSchema.getPropertyIndex(name));
    }

    public short getShortProperty(int index) throws PropertyGetException {
        Object ret = this.getProperty(index);
        if (ret == null) {
            return 0;
        }
        if (ret instanceof Number) {
            return ((Number)ret).shortValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? (short)1 : 0;
        }
        if (ret instanceof String) {
            try {
                return Short.parseShort((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(index), "The type is unmatch. value=" + ret);
    }

    public int getIntProperty(String name) throws PropertyGetException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        return this.getIntProperty(this.recordSchema.getPropertyIndex(name));
    }

    public int getIntProperty(int index) throws PropertyGetException {
        Object ret = this.getProperty(index);
        if (ret == null) {
            return 0;
        }
        if (ret instanceof Number) {
            return ((Number)ret).intValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? 1 : 0;
        }
        if (ret instanceof String) {
            try {
                return Integer.parseInt((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(index), "The type is unmatch. value=" + ret);
    }

    public long getLongProperty(String name) throws PropertyGetException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        return this.getLongProperty(this.recordSchema.getPropertyIndex(name));
    }

    public long getLongProperty(int index) throws PropertyGetException {
        Object ret = this.getProperty(index);
        if (ret == null) {
            return 0L;
        }
        if (ret instanceof Number) {
            return ((Number)ret).longValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? 1L : 0L;
        }
        if (ret instanceof String) {
            try {
                return Long.parseLong((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(index), "The type is unmatch. value=" + ret);
    }

    public float getFloatProperty(String name) throws PropertyGetException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        return this.getFloatProperty(this.recordSchema.getPropertyIndex(name));
    }

    public float getFloatProperty(int index) throws PropertyGetException {
        Object ret = this.getProperty(index);
        if (ret == null) {
            return 0.0f;
        }
        if (ret instanceof Number) {
            return ((Number)ret).floatValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? 1.0f : 0.0f;
        }
        if (ret instanceof String) {
            try {
                return Float.parseFloat((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(index), "The type is unmatch. value=" + ret);
    }

    public double getDoubleProperty(String name) throws PropertyGetException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        return this.getDoubleProperty(this.recordSchema.getPropertyIndex(name));
    }

    public double getDoubleProperty(int index) throws PropertyGetException {
        Object ret = this.getProperty(index);
        if (ret == null) {
            return 0.0;
        }
        if (ret instanceof Number) {
            return ((Number)ret).doubleValue();
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret != false ? 1.0 : 0.0;
        }
        if (ret instanceof String) {
            try {
                return Double.parseDouble((String)ret);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new PropertyGetException(this.recordSchema.getPropertySchema(index), "The type is unmatch. value=" + ret);
    }

    public String getStringProperty(String name) throws PropertyGetException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        return this.getStringProperty(this.recordSchema.getPropertyIndex(name));
    }

    public String getStringProperty(int index) throws PropertyGetException {
        Object ret = this.getProperty(index);
        if (ret == null) {
            return null;
        }
        if (ret instanceof String) {
            return (String)ret;
        }
        return ret.toString();
    }

    public Object getFormatProperty(String name) throws PropertyGetException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertyGetException(null, "No such property : " + name);
        }
        return this.getFormatProperty(this.recordSchema.getPropertyIndex(name));
    }

    public Object getFormatProperty(int index) throws PropertyGetException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(index);
        if (propertySchema == null) {
            throw new PropertyGetException(null, "No such property : " + index);
        }
        return propertySchema.format(this.getProperty(index));
    }

    public void setParseProperty(String name, Object val) throws PropertySetException {
        if (this.recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertySetException(null, "No such property : " + name);
        }
        this.setParseProperty(this.recordSchema.getPropertyIndex(name), val);
    }

    public void setParseProperty(int index, Object val) throws PropertySetException {
        if (this.recordSchema == null) {
            throw new PropertySetException(null, "Schema is not initialized.");
        }
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(index);
        if (propertySchema == null) {
            throw new PropertySetException(null, "No such property : " + index);
        }
        this.setProperty(index, propertySchema.parse(val));
    }

    public boolean validate() throws PropertyGetException, PropertyValidateException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        PropertySchema[] schemata = this.recordSchema.getPropertySchemata();
        for (int i = 0; i < schemata.length; ++i) {
            if (schemata[i].validate(this.getProperty(i))) continue;
            return false;
        }
        return true;
    }

    public boolean validateProperty(String name) throws PropertyGetException, PropertyValidateException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(name);
        if (propertySchema == null) {
            throw new PropertyGetException(null, "No such property : " + name);
        }
        return this.validateProperty(this.recordSchema.getPropertyIndex(name));
    }

    public boolean validateProperty(int index) throws PropertyGetException, PropertyValidateException {
        if (this.recordSchema == null) {
            throw new PropertyGetException(null, "Schema is not initialized.");
        }
        PropertySchema propertySchema = this.recordSchema.getPropertySchema(index);
        if (propertySchema == null) {
            throw new PropertyGetException(null, "No such property : " + index);
        }
        return propertySchema.validate(this.getProperty(index));
    }

    public void clear() {
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = null;
            }
        }
    }

    public Object clone() {
        return this.cloneRecord();
    }

    public Record cloneSchema() {
        Record clone = null;
        try {
            clone = (Record)super.clone();
            clone.values = null;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return clone;
    }

    public Record cloneRecord() {
        Record record = this.cloneSchema();
        if (this.values != null) {
            record.values = new Object[this.values.length];
            System.arraycopy(this.values, 0, record.values, 0, this.values.length);
        }
        return record;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.recordSchema != null) {
                    buf.append(this.recordSchema.getPropertyName(i));
                    buf.append('=');
                }
                buf.append(this.values[i]);
                if (i == this.values.length - 1) continue;
                buf.append(',');
            }
        }
        buf.append('}');
        return buf.toString();
    }

    public int size() {
        return this.recordSchema == null ? 0 : this.recordSchema.getPropertySize();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        return this.recordSchema == null ? false : this.recordSchema.getPropertySchema(key == null ? (String)key : key.toString()) != null;
    }

    public boolean containsValue(Object value) {
        if (this.values == null) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (value == null && this.values[i] == null) {
                return true;
            }
            if (value == null || !value.equals(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        return this.getProperty(key == null ? (String)key : key.toString());
    }

    public Object put(Object key, Object value) {
        Object old = this.get(key);
        this.setProperty(key == null ? (String)key : key.toString(), value);
        return old;
    }

    public Object remove(Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        Object old = this.get(key);
        if (old != null) {
            this.setProperty(key == null ? (String)key : key.toString(), null);
        }
        return old;
    }

    public void putAll(Map t) {
        if (t == null) {
            return;
        }
        Iterator entries = t.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set keySet() {
        return new KeySet();
    }

    public Collection values() {
        return new Values();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public CodeMasterUpdateKey createCodeMasterUpdateKey() throws DataSetException {
        return this.createCodeMasterUpdateKey(new CodeMasterUpdateKey());
    }

    public CodeMasterUpdateKey createCodeMasterUpdateKey(CodeMasterUpdateKey key) throws DataSetException {
        PropertySchema[] primaryKeys = this.recordSchema.getPrimaryKeyPropertySchemata();
        if (primaryKeys == null || primaryKeys.length == 0) {
            throw new DataSetException("Primary key is not defined.");
        }
        key.clear();
        for (int i = 0; i < primaryKeys.length; ++i) {
            PropertySchema primaryKey = primaryKeys[i];
            key.addKey(primaryKey.getName(), this.getProperty(primaryKey.getName()));
        }
        return key;
    }

    public void setCodeMasterUpdateKey(CodeMasterUpdateKey key) {
        Iterator itr = key.getKeyMap().entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            PropertySchema propSchema = this.recordSchema.getPropertySchema((String)entry.getKey());
            if (propSchema == null) continue;
            this.setProperty(propSchema.getName(), entry.getValue());
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record record = (Record)o;
        if (this.recordSchema != record.recordSchema) {
            return false;
        }
        if (this.values == record.values) {
            return true;
        }
        if (this.values == null && record.values != null || this.values != null && record.values == null || this.values.length != record.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null && record.values[i] != null || this.values[i] != null && record.values[i] == null) {
                return false;
            }
            if (this.values[i] == null || this.values[i].equals(record.values[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.recordSchema != null) {
            hashCode += this.recordSchema.hashCode();
        }
        if (this.values != null) {
            hashCode += this.values.hashCode();
        }
        return hashCode;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.schema);
        this.writeExternalValues(out);
    }

    protected void writeExternalValues(ObjectOutput out) throws IOException {
        out.writeObject(this.values);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.schema = (String)in.readObject();
        if (this.schema != null) {
            this.recordSchema = RecordSchema.getInstance(this.schema);
        }
        this.readExternalValues(in);
    }

    protected void readExternalValues(ObjectInput in) throws IOException, ClassNotFoundException {
        this.values = (Object[])in.readObject();
    }

    protected class EntrySet
    implements Set,
    Serializable {
        private static final long serialVersionUID = -4696386214482898985L;
        protected List entries = new ArrayList();

        public EntrySet() {
            if (Record.this.recordSchema != null) {
                PropertySchema[] schemata = Record.this.recordSchema.getPropertySchemata();
                for (int i = 0; i < schemata.length; ++i) {
                    this.entries.add(new Entry(schemata[i].getName()));
                }
            }
        }

        public int size() {
            return this.entries.size();
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public boolean contains(Object o) {
            return this.entries.contains(o);
        }

        public Iterator iterator() {
            return new EntrySetIterator();
        }

        public Object[] toArray() {
            return this.entries.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.entries.toArray(a);
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return Record.this.remove(((Map.Entry)o).getKey()) != null;
        }

        public boolean containsAll(Collection c) {
            return this.entries.containsAll(c);
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator itr = this.entries.iterator();
            while (itr.hasNext()) {
                Object key = ((Map.Entry)itr.next()).getKey();
                if (c.contains(key)) continue;
                result |= this.remove(key);
            }
            return result;
        }

        public boolean removeAll(Collection c) {
            boolean result = false;
            Iterator itr = this.entries.iterator();
            while (itr.hasNext()) {
                Object key = ((Map.Entry)itr.next()).getKey();
                if (!c.contains(key)) continue;
                result |= this.remove(key);
            }
            return result;
        }

        public void clear() {
            Record.this.clear();
        }

        public boolean equals(Object o) {
            return ((Object)this.entries).equals(o);
        }

        public int hashCode() {
            return ((Object)this.entries).hashCode();
        }

        protected class EntrySetIterator
        implements Iterator,
        Serializable {
            private static final long serialVersionUID = -8153119352044048534L;
            protected int index;

            protected EntrySetIterator() {
            }

            public boolean hasNext() {
                return EntrySet.this.entries.size() > this.index;
            }

            public Object next() {
                return this.hasNext() ? EntrySet.this.entries.get(this.index++) : null;
            }

            public void remove() {
                if (EntrySet.this.entries.size() > this.index) {
                    Record.this.remove(((Entry)EntrySet.this.entries.get(this.index)).getKey());
                }
            }
        }

        protected class Entry
        implements Map.Entry,
        Serializable {
            private static final long serialVersionUID = 5572280646230618952L;
            protected String key;

            public Entry(String key) {
                this.key = key;
            }

            public Object getKey() {
                return this.key;
            }

            public Object getValue() {
                return Record.this.getProperty(this.key);
            }

            public Object setValue(Object value) {
                return Record.this.put(this.key, value);
            }

            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
            }

            public int hashCode() {
                return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
            }
        }
    }

    protected class Values
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 4612582373933630957L;
        protected List valueList = new ArrayList();

        public Values() {
            if (Record.this.recordSchema != null) {
                PropertySchema[] schemata = Record.this.recordSchema.getPropertySchemata();
                for (int i = 0; i < schemata.length; ++i) {
                    this.valueList.add(Record.this.getProperty(schemata[i].getName()));
                }
            }
        }

        public int size() {
            return this.valueList.size();
        }

        public boolean isEmpty() {
            return this.valueList.isEmpty();
        }

        public boolean contains(Object o) {
            return this.valueList.contains(o);
        }

        public Iterator iterator() {
            return new ValuesIterator();
        }

        public Object[] toArray() {
            return this.valueList.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.valueList.toArray(a);
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            int index = this.valueList.indexOf(o);
            if (index == -1) {
                return false;
            }
            return Record.this.remove(Record.this.recordSchema.getPropertyName(index)) != null;
        }

        public boolean containsAll(Collection c) {
            return this.valueList.containsAll(c);
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator itr = this.valueList.iterator();
            while (itr.hasNext()) {
                Object val = itr.next();
                if (c.contains(val)) continue;
                result |= this.remove(val);
            }
            return result;
        }

        public boolean removeAll(Collection c) {
            boolean result = false;
            Iterator itr = this.valueList.iterator();
            while (itr.hasNext()) {
                Object val = itr.next();
                if (!c.contains(val)) continue;
                result |= this.remove(val);
            }
            return result;
        }

        public void clear() {
            Record.this.clear();
        }

        public boolean equals(Object o) {
            return ((Object)this.valueList).equals(o);
        }

        public int hashCode() {
            return ((Object)this.valueList).hashCode();
        }

        protected class ValuesIterator
        implements Iterator,
        Serializable {
            private static final long serialVersionUID = 167532200775957747L;
            protected int index;

            protected ValuesIterator() {
            }

            public boolean hasNext() {
                return Values.this.valueList.size() > this.index;
            }

            public Object next() {
                return this.hasNext() ? Values.this.valueList.get(this.index++) : null;
            }

            public void remove() {
                if (Values.this.valueList.size() > this.index) {
                    Values.this.remove(Values.this.valueList.get(this.index));
                }
            }
        }
    }

    protected class KeySet
    implements Set,
    Serializable {
        private static final long serialVersionUID = 810743353037210495L;
        protected List keys = new ArrayList();

        public KeySet() {
            if (Record.this.recordSchema != null) {
                PropertySchema[] schemata = Record.this.recordSchema.getPropertySchemata();
                for (int i = 0; i < schemata.length; ++i) {
                    this.keys.add(schemata[i].getName());
                }
            }
        }

        public int size() {
            return this.keys.size();
        }

        public boolean isEmpty() {
            return this.keys.isEmpty();
        }

        public boolean contains(Object o) {
            return this.keys.contains(o);
        }

        public Iterator iterator() {
            return new KeySetIterator();
        }

        public Object[] toArray() {
            return this.keys.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.keys.toArray(a);
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            return Record.this.remove(o) != null;
        }

        public boolean containsAll(Collection c) {
            return this.keys.containsAll(c);
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator itr = this.keys.iterator();
            while (itr.hasNext()) {
                Object key = itr.next();
                if (c.contains(key)) continue;
                result |= this.remove(key);
            }
            return result;
        }

        public boolean removeAll(Collection c) {
            boolean result = false;
            Iterator itr = this.keys.iterator();
            while (itr.hasNext()) {
                Object key = itr.next();
                if (!c.contains(key)) continue;
                result |= this.remove(key);
            }
            return result;
        }

        public void clear() {
            Record.this.clear();
        }

        public boolean equals(Object o) {
            return ((Object)this.keys).equals(o);
        }

        public int hashCode() {
            return ((Object)this.keys).hashCode();
        }

        protected class KeySetIterator
        implements Iterator,
        Serializable {
            private static final long serialVersionUID = -1219165095772883511L;
            protected int index;

            protected KeySetIterator() {
            }

            public boolean hasNext() {
                return KeySet.this.keys.size() > this.index;
            }

            public Object next() {
                return this.hasNext() ? KeySet.this.keys.get(this.index++) : null;
            }

            public void remove() {
                if (KeySet.this.keys.size() > this.index) {
                    Record.this.remove(KeySet.this.keys.get(this.index));
                }
            }
        }
    }
}

