/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.Serializable;
import java.util.List;
import jp.ossc.nimbus.beans.ArrayEditor;
import jp.ossc.nimbus.beans.Utility;

public class ClassArrayEditor
extends ArrayEditor
implements Serializable {
    private static final long serialVersionUID = 3752687582698392704L;

    protected Object createArray(List strList) {
        Class[] array = new Class[strList.size()];
        try {
            for (int i = 0; i < array.length; ++i) {
                array[i] = Utility.convertStringToClass(((String)strList.get(i)).trim());
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return array;
    }

    public String getAsText() {
        Class[] classArray = (Class[])this.getValue();
        if (classArray == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int max = classArray.length;
        for (int i = 0; i < max; ++i) {
            buf.append(classArray[i].getName());
            if (i == max - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }
}

