/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StreamConverter;

public class SerializeStreamConverter
implements StreamConverter,
Serializable {
    private static final long serialVersionUID = -4260884667278852436L;
    protected int convertType;
    protected boolean isCompress;

    public SerializeStreamConverter() {
        this(1);
    }

    public SerializeStreamConverter(int type) {
        this.convertType = type;
    }

    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setCompress(boolean compress) {
        this.isCompress = compress;
    }

    public boolean isCompress() {
        return this.isCompress;
    }

    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        switch (this.convertType) {
            case 1: {
                return this.convertToStream(obj);
            }
            case 2: {
                if (!(obj instanceof InputStream)) {
                    throw new ConvertException("Invalid input type : " + obj.getClass());
                }
                return this.convertToObject((InputStream)obj);
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }

    public InputStream convertToStream(Object obj) throws ConvertException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (obj != null) {
            OutputStream os = baos;
            try {
                if (this.isCompress) {
                    os = new GZIPOutputStream(os);
                }
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeObject((Serializable)obj);
                oos.flush();
                if (this.isCompress) {
                    ((GZIPOutputStream)os).finish();
                }
            }
            catch (IOException e) {
                throw new ConvertException(e);
            }
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public Object convertToObject(InputStream is) throws ConvertException {
        try {
            if (this.isCompress) {
                is = new GZIPInputStream(is);
            }
            ObjectInputStream ois = new ObjectInputStream(is);
            return ois.readObject();
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ConvertException(e);
        }
    }
}

