/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.system.javasysmon;

import com.jezhumble.javasysmon.JavaSysMon;
import com.jezhumble.javasysmon.MemoryStats;
import com.jezhumble.javasysmon.Monitor;
import java.io.Serializable;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.system.CpuTimes;
import jp.ossc.nimbus.service.system.MemoryInfo;
import jp.ossc.nimbus.service.system.OperationSystem;
import jp.ossc.nimbus.service.system.ProcessInfo;
import jp.ossc.nimbus.service.system.javasysmon.OperationSystemServiceMBean;

public class OperationSystemService
extends ServiceBase
implements OperationSystem,
OperationSystemServiceMBean {
    private static final long serialVersionUID = 2447573678398806223L;
    private Monitor monitor;
    private CpuTimes lastCpuTimes;

    public void createService() throws Exception {
        this.monitor = new JavaSysMon();
    }

    public void startService() throws Exception {
        this.lastCpuTimes = this.getCpuTimes();
    }

    public void destroyService() throws Exception {
        this.monitor = null;
    }

    public String getName() {
        return this.monitor == null ? null : this.monitor.osName();
    }

    public int getCpuNumbers() {
        return this.monitor == null ? -1 : this.monitor.numCpus();
    }

    public long getCpuFrequency() {
        return this.monitor == null ? -1L : this.monitor.cpuFrequencyInHz();
    }

    public CpuTimes getCpuTimes() {
        return new CpuTimesImpl(this.monitor == null ? null : this.monitor.cpuTimes());
    }

    public MemoryInfo getPhysicalMemoryInfo() {
        return new MemoryInfoImpl(this.monitor == null ? null : this.monitor.physical());
    }

    public MemoryInfo getSwapMemoryInfo() {
        return new MemoryInfoImpl(this.monitor == null ? null : this.monitor.swap());
    }

    public int getPid() {
        return this.monitor == null ? -1 : this.monitor.currentPid();
    }

    public void kill(int pid) {
        this.monitor.killProcess(pid);
    }

    public ProcessInfo getProcessInfo(int pid) {
        if (this.monitor == null) {
            return null;
        }
        com.jezhumble.javasysmon.ProcessInfo[] procs = this.monitor.processTable();
        if (procs == null || procs.length == 0) {
            return null;
        }
        for (int i = 0; i < procs.length; ++i) {
            if (procs[i].getPid() != pid) continue;
            return new ProcessInfoImpl(procs[i]);
        }
        return null;
    }

    public ProcessInfo[] getProcessInfos() {
        if (this.monitor == null) {
            return new ProcessInfoImpl[0];
        }
        com.jezhumble.javasysmon.ProcessInfo[] procs = this.monitor.processTable();
        if (procs == null || procs.length == 0) {
            return new ProcessInfoImpl[0];
        }
        ProcessInfo[] result = new ProcessInfoImpl[procs.length];
        for (int i = 0; i < procs.length; ++i) {
            result[i] = new ProcessInfoImpl(procs[i]);
        }
        return result;
    }

    public synchronized CpuTimes getCpuTimesDelta() {
        CpuTimes result = null;
        CpuTimes current = this.getCpuTimes();
        result = this.lastCpuTimes == null ? current : new CpuTimesImpl(this.lastCpuTimes, current);
        this.lastCpuTimes = current;
        return result;
    }

    private static class ProcessInfoImpl
    implements ProcessInfo,
    Serializable {
        private int pid = -1;
        private int parentPid = -1;
        private String name;
        private String command;
        private String owner;
        private long userCpuTime = -1L;
        private long systemCpuTime = -1L;
        private long currentMemory = -1L;
        private long totalMemory = -1L;

        public ProcessInfoImpl(com.jezhumble.javasysmon.ProcessInfo proc) {
            if (proc != null) {
                this.pid = proc.getPid();
                this.parentPid = proc.getParentPid();
                this.name = proc.getName();
                this.command = proc.getCommand();
                this.owner = proc.getOwner();
                this.userCpuTime = proc.getUserMillis();
                this.systemCpuTime = proc.getSystemMillis();
                this.currentMemory = proc.getResidentBytes();
                this.totalMemory = proc.getTotalBytes();
            }
        }

        public int getPid() {
            return this.pid;
        }

        public int getParentPid() {
            return this.parentPid;
        }

        public String getName() {
            return this.name;
        }

        public String getCommand() {
            return this.command;
        }

        public String getOwner() {
            return this.owner;
        }

        public long getUserTimeMillis() {
            return this.userCpuTime;
        }

        public long getSystemTimeMillis() {
            return this.systemCpuTime;
        }

        public long getCurrentMemoryBytes() {
            return this.currentMemory;
        }

        public long getTotalMemoryBytes() {
            return this.totalMemory;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.toString());
            buf.append('{');
            buf.append("pid=").append(this.pid);
            buf.append(", parentPid=").append(this.parentPid);
            buf.append(", name=").append(this.name);
            buf.append(", command=").append(this.command);
            buf.append(", owner=").append(this.owner);
            buf.append(", user=").append(this.userCpuTime);
            buf.append(", system=").append(this.systemCpuTime);
            buf.append(", current=").append(this.currentMemory);
            buf.append(", total=").append(this.totalMemory);
            buf.append('}');
            return buf.toString();
        }
    }

    private static class MemoryInfoImpl
    implements MemoryInfo,
    Serializable {
        private long free = -1L;
        private long total = -1L;

        public MemoryInfoImpl(MemoryStats memory) {
            if (memory != null) {
                this.free = memory.getFreeBytes();
                this.total = memory.getTotalBytes();
            }
        }

        public long getFreeBytes() {
            return this.free;
        }

        public long getUsedBytes() {
            return this.total - this.free;
        }

        public long getTotalBytes() {
            return this.total;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.toString());
            buf.append('{');
            buf.append("total=").append(this.total);
            buf.append(", used=").append(this.getUsedBytes());
            buf.append(", free=").append(this.free);
            buf.append('}');
            return buf.toString();
        }
    }

    private static class CpuTimesImpl
    implements CpuTimes,
    Serializable {
        private long user = -1L;
        private long system = -1L;
        private long idle = -1L;
        private long total = -1L;

        public CpuTimesImpl(com.jezhumble.javasysmon.CpuTimes cpu) {
            if (cpu != null) {
                this.user = cpu.getUserMillis();
                this.system = cpu.getSystemMillis();
                this.idle = cpu.getIdleMillis();
                this.total = cpu.getTotalMillis();
            }
        }

        public CpuTimesImpl(CpuTimes prev, CpuTimes current) {
            this.user = current.getUserTimeMillis() - prev.getUserTimeMillis();
            this.system = current.getSystemTimeMillis() - prev.getSystemTimeMillis();
            this.idle = current.getIdleTimeMillis() - prev.getIdleTimeMillis();
            this.total = current.getTotalTimeMillis() - prev.getTotalTimeMillis();
        }

        public long getUserTimeMillis() {
            return this.user;
        }

        public long getSystemTimeMillis() {
            return this.system;
        }

        public long getIdleTimeMillis() {
            return this.idle;
        }

        public long getTotalTimeMillis() {
            return this.total;
        }

        public float getUserRate() {
            return (float)this.user / (float)this.total;
        }

        public float getSystemRate() {
            return (float)this.system / (float)this.total;
        }

        public float getIdleRate() {
            return (float)this.idle / (float)this.total;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.toString());
            buf.append('{');
            buf.append("total=").append(this.total);
            buf.append(", user=").append(this.user).append('(').append((int)((double)this.getUserRate() * 100.0)).append(')');
            buf.append(", system=").append(this.system).append('(').append((int)((double)this.getSystemRate() * 100.0)).append(')');
            buf.append(", idle=").append(this.idle).append('(').append(100 - (int)((double)this.getUserRate() * 100.0) - (int)((double)this.getSystemRate() * 100.0)).append(')');
            buf.append('}');
            return buf.toString();
        }
    }
}

