/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.util.Date;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.scheduler2.BeanFlowConditionScheduleMakerServiceMBean;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMakerService;
import jp.ossc.nimbus.service.scheduler2.ScheduleMakeException;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaster;

public class BeanFlowConditionScheduleMakerService
extends DefaultScheduleMakerService
implements BeanFlowConditionScheduleMakerServiceMBean {
    private static final long serialVersionUID = 9128789021473711234L;
    protected ServiceName beanFlowInvokerFactoryServiceName;
    protected BeanFlowInvokerFactory beanFlowInvokerFactory;
    protected String flowName;

    public void setBeanFlowInvokerFactoryServiceName(ServiceName name) {
        this.beanFlowInvokerFactoryServiceName = name;
    }

    public ServiceName getBeanFlowInvokerFactoryServiceName() {
        return this.beanFlowInvokerFactoryServiceName;
    }

    public void setFlowName(String name) {
        this.flowName = name;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void startService() throws Exception {
        if (this.beanFlowInvokerFactoryServiceName != null) {
            this.beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        }
        if (this.beanFlowInvokerFactory == null) {
            throw new IllegalArgumentException("BeanFlowInvokerFactory is null.");
        }
    }

    public void setBeanFlowInvokerFactory(BeanFlowInvokerFactory factory) {
        this.beanFlowInvokerFactory = factory;
    }

    public BeanFlowInvokerFactory getBeanFlowInvokerFactory() {
        return this.beanFlowInvokerFactory;
    }

    protected boolean isNecessaryMake(Date date, ScheduleMaster master) throws ScheduleMakeException {
        String conditionFlowName = this.flowName == null ? master.getScheduleType() : this.flowName;
        BeanFlowInvoker invoker = this.beanFlowInvokerFactory.createFlow(conditionFlowName);
        if (invoker == null) {
            throw new ScheduleMakeException("BeanFlow is not found : " + conditionFlowName);
        }
        boolean result = false;
        try {
            Object ret = invoker.invokeFlow(new Object[]{date, master});
            if (!(ret instanceof Boolean)) {
                throw new ScheduleMakeException("Return of BeanFlow is not boolean : " + ret);
            }
            result = (Boolean)ret;
        }
        catch (Exception e) {
            throw new ScheduleMakeException(e);
        }
        return result;
    }
}

