/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.IllegalServiceStateException;
import jp.ossc.nimbus.service.queue.DistributedQueueSelector;
import jp.ossc.nimbus.service.queue.DistributedQueueServiceMBean;
import jp.ossc.nimbus.service.queue.Queue;

public class DistributedQueueService
extends ServiceBase
implements Queue,
DistributedQueueServiceMBean {
    private static final long serialVersionUID = -752202000609727763L;
    private ServiceName distributedQueueSelectorServiceName;
    private DistributedQueueSelector selector;
    protected List waitThreads;
    protected List peekWaitThreads;
    protected Set wakeUpThreads;
    protected long sleepTime = 10000L;
    protected int maxThresholdSize = -1;
    protected List pushWaitThreads;
    protected Set pushKnockedThreads;
    protected volatile boolean fourceEndFlg = false;
    protected long count = 0L;
    protected long countDelta = 0L;
    protected long lastPushedTime = 0L;
    protected long lastDepth = 0L;

    public void setDistributedQueueSelectorServiceName(ServiceName name) {
        this.distributedQueueSelectorServiceName = name;
    }

    public ServiceName getDistributedQueueSelectorServiceName() {
        return this.distributedQueueSelectorServiceName;
    }

    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setMaxThresholdSize(int size) {
        this.maxThresholdSize = size;
    }

    public int getMaxThresholdSize() {
        return this.maxThresholdSize;
    }

    public long getCount() {
        return this.count;
    }

    public long getCountDelta() {
        long delta = this.countDelta;
        this.countDelta = 0L;
        return delta;
    }

    public long getLastPushedTimeMillis() {
        return this.lastPushedTime;
    }

    public Date getLastPushedTime() {
        return new Date(this.lastPushedTime);
    }

    public long getDepth() {
        return this.size();
    }

    public long getDepthDelta() {
        long depth = this.size();
        long delta = depth - this.lastDepth;
        this.lastDepth = depth;
        return delta;
    }

    public void createService() throws Exception {
        this.waitThreads = new ArrayList();
        this.peekWaitThreads = new ArrayList();
        this.wakeUpThreads = new HashSet();
    }

    public void startService() throws Exception {
        this.selector = (DistributedQueueSelector)ServiceManagerFactory.getServiceObject(this.distributedQueueSelectorServiceName);
        if (this.maxThresholdSize > 0) {
            this.pushWaitThreads = Collections.synchronizedList(new ArrayList());
            this.pushKnockedThreads = Collections.synchronizedSet(new HashSet());
        }
        this.accept();
    }

    public void stopService() throws Exception {
        this.release();
    }

    protected Queue getPushQueue(Object item) {
        return this.selector.selectQueue(item);
    }

    protected Queue getGetQueue() {
        Queue[] queues = this.selector.getQueues();
        Queue queue = null;
        int max = 0;
        for (int i = 0; i < queues.length; ++i) {
            int current = queues[i].size();
            if (max >= current) continue;
            max = current;
            queue = queues[i];
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Object item) {
        List list;
        if (this.getState() != 3 || this.fourceEndFlg) {
            throw new IllegalServiceStateException(this);
        }
        Queue queue = this.getPushQueue(item);
        if (!(this.maxThresholdSize <= 0 || this.pushWaitThreads.size() <= 0 && this.size() < this.maxThresholdSize || this.fourceEndFlg)) {
            List list2;
            Thread current = Thread.currentThread();
            try {
                List list3 = this.pushWaitThreads;
                synchronized (list3) {
                    this.pushWaitThreads.add(current);
                }
                while (this.size() >= this.maxThresholdSize || this.pushWaitThreads.get(0) != current) {
                    if (this.getState() != 3 || this.fourceEndFlg) {
                        throw new IllegalServiceStateException(this);
                    }
                    if (this.sleepTime <= 0L) continue;
                    try {
                        this.pushKnockedThreads.remove(current);
                        Thread.sleep(this.sleepTime);
                    }
                    catch (IllegalArgumentException e) {
                    }
                    catch (InterruptedException e) {
                        if (!this.pushKnockedThreads.contains(current)) {
                            Object var7_12 = null;
                            List list4 = this.pushWaitThreads;
                            synchronized (list4) {
                                this.pushWaitThreads.remove(current);
                                this.pushKnockedThreads.remove(current);
                            }
                            return;
                        }
                        Thread.interrupted();
                    }
                }
                Object var7_13 = null;
                list2 = this.pushWaitThreads;
            }
            catch (Throwable throwable) {
                Object var7_14 = null;
                List list5 = this.pushWaitThreads;
                synchronized (list5) {
                    this.pushWaitThreads.remove(current);
                    this.pushKnockedThreads.remove(current);
                }
                throw throwable;
            }
            synchronized (list2) {
                this.pushWaitThreads.remove(current);
                this.pushKnockedThreads.remove(current);
            }
        }
        queue.push(item);
        ++this.count;
        ++this.countDelta;
        this.lastPushedTime = System.currentTimeMillis();
        if (this.waitThreads != null) {
            list = this.waitThreads;
            synchronized (list) {
                Thread waitThread;
                if (this.peekWaitThreads != null) {
                    int imax = this.peekWaitThreads.size();
                    for (int i = 0; i < imax; ++i) {
                        Thread waitThread2 = (Thread)this.peekWaitThreads.get(i);
                        if (this.wakeUpThreads.contains(waitThread2) || waitThread2.isInterrupted()) continue;
                        this.wakeUpThreads.add(waitThread2);
                        waitThread2.interrupt();
                    }
                }
                if (this.waitThreads.size() != 0 && !this.wakeUpThreads.contains(waitThread = (Thread)this.waitThreads.get(0)) && !waitThread.isInterrupted()) {
                    this.wakeUpThreads.add(waitThread);
                    waitThread.interrupt();
                }
            }
        }
        if (this.pushWaitThreads != null) {
            list = this.pushWaitThreads;
            synchronized (list) {
                Thread waitThread;
                if (this.pushWaitThreads.size() > 0 && this.size() < this.maxThresholdSize && !this.pushKnockedThreads.contains(waitThread = (Thread)this.pushWaitThreads.get(0)) && !waitThread.isInterrupted()) {
                    this.pushKnockedThreads.add(waitThread);
                    waitThread.interrupt();
                }
            }
        }
    }

    public Object get() {
        return this.get(-1L);
    }

    public Object get(long timeOutMs) {
        return this.getQueueElement(timeOutMs, true);
    }

    public Object peek() {
        return this.peek(-1L);
    }

    public Object peek(long timeOutMs) {
        return this.getQueueElement(timeOutMs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getQueueElement(long timeOutMs, boolean isRemove) {
        Object object;
        boolean removeWait;
        Thread current;
        block57: {
            block56: {
                block55: {
                    block54: {
                        List list;
                        Object waitThread;
                        block53: {
                            current = Thread.currentThread();
                            long processTime = 0L;
                            removeWait = false;
                            try {
                                if (this.waitThreads != null && !this.fourceEndFlg) {
                                    List list2 = this.waitThreads;
                                    synchronized (list2) {
                                        if (isRemove) {
                                            this.waitThreads.add(current);
                                        } else {
                                            this.peekWaitThreads.add(current);
                                        }
                                        this.wakeUpThreads.add(current);
                                    }
                                }
                                Queue queue = null;
                                while (!this.fourceEndFlg) {
                                    if (this.size() > 0 && this.waitThreads != null) {
                                        object = this.waitThreads;
                                        synchronized (object) {
                                            if (this.size() > 0) {
                                                Thread waitThread2;
                                                if (!isRemove || this.waitThreads.size() != 0 && this.waitThreads.get(0) == current) {
                                                    queue = this.getGetQueue();
                                                    Object ret = null;
                                                    if (isRemove) {
                                                        ret = queue.get(timeOutMs);
                                                        this.waitThreads.remove(current);
                                                    } else {
                                                        ret = queue.peek(timeOutMs);
                                                        this.peekWaitThreads.remove(current);
                                                    }
                                                    this.wakeUpThreads.remove(current);
                                                    removeWait = true;
                                                    Thread.interrupted();
                                                    if (isRemove && this.size() > 0 && this.waitThreads.size() != 0 && !this.wakeUpThreads.contains(waitThread = (Thread)this.waitThreads.get(0)) && !((Thread)waitThread).isInterrupted()) {
                                                        this.wakeUpThreads.add(waitThread);
                                                        ((Thread)waitThread).interrupt();
                                                    }
                                                    if (isRemove && this.pushWaitThreads != null) {
                                                        waitThread = this.pushWaitThreads;
                                                        synchronized (waitThread) {
                                                            Thread waitThread3;
                                                            if (this.pushWaitThreads.size() != 0 && this.size() < this.maxThresholdSize && !this.pushKnockedThreads.contains(waitThread3 = (Thread)this.pushWaitThreads.get(0)) && !waitThread3.isInterrupted()) {
                                                                this.pushKnockedThreads.add(waitThread3);
                                                                waitThread3.interrupt();
                                                            }
                                                        }
                                                    }
                                                    waitThread = ret;
                                                    // MONITOREXIT @DISABLED, blocks:[0, 50, 51, 52, 20, 9] lbl52 : MonitorExitStatement: MONITOREXIT : var9_8
                                                    Object var16_16 = null;
                                                    if (this.waitThreads == null) return waitThread;
                                                    if (removeWait) return waitThread;
                                                    list = this.waitThreads;
                                                    break block53;
                                                }
                                                if (this.waitThreads.size() != 0 && !this.wakeUpThreads.contains(waitThread2 = (Thread)this.waitThreads.get(0)) && !waitThread2.isInterrupted()) {
                                                    this.wakeUpThreads.add(waitThread2);
                                                    waitThread2.interrupt();
                                                }
                                            }
                                        }
                                    }
                                    if (this.fourceEndFlg || timeOutMs == 0L || timeOutMs > 0L && timeOutMs <= processTime) break;
                                    long proc = 0L;
                                    if (timeOutMs >= 0L) {
                                        proc = System.currentTimeMillis();
                                    }
                                    try {
                                        long curSleepTime;
                                        long l = curSleepTime = timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime;
                                        if (curSleepTime > 0L && !Thread.interrupted()) {
                                            this.wakeUpThreads.remove(current);
                                            Thread.sleep(curSleepTime);
                                            this.wakeUpThreads.add(current);
                                        }
                                    }
                                    catch (IllegalArgumentException e) {
                                    }
                                    catch (InterruptedException e) {
                                        if (!this.wakeUpThreads.contains(current)) {
                                            Object var12_15 = null;
                                            Object var16_17 = null;
                                            if (this.waitThreads == null) return var12_15;
                                            if (removeWait) return var12_15;
                                            List list3 = this.waitThreads;
                                            synchronized (list3) {
                                                if (isRemove) {
                                                    this.waitThreads.remove(current);
                                                } else {
                                                    this.peekWaitThreads.remove(current);
                                                }
                                                this.wakeUpThreads.remove(current);
                                                return var12_15;
                                            }
                                        }
                                        Thread.interrupted();
                                    }
                                    if (timeOutMs < 0L) continue;
                                    proc = System.currentTimeMillis() - proc;
                                    processTime += proc;
                                }
                                if (this.fourceEndFlg) {
                                    queue = this.getGetQueue();
                                    if (queue == null) {
                                        object = null;
                                        break block54;
                                    }
                                    if (isRemove) {
                                        object = queue.get(timeOutMs);
                                        break block55;
                                    }
                                    object = queue.peek(timeOutMs);
                                    break block56;
                                }
                                object = null;
                                break block57;
                            }
                            catch (Throwable throwable) {
                                Object var16_22 = null;
                                if (this.waitThreads == null) throw throwable;
                                if (removeWait) throw throwable;
                                List list4 = this.waitThreads;
                                synchronized (list4) {
                                    if (isRemove) {
                                        this.waitThreads.remove(current);
                                    } else {
                                        this.peekWaitThreads.remove(current);
                                    }
                                    this.wakeUpThreads.remove(current);
                                    throw throwable;
                                }
                            }
                        }
                        synchronized (list) {
                            if (isRemove) {
                                this.waitThreads.remove(current);
                            } else {
                                this.peekWaitThreads.remove(current);
                            }
                            this.wakeUpThreads.remove(current);
                            return waitThread;
                        }
                    }
                    Object var16_18 = null;
                    if (this.waitThreads == null) return object;
                    if (removeWait) return object;
                    List list = this.waitThreads;
                    synchronized (list) {
                        if (isRemove) {
                            this.waitThreads.remove(current);
                        } else {
                            this.peekWaitThreads.remove(current);
                        }
                        this.wakeUpThreads.remove(current);
                        return object;
                    }
                }
                Object var16_19 = null;
                if (this.waitThreads == null) return object;
                if (removeWait) return object;
                List list = this.waitThreads;
                synchronized (list) {
                    if (isRemove) {
                        this.waitThreads.remove(current);
                    } else {
                        this.peekWaitThreads.remove(current);
                    }
                    this.wakeUpThreads.remove(current);
                    return object;
                }
            }
            Object var16_20 = null;
            if (this.waitThreads == null) return object;
            if (removeWait) return object;
            List list = this.waitThreads;
            synchronized (list) {
                if (isRemove) {
                    this.waitThreads.remove(current);
                } else {
                    this.peekWaitThreads.remove(current);
                }
                this.wakeUpThreads.remove(current);
                return object;
            }
        }
        Object var16_21 = null;
        if (this.waitThreads == null) return object;
        if (removeWait) return object;
        List list = this.waitThreads;
        synchronized (list) {
            if (isRemove) {
                this.waitThreads.remove(current);
            } else {
                this.peekWaitThreads.remove(current);
            }
            this.wakeUpThreads.remove(current);
            return object;
        }
    }

    public void remove(Object item) {
        Queue[] queues = this.selector.getQueues();
        for (int i = 0; i < queues.length; ++i) {
            queues[i].remove(item);
        }
    }

    public void clear() {
        Queue[] queues = this.selector.getQueues();
        for (int i = 0; i < queues.length; ++i) {
            queues[i].clear();
        }
    }

    public int size() {
        if (this.selector == null) {
            return 0;
        }
        Queue[] queues = this.selector.getQueues();
        int size = 0;
        if (queues != null) {
            for (int i = 0; i < queues.length; ++i) {
                size += queues[i].size();
            }
        }
        return size;
    }

    public void accept() {
        Queue[] queues = this.selector.getQueues();
        for (int i = 0; i < queues.length; ++i) {
            queues[i].accept();
        }
        this.fourceEndFlg = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        List list;
        Thread waitThread;
        this.fourceEndFlg = true;
        if (this.waitThreads != null) {
            while (true) {
                waitThread = null;
                list = this.waitThreads;
                synchronized (list) {
                    if (this.waitThreads.size() == 0) {
                        break;
                    }
                    waitThread = (Thread)this.waitThreads.get(0);
                    this.wakeUpThreads.add(waitThread);
                    waitThread.interrupt();
                    Thread.yield();
                }
            }
        }
        if (this.pushWaitThreads != null) {
            while (true) {
                waitThread = null;
                list = this.pushWaitThreads;
                synchronized (list) {
                    if (this.pushWaitThreads.size() == 0) {
                        break;
                    }
                    waitThread = (Thread)this.pushWaitThreads.get(0);
                    this.pushKnockedThreads.add(waitThread);
                    waitThread.interrupt();
                    Thread.yield();
                }
            }
        }
        Queue[] queues = this.selector.getQueues();
        for (int i = 0; i < queues.length; ++i) {
            queues[i].release();
        }
    }
}

