/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.io.Externalizer;
import jp.ossc.nimbus.service.io.SerializableExternalizerServiceMBean;

public class SerializableExternalizerService
extends ServiceBase
implements SerializableExternalizerServiceMBean,
Externalizer,
Serializable {
    private static final long serialVersionUID = -2894857230847782064L;
    protected int compressMode = 0;
    protected int compressLevel = -1;
    protected int compressMethod = 8;
    protected int compressThreshold = -1;
    protected int bufferSize;

    public void setCompressMode(int mode) {
        this.compressMode = mode;
    }

    public int getCompressMode() {
        return this.compressMode;
    }

    public void setCompressLevel(int level) {
        this.compressLevel = level;
    }

    public int getCompressLevel() {
        return this.compressLevel;
    }

    public void setCompressMethod(int method) {
        this.compressMethod = method;
    }

    public int getCompressMethod() {
        return this.compressMethod;
    }

    public void setCompressThreshold(int threshold) {
        this.compressThreshold = threshold;
    }

    public int getCompressThreshold() {
        return this.compressThreshold;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(Object obj, ObjectOutput out) throws IOException {
        byte[] bytes;
        ByteArrayOutputStream baos;
        block18: {
            DeflaterOutputStream dos;
            block17: {
                if (this.compressMode == 0) {
                    this.writeInternal(obj, out);
                    return;
                }
                if (obj == null) {
                    out.writeBoolean(false);
                    this.writeInternal(obj, out);
                    return;
                }
                baos = this.bufferSize > 0 ? new ByteArrayOutputStream(this.bufferSize) : new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                this.writeInternal(obj, oos);
                oos.flush();
                bytes = baos.toByteArray();
                if (this.compressThreshold >= bytes.length) {
                    out.writeBoolean(false);
                    this.writeInternal(obj, out);
                    return;
                }
                baos.reset();
                dos = null;
                Deflater deflater = null;
                switch (this.compressMode) {
                    case 1: {
                        deflater = new Deflater(this.compressLevel);
                        dos = this.bufferSize > 0 ? new DeflaterOutputStream((OutputStream)baos, deflater, this.bufferSize) : new DeflaterOutputStream((OutputStream)baos, deflater);
                        break;
                    }
                    case 2: {
                        ZipOutputStream zos = new ZipOutputStream(baos);
                        zos.setLevel(this.compressLevel);
                        zos.setMethod(this.compressMethod);
                        zos.putNextEntry(new ZipEntry("a"));
                        dos = zos;
                        break;
                    }
                    case 3: {
                        dos = this.bufferSize > 0 ? new GZIPOutputStream((OutputStream)baos, this.bufferSize) : new GZIPOutputStream(baos);
                        break;
                    }
                    default: {
                        throw new IOException("Unknown compress mode : " + this.compressMode);
                    }
                }
                try {
                    dos.write(bytes, 0, bytes.length);
                    if (this.compressMode == 2) {
                        ((ZipOutputStream)dos).closeEntry();
                    }
                    dos.finish();
                    Object var10_9 = null;
                    if (deflater == null) break block17;
                    deflater.end();
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (deflater != null) {
                        deflater.end();
                    }
                    try {
                        dos.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    baos.close();
                    throw throwable;
                }
            }
            try {
                dos.close();
                break block18;
            }
            catch (IOException e) {
                // empty catch block
            }
            {
            }
        }
        baos.close();
        byte[] compressedBytes = baos.toByteArray();
        if (bytes.length <= compressedBytes.length) {
            out.writeBoolean(false);
            this.writeInternal(obj, out);
        } else {
            out.writeBoolean(true);
            out.writeInt(compressedBytes.length);
            out.write(compressedBytes);
        }
    }

    protected void writeInternal(Object obj, ObjectOutput out) throws IOException {
        out.writeObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object object;
        InflaterInputStream is;
        ByteArrayInputStream bais;
        block14: {
            if (this.compressMode == 0) {
                return this.readInternal(in);
            }
            boolean isCompressed = in.readBoolean();
            if (!isCompressed) {
                return this.readInternal(in);
            }
            int length = in.readInt();
            byte[] bytes = new byte[length];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int read = 0;
            while ((read = in.read(bytes)) != -1) {
                baos.write(bytes, 0, read);
            }
            bais = new ByteArrayInputStream(baos.toByteArray());
            is = null;
            Inflater inflater = null;
            switch (this.compressMode) {
                case 1: {
                    inflater = new Inflater();
                    is = this.bufferSize > 0 ? new InflaterInputStream(bais, inflater, this.bufferSize) : new InflaterInputStream(bais);
                    break;
                }
                case 2: {
                    is = new ZipInputStream(bais);
                    ((ZipInputStream)is).getNextEntry();
                    break;
                }
                case 3: {
                    is = this.bufferSize > 0 ? new GZIPInputStream((InputStream)bais, this.bufferSize) : new GZIPInputStream(bais);
                    break;
                }
                default: {
                    throw new IOException("Unknown compress mode : " + this.compressMode);
                }
            }
            ObjectInputStream ois = new ObjectInputStream(is);
            try {
                object = this.readInternal(ois);
                Object var13_12 = null;
                if (inflater == null) break block14;
                inflater.end();
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (inflater != null) {
                    inflater.end();
                }
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                bais.close();
                throw throwable;
            }
        }
        try {
            ((InputStream)is).close();
        }
        catch (IOException e) {
            // empty catch block
        }
        bais.close();
        return object;
    }

    protected Object readInternal(ObjectInput in) throws IOException, ClassNotFoundException {
        return in.readObject();
    }
}

