/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.graph.DatasetCondition;
import jp.ossc.nimbus.service.graph.DatasetConnection;
import jp.ossc.nimbus.service.graph.DatasetCreateException;
import jp.ossc.nimbus.service.graph.DatasetFactory;
import jp.ossc.nimbus.service.graph.SeriesCursor;
import jp.ossc.nimbus.service.graph.TimeSeriesCollectionFactoryServiceMBean;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;

public abstract class TimeSeriesCollectionFactoryService
extends ServiceBase
implements DatasetFactory,
TimeSeriesCollectionFactoryServiceMBean {
    private static final long serialVersionUID = -2875237240430766743L;
    protected static final int PERIOD_MILLISECOND = 1;
    protected static final int PERIOD_FIXEDMILLISECOND = 2;
    protected static final int PERIOD_SECOND = 3;
    protected static final int PERIOD_MINUTE = 4;
    protected static final int PERIOD_HOUR = 5;
    protected static final int PERIOD_DAY = 6;
    protected static final int PERIOD_WEEK = 7;
    protected static final int PERIOD_MONTH = 8;
    protected static final int PERIOD_QUARTER = 9;
    protected static final int PERIOD_YEAR = 10;
    protected String dataSetName;
    protected Map timePeriodClassMap;
    protected int collateDataType;
    protected boolean isIgnoreSameValue;
    protected int collateDataField = 14;
    protected int collateDataPeriod = 1;
    protected int inputDataField = 14;
    protected int inputDataPeriod = 1;
    protected boolean isAutoTimesharing;
    protected int collateDataDateType = 1;

    public void setName(String name) {
        this.dataSetName = name;
    }

    public String getName() {
        return this.dataSetName;
    }

    public void setTimePeriodClass(String seriesName, Class clazz) {
        this.timePeriodClassMap.put(seriesName, clazz);
    }

    public Class getTimePeriodClass(String seriesName) {
        return (Class)this.timePeriodClassMap.get(seriesName);
    }

    public void setCollateDataType(int type) {
        this.collateDataType = type;
    }

    public int getCollateDataType() {
        return this.collateDataType;
    }

    public boolean isIgnoreSameValue() {
        return this.isIgnoreSameValue;
    }

    public void setIgnoreSameValue(boolean isIgnore) {
        this.isIgnoreSameValue = isIgnore;
    }

    public void setCollateDataPeriod(int field, int period) {
        this.collateDataField = field;
        this.collateDataPeriod = period;
    }

    public void setInputDataPeriod(int field, int period) {
        this.inputDataField = field;
        this.inputDataPeriod = period;
    }

    public void setAutoTimesharing(boolean isAuto) {
        this.isAutoTimesharing = isAuto;
    }

    public boolean isAutoTimesharing() {
        return this.isAutoTimesharing;
    }

    public void setCollateDataDateType(int type) {
        this.collateDataDateType = type;
    }

    public int getCollateDataDateType() {
        return this.collateDataDateType;
    }

    public void preCreateService() throws Exception {
        super.preCreateService();
        this.timePeriodClassMap = new HashMap();
    }

    public void preStartService() throws Exception {
        super.preStartService();
        if (this.dataSetName == null || this.dataSetName.length() == 0) {
            this.dataSetName = this.getServiceName();
        }
    }

    public void postDestroyService() throws Exception {
        this.timePeriodClassMap = null;
        super.postDestroyService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset createDataset(DatasetCondition[] dsConditions) throws DatasetCreateException {
        DatasetConnection connection = this.createConnection(dsConditions);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        try {
            List cursors = connection.getSeriesCursorList();
            if (cursors == null) {
                TimeSeriesCollection timeSeriesCollection = dataset;
                return timeSeriesCollection;
            }
            Calendar workCal = Calendar.getInstance();
            Holder inOut = new Holder();
            Record record = new Record();
            DoubleList sameDateValues = null;
            OHLCList ohlcList = null;
            int imax = cursors.size();
            for (int i = 0; i < imax; ++i) {
                TimeSeriesCursor cursor = (TimeSeriesCursor)cursors.get(i);
                String series = cursor.getSeriesName();
                Class timePeriodClass = (Class)this.timePeriodClassMap.get(series);
                int periodType = 0;
                TimeSeries timeSeries = null;
                if (this.collateDataType != 0) {
                    if (timePeriodClass == null) {
                        timePeriodClass = new TimeSeries((Comparable)((Object)series)).getTimePeriodClass();
                    }
                    timePeriodClass = class$org$jfree$data$time$Millisecond == null ? TimeSeriesCollectionFactoryService.class$("org.jfree.data.time.Millisecond") : class$org$jfree$data$time$Millisecond;
                    timeSeries = new TimeSeries((Comparable)((Object)series), timePeriodClass);
                } else if (timePeriodClass != null) {
                    timeSeries = new TimeSeries((Comparable)((Object)series), timePeriodClass);
                } else {
                    timeSeries = new TimeSeries((Comparable)((Object)series));
                    timePeriodClass = timeSeries.getTimePeriodClass();
                }
                periodType = this.convertPeriodType(timePeriodClass);
                double value = 0.0;
                if (sameDateValues != null) {
                    sameDateValues.clear();
                }
                if (ohlcList != null) {
                    ohlcList.clear();
                }
                inOut.clear();
                record.clear();
                Date date = null;
                boolean hasNext = cursor.next();
                while (hasNext) {
                    double tmpValue;
                    if (inOut.date == null || inOut.preDate == null) {
                        inOut.preDate = inOut.date;
                    } else {
                        inOut.preDate.setTime(inOut.date.getTime());
                    }
                    date = cursor.getDate();
                    if (date == null) {
                        throw new DatasetCreateException("date is null.");
                    }
                    value = cursor.getValue();
                    boolean wasNull = cursor.wasNull();
                    if (!wasNull) {
                        inOut.date = date;
                        if (this.isAutoTimesharing) {
                            if (inOut.preDate != null && inOut.preDate.equals(date)) {
                                record.setDate(date);
                                record.add(value);
                                hasNext = cursor.next();
                                if (hasNext) {
                                    continue;
                                }
                            } else {
                                record.setPeriodMillis(this.getPeriodMillis(workCal, inOut.lastDate, this.inputDataField, this.inputDataPeriod));
                                inOut.date = inOut.preDate;
                                tmpValue = Double.NaN;
                                while (record.hasNext()) {
                                    if (inOut.date == null || inOut.preDate == null) {
                                        inOut.preDate = (Date)inOut.date.clone();
                                    } else {
                                        inOut.preDate.setTime(inOut.date.getTime());
                                    }
                                    inOut.date = record.nextDate();
                                    tmpValue = record.nextValue();
                                    this.addTimeSeries(date, tmpValue, workCal, timeSeries, periodType, false, inOut);
                                }
                                record.clear();
                                inOut.date = date;
                            }
                        }
                    }
                    if (hasNext) {
                        hasNext = cursor.next();
                    }
                    if (!hasNext) {
                        if (this.collateDataType == 0) continue;
                        if (this.isAutoTimesharing && record.size() != 0) {
                            record.setPeriodMillis(this.getPeriodMillis(workCal, inOut.lastDate, this.inputDataField, this.inputDataPeriod));
                            inOut.date = inOut.preDate;
                            tmpValue = Double.NaN;
                            while (record.hasNext()) {
                                if (inOut.date == null || inOut.preDate == null) {
                                    inOut.preDate = (Date)inOut.date.clone();
                                } else {
                                    inOut.preDate.setTime(inOut.date.getTime());
                                }
                                inOut.date = record.nextDate();
                                tmpValue = record.nextValue();
                                this.addTimeSeries(date, tmpValue, workCal, timeSeries, periodType, wasNull && !record.hasNext(), inOut);
                            }
                            record.clear();
                            inOut.date = date;
                        } else {
                            this.addTimeSeries(date, value, workCal, timeSeries, periodType, false, inOut);
                        }
                        if (wasNull) continue;
                        this.addTimeSeries(date, value, workCal, timeSeries, periodType, true, inOut);
                        continue;
                    }
                    if (wasNull) continue;
                    this.addTimeSeries(date, value, workCal, timeSeries, periodType, false, inOut);
                }
                dataset.addSeries(timeSeries);
                timePeriodClass = null;
                cursor.close();
            }
        }
        finally {
            connection.close();
        }
        return dataset;
    }

    protected abstract DatasetConnection createConnection(DatasetCondition[] var1) throws DatasetCreateException;

    protected long getStartMillis(Calendar cal, Date date) {
        cal.setTime(date);
        int currVal = cal.get(this.collateDataField);
        switch (this.collateDataField) {
            case 13: {
                cal.set(14, 0);
                break;
            }
            case 12: {
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 10: 
            case 11: {
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 2: 
            case 5: {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 1: {
                cal.set(2, 0);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
        }
        cal.set(this.collateDataField, currVal - currVal % this.collateDataPeriod);
        return cal.getTimeInMillis();
    }

    protected void addTimeSeries(Date realDate, double value, Calendar workCal, TimeSeries timeSeries, int periodType, boolean isFinish, Holder inOut) {
        long period = -1L;
        if (this.collateDataType != 0) {
            period = this.getPeriodMillis(workCal, inOut.date, this.collateDataField, this.collateDataPeriod);
            long startMillis = this.getStartMillis(workCal, inOut.date);
            int lastIndex = 0;
            switch (this.collateDataType) {
                case 1: {
                    if (inOut.lastStartMillis != -1L && inOut.lastStartMillis == startMillis && !isFinish) {
                        if (Double.isNaN(inOut.validValue)) {
                            inOut.validValue = value;
                        }
                        return;
                    }
                    inOut.validValue = Double.NaN;
                    inOut.date = new Date(startMillis);
                    break;
                }
                case 2: {
                    if (inOut.lastStartMillis != -1L && inOut.lastStartMillis == startMillis && !isFinish) {
                        inOut.validValue = value;
                        return;
                    }
                    if (timeSeries.getItemCount() != 0 && !Double.isNaN(inOut.validValue)) {
                        lastIndex = timeSeries.getItemCount() - 1;
                        if (!this.isIgnoreSameValue || isFinish || inOut.lastValue != inOut.validValue) {
                            timeSeries.update(lastIndex, (Number)new Double(inOut.validValue));
                        } else {
                            timeSeries.delete(lastIndex, lastIndex);
                        }
                        inOut.validValue = Double.NaN;
                    }
                    inOut.date = new Date(startMillis);
                    break;
                }
                case 3: {
                    if (inOut.lastStartMillis != -1L && inOut.lastStartMillis == startMillis && !isFinish) {
                        if (inOut.sameDateValues == null) {
                            inOut.sameDateValues = new DoubleList();
                        }
                        if (this.isIgnoreSameValue) {
                            if (!Double.isNaN(inOut.lastValueForAll) && inOut.lastValueForAll == value) {
                                inOut.existSameValueForAll = true;
                            } else {
                                if (inOut.existSameValue) {
                                    this.addTimeSeries(timeSeries, inOut.preDate, inOut.lastValue, periodType, period, inOut, false);
                                    inOut.existSameValue = false;
                                }
                                if (inOut.existSameValueForAll) {
                                    inOut.sameDateValues.add(inOut.lastValueForAll);
                                    inOut.existSameValueForAll = false;
                                }
                                inOut.sameDateValues.add(value);
                            }
                        } else {
                            inOut.sameDateValues.add(value);
                        }
                        inOut.lastValueForAll = value;
                        return;
                    }
                    if (inOut.sameDateValues != null && inOut.sameDateValues.size() > 0) {
                        long interval = (isFinish ? inOut.date.getTime() - startMillis : period) / (long)(isFinish ? inOut.sameDateValues.size() : inOut.sameDateValues.size() + 1);
                        long additionalTime = inOut.lastStartMillis;
                        DoubleList.DoubleIterator vals = inOut.sameDateValues.iterator();
                        int count = 0;
                        while (vals.hasNext() && (long)count < period) {
                            additionalTime += interval;
                            if (inOut.preDate == null) {
                                inOut.preDate = new Date(additionalTime);
                            } else {
                                inOut.preDate.setTime(additionalTime);
                            }
                            if (interval == 0L) {
                                this.addTimeSeries(timeSeries, inOut.preDate, vals.next(), periodType, period, inOut, true);
                            } else {
                                this.addTimeSeries(timeSeries, inOut.preDate, vals.next(), periodType, period, inOut, false);
                            }
                            ++count;
                        }
                        inOut.sameDateValues.clear();
                    } else if (isFinish && this.isIgnoreSameValue && inOut.existSameValue) {
                        this.addTimeSeries(timeSeries, inOut.date, value, periodType, period, inOut, false);
                    }
                    inOut.date = new Date(startMillis);
                    inOut.lastValueForAll = value;
                    break;
                }
                case 4: 
                case 6: {
                    if (inOut.lastStartMillis != -1L && inOut.lastStartMillis == startMillis && !isFinish) {
                        if (inOut.sameDateValues == null) {
                            inOut.sameDateValues = new DoubleList();
                        }
                        inOut.sameDateValues.add(value);
                        return;
                    }
                    if (inOut.sameDateValues != null && inOut.sameDateValues.size() > 0 || isFinish) {
                        if (isFinish) {
                            if (inOut.sameDateValues != null && inOut.sameDateValues.size() != 0) {
                                long interval;
                                if (this.isIgnoreSameValue) {
                                    DoubleList.DoubleIterator vals = inOut.sameDateValues.iterator();
                                    double tmpLastValue = inOut.lastValue;
                                    while (vals.hasNext()) {
                                        double val = vals.next();
                                        if (!Double.isNaN(tmpLastValue) && tmpLastValue == val) {
                                            if (vals.hasNext()) {
                                                vals.remove();
                                            }
                                        } else if (inOut.existSameValue) {
                                            this.addTimeSeries(timeSeries, inOut.preDate, inOut.lastValue, periodType, period, inOut, false);
                                            inOut.existSameValue = false;
                                        }
                                        tmpLastValue = val;
                                    }
                                    vals.reset();
                                }
                                if ((interval = (inOut.date.getTime() - startMillis) / (long)inOut.sameDateValues.size()) == 0L) {
                                    DoubleList.DoubleIterator vals = inOut.sameDateValues.iterator();
                                    lastIndex = timeSeries.getItemCount() - 1;
                                    double sum = inOut.lastValue;
                                    while (vals.hasNext()) {
                                        sum += vals.next();
                                    }
                                    double sumOrAverage = sum;
                                    if (this.collateDataType == 4) {
                                        sumOrAverage = sum / (double)(inOut.sameDateValues.size() + 1);
                                    }
                                    if (!this.isIgnoreSameValue || !inOut.existSameValue) {
                                        timeSeries.update(lastIndex, (Number)new Double(sumOrAverage));
                                        inOut.lastValue = sumOrAverage;
                                    } else {
                                        this.addTimeSeries(timeSeries, inOut.preDate, sumOrAverage, periodType, period, inOut, false);
                                        inOut.existSameValue = false;
                                    }
                                } else {
                                    long additionalTime = inOut.lastStartMillis;
                                    int count = 0;
                                    DoubleList.DoubleIterator vals = inOut.sameDateValues.iterator();
                                    while (vals.hasNext() && (long)count < inOut.date.getTime() - startMillis) {
                                        additionalTime += interval;
                                        if (inOut.preDate == null) {
                                            inOut.preDate = new Date(additionalTime);
                                        } else {
                                            inOut.preDate.setTime(additionalTime);
                                        }
                                        this.addTimeSeries(timeSeries, inOut.preDate, vals.next(), periodType, period, inOut, false);
                                        ++count;
                                    }
                                }
                            } else if (this.isIgnoreSameValue && inOut.existSameValue) {
                                this.addTimeSeries(timeSeries, inOut.preDate, inOut.lastValue, periodType, period, inOut, false);
                                inOut.existSameValue = false;
                            } else {
                                this.deleteLastTimeSeries(timeSeries);
                                this.addTimeSeries(timeSeries, inOut.preDate, value, periodType, period, inOut, false);
                            }
                        } else if (inOut.sameDateValues != null && inOut.sameDateValues.size() > 0) {
                            DoubleList.DoubleIterator vals = inOut.sameDateValues.iterator();
                            lastIndex = timeSeries.getItemCount() - 1;
                            double sum = inOut.lastValue;
                            while (vals.hasNext()) {
                                sum += vals.next();
                            }
                            double sumOrAverage = sum;
                            if (this.collateDataType == 4) {
                                sumOrAverage = sum / (double)(inOut.sameDateValues.size() + 1);
                            }
                            if (!this.isIgnoreSameValue || isFinish || inOut.lastValue != inOut.validValue) {
                                timeSeries.update(lastIndex, (Number)new Double(sumOrAverage));
                            } else {
                                timeSeries.delete(lastIndex, lastIndex);
                            }
                            inOut.sameDateValues.clear();
                        }
                    }
                    inOut.date = new Date(startMillis);
                    break;
                }
                case 5: {
                    if (inOut.lastStartMillis != -1L && inOut.lastStartMillis == startMillis && !isFinish) {
                        if (inOut.ohlcList == null) {
                            inOut.ohlcList = new OHLCList();
                        }
                        if (inOut.ohlcList.size() == 0) {
                            inOut.ohlcList.add(inOut.lastValue);
                        }
                        inOut.ohlcList.add(value);
                        return;
                    }
                    if (inOut.ohlcList != null && inOut.ohlcList.size() > 0 || isFinish) {
                        if (inOut.ohlcList != null && inOut.ohlcList.size() > 0) {
                            long interval = (isFinish ? inOut.date.getTime() - startMillis : period) / (long)(isFinish ? inOut.ohlcList.size() - 1 : inOut.ohlcList.size());
                            long additionalTime = inOut.lastStartMillis;
                            OHLCList.OHLCIterator vals = inOut.ohlcList.iterator();
                            int count = 0;
                            while (vals.hasNext() && (long)count < period) {
                                double tmpValue = vals.next();
                                if (inOut.preDate == null) {
                                    inOut.preDate = new Date(additionalTime);
                                } else {
                                    inOut.preDate.setTime(additionalTime);
                                }
                                if (count == 0) {
                                    if (this.isIgnoreSameValue && inOut.existSameValue && (inOut.ohlcList.size() != 2 || inOut.ohlcList.open != inOut.ohlcList.close)) {
                                        this.addTimeSeries(timeSeries, inOut.preDate, tmpValue, periodType, period, inOut, false);
                                        inOut.existSameValue = false;
                                    }
                                } else if (this.isIgnoreSameValue && inOut.lastValue == tmpValue && (vals.hasNext() || !isFinish)) {
                                    inOut.existSameValue = true;
                                    if (inOut.lastDate == null) {
                                        inOut.lastDate = (Date)inOut.preDate.clone();
                                    } else {
                                        inOut.lastDate.setTime(inOut.preDate.getTime());
                                    }
                                } else if (interval == 0L) {
                                    this.addTimeSeries(timeSeries, inOut.preDate, tmpValue, periodType, period, inOut, true);
                                } else {
                                    this.addTimeSeries(timeSeries, inOut.preDate, tmpValue, periodType, period, inOut, false);
                                }
                                additionalTime += interval;
                                ++count;
                            }
                        } else if (isFinish) {
                            if (this.isIgnoreSameValue && inOut.existSameValue) {
                                this.addTimeSeries(timeSeries, inOut.date, value, periodType, period, inOut, false);
                            } else {
                                this.deleteLastTimeSeries(timeSeries);
                                this.addTimeSeries(timeSeries, realDate, value, periodType, period, inOut, false);
                            }
                        }
                        if (inOut.ohlcList != null) {
                            inOut.ohlcList.clear();
                        }
                    }
                    inOut.date = new Date(startMillis);
                    break;
                }
            }
            inOut.lastStartMillis = startMillis;
        }
        if (!isFinish) {
            if (this.isIgnoreSameValue) {
                switch (this.collateDataType) {
                    case 1: 
                    case 3: 
                    case 5: {
                        if (!Double.isNaN(inOut.lastValue) && inOut.lastValue == value) {
                            inOut.existSameValue = true;
                            break;
                        }
                        if (inOut.existSameValue) {
                            this.addTimeSeries(timeSeries, inOut.preDate, inOut.lastValue, periodType, period, inOut, false);
                            inOut.existSameValue = false;
                        }
                        this.addTimeSeries(timeSeries, inOut.date, value, periodType, period, inOut, false);
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        this.addTimeSeries(timeSeries, inOut.date, value, periodType, period, inOut, false);
                    }
                }
            } else {
                this.addTimeSeries(timeSeries, inOut.date, value, periodType, period, inOut, false);
            }
            if (inOut.preDate == null) {
                inOut.preDate = (Date)inOut.date.clone();
            } else {
                inOut.preDate.setTime(inOut.date.getTime());
            }
        }
    }

    protected long getPeriodMillis(Calendar cal, Date date, int field, int period) {
        switch (field) {
            case 13: {
                return 1000 * period;
            }
            case 12: {
                return 60000 * period;
            }
            case 10: {
                return 3600000 * period;
            }
            case 5: {
                return 86400000 * period;
            }
            case 2: {
                cal.setTime(date);
                int dayOfMonth = cal.getActualMaximum(5);
                return dayOfMonth * 24 * 60 * 60 * 1000 * period;
            }
            case 1: {
                cal.setTime(date);
                int dayOfYear = cal.getActualMaximum(6);
                return dayOfYear * 24 * 60 * 60 * 1000 * period;
            }
        }
        return 1 * period;
    }

    protected int convertPeriodType(Class timePeriodClass) {
        if (timePeriodClass.equals(Millisecond.class)) {
            return 1;
        }
        if (timePeriodClass.equals(FixedMillisecond.class)) {
            return 2;
        }
        if (timePeriodClass.equals(Second.class)) {
            return 3;
        }
        if (timePeriodClass.equals(Minute.class)) {
            return 4;
        }
        if (timePeriodClass.equals(Hour.class)) {
            return 5;
        }
        if (timePeriodClass.equals(Day.class)) {
            return 6;
        }
        if (timePeriodClass.equals(Week.class)) {
            return 7;
        }
        if (timePeriodClass.equals(Month.class)) {
            return 8;
        }
        if (timePeriodClass.equals(Quarter.class)) {
            return 9;
        }
        if (timePeriodClass.equals(Year.class)) {
            return 10;
        }
        return 0;
    }

    protected TimeSeries addTimeSeries(TimeSeries series, Date date, double value, int periodType, long period, Holder inOut, boolean isAddOrUpdate) {
        switch (this.collateDataType) {
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                date = this.createCollateDate(date, period);
                break;
            }
        }
        Millisecond regTimePeriod = null;
        switch (periodType) {
            case 1: {
                regTimePeriod = new Millisecond(date);
                break;
            }
            case 2: {
                regTimePeriod = new FixedMillisecond(date);
                break;
            }
            case 3: {
                regTimePeriod = new Second(date);
                break;
            }
            case 4: {
                regTimePeriod = new Minute(date);
                break;
            }
            case 5: {
                regTimePeriod = new Hour(date);
                break;
            }
            case 6: {
                regTimePeriod = new Day(date);
                break;
            }
            case 7: {
                regTimePeriod = new Week(date);
                break;
            }
            case 8: {
                regTimePeriod = new Month(date);
                break;
            }
            case 9: {
                regTimePeriod = new Quarter(date);
                break;
            }
            case 10: {
                regTimePeriod = new Year(date);
                break;
            }
        }
        if (isAddOrUpdate) {
            series.addOrUpdate((RegularTimePeriod)regTimePeriod, value);
        } else {
            series.add((RegularTimePeriod)regTimePeriod, value);
        }
        if (inOut.lastDate == null) {
            inOut.lastDate = (Date)date.clone();
        } else {
            inOut.lastDate.setTime(date.getTime());
        }
        inOut.lastValue = value;
        return series;
    }

    protected TimeSeries deleteLastTimeSeries(TimeSeries series) {
        int lastIndex = series.getItemCount() - 1;
        if (lastIndex >= 0) {
            series.delete(lastIndex, lastIndex);
        }
        return series;
    }

    protected Date createCollateDate(Date date, long period) {
        Date result = date;
        switch (this.collateDataDateType) {
            case 2: {
                result = (Date)result.clone();
                result.setTime(result.getTime() + period - period / (long)this.collateDataPeriod);
                break;
            }
        }
        return result;
    }

    protected static class OHLCList {
        protected double open = Double.NaN;
        protected double high = Double.NaN;
        protected double low = Double.NaN;
        protected double close = Double.NaN;
        protected boolean isHighLow = true;
        protected OHLCIterator ohlcIterator = new OHLCIterator();

        protected OHLCList() {
        }

        public void add(double val) {
            if (Double.isNaN(this.open)) {
                this.open = val;
                this.high = val;
                this.low = val;
            }
            if (val > this.high) {
                this.high = val;
                this.isHighLow = false;
            }
            if (val < this.low) {
                this.low = val;
                this.isHighLow = true;
            }
            this.close = val;
        }

        public int size() {
            if (Double.isNaN(this.open)) {
                return 0;
            }
            int size = 2;
            if (this.high != this.open && this.high != this.close || this.high == this.open && this.high != this.close && !this.isHighLow || this.high != this.open && this.high == this.close && this.isHighLow) {
                ++size;
            }
            if (this.low != this.open && this.low != this.close || this.low == this.open && this.low != this.close && this.isHighLow || this.low != this.open && this.low == this.close && !this.isHighLow) {
                ++size;
            }
            return size;
        }

        public OHLCIterator iterator() {
            return this.ohlcIterator;
        }

        public void clear() {
            this.open = Double.NaN;
            this.close = Double.NaN;
            this.high = Double.NaN;
            this.low = Double.NaN;
            this.ohlcIterator.reset();
        }

        protected class OHLCIterator {
            protected int index = 0;
            protected int maxSize;

            protected OHLCIterator() {
            }

            public boolean hasNext() {
                if (this.index == 0) {
                    this.maxSize = OHLCList.this.size();
                }
                return this.maxSize > this.index;
            }

            public double next() {
                switch (this.index++) {
                    case 0: {
                        return OHLCList.this.open;
                    }
                    case 1: {
                        if (OHLCList.this.high == OHLCList.this.low) {
                            return OHLCList.this.close;
                        }
                        if (OHLCList.this.isHighLow) {
                            if (OHLCList.this.open == OHLCList.this.high) {
                                return OHLCList.this.low;
                            }
                            return OHLCList.this.high;
                        }
                        if (OHLCList.this.open == OHLCList.this.low) {
                            return OHLCList.this.high;
                        }
                        return OHLCList.this.low;
                    }
                    case 2: {
                        if (OHLCList.this.isHighLow) {
                            if (OHLCList.this.open == OHLCList.this.high) {
                                return OHLCList.this.close;
                            }
                            return OHLCList.this.low;
                        }
                        if (OHLCList.this.open == OHLCList.this.low) {
                            return OHLCList.this.close;
                        }
                        return OHLCList.this.high;
                    }
                }
                return OHLCList.this.close;
            }

            public void reset() {
                this.index = 0;
                this.maxSize = 0;
            }
        }
    }

    protected static class DoubleList {
        protected static final int INIT_SIZE = 10;
        protected static final int CAPACITY_INCREMENT_SIZE = 10;
        protected double[] vals = new double[10];
        protected int index;
        protected DoubleIterator doubleIterator = new DoubleIterator();

        protected DoubleList() {
        }

        public void add(double val) {
            if (this.vals.length <= this.index) {
                double[] tmpVals = new double[this.vals.length + 10];
                System.arraycopy(this.vals, 0, tmpVals, 0, this.vals.length);
                this.vals = tmpVals;
            }
            this.vals[this.index++] = val;
        }

        public int size() {
            return this.index;
        }

        public DoubleIterator iterator() {
            return this.doubleIterator;
        }

        public void clear() {
            this.index = 0;
            this.doubleIterator.reset();
        }

        protected class DoubleIterator {
            protected int iteratorIndex = 0;

            protected DoubleIterator() {
            }

            public boolean hasNext() {
                return DoubleList.this.index > this.iteratorIndex;
            }

            public double next() {
                return DoubleList.this.vals[this.iteratorIndex++];
            }

            public void remove() {
                System.arraycopy(DoubleList.this.vals, this.iteratorIndex, DoubleList.this.vals, this.iteratorIndex - 1, DoubleList.this.index - this.iteratorIndex);
                --this.iteratorIndex;
                --DoubleList.this.index;
            }

            public void reset() {
                this.iteratorIndex = 0;
            }
        }
    }

    protected static class Holder {
        public boolean existSameValue;
        public double validValue = Double.NaN;
        public DoubleList sameDateValues;
        public OHLCList ohlcList;
        public double lastValueForAll = Double.NaN;
        public boolean existSameValueForAll;
        public long lastStartMillis = -1L;
        public Date date;
        public Date preDate;
        public Date lastDate;
        public double lastValue = Double.NaN;

        protected Holder() {
        }

        public void clear() {
            this.existSameValue = false;
            this.validValue = Double.NaN;
            this.sameDateValues = null;
            this.ohlcList = null;
            this.lastValueForAll = Double.NaN;
            this.existSameValueForAll = false;
            this.lastStartMillis = -1L;
            this.date = null;
            this.preDate = null;
            this.lastDate = null;
            this.lastValue = Double.NaN;
        }
    }

    protected static class Record {
        protected Date date;
        protected DoubleList doubleList = new DoubleList();
        protected long periodMillis = -1L;

        protected Record() {
        }

        public void add(double val) {
            this.doubleList.add(val);
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public void setPeriodMillis(long millis) {
            this.periodMillis = millis;
        }

        public Date nextDate() {
            long millis = this.date.getTime();
            long interval = this.periodMillis / (long)(this.size() + 1);
            this.date.setTime(millis + interval);
            return this.date;
        }

        public double nextValue() {
            return this.doubleList.iterator().next();
        }

        public boolean hasNext() {
            return this.doubleList.iterator().hasNext();
        }

        public int size() {
            return this.doubleList.size();
        }

        public void clear() {
            this.date = null;
            this.doubleList.clear();
            this.periodMillis = -1L;
        }
    }

    protected abstract class TimeSeriesCursor
    extends SeriesCursor {
        public TimeSeriesCursor(String seriesName) {
            super(seriesName);
        }

        public abstract Date getDate() throws DatasetCreateException;

        public abstract double getValue() throws DatasetCreateException;

        public abstract boolean wasNull() throws DatasetCreateException;
    }
}

