/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.connection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.beans.NestedProperty;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyAccess;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.connection.DefaultPersistentManagerServiceMBean;
import jp.ossc.nimbus.service.connection.PersistentException;
import jp.ossc.nimbus.service.connection.PersistentManager;

public class DefaultPersistentManagerService
extends ServiceBase
implements PersistentManager,
DefaultPersistentManagerServiceMBean {
    private static final long serialVersionUID = 301756347991573032L;
    private PropertyAccess propertyAccess;
    private boolean isIgnoreNullProperty;
    private Map resultSetJDBCTypeMap;

    public void setIgnoreNullProperty(boolean isIgnore) {
        this.isIgnoreNullProperty = isIgnore;
    }

    public boolean isIgnoreNullProperty() {
        return this.isIgnoreNullProperty;
    }

    public void setResultSetJDBCTypeMap(Map mapping) {
        this.resultSetJDBCTypeMap = mapping;
    }

    public Map getResultSetJDBCTypeMap() {
        return this.resultSetJDBCTypeMap;
    }

    public void setResultSetJDBCType(String jdbcType, Class javaType) throws IllegalArgumentException {
        Integer type = null;
        try {
            Field field = Types.class.getField(jdbcType);
            type = (Integer)field.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.toString());
        }
        this.resultSetJDBCTypeMap.put(type, javaType);
    }

    public void createService() throws Exception {
        this.resultSetJDBCTypeMap = new HashMap();
        this.resultSetJDBCTypeMap.put(new Integer(1), String.class);
        this.resultSetJDBCTypeMap.put(new Integer(12), String.class);
        this.resultSetJDBCTypeMap.put(new Integer(-1), String.class);
        this.resultSetJDBCTypeMap.put(new Integer(2), BigDecimal.class);
        this.resultSetJDBCTypeMap.put(new Integer(-7), Boolean.TYPE);
        this.resultSetJDBCTypeMap.put(new Integer(-6), Byte.TYPE);
        this.resultSetJDBCTypeMap.put(new Integer(5), Short.TYPE);
        this.resultSetJDBCTypeMap.put(new Integer(4), Integer.TYPE);
        this.resultSetJDBCTypeMap.put(new Integer(-5), Long.TYPE);
        this.resultSetJDBCTypeMap.put(new Integer(7), Float.TYPE);
        this.resultSetJDBCTypeMap.put(new Integer(8), Double.TYPE);
        this.resultSetJDBCTypeMap.put(new Integer(-2), [B.class);
        this.resultSetJDBCTypeMap.put(new Integer(-3), [B.class);
        this.resultSetJDBCTypeMap.put(new Integer(-4), [B.class);
        this.resultSetJDBCTypeMap.put(new Integer(91), Date.class);
        this.resultSetJDBCTypeMap.put(new Integer(92), Time.class);
        this.resultSetJDBCTypeMap.put(new Integer(93), Timestamp.class);
        this.resultSetJDBCTypeMap.put(new Integer(2005), Clob.class);
        this.resultSetJDBCTypeMap.put(new Integer(2004), Blob.class);
        this.resultSetJDBCTypeMap.put(new Integer(2003), java.sql.Array.class);
        this.resultSetJDBCTypeMap.put(new Integer(2002), Struct.class);
        this.resultSetJDBCTypeMap.put(new Integer(2006), Ref.class);
    }

    public void startService() throws Exception {
        this.propertyAccess = new PropertyAccess();
        this.propertyAccess.setIgnoreNullProperty(this.isIgnoreNullProperty);
    }

    public Object loadQuery(Connection con, String query, Object input, Object output) throws PersistentException {
        StringBuffer buf = new StringBuffer(query);
        List inputProps = this.parseInput(buf);
        List outputProps = this.parseOutput(buf);
        String sql = buf.toString();
        return this.load(con, sql, input, inputProps, output, outputProps);
    }

    private List parseInput(StringBuffer query) throws PersistentException {
        return this.parseQuery(query, "<-{");
    }

    private List parseOutput(StringBuffer query) throws PersistentException {
        return this.parseQuery(query, "->{");
    }

    private List parseQuery(StringBuffer query, String prefix) throws PersistentException {
        ArrayList<String> props = null;
        int startIndex;
        while ((startIndex = query.indexOf(prefix)) != -1) {
            int endIndex = query.indexOf("}", startIndex + 3);
            if (endIndex == -1) {
                throw new PersistentException("Illegal query : " + query);
            }
            String propStr = query.substring(startIndex + 3, endIndex).trim();
            if (propStr.length() == 0) {
                throw new PersistentException("Illegal query : " + query);
            }
            if (props == null) {
                props = new ArrayList<String>();
            }
            props.add(propStr);
            query.delete(startIndex, endIndex + 1);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(Connection con, String sql, Object input, Object inputProps, Object output, Object outputProps) throws PersistentException {
        SQLException e92;
        Object object;
        ResultSet resultSet;
        block52: {
            ArrayList<Object> inputPropList = null;
            if (inputProps != null) {
                if (inputProps.getClass().isArray()) {
                    inputPropList = Arrays.asList((Object[])inputProps);
                } else if (inputProps instanceof List) {
                    inputPropList = (ArrayList<Object>)inputProps;
                } else if (inputProps instanceof String) {
                    inputPropList = new ArrayList<Object>();
                    inputPropList.add(inputProps);
                } else {
                    throw new PersistentException("No supported inputProps type." + inputProps);
                }
            }
            ArrayList<Object> outputPropList = null;
            HashMap<String, String> outputPropMap = null;
            if (outputProps != null) {
                if (outputProps.getClass().isArray()) {
                    outputPropList = Arrays.asList((Object[])outputProps);
                } else if (outputProps instanceof List) {
                    outputPropList = (ArrayList<Object>)outputProps;
                } else if (outputProps instanceof Map) {
                    outputPropMap = (HashMap<String, String>)outputProps;
                } else if (outputProps instanceof String) {
                    outputPropList = new ArrayList<Object>();
                    outputPropList.add(outputProps);
                } else {
                    throw new PersistentException("No supported outputProps type." + outputProps);
                }
            }
            PreparedStatement statement = null;
            resultSet = null;
            try {
                int i;
                try {
                    statement = con.prepareStatement(sql);
                }
                catch (SQLException e2) {
                    throw new PersistentException("Illegal sql : " + sql, e2);
                }
                try {
                    try {
                        ParameterMetaData metadata = statement.getParameterMetaData();
                        if (inputPropList != null && inputPropList.size() != metadata.getParameterCount()) {
                            throw new PersistentException("Illegal sql : " + sql);
                        }
                    }
                    catch (IncompatibleClassChangeError e3) {
                        // empty catch block
                    }
                    if (input != null) {
                        int imax;
                        if (inputPropList != null) {
                            imax = inputPropList.size();
                            for (int i2 = 0; i2 < imax; ++i2) {
                                Object param = this.propertyAccess.get(input, inputPropList.get(i2).toString());
                                this.setObject(statement, i2 + 1, param);
                            }
                        } else if (input.getClass().isArray()) {
                            imax = Array.getLength(input);
                            for (int i3 = 0; i3 < imax; ++i3) {
                                Object param = Array.get(input, i3);
                                this.setObject(statement, i3 + 1, param);
                            }
                        } else if (input instanceof List) {
                            List list = (List)input;
                            int imax2 = list.size();
                            for (i = 0; i < imax2; ++i) {
                                Object param = list.get(i);
                                this.setObject(statement, i + 1, param);
                            }
                        } else {
                            this.setObject(statement, 1, input);
                        }
                    }
                }
                catch (NoSuchPropertyException e4) {
                    throw new PersistentException("Input bean get error.", e4);
                }
                catch (InvocationTargetException e5) {
                    throw new PersistentException("Input bean get error.", e5);
                }
                catch (SQLException e6) {
                    throw new PersistentException("The parameter is not suitable for SQL.", e6);
                }
                try {
                    resultSet = statement.executeQuery();
                }
                catch (SQLException e7) {
                    throw new PersistentException("SQL execute error : " + sql, e7);
                }
                if (outputPropList != null) {
                    try {
                        ResultSetMetaData metadata = resultSet.getMetaData();
                        if (outputPropList.size() != metadata.getColumnCount()) {
                            throw new PersistentException("Illegal sql : " + sql);
                        }
                        outputPropMap = new HashMap<String, String>();
                        int imax = outputPropList.size();
                        for (i = 0; i < imax; ++i) {
                            outputPropMap.put(metadata.getColumnName(i + 1), outputPropList.get(i).toString());
                        }
                    }
                    catch (SQLException e8) {
                        throw new PersistentException("The parameter is not suitable for SQL.", e8);
                    }
                }
                object = this.fillOutput(resultSet, output, outputPropMap, false);
                Object var17_30 = null;
                if (statement == null) break block52;
            }
            catch (Throwable throwable) {
                block55: {
                    SQLException e92;
                    Object var17_31 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e92) {
                            // empty catch block
                        }
                        statement = null;
                    }
                    if (resultSet == null) break block55;
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e92) {
                        // empty catch block
                    }
                    resultSet = null;
                }
                throw throwable;
            }
            try {
                statement.close();
            }
            catch (SQLException e92) {
                // empty catch block
            }
            statement = null;
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e92) {
                // empty catch block
            }
            resultSet = null;
        }
        return object;
    }

    private Object fillOutput(ResultSet resultSet, Object output, Map outputMapping, boolean isCursor) throws PersistentException {
        if (output == null) {
            output = isCursor ? new HashMap() : new ArrayList();
        }
        try {
            Record record;
            ResultSetMetaData metadata = resultSet.getMetaData();
            int colCount = metadata.getColumnCount();
            if (outputMapping == null && (output instanceof RecordList || output instanceof Record || !(output instanceof List))) {
                outputMapping = new HashMap<String, String>();
                for (int i = 1; i <= colCount; ++i) {
                    outputMapping.put(metadata.getColumnName(i), metadata.getColumnName(i));
                }
            }
            if (output instanceof DataSet) {
                HashSet headerSet = new HashSet();
                HashMap recordListMap = new HashMap();
                HashMap recordListPropMap = new HashMap();
                Iterator itr = outputMapping.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Property prop = this.propertyAccess.getProperty((String)entry.getValue());
                    if (prop instanceof NestedProperty) {
                        Object obj = ((NestedProperty)prop).getThisProperty().getProperty(output);
                        if (obj instanceof RecordList) {
                            recordListMap.put(entry.getKey(), (RecordList)obj);
                            recordListPropMap.put(entry.getKey(), ((NestedProperty)prop).getNestedProperty());
                            continue;
                        }
                        headerSet.add(entry.getKey());
                        continue;
                    }
                    throw new PersistentException("Output bean fill error.");
                }
                HashMap<RecordList, Record> recordMap = new HashMap<RecordList, Record>();
                while (isCursor || resultSet.next()) {
                    if (headerSet.size() != 0) {
                        itr = headerSet.iterator();
                        while (itr.hasNext()) {
                            String columnName = (String)((Object)itr.next());
                            this.setValue(output, (String)outputMapping.get(columnName), resultSet, columnName);
                        }
                        headerSet.clear();
                    }
                    recordMap.clear();
                    itr = recordListMap.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = itr.next();
                        RecordList list = (RecordList)entry.getValue();
                        Record record2 = (Record)recordMap.get(list);
                        if (record2 == null) {
                            record2 = list.createRecord();
                            recordMap.put(list, record2);
                            list.addRecord(record2);
                        }
                        Property prop = (Property)recordListPropMap.get(entry.getKey());
                        prop.setProperty(record2, this.getValue((Object)record2, prop, resultSet, (String)entry.getKey()));
                    }
                    if (!isCursor) continue;
                }
                return output;
            }
            if (output instanceof RecordList) {
                RecordList list = (RecordList)output;
                if (list.getSchema() == null) {
                    list.setSchema(this.createSchema(metadata));
                }
                while (isCursor || resultSet.next()) {
                    Record record3 = list.createRecord();
                    Iterator itr = outputMapping.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = itr.next();
                        this.setValue((Object)record3, (String)entry.getValue(), resultSet, (String)entry.getKey());
                    }
                    list.addRecord(record3);
                    if (!isCursor) continue;
                    break;
                }
                return list;
            }
            if (output instanceof List) {
                List list = (List)((Object)output);
                while (isCursor || resultSet.next()) {
                    HashMap<String, Object> record4 = new HashMap<String, Object>();
                    for (int i = 1; i <= colCount; ++i) {
                        record4.put(metadata.getColumnName(i), resultSet.getObject(i));
                    }
                    list.add(record4);
                    if (!isCursor) continue;
                    break;
                }
                return list;
            }
            if (output instanceof Class) {
                Class outputClass;
                if (Record.class.isAssignableFrom(outputClass = (Class)((Object)output))) {
                    if (!isCursor && !resultSet.next()) {
                        return null;
                    }
                    Record record5 = null;
                    try {
                        record5 = (Record)outputClass.newInstance();
                        if (record5.getSchema() == null) {
                            record5.setSchema(this.createSchema(metadata));
                        }
                    }
                    catch (InstantiationException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    Iterator itr = outputMapping.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = itr.next();
                        this.setValue((Object)record5, (String)entry.getValue(), resultSet, (String)entry.getKey());
                    }
                    return record5;
                }
                if (RecordList.class.isAssignableFrom(outputClass)) {
                    RecordList list = null;
                    try {
                        list = (RecordList)outputClass.newInstance();
                        if (list.getSchema() == null) {
                            list.setSchema(this.createSchema(metadata));
                        }
                    }
                    catch (InstantiationException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    while (isCursor || resultSet.next()) {
                        Record record6 = list.createRecord();
                        Iterator itr = outputMapping.entrySet().iterator();
                        while (itr.hasNext()) {
                            Map.Entry entry = itr.next();
                            this.setValue((Object)record6, (String)entry.getValue(), resultSet, (String)entry.getKey());
                        }
                        list.addRecord(record6);
                        if (!isCursor) continue;
                        break;
                    }
                    return list;
                }
                if (isCursor) {
                    Object bean = null;
                    try {
                        bean = outputClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    Iterator itr = outputMapping.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = itr.next();
                        this.setValue(bean, (String)entry.getValue(), resultSet, (String)entry.getKey());
                    }
                    return bean;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                while (resultSet.next()) {
                    Object bean = null;
                    try {
                        bean = outputClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PersistentException("Output bean instantiate error.", e);
                    }
                    Iterator itr = outputMapping.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = itr.next();
                        this.setValue(bean, (String)entry.getValue(), resultSet, (String)entry.getKey());
                    }
                    list.add(bean);
                }
                return list;
            }
            if (!isCursor) {
                resultSet.next();
            }
            if (output instanceof Record && (record = (Record)output).getSchema() == null) {
                record.setSchema(this.createSchema(metadata));
            }
            Iterator itr = outputMapping.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                this.setValue(output, (String)entry.getValue(), resultSet, (String)entry.getKey());
            }
            return output;
        }
        catch (IllegalArgumentException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        catch (NoSuchPropertyException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        catch (InvocationTargetException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        catch (SQLException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
    }

    private void setValue(Object target, String propName, ResultSet rs, String cloumnName) throws PersistentException {
        int index = 0;
        try {
            index = rs.findColumn(cloumnName);
        }
        catch (SQLException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        this.setValue(target, propName, rs, index);
    }

    private void setValue(Object target, String propName, ResultSet rs, int index) throws PersistentException {
        try {
            this.propertyAccess.set(target, propName, this.getValue(target, propName, rs, index));
        }
        catch (IllegalArgumentException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        catch (NoSuchPropertyException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        catch (InvocationTargetException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
    }

    private Object getValue(Object target, String propName, ResultSet rs, int index) throws PersistentException {
        try {
            return this.getValue(target, this.propertyAccess.getProperty(propName), rs, index);
        }
        catch (IllegalArgumentException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
    }

    private Object getValue(Object target, Property prop, ResultSet rs, String cloumnName) throws PersistentException {
        int index = 0;
        try {
            index = rs.findColumn(cloumnName);
        }
        catch (SQLException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        return this.getValue(target, prop, rs, index);
    }

    private Object getValue(Object target, Property prop, ResultSet rs, int index) throws PersistentException {
        try {
            ResultSetMetaData metadata = rs.getMetaData();
            int jdbcType = metadata.getColumnType(index);
            Class type = null;
            Object value = null;
            switch (jdbcType) {
                case 2004: 
                case 2005: {
                    type = prop.getPropertyType(target);
                    switch (jdbcType) {
                        case 2004: {
                            Blob blob = null;
                            if ([B.class.equals(type)) {
                                blob = rs.getBlob(index);
                                if (blob == null) break;
                                value = blob.getBytes(1L, (int)blob.length());
                                break;
                            }
                            if (InputStream.class.equals(type)) {
                                value = rs.getBinaryStream(index);
                                break;
                            }
                            if (String.class.equals(type)) {
                                blob = rs.getBlob(index);
                                if (blob == null) break;
                                value = new String(blob.getBytes(1L, (int)blob.length()));
                                break;
                            }
                            value = rs.getBlob(index);
                            break;
                        }
                        case 2005: {
                            Clob clob = null;
                            if ([C.class.equals(type)) {
                                clob = rs.getClob(index);
                                if (clob == null) break;
                                Reader r = clob.getCharacterStream();
                                value = new char[(int)clob.length()];
                                r.read((char[])value);
                                r.close();
                                break;
                            }
                            if (InputStream.class.equals(type)) {
                                value = rs.getAsciiStream(index);
                                break;
                            }
                            if (Reader.class.equals(type)) {
                                clob = rs.getClob(index);
                                if (clob == null) break;
                                value = clob.getCharacterStream();
                                break;
                            }
                            if (String.class.equals(type)) {
                                clob = rs.getClob(index);
                                if (clob == null) break;
                                value = clob.getSubString(1L, (int)clob.length());
                                break;
                            }
                            value = rs.getClob(index);
                        }
                    }
                    break;
                }
                default: {
                    value = rs.getObject(index);
                }
            }
            return value;
        }
        catch (IOException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        catch (NoSuchPropertyException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        catch (InvocationTargetException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
        catch (SQLException e) {
            throw new PersistentException("Output bean fill error.", e);
        }
    }

    private void setObject(PreparedStatement statement, int index, Object value) throws PersistentException {
        try {
            if (value != null) {
                if (value instanceof byte[]) {
                    statement.setBinaryStream(index, (InputStream)new ByteArrayInputStream((byte[])value), ((byte[])value).length);
                    return;
                }
                if (value instanceof InputStream) {
                    InputStream is = (InputStream)value;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] bytes = new byte[1024];
                    int length = 0;
                    try {
                        while ((length = is.read(bytes)) != -1) {
                            baos.write(bytes, 0, length);
                        }
                    }
                    catch (IOException e) {
                        throw new PersistentException(e);
                    }
                    bytes = baos.toByteArray();
                    statement.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                    return;
                }
                if (value instanceof char[]) {
                    statement.setCharacterStream(index, (Reader)new CharArrayReader((char[])value), ((char[])value).length);
                    return;
                }
                if (value instanceof Reader) {
                    Reader reader = (Reader)value;
                    CharArrayWriter caw = new CharArrayWriter();
                    char[] chars = new char[1024];
                    int length = 0;
                    try {
                        while ((length = reader.read(chars)) != -1) {
                            caw.write(chars, 0, length);
                        }
                    }
                    catch (IOException e) {
                        throw new PersistentException(e);
                    }
                    chars = caw.toCharArray();
                    statement.setCharacterStream(index, (Reader)new CharArrayReader(chars), chars.length);
                    return;
                }
            }
            statement.setObject(index, value);
        }
        catch (SQLException e) {
            throw new PersistentException("The parameter is not suitable for SQL.", e);
        }
    }

    private String createSchema(ResultSetMetaData metadata) throws SQLException {
        int colCount = metadata.getColumnCount();
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i <= colCount; ++i) {
            Class type = (Class)this.resultSetJDBCTypeMap.get(new Integer(metadata.getColumnType(i)));
            buf.append(':').append(metadata.getColumnName(i));
            if (type != null) {
                buf.append(',').append(type.getName());
            }
            if (i == colCount) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    public PersistentManager.Cursor createQueryCursor(Connection con, String query, Object input) throws PersistentException {
        StringBuffer buf = new StringBuffer(query);
        List inputProps = this.parseInput(buf);
        List outputProps = this.parseOutput(buf);
        String sql = buf.toString();
        return this.createCursor(con, sql, input, inputProps, outputProps);
    }

    public PersistentManager.Cursor createCursor(Connection con, String sql, Object input, Object inputProps, Object outputProps) throws PersistentException {
        int i;
        ArrayList<Object> inputPropList = null;
        if (inputProps != null) {
            if (inputProps.getClass().isArray()) {
                inputPropList = Arrays.asList((Object[])inputProps);
            } else if (inputProps instanceof List) {
                inputPropList = (ArrayList<Object>)inputProps;
            } else if (inputProps instanceof String) {
                inputPropList = new ArrayList<Object>();
                inputPropList.add(inputProps);
            } else {
                throw new PersistentException("No supported inputProps type." + inputProps);
            }
        }
        ArrayList<Object> outputPropList = null;
        HashMap<String, String> outputPropMap = null;
        if (outputProps != null) {
            if (outputProps.getClass().isArray()) {
                outputPropList = Arrays.asList((Object[])outputProps);
            } else if (outputProps instanceof List) {
                outputPropList = (ArrayList<Object>)outputProps;
            } else if (outputProps instanceof Map) {
                outputPropMap = (HashMap<String, String>)outputProps;
            } else if (outputProps instanceof String) {
                outputPropList = new ArrayList<Object>();
                outputPropList.add(outputProps);
            } else {
                throw new PersistentException("No supported outputProps type." + outputProps);
            }
        }
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = con.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new PersistentException("Illegal sql : " + sql, e);
        }
        try {
            try {
                ParameterMetaData metadata = statement.getParameterMetaData();
                if (inputPropList != null && inputPropList.size() != metadata.getParameterCount()) {
                    throw new PersistentException("Illegal sql : " + sql);
                }
            }
            catch (IncompatibleClassChangeError e) {
                // empty catch block
            }
            if (input != null) {
                int imax;
                if (inputPropList != null) {
                    imax = inputPropList.size();
                    for (int i2 = 0; i2 < imax; ++i2) {
                        Object param = this.propertyAccess.get(input, inputPropList.get(i2).toString());
                        this.setObject(statement, i2 + 1, param);
                    }
                } else if (input.getClass().isArray()) {
                    imax = Array.getLength(input);
                    for (int i3 = 0; i3 < imax; ++i3) {
                        Object param = Array.get(input, i3);
                        this.setObject(statement, i3 + 1, param);
                    }
                } else if (input instanceof List) {
                    List list = (List)input;
                    int imax2 = list.size();
                    for (i = 0; i < imax2; ++i) {
                        Object param = list.get(i);
                        this.setObject(statement, i + 1, param);
                    }
                } else {
                    this.setObject(statement, 1, input);
                }
            }
        }
        catch (NoSuchPropertyException e) {
            throw new PersistentException("Input bean get error.", e);
        }
        catch (InvocationTargetException e) {
            throw new PersistentException("Input bean get error.", e);
        }
        catch (SQLException e) {
            throw new PersistentException("The parameter is not suitable for SQL.", e);
        }
        try {
            resultSet = statement.executeQuery();
        }
        catch (SQLException e) {
            throw new PersistentException("SQL execute error : " + sql, e);
        }
        if (outputPropList != null) {
            try {
                ResultSetMetaData metadata = resultSet.getMetaData();
                if (outputPropList.size() != metadata.getColumnCount()) {
                    throw new PersistentException("Illegal sql : " + sql);
                }
                outputPropMap = new HashMap<String, String>();
                int imax = outputPropList.size();
                for (i = 0; i < imax; ++i) {
                    outputPropMap.put(metadata.getColumnName(i + 1), outputPropList.get(i).toString());
                }
            }
            catch (SQLException e) {
                throw new PersistentException("The parameter is not suitable for SQL.", e);
            }
        }
        return new CursorImpl(statement, resultSet, outputPropMap);
    }

    public int persistQuery(Connection con, String query, Object input) throws PersistentException {
        StringBuffer buf = new StringBuffer(query);
        List inputProps = this.parseInput(buf);
        String sql = buf.toString();
        return this.persist(con, sql, input, inputProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int persist(Connection con, String sql, Object input, Object inputProps) throws PersistentException {
        int n;
        block16: {
            ArrayList<Object> inputPropList = null;
            if (inputProps != null) {
                if (inputProps.getClass().isArray()) {
                    inputPropList = Arrays.asList((Object[])inputProps);
                } else if (inputProps instanceof List) {
                    inputPropList = (ArrayList<Object>)inputProps;
                } else if (inputProps instanceof String) {
                    inputPropList = new ArrayList<Object>();
                    inputPropList.add(inputProps);
                } else {
                    throw new PersistentException("No supported inputProps type." + inputProps);
                }
            }
            PreparedStatement statement = null;
            try {
                try {
                    statement = con.prepareStatement(sql);
                    ParameterMetaData metadata = statement.getParameterMetaData();
                    if (inputPropList != null && inputPropList.size() != metadata.getParameterCount()) {
                        throw new PersistentException("Illegal sql : " + sql);
                    }
                }
                catch (SQLException e) {
                    throw new PersistentException("Illegal sql : " + sql, e);
                }
                catch (IncompatibleClassChangeError e) {
                    // empty catch block
                }
                n = this.persistQueryInternal(sql, statement, input, inputPropList, false);
                Object var9_11 = null;
                if (statement == null) break block16;
            }
            catch (Throwable throwable) {
                block18: {
                    Object var9_12 = null;
                    if (statement == null) break block18;
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    statement = null;
                }
                throw throwable;
            }
            try {
                statement.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            statement = null;
        }
        return n;
    }

    private int persistQueryInternal(String sql, PreparedStatement statement, Object input, List inputProps, boolean isBatch) throws PersistentException {
        if (input instanceof DataSet) {
            if (inputProps == null) {
                throw new PersistentException("Input bean get error.");
            }
            ArrayList<Object> beans = new ArrayList<Object>();
            ArrayList<Property> properties = new ArrayList<Property>();
            int count = -1;
            try {
                Iterator itr = inputProps.iterator();
                while (itr.hasNext()) {
                    Object propStr = itr.next();
                    Property prop = this.propertyAccess.getProperty(propStr.toString());
                    if (prop instanceof NestedProperty) {
                        Object obj = ((NestedProperty)prop).getThisProperty().getProperty(input);
                        if (obj instanceof RecordList) {
                            int size = ((RecordList)obj).size();
                            if (count == -1) {
                                count = size;
                            } else if (count != size) {
                                throw new PersistentException("Input bean get error.");
                            }
                        }
                        beans.add(obj);
                        properties.add(((NestedProperty)prop).getNestedProperty());
                        continue;
                    }
                    throw new PersistentException("Input bean get error.");
                }
            }
            catch (NoSuchPropertyException e) {
                throw new PersistentException("Input bean get error.", e);
            }
            catch (InvocationTargetException e) {
                throw new PersistentException("Input bean get error.", e);
            }
            if (count == 0) {
                return 0;
            }
            if (count == -1) {
                try {
                    int imax = beans.size();
                    for (int i = 0; i < imax; ++i) {
                        Object param = ((Property)properties.get(i)).getProperty(beans.get(i));
                        this.setObject(statement, i + 1, param);
                    }
                }
                catch (NoSuchPropertyException e) {
                    throw new PersistentException("Input bean get error.", e);
                }
                catch (InvocationTargetException e) {
                    throw new PersistentException("Input bean get error.", e);
                }
                try {
                    if (isBatch) {
                        statement.addBatch();
                        return -1;
                    }
                    return statement.executeUpdate();
                }
                catch (SQLException e) {
                    throw new PersistentException("SQL execute error : " + sql, e);
                }
            }
            for (int i = 0; i < count; ++i) {
                try {
                    int jmax = beans.size();
                    for (int j = 0; j < jmax; ++j) {
                        Object bean = beans.get(j);
                        if (bean instanceof RecordList) {
                            bean = ((RecordList)bean).get(i);
                        }
                        Object param = ((Property)properties.get(j)).getProperty(bean);
                        this.setObject(statement, j + 1, param);
                    }
                }
                catch (NoSuchPropertyException e) {
                    throw new PersistentException("Input bean get error.", e);
                }
                catch (InvocationTargetException e) {
                    throw new PersistentException("Input bean get error.", e);
                }
                try {
                    statement.addBatch();
                    continue;
                }
                catch (SQLException e) {
                    throw new PersistentException("SQL add batch error : " + sql, e);
                }
            }
            if (isBatch) {
                return -1;
            }
            int[] updateCounts = null;
            try {
                updateCounts = statement.executeBatch();
            }
            catch (SQLException e) {
                throw new PersistentException("SQL execute error : " + sql, e);
            }
            int result = 0;
            for (int i = 0; i < updateCounts.length; ++i) {
                if (updateCounts[i] <= 0) continue;
                result += updateCounts[i];
            }
            if (result == 0) {
                try {
                    result = statement.getUpdateCount();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            return result;
        }
        if (input instanceof List || input != null && input.getClass().isArray()) {
            List<Object> list = null;
            list = input instanceof List ? (List<Object>)input : Arrays.asList((Object[])input);
            if (inputProps != null) {
                if (list.size() == 0) {
                    return 0;
                }
                int jmax = list.size();
                for (int j = 0; j < jmax; ++j) {
                    Object bean = list.get(j);
                    try {
                        int imax = inputProps.size();
                        for (int i = 0; i < imax; ++i) {
                            Object param = this.propertyAccess.get(bean, inputProps.get(i).toString());
                            this.setObject(statement, i + 1, param);
                        }
                    }
                    catch (NoSuchPropertyException e) {
                        throw new PersistentException("Input bean get error.", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new PersistentException("Input bean get error.", e);
                    }
                    try {
                        statement.addBatch();
                        continue;
                    }
                    catch (SQLException e) {
                        throw new PersistentException("SQL add batch error : " + sql, e);
                    }
                }
                if (isBatch) {
                    return -1;
                }
                int[] updateCounts = null;
                try {
                    updateCounts = statement.executeBatch();
                }
                catch (SQLException e) {
                    throw new PersistentException("SQL execute error : " + sql, e);
                }
                int result = 0;
                for (int i = 0; i < updateCounts.length; ++i) {
                    if (updateCounts[i] <= 0) continue;
                    result += updateCounts[i];
                }
                if (result == 0) {
                    try {
                        result = statement.getUpdateCount();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                return result;
            }
            int imax = list.size();
            for (int i = 0; i < imax; ++i) {
                Object param = list.get(i);
                this.setObject(statement, i + 1, param);
            }
            if (isBatch) {
                try {
                    statement.addBatch();
                }
                catch (SQLException e) {
                    throw new PersistentException("SQL add batch error : " + sql, e);
                }
                return -1;
            }
            try {
                return statement.executeUpdate();
            }
            catch (SQLException e) {
                throw new PersistentException("SQL execute error : " + sql, e);
            }
        }
        try {
            if (input != null) {
                if (inputProps != null) {
                    int imax = inputProps.size();
                    for (int i = 0; i < imax; ++i) {
                        Object param = this.propertyAccess.get(input, inputProps.get(i).toString());
                        this.setObject(statement, i + 1, param);
                    }
                } else {
                    this.setObject(statement, 1, input);
                }
            } else {
                this.setObject(statement, 1, input);
            }
        }
        catch (NoSuchPropertyException e) {
            throw new PersistentException("Input bean get error.", e);
        }
        catch (InvocationTargetException e) {
            throw new PersistentException("Input bean get error.", e);
        }
        if (isBatch) {
            try {
                statement.addBatch();
            }
            catch (SQLException e) {
                throw new PersistentException("SQL add batch error : " + sql, e);
            }
            return -1;
        }
        try {
            return statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistentException("SQL execute error : " + sql, e);
        }
    }

    public PersistentManager.BatchExecutor createQueryBatchExecutor(Connection con, String query) throws PersistentException {
        StringBuffer buf = new StringBuffer(query);
        List inputProps = this.parseInput(buf);
        String sql = buf.toString();
        return new BatchExecutorImpl(con, sql, inputProps);
    }

    public PersistentManager.BatchExecutor createBatchExecutor(Connection con, String sql, Object inputProps) throws PersistentException {
        ArrayList<Object> inputPropList = null;
        if (inputProps != null) {
            if (inputProps.getClass().isArray()) {
                inputPropList = Arrays.asList((Object[])inputProps);
            } else if (inputProps instanceof List) {
                inputPropList = (ArrayList<Object>)inputProps;
            } else if (inputProps instanceof String) {
                inputPropList = new ArrayList<Object>();
                inputPropList.add(inputProps);
            } else {
                throw new PersistentException("No supported inputProps type." + inputProps);
            }
        }
        return new BatchExecutorImpl(con, sql, inputPropList);
    }

    private class BatchExecutorImpl
    implements PersistentManager.BatchExecutor {
        private String sql;
        private PreparedStatement statement;
        private List inputProps;

        BatchExecutorImpl(Connection con, String sql, List inputProps) throws PersistentException {
            this.sql = sql;
            this.inputProps = inputProps;
            try {
                this.statement = con.prepareStatement(sql);
                if (inputProps != null) {
                    ParameterMetaData metadata = this.statement.getParameterMetaData();
                    if (inputProps.size() != metadata.getParameterCount()) {
                        throw new PersistentException("Illegal sql : " + sql);
                    }
                }
            }
            catch (SQLException e) {
                throw new PersistentException("Illegal sql : " + sql, e);
            }
            catch (IncompatibleClassChangeError e) {
                // empty catch block
            }
        }

        public void addBatch(Object input) throws PersistentException {
            if (this.statement == null) {
                throw new PersistentException("Closed");
            }
            DefaultPersistentManagerService.this.persistQueryInternal(this.sql, this.statement, input, this.inputProps, true);
        }

        public int persist() throws PersistentException {
            if (this.statement == null) {
                throw new PersistentException("Closed");
            }
            int[] updateCounts = null;
            try {
                updateCounts = this.statement.executeBatch();
            }
            catch (SQLException e) {
                throw new PersistentException("Batch execute error.", e);
            }
            int result = 0;
            for (int i = 0; i < updateCounts.length; ++i) {
                if (updateCounts[i] <= 0) continue;
                result += updateCounts[i];
            }
            if (result == 0) {
                try {
                    result = this.statement.getUpdateCount();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return result;
        }

        public void clearBatch() throws PersistentException {
            if (this.statement != null) {
                try {
                    this.statement.clearBatch();
                }
                catch (SQLException e) {
                    throw new PersistentException("Batch clear error.", e);
                }
            }
        }

        public void close() {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.statement = null;
            }
            if (this.inputProps != null) {
                this.inputProps = null;
            }
        }
    }

    private class CursorImpl
    implements PersistentManager.Cursor {
        private PreparedStatement statement;
        private ResultSet resultSet;
        private Map outputMapping;

        public CursorImpl(PreparedStatement statement, ResultSet resultSet, Map outputMapping) {
            this.statement = statement;
            this.resultSet = resultSet;
            this.outputMapping = outputMapping;
        }

        public boolean next() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.next();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public boolean previous() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.previous();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public boolean first() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.first();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public boolean last() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.last();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public void beforeFirst() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                this.resultSet.beforeFirst();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public void afterLast() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                this.resultSet.afterLast();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public boolean absolute(int row) throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.absolute(row);
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public boolean relative(int rows) throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.relative(rows);
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public boolean isFirst() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.isFirst();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public boolean isLast() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.isLast();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public boolean isBeforeFirst() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.isBeforeFirst();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public boolean isAfterLast() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.isAfterLast();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public void setFetchDirection(int direction) throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                this.resultSet.setFetchDirection(direction);
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public int getFetchDirection() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.getFetchDirection();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public void setFetchSize(int rows) throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                this.resultSet.setFetchSize(rows);
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public int getFetchSize() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.getFetchSize();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public int getRow() throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            try {
                return this.resultSet.getRow();
            }
            catch (SQLException e) {
                throw new PersistentException(e);
            }
        }

        public Object load(Object output) throws PersistentException {
            if (this.resultSet == null) {
                throw new PersistentException("Closed");
            }
            return DefaultPersistentManagerService.this.fillOutput(this.resultSet, output, this.outputMapping, true);
        }

        public void close() {
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                this.statement = null;
            }
            if (this.resultSet != null) {
                try {
                    this.resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.resultSet = null;
            }
            this.outputMapping = null;
        }
    }
}

