/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.DefaultCachedReference;
import jp.ossc.nimbus.service.cache.IllegalCachedReferenceException;
import jp.ossc.nimbus.service.io.Externalizer;

public class SerializeCachedReference
extends DefaultCachedReference
implements Serializable {
    private static final long serialVersionUID = -1425349493190241680L;
    private transient Externalizer externalizer;

    public SerializeCachedReference(Object obj) throws IOException {
        super(null);
        this.serializeObject(obj);
    }

    public SerializeCachedReference(Object obj, Externalizer ext) throws IOException {
        super(null);
        this.externalizer = ext;
        this.serializeObject(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void serializeObject(Object obj) throws IOException {
        ByteArrayOutputStream baos;
        block7: {
            baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                if (this.externalizer == null) {
                    oos.writeObject(obj);
                } else {
                    this.externalizer.writeExternal(obj, oos);
                }
                Object var5_4 = null;
                if (oos == null) break block7;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (oos == null) throw throwable;
                try {
                    oos.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            oos.close();
        }
        this.cacheObj = baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object deserializeObject(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object entry = null;
        try {
            entry = this.externalizer == null ? ois.readObject() : this.externalizer.readExternal(ois);
            Object var5_4 = null;
            if (ois == null) return entry;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ois.close();
            return entry;
        }
        catch (IOException ex) {}
        return entry;
    }

    public byte[] getBytes() {
        return (byte[])super.get(null, false);
    }

    public Object get(Object source, boolean notify) {
        Object obj = super.get(source, notify);
        if (obj instanceof byte[]) {
            try {
                return this.deserializeObject((byte[])obj);
            }
            catch (IOException e) {
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return obj;
    }

    public void set(Object source, Object obj) throws IllegalCachedReferenceException {
        this.notifyChange(source, obj);
        if (obj != null) {
            try {
                this.serializeObject(obj);
            }
            catch (IOException e) {
                throw new IllegalCachedReferenceException(e);
            }
        } else {
            this.cacheObj = null;
        }
    }

    public void remove(Object source) {
        if (this.cacheObj != null) {
            this.notifyRemoved(source);
            this.cacheObj = null;
            if (this.linkedReferences != null) {
                this.linkedReferences.clear();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeSet(out, this.linkedReferences);
        this.writeSet(out, this.removeListeners);
        this.writeSet(out, this.accessListeners);
        this.writeSet(out, this.changeListeners);
        ServiceName name = null;
        if (this.externalizer != null) {
            name = this.getServiceName(this.externalizer);
        }
        if (name != null) {
            out.writeObject(name);
        } else {
            out.writeObject(this.externalizer);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.linkedReferences = this.readSet(in);
        this.removeListeners = this.readSet(in);
        this.accessListeners = this.readSet(in);
        this.changeListeners = this.readSet(in);
        Object obj = in.readObject();
        if (obj != null) {
            this.externalizer = obj instanceof ServiceName ? (Externalizer)ServiceManagerFactory.getServiceObject((ServiceName)obj) : (Externalizer)obj;
        }
    }
}

