/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.DefaultKeyCachedReference;
import jp.ossc.nimbus.service.cache.IllegalCachedReferenceException;
import jp.ossc.nimbus.service.io.Externalizer;

public class FileKeyCachedReference
extends DefaultKeyCachedReference
implements Serializable {
    private static final long serialVersionUID = 1386986712271917526L;
    private transient Externalizer externalizer;

    public FileKeyCachedReference(File file) throws IOException, ClassNotFoundException {
        super(null, file);
        this.cacheKey = ((MapEntry)this.deserializeObject(file)).getKey();
    }

    public FileKeyCachedReference(File file, Externalizer ext) throws IOException, ClassNotFoundException {
        super(null, file);
        this.externalizer = ext;
        this.cacheKey = ((MapEntry)this.deserializeObject(file)).getKey();
    }

    public FileKeyCachedReference(Object key, File file, Object obj) throws IOException {
        super(key, file);
        this.serializeObject(file, new MapEntry(key, obj));
    }

    public FileKeyCachedReference(Object key, File file, Object obj, Externalizer ext) throws IOException {
        super(key, file);
        this.externalizer = ext;
        this.serializeObject(file, new MapEntry(key, obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void serializeObject(File file, Object obj) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
        try {
            if (this.externalizer == null) {
                oos.writeObject(obj);
            } else {
                this.externalizer.writeExternal(obj, oos);
            }
            Object var5_4 = null;
            if (oos == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            oos.close();
            return;
        }
        catch (Exception e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object deserializeObject(File file) throws IOException, ClassNotFoundException {
        Object entry = null;
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        try {
            entry = this.externalizer == null ? ois.readObject() : this.externalizer.readExternal(ois);
            Object var5_4 = null;
            if (ois == null) return entry;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ois.close();
            return entry;
        }
        catch (IOException ex) {}
        return entry;
    }

    public File getFile(Object source) {
        return (File)super.get(source, false);
    }

    public Object get(Object source, boolean notify) {
        Object obj = super.get(source, notify);
        if (obj instanceof File) {
            File file = (File)obj;
            if (file.exists() && file.canRead()) {
                MapEntry entry = null;
                try {
                    entry = (MapEntry)this.deserializeObject(file);
                }
                catch (IOException e) {
                    return null;
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
                return entry.getValue();
            }
            return null;
        }
        return obj;
    }

    public void set(Object source, Object obj) throws IllegalCachedReferenceException {
        this.notifyChange(source, obj);
        if (obj != null) {
            try {
                this.serializeObject((File)this.cacheObj, obj);
            }
            catch (IOException e) {
                throw new IllegalCachedReferenceException(e);
            }
        } else {
            ((File)this.cacheObj).delete();
        }
    }

    public void remove(Object source) {
        if (this.cacheObj != null) {
            this.notifyRemoved(source);
            File file = (File)this.cacheObj;
            if (file.exists() && file.canRead()) {
                ((File)this.cacheObj).delete();
            }
            this.cacheObj = null;
            if (this.linkedReferences != null) {
                this.linkedReferences.clear();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeSet(out, this.linkedReferences);
        this.writeSet(out, this.removeListeners);
        this.writeSet(out, this.accessListeners);
        this.writeSet(out, this.changeListeners);
        ServiceName name = null;
        if (this.externalizer != null) {
            name = this.getServiceName(this.externalizer);
        }
        if (name != null) {
            out.writeObject(name);
        } else {
            out.writeObject(this.externalizer);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.linkedReferences = this.readSet(in);
        this.removeListeners = this.readSet(in);
        this.accessListeners = this.readSet(in);
        this.changeListeners = this.readSet(in);
        Object obj = in.readObject();
        if (obj != null) {
            this.externalizer = obj instanceof ServiceName ? (Externalizer)ServiceManagerFactory.getServiceObject((ServiceName)obj) : (Externalizer)obj;
        }
    }

    public static class MapEntry
    implements Serializable {
        private static final long serialVersionUID = 4635469653838112700L;
        protected Object key;
        protected Object value;

        public MapEntry(Object k, Object val) {
            this.key = k;
            this.value = val;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

