/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import javax.servlet.ServletRequest;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.InputExchangeException;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletRequestExchangeInterceptorServiceMBean;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.util.converter.Converter;

public class ServletRequestExchangeInterceptorService
extends ServletFilterInterceptorService
implements ServletRequestExchangeInterceptorServiceMBean {
    private static final long serialVersionUID = 2844563371397261067L;
    protected ServiceName converterServiceName;
    protected Converter converter;
    protected ServiceName threadContextServiceName;
    protected Context threadContext;
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected ServiceName exchangeEditorFinderServiceName;
    protected EditorFinder exchangeEditorFinder;
    protected ServiceName requestObjectEditorFinderServiceName;
    protected EditorFinder requestObjectEditorFinder;
    protected ServiceName exceptionEditorFinderServiceName;
    protected EditorFinder exceptionEditorFinder;
    protected String exchangeJournalKey = "Exchange";
    protected String requestObjectJournalKey = "RequestObject";
    protected String exceptionJournalKey = "Exception";
    protected String requestObjectAttributeName = DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME;
    protected String requestObjectContextKey = DEFAULT_REQUEST_OBJECT_CONTEXT_KEY;

    public void setConverterServiceName(ServiceName name) {
        this.converterServiceName = name;
    }

    public ServiceName getConverterServiceName() {
        return this.converterServiceName;
    }

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    public void setExchangeEditorFinderServiceName(ServiceName name) {
        this.exchangeEditorFinderServiceName = name;
    }

    public ServiceName getExchangeEditorFinderServiceName() {
        return this.exchangeEditorFinderServiceName;
    }

    public void setRequestObjectEditorFinderServiceName(ServiceName name) {
        this.requestObjectEditorFinderServiceName = name;
    }

    public ServiceName getRequestObjectEditorFinderServiceName() {
        return this.requestObjectEditorFinderServiceName;
    }

    public void setExceptionEditorFinderServiceName(ServiceName name) {
        this.exceptionEditorFinderServiceName = name;
    }

    public ServiceName getExceptionEditorFinderServiceName() {
        return this.exceptionEditorFinderServiceName;
    }

    public void setExchangeJournalKey(String key) {
        this.exchangeJournalKey = key;
    }

    public String getExchangeJournalKey() {
        return this.exchangeJournalKey;
    }

    public void setRequestObjectJournalKey(String key) {
        this.requestObjectJournalKey = key;
    }

    public String getRequestObjectJournalKey() {
        return this.requestObjectJournalKey;
    }

    public void setExceptionJournalKey(String key) {
        this.exceptionJournalKey = key;
    }

    public String getExceptionJournalKey() {
        return this.exceptionJournalKey;
    }

    public void setRequestObjectAttributeName(String name) {
        this.requestObjectAttributeName = name;
    }

    public String getRequestObjectAttributeName() {
        return this.requestObjectAttributeName;
    }

    public void setRequestObjectContextKey(String key) {
        this.requestObjectContextKey = key;
    }

    public String getRequestObjectContextKey() {
        return this.requestObjectContextKey;
    }

    public void startService() throws Exception {
        if (this.converterServiceName == null && this.converter == null) {
            throw new IllegalArgumentException("It is necessary to specify ConverterServiceName or Converter.");
        }
        if (this.converterServiceName != null) {
            this.converter = (Converter)ServiceManagerFactory.getServiceObject(this.converterServiceName);
        }
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
        if (this.exchangeEditorFinderServiceName != null) {
            this.exchangeEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exchangeEditorFinderServiceName);
        }
        if (this.requestObjectEditorFinderServiceName != null) {
            this.requestObjectEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.requestObjectEditorFinderServiceName);
        }
        if (this.exceptionEditorFinderServiceName != null) {
            this.exceptionEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exceptionEditorFinderServiceName);
        }
    }

    public void setConverter(Converter conv) {
        this.converter = conv;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setThreadContext(Context context) {
        this.threadContext = context;
    }

    public Context getThreadContext() {
        return this.threadContext;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setExchangeEditorFinder(EditorFinder finder) {
        this.exchangeEditorFinder = finder;
    }

    public EditorFinder getExchangeEditorFinder() {
        return this.exchangeEditorFinder;
    }

    public void setRequestObjectEditorFinder(EditorFinder finder) {
        this.requestObjectEditorFinder = finder;
    }

    public EditorFinder getRequestObjectEditorFinder() {
        return this.requestObjectEditorFinder;
    }

    public void setExceptionEditorFinder(EditorFinder finder) {
        this.exceptionEditorFinder = finder;
    }

    public EditorFinder getExceptionEditorFinder() {
        return this.exceptionEditorFinder;
    }

    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() != 3) {
            return chain.invokeNext(context);
        }
        try {
            Object ret;
            if (this.journal != null) {
                this.journal.startJournal(this.exchangeJournalKey, this.exchangeEditorFinder);
            }
            ServletRequest request = context.getServletRequest();
            Object requestObj = null;
            try {
                requestObj = this.converter.convert(request);
            }
            catch (Exception e) {
                throw new InputExchangeException(e);
            }
            if (this.journal != null) {
                this.journal.addInfo(this.requestObjectJournalKey, requestObj, this.requestObjectEditorFinder);
            }
            request.setAttribute(this.requestObjectAttributeName, requestObj);
            Object object = ret = chain.invokeNext(context);
            Object var8_9 = null;
            if (this.journal != null) {
                this.journal.endJournal();
            }
            return object;
        }
        catch (Throwable th) {
            try {
                if (this.journal != null) {
                    this.journal.addInfo(this.exceptionJournalKey, (Object)th, this.exceptionEditorFinder);
                }
                throw th;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var8_10 = null;
                    if (this.journal == null) break block11;
                    this.journal.endJournal();
                }
                throw throwable;
            }
        }
    }
}

