/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.core.LoggerWrapper;
import jp.ossc.nimbus.core.MessageRecordFactoryWrapper;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceBaseSupport;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.core.ServiceProxy;
import jp.ossc.nimbus.core.ServiceStateBroadcaster;
import jp.ossc.nimbus.core.ServiceStateChangeEvent;
import jp.ossc.nimbus.core.ServiceStateListener;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.message.MessageRecordFactory;

public abstract class ServiceBase
implements ServiceBaseMBean,
ServiceBaseSupport,
ServiceProxy,
ServiceStateBroadcaster,
Serializable {
    private static final String SVC__ = "SVC__";
    private static final String SVC__0 = "SVC__0";
    private static final String SVC__00 = "SVC__00";
    private static final String SVC__000 = "SVC__000";
    private static final String SVC__0000 = "SVC__0000";
    private static final String SVC__00001 = "SVC__00001";
    private static final String SVC__00002 = "SVC__00002";
    private static final String SVC__00003 = "SVC__00003";
    private static final String SVC__00004 = "SVC__00004";
    private static final String SVC__00005 = "SVC__00005";
    private static final String SVC__00006 = "SVC__00006";
    private static final String SVC__00007 = "SVC__00007";
    private static final String SVC__00008 = "SVC__00008";
    private static final String SVC__00009 = "SVC__00009";
    private static final String SVC__00010 = "SVC__00010";
    private static final String SVC__00011 = "SVC__00011";
    private static final String SVC__00012 = "SVC__00012";
    private static final String SVC__00013 = "SVC__00013";
    private static final String SVC__00014 = "SVC__00014";
    private static final String SVC__00015 = "SVC__00015";
    private static final String SVC__00016 = "SVC__00016";
    private static final String SVC__00017 = "SVC__00017";
    private static final String SVC__00018 = "SVC__00018";
    private static final String SVC__00019 = "SVC__00019";
    private static final String SVC__00020 = "SVC__00020";
    private static final String SVC__00021 = "SVC__00021";
    private static final String SVC__00022 = "SVC__00022";
    private static final String SVC__00023 = "SVC__00023";
    private static final String SVC__00024 = "SVC__00024";
    private static final String SVC__00025 = "SVC__00025";
    private static final String SVC__00026 = "SVC__00026";
    private static final String SVC__00027 = "SVC__00027";
    private static final String SVC__00028 = "SVC__00028";
    private static final String SVC__00029 = "SVC__00029";
    private static final String SVC__00030 = "SVC__00030";
    private static final String SVC__00031 = "SVC__00031";
    private static final String SVC__00032 = "SVC__00032";
    private static final String SVC__00033 = "SVC__00033";
    private static final String SVC__00034 = "SVC__00034";
    private static final String SVC__00035 = "SVC__00035";
    private static final String SVC__00036 = "SVC__00036";
    private static final String SVC__00037 = "SVC__00037";
    private static final String SVC__00038 = "SVC__00038";
    private static final String SVC__00039 = "SVC__00039";
    private static final String SVC__00040 = "SVC__00040";
    private static final String SVC__00041 = "SVC__00041";
    private static final String SVC__00042 = "SVC__00042";
    private static final String SVC__00043 = "SVC__00043";
    private static final String SVC__00044 = "SVC__00044";
    private static final String SVC__00045 = "SVC__00045";
    private static final String SVC__00046 = "SVC__00046";
    private static final String SVC__00047 = "SVC__00047";
    private static final String SVC__00048 = "SVC__00048";
    private static final String SVC__00049 = "SVC__00049";
    private static final String SVC__00050 = "SVC__00050";
    private static final String SVC__00051 = "SVC__00051";
    private static final String SVC__00052 = "SVC__00052";
    private static final String SVC__00053 = "SVC__00053";
    private static final String SVC__00054 = "SVC__00054";
    private static final String SVC__00055 = "SVC__00055";
    private static final String SVC__00056 = "SVC__00056";
    private static final String SVC__00057 = "SVC__00057";
    private static final String SVC__00058 = "SVC__00058";
    private static final String SVC__00059 = "SVC__00059";
    private static final String SVC__00060 = "SVC__00060";
    private static final String SVC__00061 = "SVC__00061";
    private static final String SVC__00062 = "SVC__00062";
    private static final String SVC__00063 = "SVC__00063";
    private static final String SVC__00064 = "SVC__00064";
    private static final String SVC__00065 = "SVC__00065";
    private static final String SVC__00066 = "SVC__00066";
    private static final String SVC__00067 = "SVC__00067";
    private static final String SVC__00068 = "SVC__00068";
    private static final String SVC__00069 = "SVC__00069";
    private static final String SVC__00070 = "SVC__00070";
    private static final String SVC__00071 = "SVC__00071";
    private static final String SVC__00072 = "SVC__00072";
    private static final String SVC__00073 = "SVC__00073";
    private static final String SVC__00074 = "SVC__00074";
    private static final String SVC__00075 = "SVC__00075";
    private static final String SVC__00076 = "SVC__00076";
    private static final String SVC__00077 = "SVC__00077";
    private static final String SVC__00078 = "SVC__00078";
    private static final String SVC__00079 = "SVC__00079";
    private static final String SVC__00080 = "SVC__00080";
    private static final String SVC__00081 = "SVC__00081";
    private static final String SVC__00082 = "SVC__00082";
    private static final String SVC__00083 = "SVC__00083";
    private static final String SVC__00084 = "SVC__00084";
    private static final String SVC__00085 = "SVC__00085";
    private static final String SVC__00086 = "SVC__00086";
    private static final String SVC__00087 = "SVC__00087";
    private static final String SVC__00088 = "SVC__00088";
    protected volatile int state = 7;
    protected String name;
    protected ServiceName nameObj;
    protected transient ServiceManager manager;
    protected String managerName;
    protected ServiceBaseSupport support;
    protected transient List serviceStateListeners = new ArrayList();
    protected ServiceName loggerServiceName;
    protected transient LoggerWrapper logger = new LoggerWrapper(ServiceManagerFactory.getLogger());
    protected ServiceName messageServiceName;
    protected transient MessageRecordFactoryWrapper message = new MessageRecordFactoryWrapper(ServiceManagerFactory.getMessageRecordFactory());

    public ServiceBase() {
    }

    protected ServiceBase(ServiceBaseSupport support) {
        this();
        this.support = support;
    }

    protected void setServiceManager(ServiceManager mng) {
        if (this.manager != null && this.manager.equals(mng)) {
            return;
        }
        this.manager = mng;
        if (this.manager != null) {
            this.logger.setDefaultLogger(this.manager.getLogger());
            if (this.loggerServiceName == null) {
                this.logger.setLogger(this.manager.getLogger());
            }
            this.message.setDefaultMessageRecordFactory(this.manager.getMessageRecordFactory());
            if (this.messageServiceName == null) {
                this.message.setMessageRecordFactory(this.manager.getMessageRecordFactory());
            }
        }
    }

    public ServiceManager getServiceManager() {
        return this.manager;
    }

    public ServiceLoader getServiceLoader() {
        if (this.manager == null) {
            return null;
        }
        ServiceMetaData metaData = this.manager.getServiceMetaData(this.name);
        return metaData.getServiceLoader();
    }

    public synchronized void create() throws Exception {
        if (this.manager == null && this.managerName != null) {
            this.setServiceManager(ServiceManagerFactory.findManager(this.managerName));
        }
        Object[] serviceName = null;
        if (this.managerName != null) {
            serviceName = new Object[]{this.managerName, this.name};
            this.logger.write(SVC__00001, serviceName);
        } else {
            if (this.name == null) {
                this.setServiceName(this.toString());
            }
            this.logger.write(SVC__00002, (Object)this.name);
        }
        try {
            if (!this.isNecessaryToCreate()) {
                if (this.managerName != null) {
                    this.logger.write(SVC__00003, new Object[]{this.managerName, this.name, this.getStateString()});
                } else {
                    this.logger.write(SVC__00004, new Object[]{this.name, this.getStateString()});
                }
                return;
            }
            if (this.managerName != null) {
                this.logger.write(SVC__00005, serviceName);
            } else {
                this.logger.write(SVC__00006, (Object)this.name);
            }
            this.preCreateService();
            if (this.managerName != null) {
                this.logger.write(SVC__00007, serviceName);
            } else {
                this.logger.write(SVC__00008, (Object)this.name);
            }
            if (this.managerName != null) {
                this.logger.write(SVC__00009, serviceName);
            } else {
                this.logger.write(SVC__00010, (Object)this.name);
            }
            this.createService();
            if (this.managerName != null) {
                this.logger.write(SVC__00011, serviceName);
            } else {
                this.logger.write(SVC__00012, (Object)this.name);
            }
            if (this.managerName != null) {
                this.logger.write(SVC__00013, serviceName);
            } else {
                this.logger.write(SVC__00014, (Object)this.name);
            }
            this.postCreateService();
            if (this.managerName != null) {
                this.logger.write(SVC__00015, serviceName);
            } else {
                this.logger.write(SVC__00016, (Object)this.name);
            }
        }
        catch (Exception e) {
            if (this.managerName != null) {
                this.logger.write(SVC__00017, serviceName, (Throwable)e);
            } else {
                this.logger.write(SVC__00018, (Object)this.name, (Throwable)e);
            }
            this.state = 8;
            this.processStateChanged(8);
            throw e;
        }
        if (this.managerName != null) {
            this.logger.write(SVC__00019, serviceName);
        } else {
            this.logger.write(SVC__00020, (Object)this.name);
        }
    }

    protected boolean isNecessaryToCreate() throws Exception {
        return this.state != 1 && this.state != 0 && this.state != 3;
    }

    protected void preCreateService() throws Exception {
        this.state = 0;
        this.processStateChanged(0);
    }

    protected void postCreateService() throws Exception {
        if (this.manager == null && this.managerName != null) {
            this.setServiceManager(ServiceManagerFactory.findManager(this.managerName));
        }
        if (this.manager != null && this.getServiceName() != null) {
            if (this.manager.isRegisteredService(this.getServiceName())) {
                Service registeredService = this.manager.getService(this.getServiceName());
                if (registeredService != this) {
                    this.logger.write(SVC__00088, new Object[]{this.managerName, this.name});
                    this.manager.stopService(this.getServiceName());
                    this.manager.destroyService(this.getServiceName());
                    if (this.manager.isRegisteredService(this.getServiceName())) {
                        this.manager.unregisterService(this.getServiceName());
                    }
                    this.manager.registerService(this.getServiceName(), this);
                }
            } else {
                this.manager.registerService(this.getServiceName(), this);
            }
        }
        this.state = 1;
        this.processStateChanged(1);
    }

    public synchronized void restart() throws Exception {
        this.stop();
        this.start();
    }

    public synchronized void start() throws Exception {
        Object[] serviceName = null;
        if (this.managerName != null) {
            serviceName = new Object[]{this.managerName, this.name};
            this.logger.write(SVC__00021, serviceName);
        } else {
            this.logger.write(SVC__00022, (Object)this.name);
        }
        try {
            if (!this.isNecessaryToStart()) {
                if (this.managerName != null) {
                    this.logger.write(SVC__00023, new Object[]{this.managerName, this.name, this.getStateString()});
                } else {
                    this.logger.write(SVC__00024, new Object[]{this.name, this.getStateString()});
                }
                return;
            }
            if (this.managerName != null) {
                this.logger.write(SVC__00025, serviceName);
            } else {
                this.logger.write(SVC__00026, (Object)this.name);
            }
            this.preStartService();
            if (this.managerName != null) {
                this.logger.write(SVC__00027, serviceName);
            } else {
                this.logger.write(SVC__00028, (Object)this.name);
            }
            if (this.managerName != null) {
                this.logger.write(SVC__00029, serviceName);
            } else {
                this.logger.write(SVC__00030, (Object)this.name);
            }
            this.startService();
            if (this.managerName != null) {
                this.logger.write(SVC__00031, serviceName);
            } else {
                this.logger.write(SVC__00032, (Object)this.name);
            }
            if (this.managerName != null) {
                this.logger.write(SVC__00033, serviceName);
            } else {
                this.logger.write(SVC__00034, (Object)this.name);
            }
            this.postStartService();
            if (this.managerName != null) {
                this.logger.write(SVC__00035, serviceName);
            } else {
                this.logger.write(SVC__00036, (Object)this.name);
            }
        }
        catch (Exception e) {
            if (this.managerName != null) {
                this.logger.write(SVC__00037, serviceName, (Throwable)e);
            } else {
                this.logger.write(SVC__00038, (Object)this.name, (Throwable)e);
            }
            this.state = 8;
            this.processStateChanged(8);
            throw e;
        }
        if (this.managerName != null) {
            this.logger.write(SVC__00039, serviceName);
        } else {
            this.logger.write(SVC__00040, (Object)this.name);
        }
    }

    protected boolean isNecessaryToStart() throws Exception {
        if (this.state == 7) {
            throw new IllegalStateException(this.message.findEmbedMessage(SVC__00041, new Object[]{STATES[2], this.getStateString()}));
        }
        if (this.state == 8) {
            return false;
        }
        return this.state != 3 && this.state != 2;
    }

    protected void preStartService() throws Exception {
        this.state = 2;
        this.processStateChanged(2);
    }

    protected void postStartService() throws Exception {
        this.state = 3;
        this.processStateChanged(3);
    }

    public synchronized void stop() {
        Object[] serviceName = null;
        if (this.managerName != null) {
            serviceName = new Object[]{this.managerName, this.name};
            this.logger.write(SVC__00042, serviceName);
        } else {
            this.logger.write(SVC__00043, (Object)this.name);
        }
        try {
            if (!this.isNecessaryToStop()) {
                if (this.managerName != null) {
                    this.logger.write(SVC__00044, new Object[]{this.managerName, this.name, this.getStateString()});
                } else {
                    this.logger.write(SVC__00045, new Object[]{this.name, this.getStateString()});
                }
                return;
            }
            if (this.managerName != null) {
                this.logger.write(SVC__00046, serviceName);
            } else {
                this.logger.write(SVC__00047, (Object)this.name);
            }
            this.preStopService();
            if (this.managerName != null) {
                this.logger.write(SVC__00048, serviceName);
            } else {
                this.logger.write(SVC__00049, (Object)this.name);
            }
            if (this.managerName != null) {
                this.logger.write(SVC__00050, serviceName);
            } else {
                this.logger.write(SVC__00051, (Object)this.name);
            }
            this.stopService();
            if (this.managerName != null) {
                this.logger.write(SVC__00052, serviceName);
            } else {
                this.logger.write(SVC__00053, (Object)this.name);
            }
            if (this.managerName != null) {
                this.logger.write(SVC__00054, serviceName);
            } else {
                this.logger.write(SVC__00055, (Object)this.name);
            }
            this.postStopService();
            if (this.managerName != null) {
                this.logger.write(SVC__00056, serviceName);
            } else {
                this.logger.write(SVC__00057, (Object)this.name);
            }
        }
        catch (Exception e) {
            if (this.managerName != null) {
                this.logger.write(SVC__00058, serviceName, (Throwable)e);
            } else {
                this.logger.write(SVC__00059, (Object)this.name, (Throwable)e);
            }
            this.state = 8;
            try {
                this.processStateChanged(8);
            }
            catch (Exception ex) {
                if (this.managerName != null) {
                    this.logger.write(SVC__00060, new Object[]{this.managerName, this.name, this.getStateString()}, (Throwable)ex);
                } else {
                    this.logger.write(SVC__00061, new Object[]{this.name, this.getStateString()}, (Throwable)ex);
                }
                this.state = 8;
                return;
            }
            return;
        }
        if (this.managerName != null) {
            this.logger.write(SVC__00062, serviceName);
        } else {
            this.logger.write(SVC__00063, (Object)this.name);
        }
    }

    protected boolean isNecessaryToStop() throws Exception {
        return this.state == 3;
    }

    protected void preStopService() throws Exception {
        this.state = 4;
        this.processStateChanged(4);
    }

    protected void postStopService() throws Exception {
        this.state = 5;
        this.processStateChanged(5);
    }

    public synchronized void destroy() {
        Object[] serviceName = null;
        if (this.managerName != null) {
            serviceName = new Object[]{this.managerName, this.name};
            this.logger.write(SVC__00064, serviceName);
        } else {
            this.logger.write(SVC__00065, (Object)this.name);
        }
        try {
            if (!this.isNecessaryToDestroy()) {
                if (this.managerName != null) {
                    this.logger.write(SVC__00066, new Object[]{this.managerName, this.name, this.getStateString()});
                } else {
                    this.logger.write(SVC__00067, new Object[]{this.name, this.getStateString()});
                }
                return;
            }
            if (this.managerName != null) {
                this.logger.write(SVC__00068, serviceName);
            } else {
                this.logger.write(SVC__00069, (Object)this.name);
            }
            this.preDestroyService();
            if (this.managerName != null) {
                this.logger.write(SVC__00070, serviceName);
            } else {
                this.logger.write(SVC__00071, (Object)this.name);
            }
            if (this.managerName != null) {
                this.logger.write(SVC__00072, serviceName);
            } else {
                this.logger.write(SVC__00073, (Object)this.name);
            }
            this.destroyService();
            if (this.managerName != null) {
                this.logger.write(SVC__00074, serviceName);
            } else {
                this.logger.write(SVC__00075, (Object)this.name);
            }
            if (this.managerName != null) {
                this.logger.write(SVC__00076, serviceName);
            } else {
                this.logger.write(SVC__00077, (Object)this.name);
            }
            this.postDestroyService();
            if (this.managerName != null) {
                this.logger.write(SVC__00078, serviceName);
            } else {
                this.logger.write(SVC__00079, (Object)this.name);
            }
        }
        catch (Exception e) {
            if (this.managerName != null) {
                this.logger.write(SVC__00080, serviceName, (Throwable)e);
            } else {
                this.logger.write(SVC__00081, (Object)this.name, (Throwable)e);
            }
            this.state = 8;
            try {
                this.processStateChanged(8);
            }
            catch (Exception ex) {
                if (this.managerName != null) {
                    this.logger.write(SVC__00060, new Object[]{this.managerName, this.name, this.getStateString()}, (Throwable)ex);
                } else {
                    this.logger.write(SVC__00061, new Object[]{this.name, this.getStateString()}, (Throwable)ex);
                }
                this.state = 8;
                return;
            }
            return;
        }
        if (this.managerName != null) {
            this.logger.write(SVC__00082, serviceName);
        } else {
            this.logger.write(SVC__00083, (Object)this.name);
        }
    }

    protected boolean isNecessaryToDestroy() throws Exception {
        return this.state != 7 && this.state != 6;
    }

    protected void preDestroyService() throws Exception {
        if (this.state != 5) {
            this.stop();
        }
        this.state = 6;
        this.processStateChanged(6);
        if (this.manager == null && this.managerName != null) {
            this.setServiceManager(ServiceManagerFactory.findManager(this.managerName));
        }
        if (this.manager != null && this.getServiceName() != null) {
            Service service = null;
            try {
                service = this.manager.getService(this.getServiceName());
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
            if (service == this) {
                this.manager.unregisterService(this.getServiceName());
            }
        }
    }

    protected void postDestroyService() throws Exception {
        this.state = 7;
        this.processStateChanged(7);
    }

    public void setServiceName(String name) {
        if (name != null && name.length() != 0) {
            this.name = name;
            if (this.managerName != null) {
                this.nameObj = new ServiceName(this.managerName, name);
            }
        }
    }

    public String getServiceName() {
        return this.name;
    }

    public ServiceName getServiceNameObject() {
        return this.nameObj;
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return STATES[this.state];
    }

    public void createService() throws Exception {
        if (this.support != null) {
            this.support.createService();
        }
    }

    public void startService() throws Exception {
        if (this.support != null) {
            this.support.startService();
        }
    }

    public void stopService() throws Exception {
        if (this.support != null) {
            this.support.stopService();
        }
    }

    public void destroyService() throws Exception {
        if (this.support != null) {
            this.support.destroyService();
        }
    }

    public void setSystemLoggerServiceName(final ServiceName name) {
        if (ServiceManagerFactory.isRegisteredService(name) && ServiceManagerFactory.getService(name).getState() == 3) {
            this.loggerServiceName = name;
            if (this.logger != null) {
                if (this.managerName != null) {
                    this.logger.write(SVC__00084, new Object[]{this.managerName, this.name, this.loggerServiceName});
                } else {
                    this.logger.write(SVC__00085, new Object[]{this.name, this.loggerServiceName});
                }
                this.logger.setLogger((Logger)ServiceManagerFactory.getServiceObject(this.loggerServiceName), ServiceManagerFactory.getService(this.loggerServiceName));
            }
        } else {
            ServiceManagerFactory.addServiceStateListener(name, new ServiceStateListener(){

                public void stateChanged(ServiceStateChangeEvent e) throws Exception {
                    ServiceManagerFactory.removeServiceStateListener(name, (ServiceStateListener)this);
                    ServiceBase.this.setSystemLoggerServiceName(name);
                }

                public boolean isEnabledState(int st) {
                    return st == 3;
                }
            });
        }
    }

    public ServiceName getSystemLoggerServiceName() {
        return this.loggerServiceName;
    }

    public void setSystemMessageRecordFactoryServiceName(final ServiceName name) {
        if (ServiceManagerFactory.isRegisteredService(name) && ServiceManagerFactory.getService(name).getState() == 3) {
            this.messageServiceName = name;
            if (this.message != null) {
                if (this.managerName != null) {
                    this.logger.write(SVC__00086, new Object[]{this.managerName, this.name, this.messageServiceName});
                } else {
                    this.logger.write(SVC__00087, new Object[]{this.name, this.messageServiceName});
                }
                this.message.setMessageRecordFactory((MessageRecordFactory)ServiceManagerFactory.getServiceObject(this.messageServiceName), ServiceManagerFactory.getService(this.messageServiceName));
            }
        } else {
            ServiceManagerFactory.addServiceStateListener(name, new ServiceStateListener(){

                public void stateChanged(ServiceStateChangeEvent e) throws Exception {
                    ServiceManagerFactory.removeServiceStateListener(name, (ServiceStateListener)this);
                    ServiceBase.this.setSystemMessageRecordFactoryServiceName(name);
                }

                public boolean isEnabledState(int st) {
                    return st == 3;
                }
            });
        }
    }

    public ServiceName getSystemMessageRecordFactoryServiceName() {
        return this.messageServiceName;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger log) {
        if (log != null) {
            if (log instanceof Service) {
                Service logService = (Service)((Object)log);
                String managerName = logService.getServiceManagerName();
                String serviceName = logService.getServiceName();
                if (managerName != null && serviceName != null) {
                    this.setSystemLoggerServiceName(new ServiceName(managerName, serviceName));
                    return;
                }
            }
            if (this.managerName != null) {
                this.logger.write(SVC__00084, new Object[]{this.managerName, this.name, null});
            } else {
                this.logger.write(SVC__00085, new Object[]{this.name, null});
            }
            this.logger.setLogger(log, log instanceof Service ? (Service)((Object)log) : null);
        }
    }

    public MessageRecordFactory getMessageRecordFactory() {
        return this.message;
    }

    public void setMessageRecordFactory(MessageRecordFactory msg) {
        if (msg != null) {
            if (msg instanceof Service) {
                Service msgService = (Service)((Object)msg);
                String managerName = msgService.getServiceManagerName();
                String serviceName = msgService.getServiceName();
                if (managerName != null && serviceName != null) {
                    this.setSystemMessageRecordFactoryServiceName(new ServiceName(managerName, serviceName));
                    return;
                }
            }
            if (this.managerName != null) {
                this.logger.write(SVC__00086, new Object[]{this.managerName, this.name, null});
            } else {
                this.logger.write(SVC__00087, new Object[]{this.name, null});
            }
            this.message.setMessageRecordFactory(msg, msg instanceof Service ? (Service)((Object)msg) : null);
        }
    }

    public String getServiceManagerName() {
        return this.managerName;
    }

    public void setServiceManagerName(String name) {
        this.managerName = name;
        if (name != null && this.getServiceName() != null) {
            this.nameObj = new ServiceName(this.managerName, this.getServiceName());
        }
    }

    public Object getTarget() {
        if (this.support != null) {
            return this.support;
        }
        return this;
    }

    public void addServiceStateListener(ServiceStateListener listener) {
        if (!this.serviceStateListeners.contains(listener)) {
            this.serviceStateListeners.add(listener);
        }
    }

    public void removeServiceStateListener(ServiceStateListener listener) {
        this.serviceStateListeners.remove(listener);
    }

    protected void processStateChanged(int state) throws Exception {
        Iterator listeners = new ArrayList(this.serviceStateListeners).iterator();
        while (listeners.hasNext()) {
            ServiceStateListener listener = (ServiceStateListener)listeners.next();
            if (!listener.isEnabledState(state)) continue;
            listener.stateChanged(new ServiceStateChangeEvent(this));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.logger = new LoggerWrapper(ServiceManagerFactory.getLogger());
        this.message = new MessageRecordFactoryWrapper(ServiceManagerFactory.getMessageRecordFactory());
        this.serviceStateListeners = new ArrayList();
        if (this.manager == null && this.managerName != null) {
            this.setServiceManager(ServiceManagerFactory.findManager(this.managerName));
        }
        this.logger = new LoggerWrapper(ServiceManagerFactory.getLogger());
        if (this.loggerServiceName != null) {
            this.setSystemLoggerServiceName(this.loggerServiceName);
        }
        this.message = new MessageRecordFactoryWrapper(ServiceManagerFactory.getMessageRecordFactory());
        if (this.messageServiceName != null) {
            this.setSystemMessageRecordFactoryServiceName(this.messageServiceName);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.name == null) {
            return super.equals(obj);
        }
        if (obj instanceof Service) {
            Service service = (Service)obj;
            String mngName = service.getServiceManagerName();
            if (this.managerName == null) {
                return mngName != null ? false : this.name.equals(service.getServiceName());
            }
            if (this.managerName.equals(mngName) && this.name.equals(service.getServiceName())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.name == null) {
            return super.hashCode();
        }
        return this.managerName != null ? this.managerName.hashCode() + this.name.hashCode() : this.name.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.support != null) {
            buf.append(this.support.toString());
        } else {
            buf.append(super.toString());
        }
        if (this.managerName != null || this.name != null) {
            buf.append(':');
        }
        if (this.managerName != null) {
            buf.append(this.managerName);
        }
        if (this.managerName != null) {
            buf.append('#');
        }
        if (this.name != null) {
            buf.append(this.name);
        }
        return buf.toString();
    }

    protected void finalize() throws Throwable {
        block6: {
            try {
                int state = this.getState();
                if (state > 3) break block6;
                String name = this.getServiceName();
                ServiceManager manager = this.getServiceManager();
                if (name == null && manager == null) {
                    this.stop();
                    this.destroy();
                    break block6;
                }
                Service service = null;
                try {
                    service = manager.getService(name);
                }
                catch (ServiceNotFoundException e) {
                    // empty catch block
                }
                if (service == this) {
                    manager.stopService(name);
                    manager.destroyService(name);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

