/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.msgresource;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.jms.Message;
import javax.jms.QueueSession;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.byteconvert.ByteConverter;
import jp.ossc.nimbus.service.msgresource.FileMessageInput;
import jp.ossc.nimbus.service.msgresource.MessageFormat;
import jp.ossc.nimbus.service.msgresource.MessageInput;
import jp.ossc.nimbus.service.msgresource.MessageResourceDefine;
import jp.ossc.nimbus.service.msgresource.MessageResourceUtil;
import jp.ossc.nimbus.service.msgresource.PropItem;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class CommonMessageFormat
implements MessageFormat,
MessageResourceDefine {
    protected ArrayList mPropertyItems = null;
    protected ByteConverter mByteConverter = null;
    protected MessageInput mMessageInput;
    public static final int TYPE_BYTE = 0;
    public static final String TYPE_BYTE_STR = "Byte";
    public static final int TYPE_UBYTE = 1;
    public static final String TYPE_UBYTE_STR = "UnsignedByte";
    public static final int TYPE_BYTES = 2;
    public static final String TYPE_BYTES_STR = "Bytes";
    public static final int TYPE_BOOLEAN = 3;
    public static final String TYPE_BOOLEAN_STR = "Boolean";
    public static final int TYPE_CHAR = 4;
    public static final String TYPE_CHAR_STR = "Char";
    public static final int TYPE_SHORT = 5;
    public static final String TYPE_SHORT_STR = "Short";
    public static final int TYPE_USHORT = 6;
    public static final String TYPE_USHORT_STR = "UnsignedShort";
    public static final int TYPE_INT = 7;
    public static final String TYPE_INT_STR = "Int";
    public static final int TYPE_LONG = 8;
    public static final String TYPE_LONG_STR = "Long";
    public static final int TYPE_FLOAT = 9;
    public static final String TYPE_FLOAT_STR = "Float";
    public static final int TYPE_DOUBLE = 10;
    public static final String TYPE_DOUBLE_STR = "Double";
    public static final int TYPE_UTF = 11;
    public static final String TYPE_UTF_STR = "UTF";
    public static final int TYPE_STRING = 12;
    public static final String TYPE_STRING_STR = "String";
    public static final int TYPE_OBJECT = 13;
    public static final String TYPE_OBJECT_STR = "Object";

    public CommonMessageFormat(ByteConverter converter) {
        this.mByteConverter = converter;
        this.mPropertyItems = new ArrayList();
    }

    public abstract String marshal(Message var1);

    public abstract Message unMarshal(QueueSession var1);

    public void parse(Element elem) {
        String tagName = elem.getTagName();
        if (tagName.equals("SendData")) {
            boolean inputFileExists = false;
            NodeList inputElems = elem.getElementsByTagName("inputfile");
            if (inputElems.getLength() > 1) {
                throw new ServiceException("MESSAGERESOURCEFACTORY012", "<inputfile>is can be exists only one.");
            }
            for (int rCnt = 0; rCnt < inputElems.getLength(); ++rCnt) {
                Element inputElem = (Element)inputElems.item(rCnt);
                String fileName = MessageResourceUtil.getValueMustbeSpecified(inputElem);
                this.mMessageInput = new FileMessageInput(fileName);
                inputFileExists = true;
            }
            this.propParse(elem, inputFileExists);
            this.sendPayloadParse(elem, inputFileExists);
        } else if (tagName.equals("RecvData")) {
            this.recvPayloadParse(elem);
        }
    }

    protected abstract void sendPayloadParse(Element var1, boolean var2);

    protected abstract void recvPayloadParse(Element var1);

    protected void propParse(Element elem, boolean fileSpecifiedFlag) {
        this.propKindParse(elem, fileSpecifiedFlag, this.mPropertyItems, "prop");
    }

    protected void propKindParse(Element elem, boolean fileSpecifiedFlag, ArrayList Items, String tagName) {
        NodeList propList = elem.getElementsByTagName(tagName);
        if (propList.getLength() > 1) {
            throw new ServiceException("MESSAGERESOURCEFACTORY013", "<" + tagName + "> can be specified only onece.");
        }
        boolean isAProperty = false;
        if (tagName.equals("prop")) {
            isAProperty = true;
        }
        for (int rCnt = 0; rCnt < propList.getLength(); ++rCnt) {
            Element propElem = (Element)propList.item(rCnt);
            NodeList propItems = propElem.getElementsByTagName("item");
            for (int rCount = 0; rCount < propItems.getLength(); ++rCount) {
                int typeCode;
                String type = null;
                String wrappedType = null;
                String val = null;
                String name = null;
                boolean itemUseFileFlag = false;
                Element propItem = (Element)propItems.item(rCount);
                name = MessageResourceUtil.getAttMustBeSpecified(propItem, "name");
                type = MessageResourceUtil.getAttMustBeSpecified(propItem, "type");
                int wrappedTypeCode = -1;
                if (type.equals(TYPE_OBJECT_STR) && (wrappedTypeCode = this.getWrappedTypeCode(wrappedType = MessageResourceUtil.getAttMustBeSpecified(propItem, "wrappedType"), isAProperty)) < 0) {
                    throw new ServiceException("MESSAGERESOURCEFACTORY019", "Invalid Type :" + wrappedType);
                }
                val = MessageResourceUtil.getValue(propItem);
                String resourceType = propItem.getAttribute("resourceType");
                if (resourceType.equals("file")) {
                    if (fileSpecifiedFlag) {
                        itemUseFileFlag = true;
                    } else {
                        throw new ServiceException("MESSAGERESOURCEFACTORY014", "File not specified. But type has file attribute.");
                    }
                }
                if ((typeCode = this.getPropertyTypeCode(type, isAProperty)) < 0) {
                    throw new ServiceException("MESSAGERESOURCEFACTORY018", "Invalid Type :" + type);
                }
                Items.add(new PropItem(name, typeCode, wrappedTypeCode, val, itemUseFileFlag));
            }
        }
    }

    protected int getWrappedTypeCode(String type, boolean propertyMode) {
        if (type.equals(TYPE_BYTE_STR)) {
            return 0;
        }
        if (type.equals(TYPE_BYTES_STR)) {
            if (!propertyMode) {
                return 2;
            }
            return -1;
        }
        if (type.equals(TYPE_BOOLEAN_STR)) {
            return 3;
        }
        if (type.equals(TYPE_CHAR_STR)) {
            return 4;
        }
        if (type.equals(TYPE_SHORT_STR)) {
            return 5;
        }
        if (type.equals(TYPE_INT_STR)) {
            return 7;
        }
        if (type.equals(TYPE_LONG_STR)) {
            return 8;
        }
        if (type.equals(TYPE_FLOAT_STR)) {
            return 9;
        }
        if (type.equals(TYPE_DOUBLE_STR)) {
            return 10;
        }
        if (type.equals(TYPE_STRING_STR)) {
            return 12;
        }
        if (type.equals(TYPE_UTF_STR)) {
            return 11;
        }
        return -1;
    }

    protected String getWrappedTypeStr(int code) {
        String ret = "";
        switch (code) {
            case 0: {
                ret = TYPE_BYTE_STR;
                break;
            }
            case 2: {
                ret = TYPE_BYTES_STR;
                break;
            }
            case 3: {
                ret = TYPE_BOOLEAN_STR;
                break;
            }
            case 4: {
                ret = TYPE_CHAR_STR;
                break;
            }
            case 5: {
                ret = TYPE_SHORT_STR;
                break;
            }
            case 7: {
                ret = TYPE_INT_STR;
                break;
            }
            case 8: {
                ret = TYPE_LONG_STR;
                break;
            }
            case 9: {
                ret = TYPE_FLOAT_STR;
                break;
            }
            case 10: {
                ret = TYPE_DOUBLE_STR;
                break;
            }
            case 12: {
                ret = TYPE_STRING_STR;
                break;
            }
        }
        return ret;
    }

    protected int getPropertyTypeCode(String type, boolean propertyMode) {
        if (type.equals(TYPE_STRING_STR)) {
            return 12;
        }
        if (type.equals(TYPE_INT_STR)) {
            return 7;
        }
        if (type.equals(TYPE_BOOLEAN_STR)) {
            return 3;
        }
        if (type.equals(TYPE_DOUBLE_STR)) {
            return 10;
        }
        if (type.equals(TYPE_FLOAT_STR)) {
            return 9;
        }
        if (type.equals(TYPE_BYTE_STR)) {
            return 0;
        }
        if (type.equals(TYPE_BYTES_STR)) {
            if (propertyMode) {
                return -1;
            }
            return 2;
        }
        if (type.equals(TYPE_CHAR_STR)) {
            if (propertyMode) {
                return -1;
            }
            return 4;
        }
        if (type.equals(TYPE_LONG_STR)) {
            return 8;
        }
        if (type.equals(TYPE_SHORT_STR)) {
            return 5;
        }
        if (type.equals(TYPE_OBJECT_STR)) {
            return 13;
        }
        return -1;
    }

    protected int getReadTypeCode(String type, String msgType) {
        if (type.equals(TYPE_BYTE_STR)) {
            return 0;
        }
        if (type.equals(TYPE_UBYTE_STR)) {
            if (msgType.equals(TYPE_BYTES_STR)) {
                return 1;
            }
            return -1;
        }
        if (type.equals(TYPE_BYTES_STR)) {
            return 2;
        }
        if (type.equals(TYPE_BOOLEAN_STR)) {
            return 3;
        }
        if (type.equals(TYPE_CHAR_STR)) {
            return 4;
        }
        if (type.equals(TYPE_INT_STR)) {
            return 7;
        }
        if (type.equals(TYPE_SHORT_STR)) {
            return 5;
        }
        if (type.equals(TYPE_USHORT_STR)) {
            if (msgType.equals(TYPE_BYTES_STR)) {
                return 6;
            }
            return -1;
        }
        if (type.equals(TYPE_LONG_STR)) {
            return 8;
        }
        if (type.equals(TYPE_FLOAT_STR)) {
            return 9;
        }
        if (type.equals(TYPE_DOUBLE_STR)) {
            return 10;
        }
        if (type.equals(TYPE_UTF_STR)) {
            if (msgType.equals(TYPE_BYTES_STR)) {
                return 11;
            }
            return -1;
        }
        if (type.equals(TYPE_STRING_STR)) {
            if (msgType.equals(TYPE_BYTES_STR)) {
                return -1;
            }
            return 12;
        }
        if (type.equals(TYPE_OBJECT_STR)) {
            if (msgType.equals(TYPE_BYTES_STR)) {
                return -1;
            }
            return 13;
        }
        return -1;
    }

    protected int getWriteTypeCode(String type, String msgType) {
        if (type.equals(TYPE_BYTE_STR)) {
            return 0;
        }
        if (type.equals(TYPE_BYTES_STR)) {
            return 2;
        }
        if (type.equals(TYPE_BOOLEAN_STR)) {
            return 3;
        }
        if (type.equals(TYPE_CHAR_STR)) {
            return 4;
        }
        if (type.equals(TYPE_INT_STR)) {
            return 7;
        }
        if (type.equals(TYPE_SHORT_STR)) {
            return 5;
        }
        if (type.equals(TYPE_LONG_STR)) {
            return 8;
        }
        if (type.equals(TYPE_FLOAT_STR)) {
            return 9;
        }
        if (type.equals(TYPE_DOUBLE_STR)) {
            return 10;
        }
        if (type.equals(TYPE_UTF_STR)) {
            if (msgType.equals(TYPE_BYTES_STR)) {
                return 11;
            }
            return -1;
        }
        if (type.equals(TYPE_STRING_STR)) {
            if (msgType.equals(TYPE_BYTES_STR)) {
                return -1;
            }
            return 12;
        }
        if (type.equals(TYPE_OBJECT_STR)) {
            return 13;
        }
        return -1;
    }

    protected void setMessageHeadProperties(Message msg, Properties prop) {
        Iterator Items = this.mPropertyItems.iterator();
        try {
            while (Items.hasNext()) {
                PropItem item = (PropItem)Items.next();
                int type = item.getType();
                String valueStr = null;
                String name = item.getName();
                valueStr = item.useFile() ? (String)prop.get(name) : item.getVal();
                switch (type) {
                    case 0: {
                        byte[] tmp = this.mByteConverter.hex2byte(valueStr);
                        msg.setByteProperty(name, tmp[0]);
                        break;
                    }
                    case 3: {
                        Boolean bool = Boolean.valueOf(valueStr);
                        msg.setBooleanProperty(name, bool.booleanValue());
                        break;
                    }
                    case 5: {
                        msg.setShortProperty(name, Short.parseShort(valueStr));
                        break;
                    }
                    case 7: {
                        msg.setIntProperty(name, Integer.parseInt(valueStr));
                        break;
                    }
                    case 8: {
                        msg.setLongProperty(name, Long.parseLong(valueStr));
                        break;
                    }
                    case 9: {
                        msg.setFloatProperty(name, Float.parseFloat(valueStr));
                        break;
                    }
                    case 10: {
                        msg.setDoubleProperty(name, Double.parseDouble(valueStr));
                        break;
                    }
                    case 12: {
                        msg.setStringProperty(name, valueStr);
                        break;
                    }
                    case 13: {
                        Object obj = this.createObject(item.getWrappedType(), valueStr);
                        msg.setObjectProperty(name, obj);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("MESSAGERESOURCEFACTORY017", "Property Setting failed.", e);
        }
    }

    protected Object createObject(int type, String valueStr) {
        Object ret = null;
        switch (type) {
            case 0: {
                byte[] tmp = this.mByteConverter.hex2byte(valueStr);
                ret = new Byte(tmp[0]);
                break;
            }
            case 2: {
                ret = this.mByteConverter.hex2byte(valueStr);
                break;
            }
            case 3: {
                ret = Boolean.valueOf(valueStr);
                break;
            }
            case 4: {
                ret = new Character(valueStr.charAt(0));
                break;
            }
            case 5: {
                ret = Short.valueOf(valueStr);
                break;
            }
            case 7: {
                ret = Integer.valueOf(valueStr);
                break;
            }
            case 8: {
                ret = Long.valueOf(valueStr);
                break;
            }
            case 9: {
                ret = Float.valueOf(valueStr);
                break;
            }
            case 10: {
                ret = Double.valueOf(valueStr);
                break;
            }
            case 12: {
                ret = valueStr;
                break;
            }
            case 11: {
                ret = valueStr;
                break;
            }
        }
        return ret;
    }

    protected String dumpProperties(Message msg) {
        StringBuffer ret = new StringBuffer();
        try {
            Enumeration propertyNames = msg.getPropertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                Object value = msg.getObjectProperty(name);
                ret.append(name + "=" + value + " ");
            }
        }
        catch (Exception e) {
            throw new ServiceException("MESSAGERESOURCEFACTORY017", "Property Dump Failed", e);
        }
        return ret.toString();
    }
}

