/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpSession;
import jp.ossc.nimbus.service.journal.editor.BlockJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.HttpSessionJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class HttpSessionJournalEditorService
extends BlockJournalEditorServiceBase
implements HttpSessionJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = -1628012879212995304L;
    private static final String ATTRIBUTE_HEADER = "Attribute : ";
    private static final String CREATION_TIME_HEADER = "Creation Time : ";
    private static final String LAST_ACCESSED_TIME_HEADER = "Last Accessed Time : ";
    private static final String MAX_INACTIVE_INTERVAL_HEADER = "Max Inactive Interval : ";
    private static final String IS_NEW_HEADER = "New : ";
    private static final String ID_HEADER = "ID : ";
    private static final String ATTRIBUTE_SEPARATOR = " = ";
    private static final String HEADER = "[HttpSession]";
    private static final String DEFAULT_SECRET_STRING = "******";
    private boolean isOutputCreationTime = true;
    private boolean isOutputLastAccessedTime = true;
    private boolean isOutputMaxInactiveInterval = false;
    private boolean isOutputAttributes = true;
    private boolean isOutputIsNew = true;
    private boolean isOutputId = true;
    private String secretString = "******";
    private String[] secretAttributes;
    private Set secretAttributeSet;
    private String[] enabledAttributes;
    private Set enabledAttributeSet;

    public HttpSessionJournalEditorService() {
        this.setHeader(HEADER);
    }

    public void setOutputCreationTime(boolean isOutput) {
        this.isOutputCreationTime = isOutput;
    }

    public boolean isOutputCreationTime() {
        return this.isOutputCreationTime;
    }

    public void setOutputLastAccessedTime(boolean isOutput) {
        this.isOutputLastAccessedTime = isOutput;
    }

    public boolean isOutputLastAccessedTime() {
        return this.isOutputLastAccessedTime;
    }

    public void setOutputMaxInactiveInterval(boolean isOutput) {
        this.isOutputMaxInactiveInterval = isOutput;
    }

    public boolean isOutputMaxInactiveInterval() {
        return this.isOutputMaxInactiveInterval;
    }

    public void setOutputIsNew(boolean isOutput) {
        this.isOutputIsNew = isOutput;
    }

    public boolean isOutputIsNew() {
        return this.isOutputIsNew;
    }

    public void setOutputId(boolean isOutput) {
        this.isOutputId = isOutput;
    }

    public boolean isOutputId() {
        return this.isOutputId;
    }

    public void setOutputAttributes(boolean isOutput) {
        this.isOutputAttributes = isOutput;
    }

    public boolean isOutputAttributes() {
        return this.isOutputAttributes;
    }

    public void setSecretString(String str) {
        this.secretString = str;
    }

    public String getSecretString() {
        return this.secretString;
    }

    public void setSecretAttributes(String[] names) {
        this.secretAttributes = names;
    }

    public String[] getSecretAttributes() {
        return this.secretAttributes;
    }

    public void setEnabledAttributes(String[] names) {
        this.enabledAttributes = names;
    }

    public String[] getEnabledAttributes() {
        return this.enabledAttributes;
    }

    public void createService() throws Exception {
        this.secretAttributeSet = new HashSet();
        this.enabledAttributeSet = new HashSet();
    }

    public void startService() throws Exception {
        int i;
        if (this.secretAttributes != null) {
            for (i = 0; i < this.secretAttributes.length; ++i) {
                this.secretAttributeSet.add(this.secretAttributes[i]);
            }
        }
        if (this.enabledAttributes != null) {
            for (i = 0; i < this.enabledAttributes.length; ++i) {
                this.enabledAttributeSet.add(this.enabledAttributes[i]);
            }
        }
    }

    public void stopService() throws Exception {
        this.secretAttributeSet.clear();
        this.enabledAttributeSet.clear();
    }

    public void destroyService() throws Exception {
        this.secretAttributeSet = null;
        this.enabledAttributeSet = null;
    }

    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        HttpSession session = (HttpSession)value;
        boolean isMake = false;
        if (this.isOutputId()) {
            this.makeIdFormat(finder, key, session, buf);
            isMake = true;
        }
        if (this.isOutputCreationTime()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeCreationTimeFormat(finder, key, session, buf);
            isMake = true;
        }
        if (this.isOutputLastAccessedTime()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeLastAccessedTimeFormat(finder, key, session, buf);
            isMake = true;
        }
        if (this.isOutputMaxInactiveInterval()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeMaxInactiveIntervalFormat(finder, key, session, buf);
            isMake = true;
        }
        if (this.isOutputIsNew()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeIsNewFormat(finder, key, session, buf);
            isMake = true;
        }
        if (this.isOutputAttributes()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeAttributesFormat(finder, key, session, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeIdFormat(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
        return buf.append(ID_HEADER).append(session.getId());
    }

    protected StringBuffer makeCreationTimeFormat(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
        buf.append(CREATION_TIME_HEADER);
        this.makeObjectFormat(finder, key, new Date(session.getCreationTime()), buf);
        return buf;
    }

    protected StringBuffer makeLastAccessedTimeFormat(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
        buf.append(LAST_ACCESSED_TIME_HEADER);
        this.makeObjectFormat(finder, key, new Date(session.getLastAccessedTime()), buf);
        return buf;
    }

    protected StringBuffer makeMaxInactiveIntervalFormat(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
        return buf.append(MAX_INACTIVE_INTERVAL_HEADER).append(session.getMaxInactiveInterval());
    }

    protected StringBuffer makeIsNewFormat(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
        return buf.append(IS_NEW_HEADER).append(session.isNew());
    }

    protected StringBuffer makeAttributesFormat(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
        buf.append(ATTRIBUTE_HEADER);
        Enumeration attrNames = session.getAttributeNames();
        if (!attrNames.hasMoreElements()) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        while (attrNames.hasMoreElements()) {
            String name = (String)attrNames.nextElement();
            if (!this.enabledAttributeSet.isEmpty() && !this.enabledAttributeSet.contains(name)) continue;
            subBuf.append(name);
            subBuf.append(ATTRIBUTE_SEPARATOR);
            if (this.secretAttributeSet.contains(name)) {
                subBuf.append(this.getSecretString());
            } else {
                this.makeObjectFormat(finder, null, session.getAttribute(name), subBuf);
            }
            if (!attrNames.hasMoreElements()) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }
}

