/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.http.proxy;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.http.proxy.Process;
import jp.ossc.nimbus.service.http.proxy.ProxyServerServiceMBean;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerService;

public class ProxyServerService
extends ServiceBase
implements ProxyServerServiceMBean,
DaemonRunnable,
QueueHandler {
    private static final long serialVersionUID = 313673219796070087L;
    private static final String MSG_ID_00001 = "PSS__00001";
    private int port = 8080;
    private ServerSocket serverSocket;
    private Daemon serverDaemon;
    private int soTimeout = -1;
    private ServiceName processServiceName;
    private Process process;
    private DefaultQueueService queue;
    private QueueHandlerContainerService queueHandlerContainer;
    private int maxProcessCount = 1;

    public void setProcessServiceName(ServiceName name) {
        this.processServiceName = name;
    }

    public ServiceName getProcessServiceName() {
        return this.processServiceName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setSoTimeout(int millis) {
        this.soTimeout = millis;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setMaxProcessCount(int count) {
        this.maxProcessCount = count;
    }

    public int getMaxProcessCount() {
        return this.maxProcessCount;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public void startService() throws Exception {
        if (this.processServiceName != null) {
            this.process = (Process)ServiceManagerFactory.getServiceObject(this.processServiceName);
        }
        if (this.process == null) {
            throw new IllegalArgumentException("Process must be specified.");
        }
        this.queue = new DefaultQueueService();
        this.queue.create();
        this.queue.start();
        this.queueHandlerContainer = new QueueHandlerContainerService();
        this.queueHandlerContainer.setQueueService(this.queue);
        this.queueHandlerContainer.setQueueHandler(this);
        this.queueHandlerContainer.setQueueHandlerSize(this.maxProcessCount);
        this.queueHandlerContainer.create();
        this.queueHandlerContainer.start();
        this.serverSocket = new ServerSocket(this.port);
        if (this.soTimeout >= 0) {
            this.serverSocket.setSoTimeout(this.soTimeout);
        }
        this.serverDaemon = new Daemon(this);
        this.serverDaemon.setName("Nimbus TestProxyServerDaemon " + this.getServiceNameObject());
        this.serverDaemon.start();
    }

    public void stopService() throws Exception {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.serverDaemon != null) {
            this.serverDaemon.stop();
        }
        this.queueHandlerContainer.stop();
        this.queueHandlerContainer.destroy();
        this.queue.stop();
        this.queue.destroy();
    }

    public boolean onStart() {
        return true;
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) throws Exception {
        try {
            return this.serverSocket.accept();
        }
        catch (SocketException e) {
            if (this.getState() != 4) {
                this.getLogger().write(MSG_ID_00001, e);
            }
            ctrl.setRunning(false);
            return null;
        }
    }

    public void consume(Object paramObj, DaemonControl ctrl) throws Exception {
        if (paramObj == null) {
            return;
        }
        Socket socket = (Socket)paramObj;
        this.queue.push(socket);
    }

    public void garbage() {
        if (this.queue != null) {
            while (this.queue.size() > 0) {
                Socket socket = (Socket)this.queue.get(0L);
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDequeuedObject(Object obj) throws Throwable {
        if (obj == null) {
            return;
        }
        Socket socket = (Socket)obj;
        try {
            this.process.doProcess(socket.getInputStream(), socket.getOutputStream());
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }
}

