/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerAccess;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerFactoryCallBack;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitor;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitorStopException;
import jp.ossc.nimbus.service.beancontrol.JobStep;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanControlUncheckedException;
import jp.ossc.nimbus.service.beancontrol.interfaces.InvalidConfigurationException;
import jp.ossc.nimbus.service.beancontrol.resource.ResourceManager;
import jp.ossc.nimbus.service.journal.Journal;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BeanFlowInvokerAccessImpl
implements BeanFlowInvokerAccess {
    protected String mFlowName = null;
    protected ArrayList mAiliasAry = null;
    protected HashMap mResourceHash = null;
    protected ArrayList mJobSteps = new ArrayList();
    protected BeanFlowInvokerFactoryCallBack mCallBack = null;
    private static final String C_NAME = "name";
    private static final String C_AILIAS = "alias";
    private static final String C_RESOURCE = "resource";
    private static final String C_FLOW = "flow";
    private static final String C_STEP = "step";
    private static final String C_KEY = "key";
    private static final String C_SERVICE = "service";
    private static final String C_TRANCONTROL = "trancontrol";
    private static final String C_TRANCLOSE = "tranclose";
    private static final String C_TRUE = "true";
    private static final String C_FALSE = "false";
    private static final String C_RESOURCE_ADDED = "add resource";

    public BeanFlowInvokerAccessImpl() {
        this.mAiliasAry = new ArrayList();
        this.mResourceHash = new HashMap();
    }

    public void fillInstance(Element item, BeanFlowInvokerFactoryCallBack callBack) {
        this.mCallBack = callBack;
        this.mFlowName = item.getAttribute(C_NAME);
        NodeList ailiasList = item.getElementsByTagName(C_AILIAS);
        for (int rCnt = 0; rCnt < ailiasList.getLength(); ++rCnt) {
            Element ailiasElement = (Element)ailiasList.item(rCnt);
            this.mAiliasAry.add(ailiasElement.getAttribute(C_NAME));
        }
        NodeList resourceList = item.getElementsByTagName(C_RESOURCE);
        for (int rCnt = 0; rCnt < resourceList.getLength(); ++rCnt) {
            Element resourceElement = (Element)resourceList.item(rCnt);
            String key = resourceElement.getAttribute(C_NAME);
            if (key == null || "".equals(key)) {
                throw new InvalidConfigurationException("key is none");
            }
            String findkey = resourceElement.getAttribute(C_KEY);
            if (findkey == null) {
                throw new InvalidConfigurationException("findkey is none");
            }
            String service = resourceElement.getAttribute(C_SERVICE);
            if (service == null || "".equals(service)) {
                throw new InvalidConfigurationException("service is none");
            }
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setAsText(service);
            String tranControl = resourceElement.getAttribute(C_TRANCONTROL);
            boolean isTranControl = false;
            if (tranControl != null && tranControl.equals(C_TRUE)) {
                isTranControl = true;
            }
            String tranClose = resourceElement.getAttribute(C_TRANCLOSE);
            boolean isTranClose = true;
            if (tranClose != null && tranClose.equals(C_FALSE)) {
                isTranClose = false;
            }
            ResourceInfo tmp = new ResourceInfo();
            tmp.setKey(key);
            tmp.setFindKey(findkey);
            tmp.setServiceName((ServiceName)editor.getValue());
            tmp.setTranControl(isTranControl);
            tmp.setTranClose(isTranClose);
            this.mResourceHash.put(key, tmp);
        }
        NodeList stepList = item.getElementsByTagName(C_STEP);
        for (int rCnt = 0; rCnt < stepList.getLength(); ++rCnt) {
            Element stepElement = (Element)stepList.item(rCnt);
            JobStep step = new JobStep();
            step.fillElement(stepElement, callBack, this.mJobSteps);
            this.mJobSteps.add(step);
        }
    }

    public String getFlowName() {
        return this.mFlowName;
    }

    public List getAiliasFlowNames() {
        return this.mAiliasAry;
    }

    public Object invokeFlow(Object input) throws Exception {
        return this.invokeFlow(input, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeFlow(Object input, BeanFlowMonitor monitor) throws Exception {
        if (monitor == null) {
            monitor = new BeanFlowMonitor();
        }
        Object output = null;
        String newName = new String(this.mFlowName);
        monitor.setFlowName(newName);
        monitor.setCurrentFlowName(newName);
        monitor.setStartTime(System.currentTimeMillis());
        if (this.mCallBack.isManageExecBeanFlow()) {
            this.mCallBack.addExcecFlow(monitor);
        }
        Journal jnl = this.mCallBack.getJournal();
        try {
            if (jnl != null) {
                jnl.addStartStep(C_FLOW);
                jnl.addInfo(C_NAME, newName);
            }
            ResourceManager rm = this.mCallBack.createResourceManager();
            HashMap execBeanMap = new HashMap();
            Iterator ite = this.mResourceHash.keySet().iterator();
            while (ite.hasNext()) {
                String key = (String)ite.next();
                ResourceInfo ele = (ResourceInfo)this.mResourceHash.get(key);
                rm.addResource(key, ele.getFindKey(), ele.getServiceName(), ele.isTranControl(), ele.isTranClose());
                if (jnl == null) continue;
                jnl.addInfo(C_RESOURCE_ADDED, key);
            }
            try {
                if (this.mJobSteps != null) {
                    int max = this.mJobSteps.size();
                    for (int i = 0; i < max; ++i) {
                        JobStep jobStepObj = (JobStep)this.mJobSteps.get(i);
                        Object tmp = jobStepObj.invokeStep(input, execBeanMap, rm, monitor);
                        if (tmp == null) continue;
                        output = tmp;
                    }
                }
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getTargetException();
                this.endJob(th, rm, monitor, newName);
                if (th instanceof Exception) {
                    Exception ee = (Exception)th;
                    throw ee;
                }
                throw new BeanControlUncheckedException("Target Error occured", th);
            }
            catch (BeanFlowMonitorStopException e) {
                this.endJob(e, rm, monitor, newName);
                throw e;
            }
            catch (Throwable th) {
                this.endJob(th, rm, monitor, newName);
                throw new BeanControlUncheckedException("Target Error occured", th);
            }
            this.endJob(null, rm, monitor, newName);
        }
        finally {
            if (jnl != null) {
                jnl.addEndStep();
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endJob(Throwable e, ResourceManager rm, BeanFlowMonitor monitor, String name) {
        monitor.end();
        try {
            if (e == null) {
                rm.commitAllResources();
            } else {
                rm.rollbbackAllResources();
            }
            Object var6_5 = null;
            if (this.mCallBack.isManageExecBeanFlow()) {
                this.mCallBack.removeExecFlow(monitor);
            }
            rm.terminateResourceManager();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.mCallBack.isManageExecBeanFlow()) {
                this.mCallBack.removeExecFlow(monitor);
            }
            rm.terminateResourceManager();
            throw throwable;
        }
    }

    private class ResourceInfo {
        public String key = null;
        public String findKey = null;
        public ServiceName serviceName = null;
        public boolean isTranControl = false;
        public boolean isTranClose = true;

        private ResourceInfo() {
        }

        public String getFindKey() {
            return this.findKey;
        }

        public boolean isTranControl() {
            return this.isTranControl;
        }

        public boolean isTranClose() {
            return this.isTranClose;
        }

        public String getKey() {
            return this.key;
        }

        public ServiceName getServiceName() {
            return this.serviceName;
        }

        public void setFindKey(String string) {
            this.findKey = string;
        }

        public void setTranControl(boolean b) {
            this.isTranControl = b;
        }

        public void setTranClose(boolean b) {
            this.isTranClose = b;
        }

        public void setKey(String string) {
            this.key = string;
        }

        public void setServiceName(ServiceName name) {
            this.serviceName = name;
        }
    }
}

