/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jp.ossc.nimbus.core.FactoryServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceBase;

public abstract class FactoryServiceBase
extends ServiceBase
implements FactoryServiceBaseMBean {
    protected volatile boolean isManaged;
    protected volatile boolean isThreadLocal;
    protected Set managedInstances = Collections.synchronizedSet(new HashSet());
    protected ThreadLocal threadLocal = new InheritableThreadLocal();
    protected boolean isCreateTemplateOnStart = true;

    public void setManagement(boolean isManaged) {
        this.isManaged = isManaged;
    }

    public boolean isManagement() {
        return this.isManaged;
    }

    public void setThreadLocal(boolean isThreadLocal) {
        this.isThreadLocal = isThreadLocal;
    }

    public boolean isThreadLocal() {
        return this.isThreadLocal;
    }

    public void release(Object service) {
        if (this.managedInstances.size() != 0) {
            this.managedInstances.remove(service);
        }
        this.threadLocal.set(null);
    }

    public void release() {
        Object[] instances = this.managedInstances.toArray();
        for (int i = 0; i < instances.length; ++i) {
            this.release(instances[i]);
        }
        this.threadLocal = new InheritableThreadLocal();
    }

    public Object newInstance() {
        Object obj = null;
        if (this.isThreadLocal) {
            obj = this.threadLocal.get();
        }
        if (obj == null) {
            try {
                obj = this.createInstance();
            }
            catch (Exception e) {
                return null;
            }
            if (this.isThreadLocal) {
                this.threadLocal.set(obj);
            }
        }
        if (this.isManaged) {
            this.managedInstances.add(obj);
        }
        return obj;
    }

    public void setCreateTemplateOnStart(boolean isCreate) {
        this.isCreateTemplateOnStart = isCreate;
    }

    public boolean isCreateTemplateOnStart() {
        return this.isCreateTemplateOnStart;
    }

    protected Set getManagedInstanceSet() {
        return this.managedInstances;
    }

    protected abstract Object createInstance() throws Exception;

    protected Object createTemplate() throws Exception {
        return this.createInstance();
    }

    protected void postStartService() throws Exception {
        super.postStartService();
        if (this.isCreateTemplateOnStart) {
            Object obj = this.createTemplate();
            this.release(obj);
        }
    }

    protected void postDestroyService() throws Exception {
        super.postDestroyService();
        this.managedInstances.clear();
    }
}

