
import javax.naming.NamingException;

import javax.jms.QueueConnection;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.QueueSession;
import javax.jms.QueueSender;
import javax.jms.TextMessage;
import javax.jms.QueueReceiver;
import javax.jms.JMSException;

import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.jms.JMSMessageProducerFactory;
import jp.ossc.nimbus.service.jms.JMSMessageProducerCreateException;
import jp.ossc.nimbus.service.jndi.JndiFinder;

/**
 * TvRsNXB
 */
public class Main{
    
    public static final void main(String[] args){
        
        // T[rX`t@C[h
        if(ServiceManagerFactory.loadManager("service-definition.xml")){
            System.out.println("T[rX`̓ǂݍ݂ɐ܂B");
            
            // T[rX擾
            JMSMessageProducerFactory factory
                 = (JMSMessageProducerFactory)ServiceManagerFactory
                    .getServiceObject("MessageProducerFactory");
            JndiFinder finder = (JndiFinder)ServiceManagerFactory
                    .getServiceObject("JndiFinder");
            
            // Queue擾
            Queue queue = null;
            try{
                queue = (Queue)finder.lookup("queue/ex");
                System.out.println("Queue擾");
            }catch(NamingException e){
                e.printStackTrace();
                System.exit(-1);
            }
            
            QueueSender sender = null;
            try{
                // QueueSender𐶐
                sender = (QueueSender)factory.createProducer();
                System.out.println("QueueSender");
            }catch(JMSMessageProducerCreateException e){
                e.printStackTrace();
                System.exit(-1);
            }
            
            try{
                // bZ[W𑗐M
                QueueSession session = (QueueSession)factory.getSession();
                TextMessage message = session.createTextMessage();
                message.setText("Hello!");
                System.out.println("bZ[WM : " + message.getText());
                sender.send(message);
                System.out.println("bZ[WM");
                sender.close();
                
                // QueueReceiver𐶐
                QueueReceiver receiver = session.createReceiver(queue);
                System.out.println("QueueReceiver");
                
                // bZ[WM
                System.out.println("bZ[WM҂");
                QueueConnection connection = (QueueConnection)factory
                    .getSessionFactory().getConnection();
                connection.start();
                message = (TextMessage)receiver.receive();
                System.out.println("bZ[WM : " + message.getText());
                receiver.close();
                
                session.close();
                connection.close();
            }catch(JMSException e){
                e.printStackTrace();
                System.exit(-1);
            }
            
        }else{
            System.out.println("T[rX`̓ǂݍ݂Ɏs܂B");
        }
        
        // T[rX`t@CA[h
        ServiceManagerFactory.unloadManager("service-definition.xml");
    }
    
}