/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNameRef;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.ServletFilterInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ServletFilterInterceptorService;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ThreadContextInitializeInterceptorServiceMBean;
import jp.ossc.nimbus.service.codemaster.CodeMasterFinder;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.sequence.Sequence;

public class ThreadContextInitializeInterceptorService
extends ServletFilterInterceptorService
implements ThreadContextInitializeInterceptorServiceMBean {
    private static final long serialVersionUID = -3154621046378825548L;
    protected ServiceName threadContextServiceName;
    protected Context threadContext;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;
    protected ServiceName codeMasterFinderServiceName;
    protected CodeMasterFinder codeMasterFinder;
    protected ServiceNameRef[] contextValueServiceNames;
    protected Map contextValueMapping;
    protected boolean isOutputContextPath = true;
    protected boolean isOutputServletPath = true;
    protected boolean isOutputSessionID = true;
    protected boolean isNewSession = false;
    protected boolean isOutputThreadName = true;
    protected boolean isOutputThreadGroupName = true;
    protected boolean isInitializeRecursiveCall = true;
    protected ThreadLocal callStack;

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    public void setCodeMasterFinderServiceName(ServiceName name) {
        this.codeMasterFinderServiceName = name;
    }

    public ServiceName getCodeMasterFinderServiceName() {
        return this.codeMasterFinderServiceName;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    public void setContextValueServiceNames(ServiceNameRef[] names) {
        this.contextValueServiceNames = names;
    }

    public ServiceNameRef[] getContextValueServiceNames() {
        return this.contextValueServiceNames;
    }

    public void setContextValueMapping(Map mapping) {
        this.contextValueMapping = mapping;
    }

    public Map getContextValueMapping() {
        return this.contextValueMapping;
    }

    public void setContextValue(String key, Object value) {
        if (this.contextValueMapping == null) {
            this.contextValueMapping = new HashMap();
        }
        this.contextValueMapping.put(key, value);
    }

    public Object getContextValue(String key) {
        if (this.contextValueMapping == null) {
            return null;
        }
        return this.contextValueMapping.get(key);
    }

    public void setOutputContextPath(boolean isOutput) {
        this.isOutputContextPath = isOutput;
    }

    public boolean isOutputContextPath() {
        return this.isOutputContextPath;
    }

    public void setOutputServletPath(boolean isOutput) {
        this.isOutputServletPath = isOutput;
    }

    public boolean isOutputServletPath() {
        return this.isOutputServletPath;
    }

    public void setOutputSessionID(boolean isOutput) {
        this.isOutputSessionID = isOutput;
    }

    public boolean isOutputSessionID() {
        return this.isOutputSessionID;
    }

    public void setOutputThreadName(boolean isOutput) {
        this.isOutputThreadName = isOutput;
    }

    public boolean isOutputThreadName() {
        return this.isOutputThreadName;
    }

    public void setOutputThreadGroupName(boolean isOutput) {
        this.isOutputThreadGroupName = isOutput;
    }

    public boolean isOutputThreadGroupName() {
        return this.isOutputThreadGroupName;
    }

    public void setNewSession(boolean isNew) {
        this.isNewSession = isNew;
    }

    public boolean isNewSession() {
        return this.isNewSession;
    }

    public boolean isInitializeRecursiveCall() {
        return this.isInitializeRecursiveCall;
    }

    public void setInitializeRecursiveCall(boolean isInitialize) {
        this.isInitializeRecursiveCall = isInitialize;
    }

    public void startService() throws Exception {
        if (this.threadContextServiceName == null) {
            throw new IllegalArgumentException("threadContextServiceName must be specified.");
        }
        this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
        if (this.codeMasterFinderServiceName != null) {
            this.codeMasterFinder = (CodeMasterFinder)ServiceManagerFactory.getServiceObject(this.codeMasterFinderServiceName);
        }
        if (!this.isInitializeRecursiveCall) {
            this.callStack = new ThreadLocal(){

                protected Object initialValue() {
                    return new CallStack();
                }
            };
        }
    }

    public void stopService() throws Exception {
        this.callStack = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeFilter(ServletFilterInvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3 && (this.callStack == null || ((CallStack)this.callStack.get()).stackIndex == 0)) {
            ServletRequest request = context.getServletRequest();
            this.threadContext.clear();
            if (this.sequence != null) {
                String requestId = this.sequence.increment();
                this.threadContext.put("REQUEST_ID", requestId);
            }
            if (this.contextValueServiceNames != null) {
                for (int i = 0; i < this.contextValueServiceNames.length; ++i) {
                    this.threadContext.put(this.contextValueServiceNames[i].getReferenceServiceName(), ServiceManagerFactory.getServiceObject(this.contextValueServiceNames[i].getServiceName()));
                }
            }
            if (this.contextValueMapping != null && this.contextValueMapping.size() != 0) {
                Iterator keys = this.contextValueMapping.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    this.threadContext.put(key, this.contextValueMapping.get(key));
                }
            }
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpReq = (HttpServletRequest)request;
                if (this.isOutputContextPath) {
                    this.threadContext.put("CONTEXT_PATH", httpReq.getContextPath());
                }
                if (this.isOutputServletPath) {
                    this.threadContext.put("SERVLET_PATH", httpReq.getServletPath());
                }
                HttpSession session = httpReq.getSession(this.isNewSession);
                if (this.isOutputSessionID && session != null) {
                    this.threadContext.put("SESSION_ID", session.getId());
                }
            }
            Thread thread = Thread.currentThread();
            if (this.isOutputThreadName) {
                this.threadContext.put("THREAD_NAME", thread.getName());
            }
            if (this.isOutputThreadGroupName) {
                ThreadGroup threadGroup = thread.getThreadGroup();
                this.threadContext.put("THREAD_GROUP_NAME", threadGroup.getName());
            }
            if (this.codeMasterFinder != null) {
                Map codeMasters = this.codeMasterFinder.getCodeMasters();
                this.threadContext.put("CODE_MASTER", codeMasters);
            }
        }
        try {
            if (this.callStack != null) {
                ++((CallStack)this.callStack.get()).stackIndex;
            }
            Object object = chain.invokeNext(context);
            Object var7_7 = null;
            if (this.callStack != null) {
                --((CallStack)this.callStack.get()).stackIndex;
            }
            return object;
        }
        catch (Throwable throwable) {
            block17: {
                Object var7_8 = null;
                if (this.callStack == null) break block17;
                --((CallStack)this.callStack.get()).stackIndex;
            }
            throw throwable;
        }
    }

    protected static class CallStack {
        public int stackIndex;

        protected CallStack() {
        }
    }
}

