
import javax.naming.NamingException;

import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.QueueSender;
import javax.jms.TextMessage;
import javax.jms.QueueReceiver;
import javax.jms.JMSException;

import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.jms.JMSMessageProducerFactory;
import jp.ossc.nimbus.service.jms.JMSMessageProducerCreateException;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory;
import jp.ossc.nimbus.service.jms.JMSMessageConsumerCreateException;

/**
 * TvSsNXB
 */
public class Main{
    
    public static final void main(String[] args){
        
        // T[rX`t@C[h
        if(ServiceManagerFactory.loadManager("service-definition.xml")){
            System.out.println("T[rX`̓ǂݍ݂ɐ܂B");
            
            // T[rX擾
            JMSMessageProducerFactory producerFactory
                 = (JMSMessageProducerFactory)ServiceManagerFactory
                    .getServiceObject("MessageProducerFactory");
            
            QueueSender sender = null;
            try{
                // QueueSender𐶐
                sender = (QueueSender)producerFactory.createProducer();
                System.out.println("QueueSender");
            }catch(JMSMessageProducerCreateException e){
                e.printStackTrace();
                System.exit(-1);
            }
            
            try{
                // bZ[W𑗐M
                QueueSession session
                     = (QueueSession)producerFactory.getSession();
                TextMessage message = session.createTextMessage();
                message.setText("Hello!");
                System.out.println("bZ[WM : " + message.getText());
                sender.send(message);
                System.out.println("bZ[WM");
                sender.close();
                session.close();
            }catch(JMSException e){
                e.printStackTrace();
                System.exit(-1);
            }
            
            // T[rX擾
            JMSMessageConsumerFactory consumerFactory
                 = (JMSMessageConsumerFactory)ServiceManagerFactory
                    .getServiceObject("MessageConsumerFactory");
            
            QueueReceiver receiver = null;
            try{
                // QueueReceiver𐶐
                receiver = (QueueReceiver)consumerFactory.createConsumer();
                System.out.println("QueueReceiver");
            }catch(JMSMessageConsumerCreateException e){
                e.printStackTrace();
                System.exit(-1);
            }
            
            try{
                // bZ[WM
                System.out.println("bZ[WM҂");
                QueueConnection connection = (QueueConnection)consumerFactory
                    .getSessionFactory().getConnection();
                connection.start();
                TextMessage message = (TextMessage)receiver.receive();
                System.out.println("bZ[WM : " + message.getText());
                receiver.close();
                
                QueueSession session
                     = (QueueSession)consumerFactory.getSession();
                session.close();
                connection.close();
            }catch(JMSException e){
                e.printStackTrace();
                System.exit(-1);
            }
            
        }else{
            System.out.println("T[rX`̓ǂݍ݂Ɏs܂B");
        }
        
        // T[rX`t@CA[h
        ServiceManagerFactory.unloadManager("service-definition.xml");
    }
    
}