/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jp.ossc.nimbus.beans.dataset.DataSet;
import jp.ossc.nimbus.beans.dataset.DataSetException;
import jp.ossc.nimbus.beans.dataset.Header;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.ReversibleConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DateSetXMLConverter
implements ReversibleConverter {
    private static final long serialVersionUID = -7027099857625192227L;
    private static final String ELEMENT_DATASET = "dataSet";
    private static final String ELEMENT_SCHEMA = "schema";
    private static final String ELEMENT_HEADER = "header";
    private static final String ELEMENT_RECORD_LIST = "recordList";
    private static final String ELEMENT_RECORD = "record";
    private static final String ATTRIBUTE_NAME = "name";
    public static final int DATASET_FROM_XML = 1;
    public static final int XML_FROM_DATASET = 2;
    public static final String DEFAULT_CHARACTER_ENCODING = "Windows-31J";
    protected int convertType;
    protected Map dataSetMap = new HashMap();
    protected boolean isOutputSchema = true;
    protected String xslFilePath;
    protected String characterEncoding = "Windows-31J";

    public DateSetXMLConverter() {
        this(1);
    }

    public DateSetXMLConverter(int type) {
        this.convertType = type;
    }

    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setDataSet(String name, DataSet dataSet) {
        this.dataSetMap.put(name, dataSet);
    }

    public void setOutputSchema(boolean isOutput) {
        this.isOutputSchema = isOutput;
    }

    public boolean isOutputSchema() {
        return this.isOutputSchema;
    }

    public void setXSLFilePath(String path) {
        this.xslFilePath = path;
    }

    public String getXSLFilePath() {
        return this.xslFilePath;
    }

    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        switch (this.convertType) {
            case 1: {
                if (obj instanceof DataSet) {
                    return this.toXML((DataSet)obj);
                }
                throw new ConvertException("Invalid input type : " + obj.getClass());
            }
            case 2: {
                if (obj instanceof File) {
                    return this.toDataSet((File)obj);
                }
                if (obj instanceof InputStream) {
                    return this.toDataSet((InputStream)obj);
                }
                throw new ConvertException("Invalid input type : " + obj.getClass());
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }

    protected DataSet toDataSet(InputStream is) throws ConvertException {
        DataSet dataSet = null;
        try {
            InputSource inputSource = new InputSource(is);
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document doc = builder.parse(inputSource);
            Element dataSetElement = doc.getDocumentElement();
            String dataSetName = MetaData.getOptionalAttribute(dataSetElement, ATTRIBUTE_NAME);
            dataSet = (DataSet)this.dataSetMap.get(dataSetName);
            if (dataSet != null) {
                dataSet = dataSet.cloneSchema();
            } else {
                Element schemaElement = MetaData.getOptionalChild(dataSetElement, ELEMENT_SCHEMA);
                if (schemaElement == null) {
                    throw new ConvertException("Dataset is not found. name=" + dataSetName);
                }
                dataSet = new DataSet(dataSetName);
                Iterator headerElements = MetaData.getChildrenByTagName(schemaElement, ELEMENT_HEADER);
                while (headerElements.hasNext()) {
                    Element headerElement = (Element)headerElements.next();
                    String headerName = MetaData.getUniqueAttribute(headerElement, ATTRIBUTE_NAME);
                    String schema = MetaData.getElementContent(headerElement);
                    dataSet.setHeaderSchema(headerName, schema);
                }
                Iterator recListElements = MetaData.getChildrenByTagName(schemaElement, ELEMENT_RECORD_LIST);
                while (recListElements.hasNext()) {
                    Element recListElement = (Element)recListElements.next();
                    String recListName = MetaData.getUniqueAttribute(recListElement, ATTRIBUTE_NAME);
                    String schema = MetaData.getElementContent(recListElement);
                    dataSet.setRecordListSchema(recListName, schema);
                }
            }
            Iterator headerElements = MetaData.getChildrenByTagName(dataSetElement, ELEMENT_HEADER);
            while (headerElements.hasNext()) {
                Element headerElement = (Element)headerElements.next();
                String headerName = MetaData.getUniqueAttribute(headerElement, ATTRIBUTE_NAME);
                Header header = dataSet.getHeader(headerName);
                if (header == null) continue;
                Iterator propElements = MetaData.getChildren(headerElement);
                while (propElements.hasNext()) {
                    Element propElement = (Element)propElements.next();
                    String propName = propElement.getTagName();
                    header.setParseProperty(propName, (Object)MetaData.getElementContent(propElement));
                }
            }
            Iterator recListElements = MetaData.getChildrenByTagName(dataSetElement, ELEMENT_RECORD_LIST);
            while (recListElements.hasNext()) {
                Element recListElement = (Element)recListElements.next();
                String recListName = MetaData.getUniqueAttribute(recListElement, ATTRIBUTE_NAME);
                RecordList recList = dataSet.getRecordList(recListName);
                if (recList == null) continue;
                Iterator recordElements = MetaData.getChildrenByTagName(recListElement, ELEMENT_RECORD);
                while (recordElements.hasNext()) {
                    Element recordElement = (Element)recordElements.next();
                    Record record = recList.createRecord();
                    Iterator propElements = MetaData.getChildren(recordElement);
                    while (propElements.hasNext()) {
                        Element propElement = (Element)propElements.next();
                        String propName = propElement.getTagName();
                        record.setParseProperty(propName, (Object)MetaData.getElementContent(propElement));
                    }
                    recList.addRecord(record);
                }
            }
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ConvertException(e);
        }
        catch (SAXException e) {
            throw new ConvertException(e);
        }
        catch (DeploymentException e) {
            throw new ConvertException(e);
        }
        catch (DataSetException e) {
            throw new ConvertException(e);
        }
        return dataSet;
    }

    protected DataSet toDataSet(File file) throws ConvertException {
        try {
            return this.toDataSet(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }

    protected InputStream toXML(DataSet dataSet) throws ConvertException {
        ByteArrayInputStream is = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element dataSetElement = document.createElement(ELEMENT_DATASET);
            if (dataSet.getName() != null) {
                dataSetElement.setAttribute(ATTRIBUTE_NAME, dataSet.getName());
            }
            document.appendChild(dataSetElement);
            if (this.isOutputSchema) {
                Element schemaElement = document.createElement(ELEMENT_SCHEMA);
                dataSetElement.appendChild(schemaElement);
                String[] headerNames = dataSet.getHeaderNames();
                for (int i = 0; i < headerNames.length; ++i) {
                    Header header = dataSet.getHeader(headerNames[i]);
                    Element headerElement = document.createElement(ELEMENT_HEADER);
                    headerElement.setAttribute(ATTRIBUTE_NAME, headerNames[i]);
                    schemaElement.appendChild(headerElement);
                    Text schemaNode = document.createTextNode(header.getSchema());
                    headerElement.appendChild(schemaNode);
                }
                String[] recListNames = dataSet.getRecordListNames();
                for (int i = 0; i < recListNames.length; ++i) {
                    RecordList recList = dataSet.getRecordList(recListNames[i]);
                    Element recListElement = document.createElement(ELEMENT_RECORD_LIST);
                    recListElement.setAttribute(ATTRIBUTE_NAME, recListNames[i]);
                    schemaElement.appendChild(recListElement);
                    Text schemaNode = document.createTextNode(recList.getSchema());
                    recListElement.appendChild(schemaNode);
                }
            }
            String[] headerNames = dataSet.getHeaderNames();
            for (int i = 0; i < headerNames.length; ++i) {
                Header header = dataSet.getHeader(headerNames[i]);
                Element headerElement = document.createElement(ELEMENT_HEADER);
                headerElement.setAttribute(ATTRIBUTE_NAME, headerNames[i]);
                dataSetElement.appendChild(headerElement);
                RecordSchema recSchema = header.getRecordSchema();
                int jmax = recSchema.getPropertySize();
                for (int j = 0; j < jmax; ++j) {
                    PropertySchema propSchema = recSchema.getPropertySchema(j);
                    Element propElement = document.createElement(propSchema.getName());
                    Object prop = header.getFormatProperty(propSchema.getName());
                    if (prop == null) continue;
                    Text valNode = document.createTextNode(prop.toString());
                    propElement.appendChild(valNode);
                    headerElement.appendChild(propElement);
                }
            }
            String[] recListNames = dataSet.getRecordListNames();
            for (int i = 0; i < recListNames.length; ++i) {
                RecordList recList = dataSet.getRecordList(recListNames[i]);
                if (recList.size() == 0) continue;
                Element recListElement = document.createElement(ELEMENT_RECORD_LIST);
                recListElement.setAttribute(ATTRIBUTE_NAME, recListNames[i]);
                dataSetElement.appendChild(recListElement);
                RecordSchema recSchema = recList.getRecordSchema();
                int jmax = recList.size();
                for (int j = 0; j < jmax; ++j) {
                    Record record = recList.getRecord(j);
                    Element recordElement = document.createElement(ELEMENT_RECORD);
                    recListElement.appendChild(recordElement);
                    int kmax = recSchema.getPropertySize();
                    for (int k = 0; k < kmax; ++k) {
                        PropertySchema propSchema = recSchema.getPropertySchema(k);
                        Element propElement = document.createElement(propSchema.getName());
                        Object prop = record.getFormatProperty(propSchema.getName());
                        if (prop == null) continue;
                        Text valNode = document.createTextNode(prop.toString());
                        propElement.appendChild(valNode);
                        recordElement.appendChild(propElement);
                    }
                }
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = null;
            transformer = this.xslFilePath == null ? tFactory.newTransformer() : tFactory.newTransformer(new StreamSource(this.xslFilePath));
            transformer.setOutputProperty("encoding", this.characterEncoding);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(document), new StreamResult(baos));
            is = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (ParserConfigurationException e) {
            throw new ConvertException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new ConvertException(e);
        }
        catch (TransformerException e) {
            throw new ConvertException(e);
        }
        catch (DataSetException e) {
            throw new ConvertException(e);
        }
        return is;
    }
}

